/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.functions;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.MyFunctionExecutionException;
import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2;
import dunit.DistributedTestCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;

public class TestFunction
extends FunctionAdapter
implements Declarable2 {
    public static final String TEST_FUNCTION10 = "TestFunction10";
    public static final String TEST_FUNCTION9 = "TestFunction9";
    public static final String TEST_FUNCTION8 = "TestFunction8";
    public static final String TEST_FUNCTION6 = "TestFunction6";
    public static final String TEST_FUNCTION5 = "TestFunction5";
    public static final String TEST_FUNCTION7 = "TestFunction7";
    public static final String TEST_FUNCTION4 = "TestFunction4";
    public static final String TEST_FUNCTION3 = "TestFunction3";
    public static final String TEST_FUNCTION2 = "TestFunction2";
    public static final String TEST_FUNCTION1 = "TestFunction1";
    public static final String TEST_FUNCTION_EXCEPTION = "TestFunctionException";
    public static final String TEST_FUNCTION_RESULT_SENDER = "TestFunctionResultSender";
    public static final String MEMBER_FUNCTION = "MemberFunction";
    public static final String TEST_FUNCTION_SOCKET_TIMEOUT = "SocketTimeOutFunction";
    public static final String TEST_FUNCTION_TIMEOUT = "executeTimeOut";
    public static final String TEST_FUNCTION_HA = "executeFunctionHA";
    public static final String TEST_FUNCTION_HA_SERVER = "executeFunctionHAOnServer";
    public static final String TEST_FUNCTION_NONHA_SERVER = "executeFunctionNonHAOnServer";
    public static final String TEST_FUNCTION_NONHA_REGION = "executeFunctionNonHAOnRegion";
    public static final String TEST_FUNCTION_HA_REGION = "executeFunctionHAOnRegion";
    public static final String TEST_FUNCTION_REEXECUTE_EXCEPTION = "executeFunctionReexecuteException";
    public static final String TEST_FUNCTION_ONSERVER_REEXECUTE_EXCEPTION = "executeFunctionReexecuteExceptionOnServer";
    public static final String TEST_FUNCTION_NO_LASTRESULT = "executeFunctionWithoutLastResult";
    public static final String TEST_FUNCTION_LASTRESULT = "executeFunctionWithLastResult";
    public static final String TEST_FUNCTION_SEND_EXCEPTION = "executeFunction_SendException";
    public static final String TEST_FUNCTION_THROW_EXCEPTION = "executeFunction_ThrowException";
    public static final String TEST_FUNCTION_RETURN_ARGS = "executeFunctionToReturnArgs";
    public static final String TEST_FUNCTION_RUNNING_FOR_LONG_TIME = "executeFunctionRunningForLongTime";
    private static final String ID = "id";
    private static final String HAVE_RESULTS = "haveResults";
    private final Properties props = new Properties();
    private static final String NOACKTEST = "NoAckTest";
    private static int retryCount = 0;
    private static int firstExecutionCount = 0;

    public TestFunction() {
    }

    public TestFunction(boolean haveResults, String id) {
        this.props.setProperty(HAVE_RESULTS, Boolean.toString(haveResults));
        this.props.setProperty(ID, id);
    }

    public TestFunction(boolean haveResults, String id, boolean hashCodeId) {
        this.props.setProperty(HAVE_RESULTS, Boolean.toString(haveResults));
        id = id + ((Object)((Object)this)).hashCode();
        this.props.setProperty(ID, id);
        this.props.setProperty(NOACKTEST, Boolean.toString(hashCodeId));
    }

    public void execute(FunctionContext context) {
        String id = this.props.getProperty(ID);
        String noAckTest = this.props.getProperty(NOACKTEST);
        if (id.equals(TEST_FUNCTION1)) {
            this.execute1(context);
        } else if (id.equals(TEST_FUNCTION2)) {
            this.execute2(context);
        } else if (id.equals(TEST_FUNCTION3)) {
            this.execute3(context);
        } else if (id.equals(TEST_FUNCTION4) || id.equals(TEST_FUNCTION7)) {
            this.execute4(context);
        } else if (id.equals(TEST_FUNCTION5) || id.equals(TEST_FUNCTION6)) {
            this.execute5(context);
        } else if (id.equals(TEST_FUNCTION8)) {
            this.execute8(context);
        } else if (id.equals(TEST_FUNCTION9)) {
            this.execute9(context);
        } else if (id.equals(TEST_FUNCTION_EXCEPTION)) {
            this.executeException(context);
        } else if (id.equals(TEST_FUNCTION_REEXECUTE_EXCEPTION)) {
            this.executeFunctionReexecuteException(context);
        } else if (id.equals(TEST_FUNCTION_RESULT_SENDER)) {
            this.executeResultSender(context);
        } else if (id.equals(MEMBER_FUNCTION)) {
            this.executeMemberFunction(context);
        } else if (id.equals(TEST_FUNCTION_TIMEOUT)) {
            this.executeTimeOut(context);
        } else if (id.equals(TEST_FUNCTION_SOCKET_TIMEOUT)) {
            this.executeSocketTimeOut(context);
        } else if (id.equals(TEST_FUNCTION_HA)) {
            this.executeHA(context);
        } else if (id.equals(TEST_FUNCTION_HA_SERVER) || id.equals(TEST_FUNCTION_NONHA_SERVER)) {
            this.executeHAAndNonHAOnServer(context);
        } else if (id.equals(TEST_FUNCTION_NONHA_REGION) || id.equals(TEST_FUNCTION_HA_REGION)) {
            this.executeHAAndNonHAOnRegion(context);
        } else if (id.equals(TEST_FUNCTION_ONSERVER_REEXECUTE_EXCEPTION)) {
            this.executeFunctionReexecuteExceptionOnServer(context);
        } else if (id.equals(TEST_FUNCTION_NO_LASTRESULT)) {
            this.executeWithNoLastResult(context);
        } else if (id.equals(TEST_FUNCTION_SEND_EXCEPTION)) {
            this.executeWithSendException(context);
        } else if (id.equals(TEST_FUNCTION_THROW_EXCEPTION)) {
            this.executeWithThrowException(context);
        } else if (id.equals(TEST_FUNCTION_LASTRESULT)) {
            this.executeWithLastResult(context);
        } else if (id.equals(TEST_FUNCTION_RETURN_ARGS)) {
            this.executeFunctionReturningArgs(context);
        } else if (id.equals(TEST_FUNCTION_RUNNING_FOR_LONG_TIME)) {
            this.executeFunctionRunningForLongTime(context);
        } else if (noAckTest.equals("true")) {
            this.execute1(context);
        }
    }

    public void executeFunctionRunningForLongTime(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.info("Exception in executeFunctionRunningForLongTime");
        }
        context.getResultSender().lastResult((Object)"Ran executeFunctionRunningForLongTime for 10000000");
    }

    public void executeFunctionReturningArgs(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.info("Executing executeFunctionReturningArgs in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (!this.hasResult()) {
            return;
        }
        Object[] args = (Object[])context.getArguments();
        if (args != null) {
            context.getResultSender().lastResult(args[0]);
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    public void execute1(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.info("Executing execute1 in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (!this.hasResult()) {
            return;
        }
        if (context.getArguments() instanceof Boolean) {
            context.getResultSender().lastResult((Object)((Serializable)context.getArguments()));
        } else if (context.getArguments() instanceof String) {
            context.getResultSender().lastResult((Object)((Serializable)context.getArguments()));
        } else if (context.getArguments() instanceof Set) {
            Set origKeys = (Set)context.getArguments();
            ArrayList vals = new ArrayList();
            for (Object val : origKeys) {
                if (val == null) continue;
                vals.add(val);
            }
            context.getResultSender().lastResult(vals);
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    public void execute2(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction2.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                if (this.hasResult()) {
                    rfContext.getResultSender().lastResult((Object)((Serializable)rfContext.getArguments()));
                } else {
                    rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction2.execute " + rfContext);
                    while (!rfContext.getDataSet().isDestroyed()) {
                        rfContext.getDataSet().getCache().getLogger().info("For Bug43513 ");
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
            } else if (rfContext.getArguments() instanceof String) {
                String key = (String)rfContext.getArguments();
                if (key.equals("TestingTimeOut")) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                    }
                }
                if (PartitionRegionHelper.isPartitionedRegion((Region)rfContext.getDataSet())) {
                    rfContext.getResultSender().lastResult((Object)((Serializable)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get((Object)key)));
                } else {
                    rfContext.getResultSender().lastResult((Object)((Serializable)rfContext.getDataSet().get((Object)key)));
                }
            } else if (rfContext.getArguments() instanceof Set) {
                Set origKeys = (Set)rfContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                for (Object key : origKeys) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get(key);
                    if (val == null) continue;
                    vals.add(val);
                }
                rfContext.getResultSender().lastResult(vals);
            } else if (rfContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)rfContext.getArguments();
                for (Map.Entry me : putData.entrySet()) {
                    rfContext.getDataSet().put(me.getKey(), me.getValue());
                }
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else if (this.hasResult()) {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        } else {
            InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
            LogWriter logger = ds.getLogWriter();
            logger.info("Executing in TestFunction on Server : " + ds.getDistributedMember() + "with Context : " + context);
            while (ds.isConnected()) {
                logger.fine("Just executing function in infinite loop for Bug43513");
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public void execute3(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext prContext = (RegionFunctionContext)context;
            prContext.getDataSet().getCache().getLogger().info("Executing function : TestFunction3.execute " + prContext);
            if (prContext.getArguments() instanceof Set) {
                Set origKeys = (Set)prContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                Iterator i = origKeys.iterator();
                while (i.hasNext()) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(i.next());
                    if (val == null) continue;
                    vals.add(val);
                }
                prContext.getResultSender().lastResult(vals);
            } else if (prContext.getFilter() != null) {
                Set origKeys = prContext.getFilter();
                ArrayList<Object> vals = new ArrayList<Object>();
                Iterator i = origKeys.iterator();
                while (i.hasNext()) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(i.next());
                    if (val == null) continue;
                    vals.add(val);
                }
                prContext.getResultSender().lastResult(vals);
            } else {
                prContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    public void execute4(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext prContext = (RegionFunctionContext)context;
            prContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction4-7.execute " + prContext);
            if (prContext.getArguments() instanceof Boolean) {
                prContext.getResultSender().lastResult((Object)((Serializable)prContext.getArguments()));
            } else if (prContext.getArguments() instanceof String) {
                String key = (String)prContext.getArguments();
                prContext.getResultSender().lastResult((Object)((Serializable)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get((Object)key)));
            } else if (prContext.getArguments() instanceof Set) {
                Set origKeys = (Set)prContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                Iterator i = origKeys.iterator();
                while (i.hasNext()) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(i.next());
                    if (val == null) continue;
                    vals.add(val);
                }
                prContext.getResultSender().lastResult(vals);
            } else if (prContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)prContext.getArguments();
                for (Map.Entry me : putData.entrySet()) {
                    prContext.getDataSet().put(me.getKey(), me.getValue());
                }
                prContext.getResultSender().lastResult((Object)Boolean.TRUE);
            } else {
                prContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    public void execute5(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.info("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (this.hasResult()) {
            if (context.getArguments() instanceof String) {
                context.getResultSender().lastResult((Object)"Success");
            } else {
                context.getResultSender().lastResult((Object)"Failure");
            }
        }
    }

    public void executeMemberFunction(FunctionContext context) {
        if (this.hasResult()) {
            if (context.getArguments() instanceof String) {
                String args = (String)context.getArguments();
                if (!args.equalsIgnoreCase("Key")) {
                    Assert.assertTrue((boolean)args.equals(InternalDistributedSystem.getAnyInstance().getDistributedMember().getId()), (Object)("Args was supposed to be [" + InternalDistributedSystem.getAnyInstance().getDistributedMember().getId() + "] but was:[" + args + "]"));
                }
                context.getResultSender().lastResult((Object)"Success");
            } else {
                context.getResultSender().lastResult((Object)"Failure");
            }
        }
    }

    public void execute8(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction8.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                rfContext.getResultSender().lastResult((Object)((Serializable)rfContext.getArguments()));
            } else if (rfContext.getArguments() instanceof String) {
                String op = (String)rfContext.getArguments();
                if (op.equals("DELETE")) {
                    Region r = rfContext.getDataSet();
                    Set s = rfContext.getFilter();
                    if (s == null) {
                        rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
                    }
                    Iterator itr = s.iterator();
                    while (itr.hasNext()) {
                        r.destroy(itr.next());
                    }
                    rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
                } else if (op.equals("GET")) {
                    Region r = rfContext.getDataSet();
                    Set s = rfContext.getFilter();
                    if (s == null) {
                        rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
                    }
                    Iterator itr = s.iterator();
                    ArrayList<Object> vals = new ArrayList<Object>();
                    while (itr.hasNext()) {
                        vals.add(r.get(itr.next()));
                    }
                    rfContext.getResultSender().lastResult(vals);
                }
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute9(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction9.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                rfContext.getResultSender().lastResult((Object)((Serializable)rfContext.getArguments()));
            } else if (rfContext.getArguments() instanceof String) {
                RegionFunctionContext prContext;
                String key = (String)rfContext.getArguments();
                if (key.equals("TestingTimeOut")) {
                    try {
                        TestFunction testFunction = this;
                        synchronized (testFunction) {
                            ((Object)((Object)this)).wait(2000L);
                        }
                    }
                    catch (InterruptedException e) {
                        rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                    }
                }
                if (context instanceof RegionFunctionContext && PartitionRegionHelper.isPartitionedRegion((Region)(prContext = (RegionFunctionContext)context).getDataSet())) {
                    rfContext.getResultSender().lastResult((Object)((Serializable)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get((Object)key)));
                }
            } else if (rfContext.getArguments() instanceof Set) {
                Set origKeys = (Set)rfContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                Iterator i = origKeys.iterator();
                while (i.hasNext()) {
                    Object val = null;
                    if (context instanceof RegionFunctionContext) {
                        RegionFunctionContext prContext = (RegionFunctionContext)context;
                        val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(i.next());
                    } else {
                        val = rfContext.getDataSet().get(i.next());
                    }
                    if (i.hasNext()) {
                        rfContext.getResultSender().sendResult((Object)((Serializable)val));
                    } else {
                        rfContext.getResultSender().lastResult((Object)((Serializable)val));
                    }
                    if (val == null) continue;
                    vals.add(val);
                }
            } else if (rfContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)rfContext.getArguments();
                for (Map.Entry me : putData.entrySet()) {
                    rfContext.getDataSet().put(me.getKey(), me.getValue());
                }
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            }
        }
        context.getResultSender().lastResult((Object)"ABCD");
    }

    private void executeException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException Exception is intentionally thrown");
            throw new MyFunctionExecutionException("I have been thrown from TestFunction");
        }
        if (context.getArguments() instanceof String) {
            String key = (String)context.getArguments();
            logger.fine("Result sent back :" + key);
            context.getResultSender().lastResult((Object)key);
        } else if (context.getArguments() instanceof Set) {
            Set origKeys = (Set)context.getArguments();
            ArrayList vals = new ArrayList();
            for (Object val : origKeys) {
                if (val == null) continue;
                vals.add(val);
            }
            logger.fine("Result sent back :" + vals);
            context.getResultSender().lastResult(vals);
        } else {
            logger.fine("Result sent back :" + Boolean.FALSE);
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void executeWithSendException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeWithSendException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (context.getArguments() instanceof Boolean) {
            context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been send from TestFunction"));
        } else if (context.getArguments() instanceof String) {
            String arg = (String)context.getArguments();
            if (arg.equals("Multiple")) {
                logger.fine("Sending Exception First time");
                context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been send from TestFunction"));
                logger.fine("Sending Exception Second time");
                context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been send from TestFunction"));
            }
        } else if (context.getArguments() instanceof Set) {
            Set args = (Set)context.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                context.getResultSender().sendResult((Object)new Integer(i));
            }
            context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been thrown from TestFunction with set"));
        } else {
            logger.fine("Result sent back :" + Boolean.FALSE);
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void executeWithThrowException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        RegionFunctionContext rfContext = (RegionFunctionContext)context;
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeWithThrowException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException Exception is intentionally thrown");
            throw new MyFunctionExecutionException("I have been thrown from TestFunction");
        }
        if (rfContext.getArguments() instanceof Set) {
            Set origKeys = (Set)rfContext.getArguments();
            Iterator i = origKeys.iterator();
            while (i.hasNext()) {
                Object key;
                Region r = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext);
                Object val = r.get(key = i.next());
                if (val == null) continue;
                throw new MyFunctionExecutionException("I have been thrown from TestFunction");
            }
        } else {
            logger.fine("Result sent back :" + Boolean.FALSE);
            rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void executeFunctionReexecuteException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (++retryCount >= 5) {
            logger.fine("Tried Function Execution 5 times. Now Returning after 5 attempts");
            context.getResultSender().lastResult((Object)new Integer(retryCount));
            retryCount = 0;
            return;
        }
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException is intentionally thrown");
            throw new FunctionInvocationTargetException((Throwable)new MyFunctionExecutionException("I have been thrown from TestFunction"));
        }
    }

    private void executeResultSender(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunctionexecuteResultSender.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                if (this.hasResult()) {
                    resultSender.lastResult((Object)((Serializable)rfContext.getArguments()));
                }
            } else if (rfContext.getArguments() instanceof Set) {
                int i;
                Set origKeys = (Set)rfContext.getArguments();
                Object[] objectArray = origKeys.toArray();
                int size = objectArray.length;
                for (i = 0; i < size - 1; ++i) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get(objectArray[i]);
                    if (val == null) continue;
                    resultSender.sendResult((Object)((Serializable)val));
                }
                resultSender.lastResult((Object)((Serializable)objectArray[i]));
            } else {
                resultSender.lastResult((Object)Boolean.FALSE);
            }
        } else {
            resultSender.lastResult((Object)Boolean.FALSE);
        }
    }

    public void executeSocketTimeOut(FunctionContext context) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 15000L, 1000L, false);
        if (context.getArguments() instanceof Boolean) {
            context.getResultSender().lastResult((Object)((Serializable)context.getArguments()));
        } else if (context.getArguments() instanceof String) {
            context.getResultSender().lastResult((Object)((Serializable)context.getArguments()));
        } else if (context.getArguments() instanceof Set) {
            Set origKeys = (Set)context.getArguments();
            ArrayList vals = new ArrayList();
            for (Object val : origKeys) {
                if (val == null) continue;
                vals.add(val);
            }
            context.getResultSender().lastResult(vals);
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTimeOut(FunctionContext context) {
        try {
            TestFunction testFunction = this;
            synchronized (testFunction) {
                ((Object)((Object)this)).wait(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                rfContext.getResultSender().lastResult((Object)((Serializable)rfContext.getArguments()));
            } else if (rfContext.getArguments() instanceof String) {
                String key = (String)rfContext.getArguments();
                if (key.equals("TestingTimeOut")) {
                    try {
                        TestFunction testFunction = this;
                        synchronized (testFunction) {
                            ((Object)((Object)this)).wait(2000L);
                        }
                    }
                    catch (InterruptedException e) {
                        rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                    }
                }
                try {
                    TestFunction e = this;
                    synchronized (e) {
                        ((Object)((Object)this)).wait(2000L);
                    }
                }
                catch (InterruptedException e) {
                    rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                }
                if (PartitionRegionHelper.isPartitionedRegion((Region)rfContext.getDataSet())) {
                    rfContext.getResultSender().lastResult((Object)((Serializable)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get((Object)key)));
                } else {
                    rfContext.getResultSender().lastResult((Object)((Serializable)rfContext.getDataSet().get((Object)key)));
                }
            } else if (rfContext.getArguments() instanceof Set) {
                Set origKeys = (Set)rfContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                Iterator i = origKeys.iterator();
                while (i.hasNext()) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get(i.next());
                    if (val == null) continue;
                    vals.add(val);
                }
                rfContext.getResultSender().lastResult(vals);
            } else if (rfContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)rfContext.getArguments();
                for (Map.Entry me : putData.entrySet()) {
                    rfContext.getDataSet().put(me.getKey(), me.getValue());
                }
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    public void executeHA(FunctionContext context) {
        RegionFunctionContext rcontext = (RegionFunctionContext)context;
        Region region = rcontext.getDataSet();
        region.getCache().getLogger().fine("executeHA#execute( " + rcontext + " )");
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 500L, false);
        rcontext.getResultSender().lastResult((Object)((Serializable)rcontext.getArguments()));
    }

    public void executeHAAndNonHAOnServer(FunctionContext context) {
        List servers = CacheFactory.getAnyInstance().getCacheServers();
        ArrayList args = (ArrayList)context.getArguments();
        Region r = CacheFactory.getAnyInstance().getRegion((String)args.get(0));
        String testName = (String)args.get(1);
        Integer numTimesStopped = (Integer)r.get((Object)"stopped");
        Integer numTimesSentResult = (Integer)r.get((Object)"sentresult");
        if (context.isPossibleDuplicate()) {
            if (testName.equals("serverExecutionHATwoServerDown")) {
                if ((Integer)r.get((Object)"stopped") == 2) {
                    if (numTimesSentResult == null) {
                        r.put((Object)"sentresult", (Object)1);
                    } else {
                        numTimesSentResult = numTimesSentResult + 1;
                        r.put((Object)"sentresult", (Object)numTimesSentResult);
                    }
                    context.getResultSender().lastResult(args.get(0));
                } else {
                    numTimesStopped = numTimesStopped + 1;
                    r.put((Object)"stopped", (Object)numTimesStopped);
                    for (CacheServer s : servers) {
                        if (!((BridgeServerImpl)s).getSystem().getDistributedMember().equals(((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                        s.stop();
                        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                        ds.disconnect();
                    }
                }
            } else if (testName.equals("serverExecutionHAOneServerDown")) {
                if (numTimesSentResult == null) {
                    r.put((Object)"sentresult", (Object)1);
                } else {
                    numTimesSentResult = numTimesSentResult + 1;
                    r.put((Object)"sentresult", (Object)numTimesSentResult);
                }
                context.getResultSender().lastResult(args.get(0));
            } else {
                context.getResultSender().lastResult(args.get(0));
            }
        } else {
            if (numTimesStopped == null) {
                r.put((Object)"stopped", (Object)1);
            } else {
                numTimesStopped = numTimesStopped + 1;
                r.put((Object)"stopped", (Object)numTimesStopped);
            }
            for (CacheServer s : servers) {
                if (!((BridgeServerImpl)s).getSystem().getDistributedMember().equals(((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                s.stop();
                InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                ds.disconnect();
            }
        }
    }

    public void executeHAAndNonHAOnRegion(FunctionContext context) {
        List servers = CacheFactory.getAnyInstance().getCacheServers();
        ArrayList args = (ArrayList)context.getArguments();
        RegionFunctionContext rfContext = (RegionFunctionContext)context;
        rfContext.getDataSet().getCache().getLogger().info("Executing function :  executeHAAndNonHAOnRegion " + rfContext);
        Region r = CacheFactory.getAnyInstance().getRegion((String)args.get(0));
        String testName = (String)args.get(1);
        Integer numTimesStopped = (Integer)r.get((Object)"stopped");
        Integer numTimesSentResult = (Integer)r.get((Object)"sentresult");
        if (context.isPossibleDuplicate()) {
            if (testName.equals("regionExecutionHATwoServerDown")) {
                if ((Integer)r.get((Object)"stopped") == 2) {
                    if (numTimesSentResult == null) {
                        r.put((Object)"sentresult", (Object)1);
                    } else {
                        numTimesSentResult = numTimesSentResult + 1;
                        r.put((Object)"sentresult", (Object)numTimesSentResult);
                    }
                    context.getResultSender().lastResult(args.get(0));
                } else {
                    numTimesStopped = numTimesStopped + 1;
                    r.put((Object)"stopped", (Object)numTimesStopped);
                    for (CacheServer s : servers) {
                        if (!((BridgeServerImpl)s).getSystem().getDistributedMember().equals(((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                        s.stop();
                        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                        ds.disconnect();
                    }
                }
            } else if (testName.equals("regionExecutionHAOneServerDown")) {
                if (numTimesSentResult == null) {
                    r.put((Object)"sentresult", (Object)1);
                } else {
                    numTimesSentResult = numTimesSentResult + 1;
                    r.put((Object)"sentresult", (Object)numTimesSentResult);
                }
                context.getResultSender().lastResult(args.get(0));
            } else {
                context.getResultSender().lastResult(args.get(0));
            }
        } else {
            if (numTimesStopped == null) {
                r.put((Object)"stopped", (Object)1);
            } else {
                numTimesStopped = numTimesStopped + 1;
                r.put((Object)"stopped", (Object)numTimesStopped);
            }
            for (CacheServer s : servers) {
                if (!((BridgeServerImpl)s).getSystem().getDistributedMember().equals(((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                s.stop();
                InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                ds.disconnect();
            }
            context.getResultSender().lastResult(args.get(0));
        }
    }

    private void executeFunctionReexecuteExceptionOnServer(FunctionContext context) {
        if (context.isPossibleDuplicate()) {
            ++retryCount;
        } else {
            ++firstExecutionCount;
        }
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (retryCount >= 5) {
            logger.fine("Tried Function Execution 5 times. Now Returning after 5 attempts");
            context.getResultSender().sendResult((Object)new Integer(firstExecutionCount));
            context.getResultSender().lastResult((Object)new Integer(retryCount));
            firstExecutionCount = 0;
            retryCount = 0;
            return;
        }
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException Exception is intentionally thrown");
            throw new InternalFunctionInvocationTargetException((Throwable)new MyFunctionExecutionException("I have been thrown from TestFunction"));
        }
    }

    public void executeWithNoLastResult(FunctionContext context) {
        InternalDistributedSystem.getConnectedInstance().getLogWriter().info("<ExpectedException action=add>did not send last result</ExpectedException>");
        context.getResultSender().sendResult((Object)((Serializable)context.getArguments()));
    }

    private void executeWithLastResult(FunctionContext context) {
        RegionFunctionContext rfContext = (RegionFunctionContext)context;
        PartitionedRegion pr = (PartitionedRegion)rfContext.getDataSet();
        InternalResourceManager resMan = pr.getCache().getResourceManager();
        RebalanceFactory factory = resMan.createRebalanceFactory();
        RebalanceOperation rebalanceOp = factory.start();
        try {
            RebalanceResults rebalanceResults = rebalanceOp.getResults();
        }
        catch (CancellationException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        context.getResultSender().lastResult((Object)((Serializable)context.getArguments()));
    }

    public String getId() {
        return this.props.getProperty(ID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestFunction)) {
            return false;
        }
        TestFunction function = (TestFunction)((Object)obj);
        return this.props.equals(function.getConfig());
    }

    public boolean hasResult() {
        return Boolean.valueOf(this.props.getProperty(HAVE_RESULTS));
    }

    public Properties getConfig() {
        return this.props;
    }

    public void init(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public boolean isHA() {
        if (this.getId().equals(TEST_FUNCTION10)) {
            return true;
        }
        if (this.getId().equals(TEST_FUNCTION_NONHA_SERVER) || this.getId().equals(TEST_FUNCTION_NONHA_REGION)) {
            return false;
        }
        return Boolean.valueOf(this.props.getProperty(HAVE_RESULTS));
    }
}

