/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.QueueStateImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.Map;
import java.util.Properties;

public class EventIdOptimizationDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    private static final long ID_VALUE_BYTE = 127L;
    private static final long ID_VALUE_SHORT = 32767L;
    private static final long ID_VALUE_INT = Integer.MAX_VALUE;
    private static final long ID_VALUE_LONG = Long.MAX_VALUE;
    private static final String REGION_NAME = "EventIdOptimizationDUnitTest_region";
    protected static Cache cache = null;
    private static PoolImpl pool = null;
    private static volatile boolean proceedForValidation = false;
    private static volatile boolean validationFailed = false;
    static StringBuffer failureMsg = new StringBuffer();
    private static final String LAST_KEY = "LAST_KEY";
    private static final EventID eventIdForLastKey = new EventID(new byte[]{1, 2}, 3L, 4L);
    private static final EventID[] eventIds = new EventID[]{new EventID(new byte[]{1, 1}, 127L, 127L), new EventID(new byte[]{1, 1}, 127L, 32767L), new EventID(new byte[]{1, 1}, 127L, Integer.MAX_VALUE), new EventID(new byte[]{1, 1}, 127L, Long.MAX_VALUE), new EventID(new byte[]{1, 1}, 32767L, 127L), new EventID(new byte[]{1, 1}, 32767L, 32767L), new EventID(new byte[]{1, 1}, 32767L, Integer.MAX_VALUE), new EventID(new byte[]{1, 1}, 32767L, Long.MAX_VALUE), new EventID(new byte[]{1, 1}, Integer.MAX_VALUE, 127L), new EventID(new byte[]{1, 1}, Integer.MAX_VALUE, 32767L), new EventID(new byte[]{1, 1}, Integer.MAX_VALUE, Integer.MAX_VALUE), new EventID(new byte[]{1, 1}, Integer.MAX_VALUE, Long.MAX_VALUE), new EventID(new byte[]{1, 1}, Long.MAX_VALUE, 127L), new EventID(new byte[]{1, 1}, Long.MAX_VALUE, 32767L), new EventID(new byte[]{1, 1}, Long.MAX_VALUE, Integer.MAX_VALUE), new EventID(new byte[]{1, 1}, Long.MAX_VALUE, Long.MAX_VALUE)};

    public EventIdOptimizationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        EventIdOptimizationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        int PORT1 = (Integer)this.server1.invoke(EventIdOptimizationDUnitTest.class, "createServerCache");
        int PORT2 = (Integer)this.server2.invoke(EventIdOptimizationDUnitTest.class, "createServerCache");
        this.client1.invoke(EventIdOptimizationDUnitTest.class, "createClientCache1", new Object[]{EventIdOptimizationDUnitTest.getServerHostName(host), new Integer(PORT1)});
        this.client2.invoke(EventIdOptimizationDUnitTest.class, "createClientCache2", new Object[]{EventIdOptimizationDUnitTest.getServerHostName(host), new Integer(PORT2)});
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        EventIdOptimizationDUnitTest.assertNotNull((Object)cache);
    }

    public static Integer createServerCache() throws Exception {
        new EventIdOptimizationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        for (int i = 0; i < eventIds.length; ++i) {
            cache.createRegion(REGION_NAME + i, attrs);
        }
        BridgeServer server = cache.addBridgeServer();
        EventIdOptimizationDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache1(String hostName, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new EventIdOptimizationDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        BridgeTestCase.configureConnectionPool(factory, hostName, port, -1, true, -1, 2, null);
        BridgeServer bs1 = cache.addBridgeServer();
        bs1.setPort(port.intValue());
        pool = (PoolImpl)PoolManager.find((String)"testPool");
    }

    public static void createClientCache2(String hostName, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new EventIdOptimizationDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        BridgeTestCase.configureConnectionPool(factory, hostName, port, -1, true, -1, 2, null);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                String key = (String)event.getKey();
                EventIdOptimizationDUnitTest.validateEventsAtReceivingClientListener(key);
            }

            public void afterDestroy(EntryEvent event) {
                String key = (String)event.getKey();
                EventIdOptimizationDUnitTest.validateEventsAtReceivingClientListener(key);
            }

            public void afterRegionDestroy(RegionEvent event) {
                EventIdOptimizationDUnitTest.validateEventsAtReceivingClientListener(" <destroyRegion Event> ");
            }

            public void afterRegionClear(RegionEvent event) {
                EventIdOptimizationDUnitTest.validateEventsAtReceivingClientListener(" <clearRegion Event> ");
            }
        });
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.registerInterest((Object)"ALL_KEYS");
        for (int i = 0; i < eventIds.length; ++i) {
            region = cache.createRegion(REGION_NAME + i, attrs);
            region.registerInterest((Object)"ALL_KEYS");
        }
        pool = (PoolImpl)PoolManager.find((String)"testPool");
    }

    public static void generateEventsByPutOperation() throws Exception {
        Connection connection = pool.acquireConnection();
        String regionName = "/EventIdOptimizationDUnitTest_region";
        ServerRegionProxy srp = new ServerRegionProxy(regionName, pool);
        for (int i = 0; i < eventIds.length; ++i) {
            srp.putOnForTestsOnly(connection, (Object)("KEY-" + i), (Object)("VAL-" + i), eventIds[i], null);
        }
        srp.putOnForTestsOnly(connection, (Object)LAST_KEY, (Object)"LAST_VAL", eventIdForLastKey, null);
    }

    public static void generateEventsByDestroyEntryOperation() throws Exception {
        Connection connection = pool.acquireConnection();
        String regionName = "/EventIdOptimizationDUnitTest_region";
        ServerRegionProxy srp = new ServerRegionProxy(regionName, pool);
        for (int i = 0; i < eventIds.length; ++i) {
            srp.destroyOnForTestsOnly(connection, (Object)("KEY-" + i), null, Operation.DESTROY, new EntryEventImpl(eventIds[i]), null);
        }
        srp.destroyOnForTestsOnly(connection, (Object)LAST_KEY, null, Operation.DESTROY, new EntryEventImpl(eventIdForLastKey), null);
    }

    public static void generateEventsByDestroyRegionOperation() throws Exception {
        Connection connection = pool.acquireConnection();
        String regionName = "/EventIdOptimizationDUnitTest_region";
        for (int i = 0; i < 1; ++i) {
            ServerRegionProxy srp = new ServerRegionProxy(regionName + i, pool);
            srp.destroyRegionOnForTestsOnly(connection, eventIds[i], null);
        }
        ServerRegionProxy srp = new ServerRegionProxy(regionName, pool);
        srp.destroyRegionOnForTestsOnly(connection, eventIdForLastKey, null);
    }

    public static void generateEventsByClearRegionOperation() throws Exception {
        Connection connection = pool.acquireConnection();
        String regionName = "/EventIdOptimizationDUnitTest_region";
        ServerRegionProxy srp = new ServerRegionProxy(regionName, pool);
        for (int i = 0; i < eventIds.length; ++i) {
            srp.clearOnForTestsOnly(connection, eventIds[i], null);
        }
        srp.clearOnForTestsOnly(connection, eventIdForLastKey, null);
    }

    public void testEventIdOptimizationByPutOperation() throws Exception {
        this.client1.invoke(EventIdOptimizationDUnitTest.class, "generateEventsByPutOperation");
        this.client2.invoke(EventIdOptimizationDUnitTest.class, "verifyEventIdsOnClient2");
    }

    public void testEventIdOptimizationByDestroyEntryOperation() throws Exception {
        this.client1.invoke(EventIdOptimizationDUnitTest.class, "generateEventsByDestroyEntryOperation");
        this.client2.invoke(EventIdOptimizationDUnitTest.class, "verifyEventIdsOnClient2");
    }

    public void testEventIdOptimizationByDestroyRegionOperation() throws Exception {
        this.client1.invoke(EventIdOptimizationDUnitTest.class, "generateEventsByDestroyRegionOperation");
        this.client2.invoke(EventIdOptimizationDUnitTest.class, "verifyEventIdsOnClient2");
    }

    public void testEventIdOptimizationByClearRegionOperation() throws Exception {
        this.client1.invoke(EventIdOptimizationDUnitTest.class, "generateEventsByClearRegionOperation");
        this.client2.invoke(EventIdOptimizationDUnitTest.class, "verifyEventIdsOnClient2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void verifyEventIdsOnClient2() {
        if (!proceedForValidation) {
            Class<EventIdOptimizationDUnitTest> clazz = EventIdOptimizationDUnitTest.class;
            // MONITORENTER : com.gemstone.gemfire.internal.cache.ha.EventIdOptimizationDUnitTest.class
            if (!proceedForValidation) {
                try {
                    Log.getLogWriter().info("Client2 going in wait before starting validation");
                    EventIdOptimizationDUnitTest.class.wait();
                }
                catch (InterruptedException e) {
                    EventIdOptimizationDUnitTest.fail((String)"interrupted");
                }
            }
            // MONITOREXIT : clazz
        }
        Log.getLogWriter().info("Starting validation on client2");
        if (validationFailed) {
            EventIdOptimizationDUnitTest.fail((String)("\n The following eventIds recieved by client2 were not present in the eventId array sent by client1 \n" + failureMsg));
        }
        Log.getLogWriter().info("Validation complete on client2, goin to unregister listeners");
        Region region = cache.getRegion("/EventIdOptimizationDUnitTest_region");
        if (region != null && !region.isDestroyed()) {
            try {
                AttributesMutator mutator = region.getAttributesMutator();
                mutator.initCacheListeners(null);
            }
            catch (RegionDestroyedException mutator) {
                // empty catch block
            }
        }
        int i = 0;
        while (true) {
            if (i >= eventIds.length) {
                Log.getLogWriter().info("Test completed, Unregistered the listeners");
                return;
            }
            region = cache.getRegion("/EventIdOptimizationDUnitTest_region" + i);
            if (region != null && !region.isDestroyed()) {
                try {
                    AttributesMutator mutator = region.getAttributesMutator();
                    mutator.initCacheListeners(null);
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.client1.invoke(EventIdOptimizationDUnitTest.class, "closeCache");
        this.client2.invoke(EventIdOptimizationDUnitTest.class, "closeCache");
        this.server1.invoke(EventIdOptimizationDUnitTest.class, "closeCache");
        this.server2.invoke(EventIdOptimizationDUnitTest.class, "closeCache");
    }

    public static Object assertThreadIdToSequenceIdMapHasEntryId() {
        Map map = pool.getThreadIdToSequenceIdMap();
        EventIdOptimizationDUnitTest.assertNotNull((Object)map);
        EventIdOptimizationDUnitTest.assertTrue((map.size() != 0 ? 1 : 0) != 0);
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
        }
        ThreadIdentifier tid = (ThreadIdentifier)entry2.getKey();
        QueueStateImpl.SequenceIdAndExpirationObject seo = (QueueStateImpl.SequenceIdAndExpirationObject)entry2.getValue();
        long sequenceId = seo.getSequenceId();
        EventID evId = new EventID(tid.getMembershipID(), tid.getThreadID(), sequenceId);
        map.clear();
        return evId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateEventsAtReceivingClientListener(String key) {
        EventID eventIdAtClient2 = (EventID)EventIdOptimizationDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
        if (eventIdAtClient2.getThreadID() == eventIdForLastKey.getThreadID() && eventIdAtClient2.getSequenceID() == eventIdForLastKey.getSequenceID()) {
            Class<EventIdOptimizationDUnitTest> clazz = EventIdOptimizationDUnitTest.class;
            synchronized (EventIdOptimizationDUnitTest.class) {
                Log.getLogWriter().info("Notifying client2 to proceed for validation");
                proceedForValidation = true;
                EventIdOptimizationDUnitTest.class.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            boolean containsEventId = false;
            for (int i = 0; i < eventIds.length; ++i) {
                if (eventIdAtClient2.getThreadID() != eventIds[i].getThreadID() || eventIdAtClient2.getSequenceID() != eventIds[i].getSequenceID()) continue;
                containsEventId = true;
                break;
            }
            if (!containsEventId) {
                validationFailed = true;
                failureMsg.append("key = ").append(key).append(" ; eventID = ").append(eventIdAtClient2).append(System.getProperty("line.separator"));
            }
        }
    }
}

