/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.Properties;

public class FailoverDUnitTest
extends DistributedTestCase {
    protected static Cache cache = null;
    private static VM vm0 = null;
    private static VM vm1 = null;
    protected static VM primary = null;
    private static int PORT1;
    private static int PORT2;
    private static final String regionName = "interestRegion";

    public FailoverDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
        vm0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        vm1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        PORT1 = (Integer)vm0.invoke(FailoverDUnitTest.class, "createServerCache");
        PORT2 = (Integer)vm1.invoke(FailoverDUnitTest.class, "createServerCache");
        CacheServerTestUtil.disableShufflingOfEndpoints();
        FailoverDUnitTest.createClientCache(FailoverDUnitTest.getServerHostName(host), new Integer(PORT1), new Integer(PORT2));
        this.waitForPrimaryAndBackups(1);
        PoolImpl pool = (PoolImpl)PoolManager.find((String)"FailoverPool");
        if (pool.getPrimaryPort() == PORT1) {
            primary = vm0;
        } else {
            FailoverDUnitTest.assertEquals((int)PORT2, (int)pool.getPrimaryPort());
            primary = vm1;
        }
    }

    public void testFailover() {
        FailoverDUnitTest.createEntries();
        this.waitForPrimaryAndBackups(1);
        FailoverDUnitTest.registerInterestList();
        primary.invoke(FailoverDUnitTest.class, "put");
        this.verifyEntries();
        FailoverDUnitTest.setBridgeObserver();
        primary.invoke(FailoverDUnitTest.class, "stopServer");
        this.verifyEntriesAfterFailover();
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        FailoverDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        FailoverDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String hostName, Integer port1, Integer port2) throws Exception {
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new FailoverDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        BridgeTestCase.configureConnectionPoolWithName(factory, hostName, new int[]{PORT1, PORT2}, true, -1, 2, null, "FailoverPool");
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterUpdate(EntryEvent event) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    cache.getLogger().info("Event Received : key..." + event.getKey());
                    cache.getLogger().info("Event Received : value..." + event.getNewValue());
                }
            }
        });
        cache.createRegion(regionName, factory.create());
    }

    public static Integer createServerCache() throws Exception {
        new FailoverDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public void waitForPrimaryAndBackups(final int numBackups) {
        final PoolImpl pool = (PoolImpl)PoolManager.find((String)"FailoverPool");
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                if (pool.getPrimary() == null) {
                    return false;
                }
                return pool.getRedundants().size() >= numBackups;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
        FailoverDUnitTest.assertNotNull((Object)pool.getPrimary());
        FailoverDUnitTest.assertTrue((String)("backups=" + pool.getRedundants() + " expected=" + numBackups), (pool.getRedundants().size() >= numBackups ? 1 : 0) != 0);
    }

    public static void registerInterestList() {
        try {
            Region r = cache.getRegion("/interestRegion");
            FailoverDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"key-1");
            r.registerInterest((Object)"key-2");
            r.registerInterest((Object)"key-3");
            r.registerInterest((Object)"key-4");
            r.registerInterest((Object)"key-5");
        }
        catch (Exception ex) {
            FailoverDUnitTest.fail("failed while registering keys k1 to k5", ex);
        }
    }

    public static void createEntries() {
        try {
            Region r = cache.getRegion("/interestRegion");
            FailoverDUnitTest.assertNotNull((Object)r);
            r.create((Object)"key-1", (Object)"key-1");
            r.create((Object)"key-2", (Object)"key-2");
            r.create((Object)"key-3", (Object)"key-3");
            r.create((Object)"key-4", (Object)"key-4");
            r.create((Object)"key-5", (Object)"key-5");
        }
        catch (Exception ex) {
            FailoverDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void stopServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            FailoverDUnitTest.fail((String)("failed while stopServer()" + e));
        }
    }

    public static void put() {
        try {
            Region r = cache.getRegion("/interestRegion");
            FailoverDUnitTest.assertNotNull((Object)r);
            r.put((Object)"key-1", (Object)"value-1");
            r.put((Object)"key-2", (Object)"value-2");
            r.put((Object)"key-3", (Object)"value-3");
        }
        catch (Exception ex) {
            FailoverDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public void verifyEntries() {
        final Region r = cache.getRegion("/interestRegion");
        FailoverDUnitTest.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !r.getEntry((Object)"key-3").getValue().equals("key-3");
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
        FailoverDUnitTest.assertEquals((Object)"value-1", (Object)r.getEntry((Object)"key-1").getValue());
        FailoverDUnitTest.assertEquals((Object)"value-2", (Object)r.getEntry((Object)"key-2").getValue());
        FailoverDUnitTest.assertEquals((Object)"value-3", (Object)r.getEntry((Object)"key-3").getValue());
    }

    public static void setBridgeObserver() {
        PoolImpl.BEFORE_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void beforePrimaryIdentificationFromBackup() {
                primary.invoke(FailoverDUnitTest.class, "putDuringFailover");
                PoolImpl.BEFORE_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
            }
        });
    }

    public static void putDuringFailover() {
        try {
            Region r = cache.getRegion("/interestRegion");
            FailoverDUnitTest.assertNotNull((Object)r);
            r.put((Object)"key-4", (Object)"value-4");
            r.put((Object)"key-5", (Object)"value-5");
        }
        catch (Exception ex) {
            FailoverDUnitTest.fail("failed while r.putDuringFailover()", ex);
        }
    }

    public void verifyEntriesAfterFailover() {
        final Region r = cache.getRegion("/interestRegion");
        FailoverDUnitTest.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !r.getEntry((Object)"key-5").getValue().equals("key-5");
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
        FailoverDUnitTest.assertEquals((Object)"value-5", (Object)r.getEntry((Object)"key-5").getValue());
        FailoverDUnitTest.assertEquals((Object)"value-4", (Object)r.getEntry((Object)"key-4").getValue());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        FailoverDUnitTest.closeCache();
        vm0.invoke(FailoverDUnitTest.class, "closeCache");
        vm1.invoke(FailoverDUnitTest.class, "closeCache");
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
            cache = null;
        }
    }
}

