/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class HABugInPutDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    public static int PORT1;
    public static int PORT2;
    private static final String REGION_NAME = "HABugInPutDUnitTest_region";
    static final String KEY1 = "KEY1";
    static final String VALUE1 = "VALUE1";
    protected static Cache cache;

    public HABugInPutDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        PORT1 = (Integer)this.server1.invoke(HABugInPutDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(HABugInPutDUnitTest.class, "createServerCache");
        this.client1.invoke(HABugInPutDUnitTest.class, "createClientCache", new Object[]{HABugInPutDUnitTest.getServerHostName(host), new Integer(PORT1), new Integer(PORT2)});
        this.client2.invoke(HABugInPutDUnitTest.class, "createClientCache", new Object[]{HABugInPutDUnitTest.getServerHostName(host), new Integer(PORT1), new Integer(PORT2)});
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(HABugInPutDUnitTest.class, "closeCache");
        this.client2.invoke(HABugInPutDUnitTest.class, "closeCache");
        this.server1.invoke(HABugInPutDUnitTest.class, "closeCache");
        this.server2.invoke(HABugInPutDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HABugInPutDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HABugInPutDUnitTest.assertNotNull((Object)cache);
    }

    public static Integer createServerCache() throws Exception {
        new HABugInPutDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServerImpl server = (BridgeServerImpl)cache.addBridgeServer();
        HABugInPutDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(false);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache(String hostName, Integer port1, Integer port2) throws Exception {
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HABugInPutDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        BridgeTestCase.configureConnectionPool(factory, hostName, new int[]{PORT1, PORT2}, true, -1, 2, null);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        Region region = cache.getRegion("/HABugInPutDUnitTest_region");
        HABugInPutDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)KEY1);
    }

    public void testBugInPut() throws Exception {
        this.client1.invoke(new CacheSerializableRunnable("putFromClient1"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HABugInPutDUnitTest_region");
                TestCase.assertNotNull((Object)region);
                region.put((Object)HABugInPutDUnitTest.KEY1, (Object)HABugInPutDUnitTest.VALUE1);
                cache.getLogger().info("Put done successfully");
            }
        });
    }

    static {
        cache = null;
    }
}

