/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.Properties;
import junit.framework.TestCase;

public class HAClearDUnitTest
extends DistributedTestCase {
    static VM server1 = null;
    static VM server2 = null;
    static VM client1 = null;
    static VM client2 = null;
    public static int PORT1;
    public static int PORT2;
    private static final String REGION_NAME = "HAClearDUnitTest_Region";
    protected static Cache cache;
    static BridgeServerImpl server;
    static final int NO_OF_PUTS = 100;
    public static final Object dummyObj;
    static boolean waitFlag;
    static int put_counter;
    static boolean gotClearCallback;
    static boolean gotDestroyRegionCallback;

    public HAClearDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        server2 = host.getVM(1);
        server2.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(HAClearDUnitTest.class, "closeCache");
        client2.invoke(HAClearDUnitTest.class, "closeCache");
        server1.invoke(HAClearDUnitTest.class, "closeCache");
        server2.invoke(HAClearDUnitTest.class, "closeCache");
        HAClearDUnitTest.closeCache();
    }

    public void testClearWithOperationFromClient() throws Exception {
        this.createClientServerConfigurationForClearTest();
        gotClearCallback = false;
        this.putKnownKeys();
        Thread.sleep(5000L);
        int regionSize = 100;
        server1.invoke(this.checkSizeRegion(regionSize));
        server2.invoke(this.checkSizeRegion(regionSize));
        client1.invoke(this.checkSizeRegion(regionSize));
        client2.invoke(this.checkSizeRegion(regionSize));
        Region region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        HAClearDUnitTest.assertEquals((int)region.size(), (int)regionSize);
        this.clearRegion();
        client1.invoke(new CacheSerializableRunnable("waitForClearToCompleteFromClient1"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotClearCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"Interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotClearCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotClearCallback = false;
                    return;
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("waitForClearToCompleteFromClient2"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotClearCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotClearCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotClearCallback = false;
                    return;
                }
            }
        });
        regionSize = 0;
        client1.invoke(this.checkSizeRegion(regionSize));
        client2.invoke(this.checkSizeRegion(regionSize));
        server1.invoke(this.checkSizeRegion(regionSize));
        server2.invoke(this.checkSizeRegion(regionSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearWithOperationFromServer() throws Exception {
        this.createClientServerConfigurationForClearTest();
        gotClearCallback = false;
        server1.invoke(this.putFromServer());
        int regionSize = 100;
        Thread.sleep(5000L);
        server2.invoke(this.checkSizeRegion(regionSize));
        client1.invoke(this.checkSizeRegion(regionSize));
        client2.invoke(this.checkSizeRegion(regionSize));
        Region region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        HAClearDUnitTest.assertEquals((int)region.size(), (int)100);
        server1.invoke(this.clearRegionFromServer());
        client1.invoke(new CacheSerializableRunnable("waitForClearToCompleteCleint1"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotClearCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotClearCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotClearCallback = false;
                    return;
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("waitForClearToCompleteClient2"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotClearCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotClearCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotClearCallback = false;
                    return;
                }
            }
        });
        regionSize = 0;
        region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
        synchronized (HAClearDUnitTest.class) {
            while (!gotClearCallback) {
                try {
                    HAClearDUnitTest.class.wait();
                }
                catch (InterruptedException e) {
                    HAClearDUnitTest.fail((String)"interrupted");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!gotClearCallback) {
                HAClearDUnitTest.fail((String)"test failed");
            }
            gotClearCallback = false;
            HAClearDUnitTest.assertEquals((int)region.size(), (int)regionSize);
            server1.invoke(this.checkSizeRegion(regionSize));
            server2.invoke(this.checkSizeRegion(regionSize));
            client1.invoke(this.checkSizeRegion(regionSize));
            client2.invoke(this.checkSizeRegion(regionSize));
            return;
        }
    }

    public void testDestroyRegionWithOperationFromClient() throws Exception {
        this.createClientServerConfigurationForClearTest();
        gotDestroyRegionCallback = false;
        this.putKnownKeys();
        Thread.sleep(5000L);
        int regionSize = 100;
        Region region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        HAClearDUnitTest.assertEquals((int)region.size(), (int)regionSize);
        server1.invoke(this.checkSizeRegion(regionSize));
        server2.invoke(this.checkSizeRegion(regionSize));
        client1.invoke(this.checkSizeRegion(regionSize));
        client2.invoke(this.checkSizeRegion(regionSize));
        this.destroyRegion();
        Thread.sleep(1000L);
        client1.invoke(new CacheSerializableRunnable("waitForDestroyRegionToCompleteClient1"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotDestroyRegionCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotDestroyRegionCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotDestroyRegionCallback = false;
                    return;
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("waitForDestroyRegionToCompleteClient2"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotDestroyRegionCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotDestroyRegionCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotDestroyRegionCallback = false;
                    return;
                }
            }
        });
        region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNull((Object)region);
        client1.invoke(this.checkDestroyRegion());
        client2.invoke(this.checkDestroyRegion());
        server1.invoke(this.checkDestroyRegion());
        server2.invoke(this.checkDestroyRegion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDestroyRegionWithOperationFromServer() throws Exception {
        this.createClientServerConfigurationForClearTest();
        gotDestroyRegionCallback = false;
        server1.invoke(this.putFromServer());
        int regionSize = 100;
        Thread.sleep(5000L);
        server2.invoke(this.checkSizeRegion(regionSize));
        client1.invoke(this.checkSizeRegion(regionSize));
        client2.invoke(this.checkSizeRegion(regionSize));
        Region region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        HAClearDUnitTest.assertEquals((int)region.size(), (int)100);
        server1.invoke(this.destroyRegionFromServer());
        client1.invoke(new CacheSerializableRunnable("waitForDestroyRegionToCompleteFromClient1"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotDestroyRegionCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotDestroyRegionCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotDestroyRegionCallback = false;
                    return;
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("waitForDestroyRegionToCompleteFromClient2"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                synchronized (HAClearDUnitTest.class) {
                    while (!gotDestroyRegionCallback) {
                        try {
                            HAClearDUnitTest.class.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (!gotDestroyRegionCallback) {
                        TestCase.fail((String)"test failed");
                    }
                    gotDestroyRegionCallback = false;
                    return;
                }
            }
        });
        Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
        synchronized (HAClearDUnitTest.class) {
            while (!gotDestroyRegionCallback) {
                try {
                    HAClearDUnitTest.class.wait();
                }
                catch (InterruptedException e) {
                    HAClearDUnitTest.fail((String)"interrupted");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!gotDestroyRegionCallback) {
                HAClearDUnitTest.fail((String)"test failed");
            }
            gotDestroyRegionCallback = false;
            region = cache.getRegion("/HAClearDUnitTest_Region");
            HAClearDUnitTest.assertNull((Object)region);
            client1.invoke(this.checkDestroyRegion());
            client2.invoke(this.checkDestroyRegion());
            server1.invoke(this.checkDestroyRegion());
            server2.invoke(this.checkDestroyRegion());
            return;
        }
    }

    private CacheSerializableRunnable putFromServer() {
        CacheSerializableRunnable putFromServer = new CacheSerializableRunnable("putFromServer"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAClearDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key" + i), (Object)("value" + i));
                }
            }
        };
        return putFromServer;
    }

    private void putKnownKeys() {
        Region region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        for (int i = 0; i < 100; ++i) {
            region.put((Object)("key" + i), (Object)("value" + i));
        }
    }

    private void clearRegion() {
        LocalRegion region = (LocalRegion)cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        region.clear();
    }

    private void destroyRegion() {
        LocalRegion region = (LocalRegion)cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        region.destroyRegion();
    }

    private CacheSerializableRunnable clearRegionFromServer() {
        CacheSerializableRunnable clearFromServer = new CacheSerializableRunnable("clearFromServer"){

            @Override
            public void run2() {
                LocalRegion region = (LocalRegion)cache.getRegion("/HAClearDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                region.clear();
            }
        };
        return clearFromServer;
    }

    private CacheSerializableRunnable destroyRegionFromServer() {
        CacheSerializableRunnable clearFromServer = new CacheSerializableRunnable("destroyRegionFromServer"){

            @Override
            public void run2() {
                LocalRegion region = (LocalRegion)cache.getRegion("/HAClearDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                region.destroyRegion();
            }
        };
        return clearFromServer;
    }

    private CacheSerializableRunnable checkSizeRegion(final int size) {
        CacheSerializableRunnable clearRegion = new CacheSerializableRunnable("checkSize"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAClearDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                Log.getLogWriter().info("Size of the region " + region.size());
                TestCase.assertEquals((int)size, (int)region.size());
            }
        };
        return clearRegion;
    }

    private CacheSerializableRunnable checkDestroyRegion() {
        CacheSerializableRunnable destroyRegion = new CacheSerializableRunnable("checkDestroyRegion"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAClearDUnitTest_Region");
                DistributedTestCase.getLogWriter().warning("Found region " + region);
                TestCase.assertNull((Object)region);
            }
        };
        return destroyRegion;
    }

    private void createClientServerConfigurationForClearTest() throws Exception {
        PORT1 = (Integer)server1.invoke(HAClearDUnitTest.class, "createServerCache");
        PORT2 = (Integer)server2.invoke(HAClearDUnitTest.class, "createServerCache");
        client1.invoke(HAClearDUnitTest.class, "createClientCache", new Object[]{HAClearDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), new Boolean(true), new Boolean(true)});
        client2.invoke(HAClearDUnitTest.class, "createClientCache", new Object[]{HAClearDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), new Boolean(true), new Boolean(true)});
        HAClearDUnitTest.createClientCache(HAClearDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2), new Boolean(true), new Boolean(true));
    }

    public static Integer createServerCache() throws Exception {
        new HAClearDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        server = (BridgeServerImpl)cache.addBridgeServer();
        HAClearDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.start();
        return new Integer(server.getPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HAClearDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAClearDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String hostName, Integer port1, Integer port2, Boolean listenerAttached, Boolean registerInterest) throws Exception {
        PORT1 = port1;
        PORT2 = port2;
        boolean isListenerAttached = listenerAttached;
        boolean isRegisterInterest = registerInterest;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAClearDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        BridgeTestCase.configureConnectionPool(factory, hostName, new int[]{PORT1, PORT2}, true, -1, 2, null);
        if (isListenerAttached) {
            factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRegionClear(RegionEvent event) {
                    DistributedTestCase.getLogWriter().info("-------> afterRegionClear received");
                    Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                    synchronized (HAClearDUnitTest.class) {
                        gotClearCallback = true;
                        HAClearDUnitTest.class.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRegionDestroy(RegionEvent event) {
                    Class<HAClearDUnitTest> clazz = HAClearDUnitTest.class;
                    synchronized (HAClearDUnitTest.class) {
                        DistributedTestCase.getLogWriter().info("-------> afterRegionDestroy received");
                        gotDestroyRegionCallback = true;
                        HAClearDUnitTest.class.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        Region region = cache.getRegion("/HAClearDUnitTest_Region");
        HAClearDUnitTest.assertNotNull((Object)region);
        if (isRegisterInterest) {
            region.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        } else {
            region.registerInterestRegex("*.", false, false);
        }
    }

    public static void closeCache() {
        String p1 = "Problem removing all interest on region=";
        if (cache != null && !cache.isClosed()) {
            cache.getDistributedSystem().getLogWriter().info("<ExpectedException action=add>" + p1 + "</ExpectedException>");
            cache.close();
            cache.getDistributedSystem().getLogWriter().info("<ExpectedException action=remove>" + p1 + "</ExpectedException>");
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        cache = null;
        server = null;
        dummyObj = "dummyObject";
        waitFlag = true;
        put_counter = 0;
        gotClearCallback = false;
        gotDestroyRegionCallback = false;
    }
}

