/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.ha.HAClientCountEventListener;
import com.gemstone.gemfire.internal.cache.ha.HADispatcherDUnitTest;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class HAConflationDUnitTest
extends CacheTestCase {
    VM server1 = null;
    VM client1 = null;
    public static int PORT1;
    private static final String regionName = "HAConflationDUnitTest_region";
    static final String KEY1 = "KEY1";
    static final String KEY2 = "KEY2";
    static final String KEY3 = "KEY3";
    static final String VALUE1 = "VALUE1";
    static final String VALUE2 = "VALUE2";
    static final String VALUE3 = "VALUE3";
    static final String LAST_KEY = "lastkey";
    static final String LAST_VALUE = "lastvalue";
    static boolean lastKeyArrived;
    static Object LOCK;
    static int expectedNoEvents;
    static int actualNoEvents;

    public HAConflationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.client1 = host.getVM(2);
        PORT1 = (Integer)this.server1.invoke(HAConflationDUnitTest.class, "createServerCache", new Object[]{new Boolean(false)});
        this.server1.invoke(ConflationDUnitTest.class, "setIsSlowStart");
        this.server1.invoke(HAConflationDUnitTest.class, "makeDispatcherSlow");
        this.client1.invoke(HAConflationDUnitTest.class, "createClientCache", new Object[]{HAConflationDUnitTest.getServerHostName(host), new Integer(PORT1), new Boolean(true)});
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(HADispatcherDUnitTest.class, "closeCache");
        this.server1.invoke(HADispatcherDUnitTest.class, "closeCache");
    }

    public void testConflationCreateUpdate() throws Exception {
        this.server1.invoke(this.putFromServer(KEY1, VALUE1));
        this.server1.invoke(this.putFromServer(KEY1, VALUE2));
        this.server1.invoke(this.putFromServer(LAST_KEY, LAST_VALUE));
        expectedNoEvents = 2;
        this.client1.invoke(this.checkNoEvents(expectedNoEvents));
    }

    public void testConflationUpdate() throws Exception {
        this.server1.invoke(this.putFromServer(KEY1, VALUE1));
        this.server1.invoke(this.putFromServer(KEY1, VALUE2));
        this.server1.invoke(this.putFromServer(KEY1, VALUE3));
        this.server1.invoke(this.putFromServer(KEY1, VALUE1));
        this.server1.invoke(this.putFromServer(KEY1, VALUE2));
        this.server1.invoke(this.putFromServer(KEY1, VALUE3));
        this.server1.invoke(this.putFromServer(KEY1, VALUE1));
        this.server1.invoke(this.putFromServer(KEY1, VALUE2));
        this.server1.invoke(this.putFromServer(KEY1, VALUE3));
        this.server1.invoke(this.putFromServer(LAST_KEY, LAST_VALUE));
        expectedNoEvents = 2;
        this.client1.invoke(this.checkNoEvents(expectedNoEvents));
    }

    public void testConflationCreateUpdateInvalidate() throws Exception {
        this.server1.invoke(this.putFromServer(KEY1, VALUE1));
        this.server1.invoke(this.putFromServer(KEY1, VALUE2));
        this.server1.invoke(this.putFromServer(KEY1, VALUE3));
        this.server1.invoke(this.invalidateFromServer(KEY1));
        this.server1.invoke(this.putFromServer(LAST_KEY, LAST_VALUE));
        expectedNoEvents = 3;
        this.client1.invoke(this.checkNoEvents(expectedNoEvents));
    }

    public void testConflationCreateUpdateDestroy() throws Exception {
        this.server1.invoke(this.putFromServer(KEY1, VALUE1));
        this.server1.invoke(this.putFromServer(KEY1, VALUE2));
        this.server1.invoke(this.putFromServer(KEY1, VALUE3));
        this.server1.invoke(this.destroyFromServer(KEY1));
        this.server1.invoke(this.putFromServer(LAST_KEY, LAST_VALUE));
        expectedNoEvents = 3;
        this.client1.invoke(this.checkNoEvents(expectedNoEvents));
    }

    private CacheSerializableRunnable putFromServer(final String key, final String value) {
        CacheSerializableRunnable performPut = new CacheSerializableRunnable("putFromServer"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAConflationDUnitTest_region");
                TestCase.assertNotNull((Object)region);
                cache.getLogger().info("starting put()");
                region.put((Object)key, (Object)value);
                cache.getLogger().info("finished put()");
            }
        };
        return performPut;
    }

    private CacheSerializableRunnable invalidateFromServer(final String key) {
        CacheSerializableRunnable performInvalidate = new CacheSerializableRunnable("invalidateFromServer"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAConflationDUnitTest_region");
                TestCase.assertNotNull((Object)region);
                region.invalidate((Object)key);
                cache.getLogger().info("done invalidate() successfully");
            }
        };
        return performInvalidate;
    }

    private CacheSerializableRunnable destroyFromServer(final String key) {
        CacheSerializableRunnable performDestroy = new CacheSerializableRunnable("performDestroy"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAConflationDUnitTest_region");
                TestCase.assertNotNull((Object)region);
                region.destroy((Object)key);
                cache.getLogger().info("done destroy successfully");
            }
        };
        return performDestroy;
    }

    private CacheSerializableRunnable checkNoEvents(final int expectedEvents) {
        CacheSerializableRunnable checkEvents = new CacheSerializableRunnable("checkEvents"){
            final int interval = 200;
            {
                super(x0);
                this.interval = 200;
            }

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion w = new DistributedTestCase.WaitCriterion(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean done() {
                        Object object = LOCK;
                        synchronized (object) {
                            if (!lastKeyArrived) {
                                try {
                                    LOCK.wait(200L);
                                }
                                catch (InterruptedException e) {
                                    TestCase.fail((String)"interrupted");
                                }
                            }
                        }
                        return lastKeyArrived;
                    }

                    @Override
                    public String description() {
                        return "expected " + expectedEvents + " events but received " + actualNoEvents;
                    }
                };
                DistributedTestCase.waitForCriterion(w, 180000L, 200L, true);
            }
        };
        return checkEvents;
    }

    public static void makeDispatcherSlow() {
        System.setProperty("slowStartTimeForTesting", "15000");
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HAConflationDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAConflationDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1, Boolean isListenerPresent) throws Exception {
        PORT1 = port1;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAConflationDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        BridgeTestCase.configureConnectionPool(factory, host, new int[]{PORT1}, true, -1, -1, null);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableConflation(true);
        if (isListenerPresent.booleanValue()) {
            HAClientCountEventListener clientListener = new HAClientCountEventListener();
            factory.setCacheListener((CacheListener)clientListener);
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        Region region = cache.getRegion("/HAConflationDUnitTest_region");
        HAConflationDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)KEY1);
        region.registerInterest((Object)KEY2);
        region.registerInterest((Object)KEY3);
        region.registerInterest((Object)LAST_KEY);
        lastKeyArrived = false;
        actualNoEvents = 0;
    }

    public static Integer createServerCache(Boolean isListenerPresent) throws Exception {
        new HAConflationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        if (isListenerPresent.booleanValue()) {
            HAClientCountEventListener serverListener = new HAClientCountEventListener();
            factory.setCacheListener((CacheListener)serverListener);
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        BridgeServerImpl server = (BridgeServerImpl)cache.addBridgeServer();
        HAConflationDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    static {
        lastKeyArrived = false;
        LOCK = new Object();
        expectedNoEvents = 2;
        actualNoEvents = 0;
    }
}

