/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.ha.HAValidateDuplicateListener;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class HADuplicateDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    public static int PORT1;
    public static int PORT2;
    private static final String REGION_NAME = "HADuplicateDUnitTest_Region";
    protected static Cache cache;
    static boolean isEventDuplicate;
    static BridgeServerImpl server;
    static final int NO_OF_PUTS = 100;
    public static final Object dummyObj;
    static boolean waitFlag;
    static int put_counter;
    static Map storeEvents;

    public HADuplicateDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(HADuplicateDUnitTest.class, "closeCache");
        this.server1.invoke(HADuplicateDUnitTest.class, "reSetQRMslow");
        this.server1.invoke(HADuplicateDUnitTest.class, "closeCache");
        this.server2.invoke(HADuplicateDUnitTest.class, "closeCache");
    }

    public void _testDuplicate() throws Exception {
        this.createClientServerConfiguration();
        this.server1.invoke(this.putForKnownKeys());
        this.server1.invoke(this.stopServer());
        this.client1.invoke(new CacheSerializableRunnable("waitForPutToComplete"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Object object = dummyObj;
                synchronized (object) {
                    while (waitFlag) {
                        try {
                            dummyObj.wait();
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
                if (waitFlag) {
                    TestCase.fail((String)"test failed");
                }
            }
        });
        this.client1.invoke(new CacheSerializableRunnable("validateDuplicates"){

            @Override
            public void run2() throws CacheException {
                if (!isEventDuplicate) {
                    TestCase.fail((String)" Not all duplicates received");
                }
            }
        });
        this.server1.invoke(HADuplicateDUnitTest.class, "reSetQRMslow");
    }

    public void testSample() throws Exception {
        this.createClientServerConfiguration();
        this.server1.invoke(new CacheSerializableRunnable("putKey"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HADuplicateDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                region.put((Object)"key1", (Object)"value1");
            }
        });
    }

    private CacheSerializableRunnable putForKnownKeys() {
        CacheSerializableRunnable putforknownkeys = new CacheSerializableRunnable("putforknownkeys"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HADuplicateDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key" + i), (Object)("value" + i));
                }
            }
        };
        return putforknownkeys;
    }

    private CacheSerializableRunnable stopServer() {
        CacheSerializableRunnable stopserver = new CacheSerializableRunnable("stopServer"){

            @Override
            public void run2() throws CacheException {
                server.stop();
            }
        };
        return stopserver;
    }

    private void createClientServerConfiguration() {
        PORT1 = (Integer)this.server1.invoke(HADuplicateDUnitTest.class, "createServerCache");
        this.server1.invoke(HADuplicateDUnitTest.class, "setQRMslow");
        PORT2 = (Integer)this.server2.invoke(HADuplicateDUnitTest.class, "createServerCache");
        this.client1.invoke(HADuplicateDUnitTest.class, "createClientCache", new Object[]{HADuplicateDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2)});
    }

    public static void setQRMslow() {
        System.setProperty("QueueRemovalThreadWaitTime", "100000");
    }

    public static void reSetQRMslow() {
        System.setProperty("QueueRemovalThreadWaitTime", "1000");
    }

    public static Integer createServerCache() throws Exception {
        new HADuplicateDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        server = (BridgeServerImpl)cache.addBridgeServer();
        HADuplicateDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HADuplicateDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HADuplicateDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String hostName, Integer port1, Integer port2) throws Exception {
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HADuplicateDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        BridgeTestCase.configureConnectionPool(factory, hostName, new int[]{PORT1, PORT2}, true, -1, 2, null);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        HAValidateDuplicateListener clientListener = new HAValidateDuplicateListener();
        factory.setCacheListener((CacheListener)clientListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        Region region = cache.getRegion("/HADuplicateDUnitTest_Region");
        HADuplicateDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        cache = null;
        isEventDuplicate = true;
        server = null;
        dummyObj = "dummyObject";
        waitFlag = true;
        put_counter = 0;
        storeEvents = new HashMap();
    }
}

