/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueueAttributes;
import com.gemstone.gemfire.internal.cache.ha.vmListener;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class HAExpiryDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    protected static Cache cache = null;
    static String regionQueueName = "regionQueue1";
    private static final String REGION_NAME = "HAExpiryDUnitTest_region";
    static RegionQueue regionqueue = null;
    protected static int regionQueueSize = -1;

    public HAExpiryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.vm0.invoke(HAExpiryDUnitTest.class, "closeCache");
        this.vm1.invoke(HAExpiryDUnitTest.class, "closeCache");
        this.vm2.invoke(HAExpiryDUnitTest.class, "closeCache");
        this.vm3.invoke(HAExpiryDUnitTest.class, "closeCache");
        cache = null;
        HAExpiryDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public void testExpiryPeriod() throws Exception {
        this.vm0.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(false)});
        this.vm1.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(false)});
        this.vm2.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(false)});
        this.vm3.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(false)});
        this.vm0.invoke(new CacheSerializableRunnable("putFromVm"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAExpiryDUnitTest_region");
                region.put((Object)"KEY1", (Object)"VALUE1");
            }
        });
        this.vm0.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm1.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm2.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm3.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm0.invoke(HAExpiryDUnitTest.class, "checkSizeAfterExpiration");
        this.vm1.invoke(HAExpiryDUnitTest.class, "checkSizeAfterExpiration");
        this.vm2.invoke(HAExpiryDUnitTest.class, "checkSizeAfterExpiration");
        this.vm3.invoke(HAExpiryDUnitTest.class, "checkSizeAfterExpiration");
    }

    public void testDurableExpiryPeriod() throws Exception {
        this.vm0.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(true)});
        this.vm1.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(true)});
        this.vm2.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(true)});
        this.vm3.invoke(HAExpiryDUnitTest.class, "createRegionQueue", new Object[]{new Boolean(true)});
        this.vm0.invoke(new CacheSerializableRunnable("putFromVm"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAExpiryDUnitTest_region");
                region.put((Object)"KEY1", (Object)"VALUE1");
            }
        });
        this.vm0.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm1.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm2.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm3.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        HAExpiryDUnitTest.pause(5000);
        this.vm0.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm1.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm2.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
        this.vm3.invoke(HAExpiryDUnitTest.class, "checkSizeBeforeExpiration");
    }

    public static void checkSizeBeforeExpiration() throws Exception {
        HARegion regionForQueue = (HARegion)cache.getRegion("/" + HARegionQueue.createRegionName((String)regionQueueName));
        final HARegionQueue regionqueue = regionForQueue.getOwner();
        regionQueueSize = regionqueue.size();
        cache.getLogger().info("Size of the regionqueue before expiration is " + regionQueueSize);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return regionqueue.size() >= 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    public static void checkSizeAfterExpiration() throws Exception {
        HARegion regionForQueue = (HARegion)cache.getRegion("/" + HARegionQueue.createRegionName((String)regionQueueName));
        final HARegionQueue regionqueue = regionForQueue.getOwner();
        cache.getLogger().info("Size of the regionqueue After expiration is " + regionqueue.size());
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return regionqueue.size() <= regionQueueSize;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HAExpiryDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAExpiryDUnitTest.assertNotNull((Object)cache);
    }

    public static void createRegionQueue(Boolean isDurable) throws Exception {
        new HAExpiryDUnitTest("temp").createCache(new Properties());
        HARegionQueueAttributes hattr = new HARegionQueueAttributes();
        hattr.setExpiryTime(4);
        HARegionQueue regionqueue = HARegionQueue.getHARegionQueueInstance((String)regionQueueName, (Cache)cache, (HARegionQueueAttributes)hattr, (int)2, (boolean)isDurable);
        HAExpiryDUnitTest.assertNotNull((Object)regionqueue);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        vmListener serverListener = new vmListener();
        factory.setCacheListener((CacheListener)serverListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }
}

