/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.ha.ConflatableObject;
import com.gemstone.gemfire.internal.cache.ha.HAExpiryDUnitTest;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueueAttributes;
import com.gemstone.gemfire.internal.cache.ha.vmListenerToCheckHARegionQueue;
import com.gemstone.gemfire.internal.cache.ha.vmListenerToPutInHARegionQueue;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;

public class HAGIIBugDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    protected static Cache cache = null;
    static String regionQueueName = "regionQueue1";
    private static final String REGION_NAME = "HAGIIBugDUnitTest_region";
    static RegionQueue regionqueue = null;
    static boolean isTestFailed = false;
    static final int NO_OF_PUTS = 100;
    static final int NO_OF_PUTS_BEFORE_GII = 10000;
    static int TOTAL_NO_OF_PUTS = 0;
    static volatile boolean isHARegionQueueUp = false;
    static volatile boolean isStop = false;
    static Object[] total_no_puts = new Object[4];
    ArrayList keys_set_before_gii = new ArrayList();
    static ArrayList keys_set_after_gii = new ArrayList();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        this.vm0.invoke(HAGIIBugDUnitTest.class, "createRegionQueue");
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.vm0.invoke(HAGIIBugDUnitTest.class, "closeCache");
        this.vm1.invoke(HAGIIBugDUnitTest.class, "closeCache");
        this.vm2.invoke(HAGIIBugDUnitTest.class, "closeCache");
        this.vm3.invoke(HAGIIBugDUnitTest.class, "closeCache");
        cache = null;
        HAGIIBugDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    protected void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HAGIIBugDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAGIIBugDUnitTest.assertNotNull((Object)cache);
    }

    public void testDummy() throws Exception {
        Log.getLogWriter().info("This is Dummy test for the GII");
    }

    public void _testGIIBug() throws Exception {
        this.vm0.invoke(this.putFromVmBeforeGII("vm0_1"));
        this.populateKeySet("vm0_1");
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    HAGIIBugDUnitTest.this.createCache(new Properties());
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    vmListenerToCheckHARegionQueue regionListener = new vmListenerToCheckHARegionQueue();
                    factory.setCacheListener((CacheListener)regionListener);
                    RegionAttributes attrs = factory.create();
                    Region region = cache.createRegion(HAGIIBugDUnitTest.REGION_NAME, attrs);
                    Log.getLogWriter().info("Name of the region is : " + region.getFullPath());
                    HARegionQueueAttributes hattr = new HARegionQueueAttributes();
                    hattr.setExpiryTime(12000000);
                    HARegionQueue regionqueue = null;
                    regionqueue = HARegionQueue.getHARegionQueueInstance((String)regionQueueName, (Cache)cache, (HARegionQueueAttributes)hattr, (int)2, (boolean)false);
                    isHARegionQueueUp = true;
                    HAGIIBugDUnitTest.this.vm0.invoke(HAGIIBugDUnitTest.this.setStopFlag());
                    TestCase.assertNotNull((Object)regionqueue);
                }
                catch (Exception e) {
                    isTestFailed = true;
                    e.printStackTrace();
                }
            }
        };
        AsyncInvocation[] async = new AsyncInvocation[4];
        async[0] = this.vm0.invokeAsync(this.putFrmVm("vm0_2"));
        t1.start();
        DistributedTestCase.join(t1, 30000L, HAGIIBugDUnitTest.getLogWriter());
        if (isTestFailed) {
            HAGIIBugDUnitTest.fail((String)"HARegionQueue can not be created");
        }
        for (int count = 0; count < 1; ++count) {
            DistributedTestCase.join(async[count], 30000L, HAGIIBugDUnitTest.getLogWriter());
            if (!async[count].exceptionOccurred()) continue;
            HAGIIBugDUnitTest.fail("Got exception on " + count, async[count].getException());
        }
        HAGIIBugDUnitTest.total_no_puts[0] = this.vm0.invoke(HAGIIBugDUnitTest.class, "getTotalNoPuts");
        this.populate_keys_after_gii();
        boolean validationFlag = false;
        this.validateResults(validationFlag);
        if (this.keys_set_before_gii.size() != 0) {
            HAGIIBugDUnitTest.fail((String)"Data in the HARegion Queue is inconsistent for the keys that are put before GII");
        }
        validationFlag = true;
        this.validateResults(validationFlag);
        Log.getLogWriter().info("No. of keys that are missed by HARegion Queue during GII " + keys_set_after_gii.size());
        if (keys_set_after_gii.size() != 0) {
            HAGIIBugDUnitTest.fail((String)"Set of the keys are missed by HARegion Queue during GII");
        }
    }

    private void populate_keys_after_gii() {
        for (int i = 0; i < 1; ++i) {
            long totalPuts = (Long)total_no_puts[i] - 300L;
            Log.getLogWriter().info("Total no of puts expectesd " + totalPuts);
            int j = 0;
            while ((long)j < totalPuts) {
                keys_set_after_gii.add("vm" + i + "_2" + j);
                ++j;
            }
        }
    }

    private void populateKeySet(String whichKey) {
        for (int i = 0; i < 10000; ++i) {
            this.keys_set_before_gii.add(whichKey + i);
        }
    }

    private void validateResults(boolean isSecond) {
        HARegion regionForQueue = (HARegion)cache.getRegion("/" + HARegionQueue.createRegionName((String)HAExpiryDUnitTest.regionQueueName));
        Log.getLogWriter().info("Region Queue size : " + regionForQueue.keys().size());
        for (Region.Entry entry : regionForQueue.entries(false)) {
            if (!(entry.getKey() instanceof Long)) continue;
            String strValue = (String)((ConflatableObject)entry.getValue()).getKey();
            if (isSecond) {
                if (strValue.indexOf("_2") == -1 || !keys_set_after_gii.contains(((ConflatableObject)entry.getValue()).getKey())) continue;
                keys_set_after_gii.remove(strValue);
                continue;
            }
            if (strValue.indexOf("_1") == -1) continue;
            if (!this.keys_set_before_gii.contains(strValue)) {
                HAGIIBugDUnitTest.fail((String)("Key " + ((ConflatableObject)entry.getValue()).getKey() + " not present in the region queue before GII"));
                continue;
            }
            this.keys_set_before_gii.remove(strValue);
        }
    }

    public static Object getTotalNoPuts() {
        return new Long(TOTAL_NO_OF_PUTS);
    }

    private CacheSerializableRunnable putFromVmBeforeGII(final String whichVm) {
        CacheSerializableRunnable putBeforeGII = new CacheSerializableRunnable("putBeforeGII"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAGIIBugDUnitTest_region");
                for (int i = 0; i < 10000; ++i) {
                    region.put((Object)(whichVm + i), (Object)(whichVm + i));
                }
            }
        };
        return putBeforeGII;
    }

    private CacheSerializableRunnable putFrmVm(final String whichVm) {
        CacheSerializableRunnable putFromVM = new CacheSerializableRunnable("putFromVM"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HAGIIBugDUnitTest_region");
                int j = 0;
                while (!isStop) {
                    for (int i = 0; i < 100; ++i) {
                        region.put((Object)(whichVm + j), (Object)(whichVm + j));
                        ++j;
                    }
                    TOTAL_NO_OF_PUTS += 100;
                }
                Log.getLogWriter().info("Total no of puts : " + TOTAL_NO_OF_PUTS);
            }
        };
        return putFromVM;
    }

    protected CacheSerializableRunnable setStopFlag() {
        CacheSerializableRunnable setFlag = new CacheSerializableRunnable("setFlag"){

            @Override
            public void run2() throws CacheException {
                isStop = true;
            }
        };
        return setFlag;
    }

    public static void createRegionQueue() throws Exception {
        new HAGIIBugDUnitTest("temp").createCache(new Properties());
        HARegionQueueAttributes hattr = new HARegionQueueAttributes();
        hattr.setExpiryTime(12000000);
        HARegionQueue regionqueue = HARegionQueue.getHARegionQueueInstance((String)regionQueueName, (Cache)cache, (HARegionQueueAttributes)hattr, (int)2, (boolean)false);
        HAGIIBugDUnitTest.assertNotNull((Object)regionqueue);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        vmListenerToPutInHARegionQueue regionListener = new vmListenerToPutInHARegionQueue();
        factory.setCacheListener((CacheListener)regionListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public HAGIIBugDUnitTest(String arg0) {
        super(arg0);
    }
}

