/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.ha.GIIChecker;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientTombstoneMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class HAGIIDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server0 = null;
    private static VM server1 = null;
    private static VM client0 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "HAGIIDUnitTest_region";
    protected static GIIChecker checker;

    public HAGIIDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server0 = host.getVM(0);
        server1 = host.getVM(1);
        client0 = host.getVM(2);
        PORT1 = (Integer)server0.invoke(HAGIIDUnitTest.class, "createServer1Cache");
        server0.invoke(ConflationDUnitTest.class, "setIsSlowStart");
        server0.invoke(HAGIIDUnitTest.class, "setSystemProperty");
        PORT2 = AvailablePort.getRandomAvailablePort((int)0);
        client0.invoke(HAGIIDUnitTest.class, "createClientCache", new Object[]{HAGIIDUnitTest.getServerHostName(host), new Integer(PORT1), new Integer(PORT2)});
    }

    public void testGIIRegionQueue() {
        client0.invoke(HAGIIDUnitTest.class, "createEntries");
        client0.invoke(HAGIIDUnitTest.class, "registerInterestList");
        server0.invoke(HAGIIDUnitTest.class, "put");
        server0.invoke(HAGIIDUnitTest.class, "tombstonegc");
        client0.invoke(HAGIIDUnitTest.class, "verifyEntries");
        server1.invoke(HAGIIDUnitTest.class, "createServer2Cache", new Object[]{new Integer(PORT2)});
        HAGIIDUnitTest.pause(6000);
        server0.invoke(HAGIIDUnitTest.class, "stopServer");
        client0.invoke(HAGIIDUnitTest.class, "verifyEntriesAfterGiiViaListener");
    }

    public void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        HAGIIDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAGIIDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAGIIDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        BridgeTestCase.configureConnectionPool(factory, host, new int[]{PORT1, PORT2}, true, -1, 2, null, 1000, -1, false, -1);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.addCacheListener((CacheListener)checker);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServer1Cache() throws Exception {
        new HAGIIDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public static void createServer2Cache(Integer port) throws Exception {
        new HAGIIDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
    }

    public static void registerInterestList() {
        try {
            Region r = cache.getRegion("/HAGIIDUnitTest_region");
            HAGIIDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"key-1", InterestResultPolicy.KEYS_VALUES);
            r.registerInterest((Object)"key-2", InterestResultPolicy.KEYS_VALUES);
            r.registerInterest((Object)"key-3", InterestResultPolicy.KEYS_VALUES);
        }
        catch (Exception ex) {
            HAGIIDUnitTest.fail("failed while registering keys ", ex);
        }
    }

    public static void createEntries() {
        try {
            Region r = cache.getRegion("/HAGIIDUnitTest_region");
            HAGIIDUnitTest.assertNotNull((Object)r);
            r.create((Object)"key-1", (Object)"key-1");
            r.create((Object)"key-2", (Object)"key-2");
            r.create((Object)"key-3", (Object)"key-3");
        }
        catch (Exception ex) {
            HAGIIDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void stopServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            HAGIIDUnitTest.fail((String)("failed while stopServer()" + e));
        }
    }

    public static void put() {
        try {
            Region r = cache.getRegion("/HAGIIDUnitTest_region");
            HAGIIDUnitTest.assertNotNull((Object)r);
            r.put((Object)"key-1", (Object)"value-1");
            r.put((Object)"key-2", (Object)"value-2");
            r.put((Object)"key-3", (Object)"value-3");
        }
        catch (Exception ex) {
            HAGIIDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void tombstonegc() throws Exception {
        LocalRegion r = (LocalRegion)cache.getRegion("/HAGIIDUnitTest_region");
        HAGIIDUnitTest.assertNotNull((Object)r);
        InternalDistributedMember id = r.getCache().getDistributedSystem().getDistributedMember();
        RegionEventImpl regionEvent = new RegionEventImpl((Region)r, Operation.REGION_DESTROY, null, true, (DistributedMember)id);
        FilterRoutingInfo.FilterInfo clientRouting = r.getFilterProfile().getLocalFilterRouting((CacheEvent)regionEvent);
        HAGIIDUnitTest.assertTrue((clientRouting.getInterestedClients().size() > 0 ? 1 : 0) != 0);
        regionEvent.setLocalFilterInfo(clientRouting);
        Map map = Collections.emptyMap();
        ClientTombstoneMessage message = ClientTombstoneMessage.gc((LocalRegion)r, map, (EventID)new EventID((DistributedSystem)r.getCache().getDistributedSystem()));
        CacheClientNotifier.notifyClients((InternalCacheEvent)regionEvent, (ClientUpdateMessage)message);
    }

    public static void verifyEntries() {
        try {
            final Region r = cache.getRegion("/HAGIIDUnitTest_region");
            HAGIIDUnitTest.assertNotNull((Object)r);
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r.getEntry((Object)"key-1").getValue().equals("key-1");
                }

                @Override
                public String description() {
                    return null;
                }
            };
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r.getEntry((Object)"key-2").getValue().equals("key-2");
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r.getEntry((Object)"key-3").getValue().equals("key-3");
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        }
        catch (Exception ex) {
            HAGIIDUnitTest.fail("failed while verifyEntries()", ex);
        }
    }

    public static void verifyEntriesAfterGiiViaListener() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return checker.gotFirst();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 90000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return checker.gotSecond();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return checker.gotThird();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        HAGIIDUnitTest.assertEquals((int)3, (int)checker.getUpdates());
    }

    public static void verifyEntriesAfterGII() {
        try {
            final Region r = cache.getRegion("/HAGIIDUnitTest_region");
            HAGIIDUnitTest.assertNotNull((Object)r);
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r.getEntry((Object)"key-1").getValue().equals("value-1");
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r.getEntry((Object)"key-2").getValue().equals("value-2");
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r.getEntry((Object)"key-3").getValue().equals("value-3");
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        }
        catch (Exception ex) {
            HAGIIDUnitTest.fail("failed while verifyEntriesAfterGII()", ex);
        }
    }

    public static void setSystemProperty() {
        System.setProperty("slowStartTimeForTesting", "120000");
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client0.invoke(HAGIIDUnitTest.class, "closeCache");
        server0.invoke(HAGIIDUnitTest.class, "closeCache");
        server1.invoke(HAGIIDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        checker = new GIIChecker();
    }
}

