/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.ha.ConflatableObject;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.Assert;

public class HARegionDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    private static Cache cache = null;
    private static final String REGION_NAME = "HARegionDUnitTest_region";
    private static HARegionQueue hrq = null;

    public HARegionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.vm0.invoke(HARegionDUnitTest.class, "closeCache");
        this.vm1.invoke(HARegionDUnitTest.class, "closeCache");
    }

    private Cache createCache() throws Exception {
        Properties props = new Properties();
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public void testLocalPut() {
        this.vm0.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm1.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm0.invoke(HARegionDUnitTest.class, "putValue1");
        this.vm1.invoke(HARegionDUnitTest.class, "getNull");
        this.vm1.invoke(HARegionDUnitTest.class, "putValue2");
        this.vm0.invoke(HARegionDUnitTest.class, "getValue1");
        this.vm1.invoke(HARegionDUnitTest.class, "getValue2");
    }

    public void testLocalDestroy() {
        this.vm0.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm1.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm0.invoke(HARegionDUnitTest.class, "putValue1");
        this.vm1.invoke(HARegionDUnitTest.class, "getNull");
        this.vm1.invoke(HARegionDUnitTest.class, "putValue2");
        this.vm0.invoke(HARegionDUnitTest.class, "getValue1");
        this.vm1.invoke(HARegionDUnitTest.class, "getValue2");
        this.vm0.invoke(HARegionDUnitTest.class, "destroy");
        this.vm0.invoke(HARegionDUnitTest.class, "getNull");
        this.vm1.invoke(HARegionDUnitTest.class, "getValue2");
    }

    public void testGII() {
        this.vm0.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm0.invoke(HARegionDUnitTest.class, "putValue1");
        this.vm0.invoke(HARegionDUnitTest.class, "getValue1");
        this.vm1.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm1.invoke(HARegionDUnitTest.class, "getValue1");
        this.vm1.invoke(HARegionDUnitTest.class, "putValue2");
        this.vm1.invoke(HARegionDUnitTest.class, "getValue2");
    }

    public void testLocalDestroyRegion() {
        this.vm0.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm1.invoke(HARegionDUnitTest.class, "createRegion");
        this.vm0.invoke(HARegionDUnitTest.class, "destroyRegion");
        this.vm1.invoke(HARegionDUnitTest.class, "verifyRegionNotDestroyed");
    }

    public static void destroyRegion() {
        cache.getRegion(REGION_NAME).localDestroyRegion(null);
    }

    public static void verifyRegionNotDestroyed() {
        Assert.assertTrue((cache.getRegion(REGION_NAME) != null ? 1 : 0) != 0);
    }

    public void testQRM() {
        this.vm0.invoke(HARegionDUnitTest.class, "createRegionQueue");
        this.vm1.invoke(HARegionDUnitTest.class, "createRegionQueue");
        this.vm0.invoke(HARegionDUnitTest.class, "verifyAddingDispatchMesgs");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            HARegionDUnitTest.fail((String)"interrupted");
        }
        this.vm1.invoke(HARegionDUnitTest.class, "verifyDispatchedMessagesRemoved");
    }

    public static void createRegion() throws Exception {
        HARegionDUnitTest test = new HARegionDUnitTest(REGION_NAME);
        cache = test.createCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        HARegion.getInstance((String)REGION_NAME, (GemFireCacheImpl)((GemFireCacheImpl)cache), null, (RegionAttributes)factory.create());
    }

    public static void createRegionQueue() throws Exception {
        HARegionDUnitTest test = new HARegionDUnitTest(REGION_NAME);
        cache = test.createCache();
        hrq = HARegionQueue.getHARegionQueueInstance((String)REGION_NAME, (Cache)cache, (int)2, (boolean)false);
        EventID id1 = new EventID(new byte[]{1}, 1L, 1L);
        EventID id2 = new EventID(new byte[]{1}, 1L, 2L);
        ConflatableObject c1 = new ConflatableObject((Object)"1", (Object)"1", id1, false, REGION_NAME);
        ConflatableObject c2 = new ConflatableObject((Object)"2", (Object)"2", id2, false, REGION_NAME);
        hrq.put((Object)c1);
        hrq.put((Object)c2);
    }

    public static void verifyAddingDispatchMesgs() {
        Assert.assertTrue((boolean)HARegionQueue.getDispatchedMessagesMapForTesting().isEmpty());
        hrq.addDispatchedMessage(new ThreadIdentifier(new byte[1], 1L), 1L);
        Assert.assertTrue((!HARegionQueue.getDispatchedMessagesMapForTesting().isEmpty() ? 1 : 0) != 0);
    }

    public static void verifyDispatchedMessagesRemoved() {
        try {
            HARegion region = hrq.getRegion();
            if (region.get((Object)new Long(0L)) != null) {
                HARegionDUnitTest.fail((String)"Expected message to have been deleted but it is not deleted");
            }
            if (region.get((Object)new Long(1L)) == null) {
                HARegionDUnitTest.fail((String)"Expected message not to have been deleted but it is deleted");
            }
        }
        catch (Exception e) {
            HARegionDUnitTest.fail((String)("test failed due to an exception :  " + e));
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void putValue1() {
        try {
            Region r1 = cache.getRegion("/HARegionDUnitTest_region");
            r1.put((Object)"key-1", (Object)"value-1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HARegionDUnitTest.fail("failed while region.put()", ex);
        }
    }

    public static void putValue2() {
        try {
            Region r1 = cache.getRegion("/HARegionDUnitTest_region");
            r1.put((Object)"key-1", (Object)"value-2");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HARegionDUnitTest.fail("failed while region.put()", ex);
        }
    }

    public static void getValue1() {
        try {
            Region r = cache.getRegion("/HARegionDUnitTest_region");
            if (!r.get((Object)"key-1").equals("value-1")) {
                HARegionDUnitTest.fail((String)"expected value to be value-1 but it is not so");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HARegionDUnitTest.fail("failed while region.get()", ex);
        }
    }

    public static void getNull() {
        try {
            Region r = cache.getRegion("/HARegionDUnitTest_region");
            if (r.get((Object)"key-1") != null) {
                HARegionDUnitTest.fail((String)"expected value to be null but it is not so");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HARegionDUnitTest.fail("failed while region.get()", ex);
        }
    }

    public static void getValue2() {
        try {
            Region r = cache.getRegion("/HARegionDUnitTest_region");
            if (!r.get((Object)"key-1").equals("value-2")) {
                HARegionDUnitTest.fail((String)"expected value to be value-2 but it is not so");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HARegionDUnitTest.fail("failed while region.get()", ex);
        }
    }

    public static void destroy() {
        try {
            Region region1 = cache.getRegion("/HARegionDUnitTest_region");
            region1.localDestroy((Object)"key-1");
        }
        catch (Exception e) {
            e.printStackTrace();
            HARegionDUnitTest.fail((String)"test failed due to exception in destroy ");
        }
    }
}

