/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Properties;

public class OperationsPropagationDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    public static int PORT1;
    public static int PORT2;
    private static final String REGION_NAME = "OperationsPropagationDUnitTest_Region";
    private static Cache cache;
    protected static Region region;
    public static final String CREATE_KEY = "createKey";
    public static final String CREATE_VALUE = "createValue";
    public static final String UPDATE_KEY = "updateKey";
    public static final String UPDATE_VALUE1 = "updateValue1";
    public static final String UPDATE_VALUE2 = "updateValue2";
    public static final String INVALIDATE_KEY = "invalidateKey";
    public static final String INVALIDATE_VALUE = "invalidateValue";
    public static final String DESTROY_KEY = "destroyKey";
    public static final String DESTROY_VALUE = "destroyValue";
    public static final String PUTALL_KEY = "putAllKey";
    public static final String PUTALL_VALUE = "putAllValue";
    public static final String PUTALL_KEY2 = "putAllKey2";
    public static final String PUTALL_VALUE2 = "putAllValue2";

    public OperationsPropagationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        PORT1 = (Integer)this.server1.invoke(OperationsPropagationDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(OperationsPropagationDUnitTest.class, "createServerCache");
        this.client1.invoke(OperationsPropagationDUnitTest.class, "createClientCache", new Object[]{OperationsPropagationDUnitTest.getServerHostName(host), new Integer(PORT2)});
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(OperationsPropagationDUnitTest.class, "closeCache");
        this.server1.invoke(OperationsPropagationDUnitTest.class, "closeCache");
        this.server2.invoke(OperationsPropagationDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        OperationsPropagationDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        OperationsPropagationDUnitTest.assertNotNull((Object)cache);
    }

    public static Integer createServerCache() throws Exception {
        new OperationsPropagationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(REGION_NAME, attrs);
        BridgeServerImpl server = (BridgeServerImpl)cache.addBridgeServer();
        OperationsPropagationDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache(String host, Integer port2) throws Exception {
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new OperationsPropagationDUnitTest("temp").createCache(props);
        props.setProperty("retryAttempts", "2");
        props.setProperty("endpoints", "ep1=" + host + ":" + PORT2);
        props.setProperty("redundancyLevel", "-1");
        props.setProperty("establishCallbackConnection", "true");
        props.setProperty("LBPolicy", "Sticky");
        props.setProperty("readTimeout", "2000");
        props.setProperty("socketBufferSize", "1000");
        props.setProperty("retryInterval", "250");
        props.setProperty("connectionsPerServer", "2");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        BridgeTestCase.configureConnectionPool(factory, host, PORT2, -1, true, -1, 2, null);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(REGION_NAME, attrs);
        OperationsPropagationDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)"ALL_KEYS");
    }

    public void testOperationsPropagation() throws Exception {
        this.server1.invoke(OperationsPropagationDUnitTest.class, "initialPutKeyValue");
        this.client1.invoke(OperationsPropagationDUnitTest.class, "assertKeyValuePresent");
        this.server1.invoke(OperationsPropagationDUnitTest.class, "doOperations");
        this.client1.invoke(OperationsPropagationDUnitTest.class, "assertOperationsSucceeded");
    }

    public static void initialPutKeyValue() {
        try {
            region.put((Object)UPDATE_KEY, (Object)UPDATE_VALUE1);
            region.put((Object)INVALIDATE_KEY, (Object)INVALIDATE_VALUE);
            region.put((Object)DESTROY_KEY, (Object)DESTROY_VALUE);
        }
        catch (Exception e) {
            OperationsPropagationDUnitTest.fail(" Test failed due to " + e, e);
        }
    }

    public static void doOperations() {
        try {
            region.create((Object)CREATE_KEY, (Object)CREATE_VALUE);
            region.put((Object)UPDATE_KEY, (Object)UPDATE_VALUE2);
            region.invalidate((Object)INVALIDATE_KEY);
            region.destroy((Object)DESTROY_KEY);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PUTALL_KEY, PUTALL_VALUE);
            map.put(PUTALL_KEY2, PUTALL_VALUE2);
            region.putAll(map);
        }
        catch (Exception e) {
            OperationsPropagationDUnitTest.fail(" Test failed due to " + e, e);
        }
    }

    public static void assertKeyValuePresent() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.UPDATE_KEY);
                    return OperationsPropagationDUnitTest.UPDATE_VALUE1.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.INVALIDATE_KEY);
                    return OperationsPropagationDUnitTest.INVALIDATE_VALUE.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.DESTROY_KEY);
                    return OperationsPropagationDUnitTest.DESTROY_VALUE.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        }
        catch (Exception e) {
            OperationsPropagationDUnitTest.fail(" Test failed due to " + e, e);
        }
    }

    public static void assertOperationsSucceeded() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.CREATE_KEY);
                    return OperationsPropagationDUnitTest.CREATE_VALUE.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.UPDATE_KEY);
                    return OperationsPropagationDUnitTest.UPDATE_VALUE2.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return !region.containsKey((Object)OperationsPropagationDUnitTest.DESTROY_KEY);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.INVALIDATE_KEY);
                    return val == null;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.PUTALL_KEY);
                    return OperationsPropagationDUnitTest.PUTALL_VALUE.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = region.get((Object)OperationsPropagationDUnitTest.PUTALL_KEY2);
                    return OperationsPropagationDUnitTest.PUTALL_VALUE2.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        }
        catch (Exception e) {
            OperationsPropagationDUnitTest.fail(" Test failed due to " + e, e);
        }
    }

    static {
        cache = null;
        region = null;
    }
}

