/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.QueueStateImpl;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class PutAllDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    public static int PORT1;
    public static int PORT2;
    private static final String REGION_NAME = "PutAllDUnitTest_Region";
    private static Cache cache;
    static BridgeServerImpl server;
    private static PoolImpl pool;
    protected static EventID eventId;
    protected static volatile EventID putAlleventId1;
    protected static volatile EventID putAlleventId2;
    protected static volatile EventID putAlleventId3;
    protected static volatile EventID putAlleventId4;
    protected static volatile EventID putAlleventId5;
    protected static final String PUTALL_KEY1 = "putAllKey1";
    protected static final String PUTALL_KEY2 = "putAllKey2";
    protected static final String PUTALL_KEY3 = "putAllKey3";
    protected static final String PUTALL_KEY4 = "putAllKey4";
    protected static final String PUTALL_KEY5 = "putAllKey5";
    private static String PUTALL_VALUE1;
    private static String PUTALL_VALUE2;
    private static String PUTALL_VALUE3;
    private static String PUTALL_VALUE4;
    private static String PUTALL_VALUE5;
    protected static Object lockObject;
    protected static volatile boolean receivedOperation;

    public PutAllDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(PutAllDUnitTest.class, "closeCache");
        this.client2.invoke(PutAllDUnitTest.class, "closeCache");
        this.server1.invoke(PutAllDUnitTest.class, "closeCache");
        this.server2.invoke(PutAllDUnitTest.class, "closeCache");
        PutAllDUnitTest.closeCache();
    }

    private CacheSerializableRunnable stopServer() {
        CacheSerializableRunnable stopserver = new CacheSerializableRunnable("stopServer"){

            @Override
            public void run2() throws CacheException {
                server.stop();
            }
        };
        return stopserver;
    }

    private void createClientServerConfiguration() {
        PORT1 = (Integer)this.server1.invoke(PutAllDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(PutAllDUnitTest.class, "createServerCache");
        this.client1.invoke(PutAllDUnitTest.class, "createClientCache1", new Object[]{PutAllDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1)});
        this.client2.invoke(PutAllDUnitTest.class, "createClientCache2", new Object[]{PutAllDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT2)});
        try {
            PutAllDUnitTest.createClientCache2(PutAllDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT2));
        }
        catch (Exception e) {
            PutAllDUnitTest.fail((String)(" test failed due to " + e));
        }
    }

    public static Integer createServerCache() throws Exception {
        new PutAllDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        HAEventIdPropagationListenerForClient1 clientListener = new HAEventIdPropagationListenerForClient1();
        factory.setCacheListener((CacheListener)clientListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        server = (BridgeServerImpl)cache.addBridgeServer();
        PutAllDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        PutAllDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PutAllDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache2(String host, Integer port1) throws Exception {
        PORT1 = port1;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new PutAllDUnitTest("temp").createCache(props);
        props.setProperty("retryAttempts", "2");
        props.setProperty("endpoints", "ep1=" + host + ":" + PORT1);
        props.setProperty("redundancyLevel", "-1");
        props.setProperty("establishCallbackConnection", "true");
        props.setProperty("LBPolicy", "Sticky");
        props.setProperty("readTimeout", "2000");
        props.setProperty("socketBufferSize", "1000");
        props.setProperty("retryInterval", "250");
        props.setProperty("connectionsPerServer", "2");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        PoolImpl p = (PoolImpl)BridgeTestCase.configureConnectionPool(factory, host, PORT1, -1, true, -1, 2, null);
        HAEventIdPropagationListenerForClient2 clientListener = new HAEventIdPropagationListenerForClient2();
        factory.setCacheListener((CacheListener)clientListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        Region region = cache.getRegion("/PutAllDUnitTest_Region");
        PutAllDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        pool = p;
    }

    public static void createClientCache1(String host, Integer port1) throws Exception {
        PORT1 = port1;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new PutAllDUnitTest("temp").createCache(props);
        props.setProperty("retryAttempts", "2");
        props.setProperty("endpoints", "ep1=" + host + ":" + PORT1);
        props.setProperty("redundancyLevel", "-1");
        props.setProperty("establishCallbackConnection", "true");
        props.setProperty("LBPolicy", "Sticky");
        props.setProperty("readTimeout", "2000");
        props.setProperty("socketBufferSize", "1000");
        props.setProperty("retryInterval", "250");
        props.setProperty("connectionsPerServer", "2");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        PoolImpl p = (PoolImpl)BridgeTestCase.configureConnectionPool(factory, host, PORT1, -1, true, -1, 2, null);
        HAEventIdPropagationListenerForClient1 clientListener = new HAEventIdPropagationListenerForClient1();
        factory.setCacheListener((CacheListener)clientListener);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        Region region = cache.getRegion("/PutAllDUnitTest_Region");
        PutAllDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        pool = p;
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            try {
                cache.close();
                cache.getDistributedSystem().disconnect();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static void assertThreadIdToSequenceIdMapisNotNullButEmpty() {
        Map map = pool.getThreadIdToSequenceIdMap();
        PutAllDUnitTest.assertNotNull((Object)map);
        PutAllDUnitTest.assertTrue((map.size() == 1 ? 1 : 0) != 0);
    }

    public static Object assertThreadIdToSequenceIdMapHasEntryId() {
        Map map = pool.getThreadIdToSequenceIdMap();
        PutAllDUnitTest.assertNotNull((Object)map);
        PutAllDUnitTest.assertTrue((map.size() != 0 ? 1 : 0) != 0);
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
        }
        ThreadIdentifier tid = (ThreadIdentifier)entry2.getKey();
        QueueStateImpl.SequenceIdAndExpirationObject seo = (QueueStateImpl.SequenceIdAndExpirationObject)entry2.getValue();
        long sequenceId = seo.getSequenceId();
        EventID evId = new EventID(tid.getMembershipID(), tid.getThreadID(), sequenceId);
        map.clear();
        return evId;
    }

    public static Object[] assertThreadIdToSequenceIdMapHasEntryIds() {
        Object[] evids = new EventID[5];
        Map map = pool.getThreadIdToSequenceIdMap();
        PutAllDUnitTest.assertNotNull((Object)map);
        evids[0] = putAlleventId1;
        evids[1] = putAlleventId2;
        evids[2] = putAlleventId3;
        evids[3] = putAlleventId4;
        evids[4] = putAlleventId5;
        PutAllDUnitTest.assertNotNull((Object)evids[0]);
        PutAllDUnitTest.assertNotNull((Object)evids[1]);
        PutAllDUnitTest.assertNotNull((Object)evids[2]);
        PutAllDUnitTest.assertNotNull((Object)evids[3]);
        PutAllDUnitTest.assertNotNull((Object)evids[4]);
        return evids;
    }

    public void testPutAll() throws Exception {
        int i;
        PutAllDUnitTest.setReceivedOperationToFalse();
        this.client2.invoke(PutAllDUnitTest.class, "setReceivedOperationToFalse");
        this.createClientServerConfiguration();
        EventID[] eventIds1 = (EventID[])this.client1.invoke(PutAllDUnitTest.class, "putAll");
        PutAllDUnitTest.assertNotNull((Object)eventIds1);
        this.client2.invoke(PutAllDUnitTest.class, "waitTillOperationReceived");
        PutAllDUnitTest.waitTillOperationReceived();
        EventID[] eventIds2 = (EventID[])this.client2.invoke(PutAllDUnitTest.class, "assertThreadIdToSequenceIdMapHasEntryIds");
        PutAllDUnitTest.assertNotNull((Object)eventIds2);
        this.server1.invoke(PutAllDUnitTest.class, "assertGotAllValues");
        this.server2.invoke(PutAllDUnitTest.class, "assertGotAllValues");
        this.client2.invoke(PutAllDUnitTest.class, "assertGotAllValues");
        PutAllDUnitTest.assertGotAllValues();
        EventID[] eventIds3 = (EventID[])PutAllDUnitTest.assertThreadIdToSequenceIdMapHasEntryIds();
        for (i = 0; i < 5; ++i) {
            PutAllDUnitTest.assertNotNull((Object)eventIds1[i]);
            PutAllDUnitTest.assertNotNull((Object)eventIds2[i]);
            PutAllDUnitTest.assertEquals((Object)eventIds1[i], (Object)eventIds2[i]);
        }
        for (i = 0; i < 5; ++i) {
            PutAllDUnitTest.assertNotNull((Object)eventIds1[i]);
            PutAllDUnitTest.assertNotNull((Object)eventIds3[i]);
            PutAllDUnitTest.assertEquals((Object)eventIds1[i], (Object)eventIds3[i]);
        }
    }

    public static void setReceivedOperationToFalse() {
        receivedOperation = false;
    }

    public static void assertGotAllValues() {
        Region region = cache.getRegion("/PutAllDUnitTest_Region");
        PutAllDUnitTest.assertNotNull((Object)region);
        PutAllDUnitTest.assertTrue((boolean)region.get((Object)PUTALL_KEY1).equals(PUTALL_VALUE1));
        PutAllDUnitTest.assertTrue((boolean)region.get((Object)PUTALL_KEY2).equals(PUTALL_VALUE2));
        PutAllDUnitTest.assertTrue((boolean)region.get((Object)PUTALL_KEY3).equals(PUTALL_VALUE3));
        PutAllDUnitTest.assertTrue((boolean)region.get((Object)PUTALL_KEY4).equals(PUTALL_VALUE4));
        PutAllDUnitTest.assertTrue((boolean)region.get((Object)PUTALL_KEY5).equals(PUTALL_VALUE5));
    }

    public static Object[] putAll() {
        Region region = cache.getRegion("/PutAllDUnitTest_Region");
        PutAllDUnitTest.assertNotNull((Object)region);
        try {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(PUTALL_KEY1, PUTALL_VALUE1);
            map.put(PUTALL_KEY2, PUTALL_VALUE2);
            map.put(PUTALL_KEY3, PUTALL_VALUE3);
            map.put(PUTALL_KEY4, PUTALL_VALUE4);
            map.put(PUTALL_KEY5, PUTALL_VALUE5);
            region.putAll(map);
            Object[] evids = new EventID[]{putAlleventId1, putAlleventId2, putAlleventId3, putAlleventId4, putAlleventId5};
            PutAllDUnitTest.assertNotNull((Object)evids[0]);
            PutAllDUnitTest.assertNotNull((Object)evids[1]);
            PutAllDUnitTest.assertNotNull((Object)evids[2]);
            PutAllDUnitTest.assertNotNull((Object)evids[3]);
            PutAllDUnitTest.assertNotNull((Object)evids[4]);
            return evids;
        }
        catch (Exception e) {
            PutAllDUnitTest.fail((String)("put failed due to " + e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitTillOperationReceived() {
        Object object = lockObject;
        synchronized (object) {
            if (!receivedOperation) {
                try {
                    lockObject.wait(10000L);
                }
                catch (InterruptedException e) {
                    PutAllDUnitTest.fail((String)"interrupted");
                }
            }
            if (!receivedOperation) {
                PutAllDUnitTest.fail((String)" operation should have been received but it has not been received yet");
            }
        }
    }

    static {
        cache = null;
        server = null;
        pool = null;
        eventId = null;
        putAlleventId1 = null;
        putAlleventId2 = null;
        putAlleventId3 = null;
        putAlleventId4 = null;
        putAlleventId5 = null;
        PUTALL_VALUE1 = "putAllValue1";
        PUTALL_VALUE2 = "putAllValue2";
        PUTALL_VALUE3 = "putAllValue3";
        PUTALL_VALUE4 = "putAllValue4";
        PUTALL_VALUE5 = "putAllValue5";
        lockObject = new Object();
        receivedOperation = false;
    }

    static class HAEventIdPropagationListenerForClient1
    extends CacheListenerAdapter {
        private int putAllReceivedCount = 0;

        HAEventIdPropagationListenerForClient1() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            DistributedTestCase.getLogWriter().fine(" entered after created with " + event.getKey());
            boolean shouldNotify = false;
            Object key = event.getKey();
            if (key.equals(PutAllDUnitTest.PUTALL_KEY1)) {
                ++this.putAllReceivedCount;
                putAlleventId1 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId1);
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY2)) {
                ++this.putAllReceivedCount;
                putAlleventId2 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId2);
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY3)) {
                ++this.putAllReceivedCount;
                putAlleventId3 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId3);
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY4)) {
                ++this.putAllReceivedCount;
                putAlleventId4 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId4);
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY5)) {
                ++this.putAllReceivedCount;
                putAlleventId5 = ((EntryEventImpl)event).getEventId();
                TestCase.assertNotNull((Object)putAlleventId5);
            }
            if (this.putAllReceivedCount == 5) {
                shouldNotify = true;
            }
            if (shouldNotify) {
                Object object = lockObject;
                synchronized (object) {
                    receivedOperation = true;
                    lockObject.notify();
                }
            }
        }
    }

    static class HAEventIdPropagationListenerForClient2
    extends CacheListenerAdapter {
        private int putAllReceivedCount = 0;

        HAEventIdPropagationListenerForClient2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            boolean shouldNotify = false;
            Object key = event.getKey();
            if (key.equals(PutAllDUnitTest.PUTALL_KEY1)) {
                ++this.putAllReceivedCount;
                putAlleventId1 = (EventID)PutAllDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY2)) {
                ++this.putAllReceivedCount;
                putAlleventId2 = (EventID)PutAllDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY3)) {
                ++this.putAllReceivedCount;
                putAlleventId3 = (EventID)PutAllDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY4)) {
                ++this.putAllReceivedCount;
                putAlleventId4 = (EventID)PutAllDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            } else if (key.equals(PutAllDUnitTest.PUTALL_KEY5)) {
                ++this.putAllReceivedCount;
                putAlleventId5 = (EventID)PutAllDUnitTest.assertThreadIdToSequenceIdMapHasEntryId();
            }
            if (this.putAllReceivedCount == 5) {
                shouldNotify = true;
            }
            if (shouldNotify) {
                Object object = lockObject;
                synchronized (object) {
                    receivedOperation = true;
                    lockObject.notify();
                }
            }
        }
    }
}

