/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.Iterator;
import java.util.Properties;

public class StatsBugDUnitTest
extends DistributedTestCase {
    VM primary = null;
    VM secondary = null;
    VM client1 = null;
    private static Cache cache = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "StatsBugDUnitTest_Region";
    private static PoolImpl pool;
    private static final int TOTAL_SERVERS = 2;
    private static final int PUTS_PER_SERVER = 10;
    private static final String primaryPrefix = "primary_";
    private static final String secondaryPrefix = "secondary_";

    public StatsBugDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        StatsBugDUnitTest.disconnectAllFromDS();
        super.setUp();
        Host host = Host.getHost(0);
        this.primary = host.getVM(0);
        this.secondary = host.getVM(1);
        this.client1 = host.getVM(2);
        PORT1 = (Integer)this.primary.invoke(StatsBugDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.secondary.invoke(StatsBugDUnitTest.class, "createServerCache");
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(StatsBugDUnitTest.class, "closeCache");
        this.primary.invoke(StatsBugDUnitTest.class, "closeCache");
        this.secondary.invoke(StatsBugDUnitTest.class, "closeCache");
    }

    public void testBug36109() throws Exception {
        Log.getLogWriter().info("testBug36109 : BEGIN");
        this.client1.invoke(StatsBugDUnitTest.class, "createClientCacheForInvalidates", new Object[]{StatsBugDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2)});
        this.client1.invoke(StatsBugDUnitTest.class, "prepopulateClient");
        this.primary.invoke(StatsBugDUnitTest.class, "doEntryOperations", new Object[]{primaryPrefix});
        StatsBugDUnitTest.pause(3000);
        this.primary.invoke(StatsBugDUnitTest.class, "stopServer");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ignore) {
            StatsBugDUnitTest.fail((String)"interrupted");
        }
        this.secondary.invoke(StatsBugDUnitTest.class, "doEntryOperations", new Object[]{secondaryPrefix});
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ignore) {
            StatsBugDUnitTest.fail((String)"interrupted");
        }
        this.client1.invoke(StatsBugDUnitTest.class, "verifyNumInvalidates");
        Log.getLogWriter().info("testBug36109 : END");
    }

    public static Integer createServerCache() throws Exception {
        StatsBugDUnitTest test = new StatsBugDUnitTest("temp");
        Properties props = new Properties();
        cache = test.createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(false);
        server.setSocketBufferSize(32768);
        server.start();
        Log.getLogWriter().info("Server started at PORT = " + port);
        return new Integer(port);
    }

    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        StatsBugDUnitTest test = new StatsBugDUnitTest("temp");
        cache = test.createCache(StatsBugDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        pool = (PoolImpl)BridgeTestCase.configureConnectionPool(factory, host, new int[]{port1, port2}, true, -1, 3, null);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.registerInterest((Object)"ALL_KEYS");
        Log.getLogWriter().info("Client cache created");
    }

    public static void createClientCacheForInvalidates(String host, Integer port1, Integer port2) throws Exception {
        StatsBugDUnitTest test = new StatsBugDUnitTest("temp");
        cache = test.createCache(StatsBugDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        pool = (PoolImpl)BridgeTestCase.configureConnectionPool(factory, host, new int[]{port1, port2}, true, -1, 3, null);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.registerInterest((Object)"ALL_KEYS", false, false);
        Log.getLogWriter().info("Client cache created");
    }

    public static void verifyNumInvalidates() {
        long invalidatesRecordedByStats = pool.getInvalidateCount();
        Log.getLogWriter().info("invalidatesRecordedByStats = " + invalidatesRecordedByStats);
        int expectedInvalidates = 20;
        Log.getLogWriter().info("expectedInvalidates = " + expectedInvalidates);
        if (invalidatesRecordedByStats != (long)expectedInvalidates) {
            StatsBugDUnitTest.fail((String)("Invalidates received by client(" + invalidatesRecordedByStats + ") does not match with the number of operations(" + expectedInvalidates + ") done at server"));
        }
    }

    public static void stopServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            StatsBugDUnitTest.fail((String)("failed while stopServer()" + e));
        }
    }

    private static Properties createProperties1() {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        return props;
    }

    public static void doEntryOperations(String keyPrefix) throws Exception {
        Region r1 = cache.getRegion("/StatsBugDUnitTest_Region");
        for (int i = 0; i < 10; ++i) {
            r1.put((Object)(keyPrefix + i), (Object)(keyPrefix + "val-" + i));
        }
    }

    public static void prepopulateClient() throws Exception {
        StatsBugDUnitTest.doEntryOperations(primaryPrefix);
        StatsBugDUnitTest.doEntryOperations(secondaryPrefix);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        pool = null;
    }
}

