/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.execute.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class PartitionResolverDUnitTest
extends CacheTestCase {
    private static final String CUSTOMER = "custRegion";
    private static final String ORDER = "orderRegion";
    Host host;
    VM accessor;
    VM datastore1;
    VM datastore2;

    public PartitionResolverDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(0);
        this.datastore1 = this.host.getVM(1);
        this.datastore2 = this.host.getVM(2);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        CountingResolver.resetResolverCount();
    }

    void createRegion(boolean isAccessor, int redundantCopies) {
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.DISTRIBUTED_ACK);
        af = new AttributesFactory();
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(4).setLocalMaxMemory(isAccessor ? 0 : 1).setPartitionResolver((PartitionResolver)new CountingResolver("CountingResolverCust")).setRedundantCopies(redundantCopies).create());
        this.getCache().createRegion(CUSTOMER, af.create());
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(4).setLocalMaxMemory(isAccessor ? 0 : 1).setPartitionResolver((PartitionResolver)new CountingResolver("CountingResolverOrder")).setRedundantCopies(redundantCopies).setColocatedWith(CUSTOMER).create());
        this.getCache().createRegion(ORDER, af.create());
    }

    void populateData() {
        Region custRegion = this.getCache().getRegion(CUSTOMER);
        Region orderRegion = this.getCache().getRegion(ORDER);
        for (int i = 0; i < 5; ++i) {
            CustId custId = new CustId(i);
            Customer customer = new Customer("customer" + i, "address" + i);
            OrderId orderId = new OrderId(i, custId);
            Order order = new Order("order" + i);
            custRegion.put((Object)custId, (Object)customer);
            orderRegion.put((Object)orderId, (Object)order);
        }
    }

    private void initAccessorAndDataStore(final int redundantCopies) {
        this.accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionResolverDUnitTest.this.createRegion(true, redundantCopies);
                return null;
            }
        });
        this.datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionResolverDUnitTest.this.createRegion(false, redundantCopies);
                return null;
            }
        });
        this.datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionResolverDUnitTest.this.createRegion(false, redundantCopies);
                PartitionResolverDUnitTest.this.populateData();
                return null;
            }
        });
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, this.getNumberOfKeysOwnedByVM(this.datastore1));
        this.verifyResolverCountInVM(this.datastore2, 10);
        this.getCache().getLoggerI18n().fine("Reset resolver count");
    }

    private int getNumberOfKeysOwnedByVM(VM datastore12) {
        Integer numKeys = (Integer)datastore12.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion custRegion = (PartitionedRegion)PartitionResolverDUnitTest.this.getGemfireCache().getRegion(PartitionResolverDUnitTest.CUSTOMER);
                Set bucketSet = custRegion.getDataStore().getAllLocalPrimaryBucketRegions();
                int count = 0;
                for (BucketRegion br : bucketSet) {
                    count += br.size();
                }
                return count;
            }
        });
        return numKeys * 2;
    }

    private void verifyResolverCountInVM(VM vm, final int i) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TestCase.assertEquals((String)("My id: " + PartitionResolverDUnitTest.this.getGemfireCache().getMyId()), (int)i, (int)CountingResolver.count.get());
                CountingResolver.resetResolverCount();
                return null;
            }
        });
    }

    public void testKeysInIterationOnAccessor() {
        this.resolverInIteration(LocalRegion.IteratorType.KEYS, this.accessor);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, 0);
        this.verifyResolverCountInVM(this.datastore2, 0);
    }

    public void testValuesInIterationOnAccessor() {
        this.resolverInIteration(LocalRegion.IteratorType.VALUES, this.accessor);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, this.getNumberOfKeysOwnedByVM(this.datastore1));
        this.verifyResolverCountInVM(this.datastore2, this.getNumberOfKeysOwnedByVM(this.datastore2));
    }

    public void testEntriesInIterationOnAccessor() {
        this.resolverInIteration(LocalRegion.IteratorType.ENTRIES, this.accessor);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, this.getNumberOfKeysOwnedByVM(this.datastore1));
        this.verifyResolverCountInVM(this.datastore2, this.getNumberOfKeysOwnedByVM(this.datastore2));
    }

    public void testKeysInIterationOnDataStore() {
        this.resolverInIteration(LocalRegion.IteratorType.KEYS, this.datastore1);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, 0);
        this.verifyResolverCountInVM(this.datastore2, 0);
    }

    public void testValuesInIterationOnDataStore() {
        this.resolverInIteration(LocalRegion.IteratorType.VALUES, this.datastore1);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, 0);
        this.verifyResolverCountInVM(this.datastore2, this.getNumberOfKeysOwnedByVM(this.datastore2));
    }

    public void testEntriesInIterationOnDataStore() {
        this.resolverInIteration(LocalRegion.IteratorType.ENTRIES, this.datastore1);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, 0);
        this.verifyResolverCountInVM(this.datastore2, this.getNumberOfKeysOwnedByVM(this.datastore2));
    }

    private void resolverInIteration(final LocalRegion.IteratorType type, VM vm) {
        this.initAccessorAndDataStore(0);
        SerializableCallable doIteration = new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = PartitionResolverDUnitTest.this.getGemfireCache().getRegion(PartitionResolverDUnitTest.CUSTOMER);
                Region orderRegion = PartitionResolverDUnitTest.this.getGemfireCache().getRegion(PartitionResolverDUnitTest.ORDER);
                Iterator custIterator = null;
                Iterator orderIterator = null;
                switch (type) {
                    case ENTRIES: {
                        custIterator = custRegion.entrySet().iterator();
                        orderIterator = orderRegion.entrySet().iterator();
                        break;
                    }
                    case KEYS: {
                        custIterator = custRegion.keySet().iterator();
                        orderIterator = orderRegion.keySet().iterator();
                        break;
                    }
                    case VALUES: {
                        custIterator = custRegion.values().iterator();
                        orderIterator = orderRegion.values().iterator();
                        break;
                    }
                }
                while (custIterator.hasNext()) {
                    custIterator.next();
                }
                while (orderIterator.hasNext()) {
                    orderIterator.next();
                }
                return null;
            }
        };
        vm.invoke(doIteration);
    }

    public void testKeysIterationInFunctionExection() {
        this.doIterationInFunction(LocalRegion.IteratorType.KEYS);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, 0);
        this.verifyResolverCountInVM(this.datastore2, 0);
    }

    public void testValuesIterationInFunctionExection() {
        this.doIterationInFunction(LocalRegion.IteratorType.VALUES);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, 0);
        this.verifyResolverCountInVM(this.datastore2, 0);
    }

    public void testEntriesIterationInFunctionExection() {
        this.doIterationInFunction(LocalRegion.IteratorType.ENTRIES);
        this.verifyResolverCountInVM(this.accessor, 0);
        this.verifyResolverCountInVM(this.datastore1, 0);
        this.verifyResolverCountInVM(this.datastore2, 0);
    }

    private void doIterationInFunction(final LocalRegion.IteratorType type) {
        this.initAccessorAndDataStore(0);
        SerializableCallable registerFunction = new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)new IteratorFunction());
                return null;
            }
        };
        this.accessor.invoke(registerFunction);
        this.datastore1.invoke(registerFunction);
        this.datastore2.invoke(registerFunction);
        this.accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.onRegion((Region)PartitionResolverDUnitTest.this.getGemfireCache().getRegion(PartitionResolverDUnitTest.CUSTOMER)).withArgs((Object)type).execute("IteratorFunction").getResult();
                return null;
            }
        });
    }

    public void testOps() {
        this.initAccessorAndDataStore(0);
        this.doOps(false);
        this.verifyResolverCountInVM(this.accessor, 7);
        this.verifyResolverCountInVM(this.datastore1, this.getResolverCountForVM(this.datastore1));
        this.verifyResolverCountInVM(this.datastore2, this.getResolverCountForVM(this.datastore2));
    }

    public void _testTxOps() {
        this.initAccessorAndDataStore(0);
        this.doOps(true);
        this.verifyResolverCountInVM(this.accessor, 7);
        this.verifyResolverCountInVM(this.datastore1, this.getResolverCountForVM(this.datastore1));
        this.verifyResolverCountInVM(this.datastore2, this.getResolverCountForVM(this.datastore2));
    }

    private void doOps(final boolean isTx) {
        this.accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = PartitionResolverDUnitTest.this.getGemfireCache().getRegion(PartitionResolverDUnitTest.CUSTOMER);
                TXManagerImpl mgr = PartitionResolverDUnitTest.this.getGemfireCache().getCacheTransactionManager();
                CustId custId = new CustId(6);
                Customer customer = new Customer("customer6", "address6");
                PartitionResolverDUnitTest.this.getGemfireCache().getLogger().fine("SWAP:Begin");
                if (isTx) {
                    mgr.begin();
                }
                custRegion.put((Object)custId, (Object)customer);
                if (isTx) {
                    mgr.commit();
                }
                if (isTx) {
                    mgr.begin();
                }
                custRegion.invalidate((Object)custId);
                if (isTx) {
                    mgr.commit();
                }
                if (isTx) {
                    mgr.begin();
                }
                custRegion.put((Object)custId, (Object)customer);
                if (isTx) {
                    mgr.commit();
                }
                if (isTx) {
                    mgr.begin();
                }
                custRegion.destroy((Object)custId);
                if (isTx) {
                    mgr.commit();
                }
                if (isTx) {
                    mgr.begin();
                }
                custRegion.put((Object)custId, (Object)customer);
                if (isTx) {
                    mgr.commit();
                }
                if (isTx) {
                    mgr.begin();
                }
                custRegion.containsKey((Object)custId);
                if (isTx) {
                    mgr.commit();
                }
                if (isTx) {
                    mgr.begin();
                }
                custRegion.containsValueForKey((Object)custId);
                if (isTx) {
                    mgr.commit();
                }
                return null;
            }
        });
    }

    private int getResolverCountForVM(VM datastore12) {
        Integer containsTestKey = (Integer)datastore12.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PartitionRegionHelper.getLocalData((Region)PartitionResolverDUnitTest.this.getGemfireCache().getRegion(PartitionResolverDUnitTest.CUSTOMER));
                Iterator it = r.keySet().iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(new CustId(6))) continue;
                    return 1;
                }
                return 0;
            }
        });
        return containsTestKey * 7;
    }

    static class IteratorFunction
    implements Function {
        private static final String id = "IteratorFunction";

        IteratorFunction() {
        }

        public void execute(FunctionContext context) {
            Region custRegion = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)((RegionFunctionContext)context));
            Region orderRegion = PartitionRegionHelper.getLocalData((Region)custRegion.getCache().getRegion(PartitionResolverDUnitTest.ORDER));
            LocalRegion.IteratorType type = (LocalRegion.IteratorType)context.getArguments();
            Iterator custIterator = null;
            Iterator orderIterator = null;
            switch (type) {
                case ENTRIES: {
                    custIterator = custRegion.entrySet().iterator();
                    orderIterator = orderRegion.entrySet().iterator();
                    break;
                }
                case KEYS: {
                    custIterator = custRegion.keySet().iterator();
                    orderIterator = orderRegion.keySet().iterator();
                    break;
                }
                case VALUES: {
                    custIterator = custRegion.values().iterator();
                    orderIterator = orderRegion.values().iterator();
                    break;
                }
            }
            while (custIterator.hasNext()) {
                custIterator.next();
            }
            while (orderIterator.hasNext()) {
                orderIterator.next();
            }
            context.getResultSender().lastResult((Object)Boolean.TRUE);
        }

        public String getId() {
            return id;
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public boolean isHA() {
            return false;
        }
    }

    static class CountingResolver
    extends CustomerIDPartitionResolver {
        static AtomicInteger count = new AtomicInteger();

        public CountingResolver(String resolverID) {
            super(resolverID);
        }

        @Override
        public Serializable getRoutingObject(EntryOperation opDetails) {
            count.incrementAndGet();
            opDetails.getRegion().getCache().getLoggerI18n().fine("Resolver called key:" + opDetails.getKey() + " Region " + opDetails.getRegion().getName() + " id:" + ((GemFireCacheImpl)opDetails.getRegion().getCache()).getMyId(), new Throwable());
            return super.getRoutingObject(opDetails);
        }

        public static void resetResolverCount() {
            count.set(0);
        }
    }
}

