/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableRunnable;
import dunit.VM;

public class PartitionedRegionMetaDataCleanupDUnitTest
extends CacheTestCase {
    public PartitionedRegionMetaDataCleanupDUnitTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCleanupOnCloseCache() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, "region1", 5);
        this.createPR(vm1, "region2", 10);
        DistributedTestCase.ExpectedException ex = PartitionedRegionMetaDataCleanupDUnitTest.addExpectedException("IllegalStateException", vm1);
        try {
            this.createPR(vm1, "region1", 10);
            PartitionedRegionMetaDataCleanupDUnitTest.fail((String)"Should have received an exception");
        }
        catch (RMIException rMIException) {
        }
        finally {
            ex.remove();
        }
        this.closeCache(vm0);
        this.waitForCreate(vm0, "region1", 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCleanupOnCloseRegion() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, "region1", 5);
        this.createPR(vm1, "region2", 10);
        DistributedTestCase.ExpectedException ex = PartitionedRegionMetaDataCleanupDUnitTest.addExpectedException("IllegalStateException", vm1);
        try {
            this.createPR(vm1, "region1", 10);
            PartitionedRegionMetaDataCleanupDUnitTest.fail((String)"Should have received an exception");
        }
        catch (RMIException rMIException) {
        }
        finally {
            ex.remove();
        }
        this.closePr(vm0, "region1");
        this.waitForCreate(vm0, "region1", 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCrash() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, "region1", 5);
        this.createPR(vm1, "region2", 10);
        DistributedTestCase.ExpectedException ex = PartitionedRegionMetaDataCleanupDUnitTest.addExpectedException("IllegalStateException", vm1);
        try {
            this.createPR(vm1, "region1", 10);
            PartitionedRegionMetaDataCleanupDUnitTest.fail((String)"Should have received an exception");
        }
        catch (RMIException rMIException) {
        }
        finally {
            ex.remove();
        }
        ex = PartitionedRegionMetaDataCleanupDUnitTest.addExpectedException("DistributedSystemDisconnectedException", vm0);
        try {
            this.fakeCrash(vm0);
        }
        finally {
            ex.remove();
        }
        this.waitForCreate(vm0, "region1", 15);
    }

    private void closeCache(VM vm0) {
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CacheTestCase.closeCache();
            }
        });
    }

    private void fakeCrash(VM vm0) {
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                InternalDistributedSystem ds = (InternalDistributedSystem)PartitionedRegionMetaDataCleanupDUnitTest.this.getCache().getDistributedSystem();
                ds.getDistributionManager().close();
                CacheTestCase.disconnectFromDS();
            }
        });
    }

    private void closePr(VM vm0, final String regionName) {
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegionMetaDataCleanupDUnitTest.this.getCache().getRegion(regionName).close();
            }
        });
    }

    private void createPR(VM vm0, final String regionName, final int expirationTime) {
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PartitionedRegionMetaDataCleanupDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION).setEntryTimeToLive(new ExpirationAttributes(expirationTime)).create(regionName);
            }
        });
    }

    private void waitForCreate(VM vm0, final String regionName, final int expirationTime) {
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                RegionFactory rf = PartitionedRegionMetaDataCleanupDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION).setEntryTimeToLive(new ExpirationAttributes(expirationTime));
                DistributedTestCase.ExpectedException ex = DistributedTestCase.addExpectedException("IllegalStateException");
                try {
                    int i = 0;
                    while (true) {
                        try {
                            ++i;
                            rf.create(regionName);
                            return;
                        }
                        catch (IllegalStateException expected) {
                            if (i == 20) {
                                DistributedTestCase.fail("Metadata was never cleaned up in 20 tries", expected);
                            }
                            DistributedTestCase.pause(500);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    ex.remove();
                }
            }
        });
    }
}

