/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.persistence.ConflictingPersistentDataException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.persistence.RevokeFailedException;
import com.gemstone.gemfire.cache.persistence.RevokedPersistentDataException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.partitioned.ManageBucketMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PersistentPartitionedRegionTestBase;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;

public class PersistentPartitionedRegionDUnitTest
extends PersistentPartitionedRegionTestBase {
    private static final int NUM_BUCKETS = 15;
    private static final int MAX_WAIT = 65000;
    private static boolean FAIL_IN_THIS_VM = false;

    public PersistentPartitionedRegionDUnitTest(String name) {
        super(name);
    }

    public void testSinglePR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        host.getVM(1);
        this.createPR(vm0, 0);
        this.createData(vm0, 0, 1, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        this.closeCache(vm0);
        this.createPR(vm0, 0);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        this.checkData(vm0, 0, 1, "a");
        this.localDestroyPR(vm0);
        this.closeCache(vm0);
        this.createPR(vm0, 0);
        this.checkData(vm0, 0, 1, null);
    }

    public void testChangedToalBucketNumberSinglePR() {
        Object[] prms;
        IllegalStateException ise;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.createPR(vm0, 0, 0, 5);
        this.createData(vm0, 0, 5, "a");
        this.closeCache(vm0);
        DistributedTestCase.ExpectedException expect = PersistentPartitionedRegionDUnitTest.addExpectedException("IllegalStateException", vm0);
        expect = PersistentPartitionedRegionDUnitTest.addExpectedException("DiskAccessException", vm0);
        try {
            this.createPR(vm0, 0, 0, 2);
            PersistentPartitionedRegionDUnitTest.fail((String)"Expect to get java.lang.IllegalStateException, but it did not");
        }
        catch (RMIException exp) {
            PersistentPartitionedRegionDUnitTest.assertTrue((boolean)(exp.getCause() instanceof IllegalStateException));
            ise = (IllegalStateException)exp.getCause();
            prms = new Object[]{"/" + PR_REGION_NAME, 2, 5};
            PersistentPartitionedRegionDUnitTest.assertTrue((boolean)ise.getMessage().contains(LocalizedStrings.PartitionedRegion_FOR_REGION_0_TotalBucketNum_1_SHOULD_NOT_BE_CHANGED_Previous_Configured_2.toString(prms)));
        }
        this.closeCache(vm0);
        try {
            this.createPR(vm0, 0, 0, 10);
            PersistentPartitionedRegionDUnitTest.fail((String)"Expect to get java.lang.IllegalStateException, but it did not");
        }
        catch (RMIException exp) {
            PersistentPartitionedRegionDUnitTest.assertTrue((boolean)(exp.getCause() instanceof IllegalStateException));
            ise = (IllegalStateException)exp.getCause();
            prms = new Object[]{"/" + PR_REGION_NAME, 10, 5};
            PersistentPartitionedRegionDUnitTest.assertTrue((boolean)ise.getMessage().contains(LocalizedStrings.PartitionedRegion_FOR_REGION_0_TotalBucketNum_1_SHOULD_NOT_BE_CHANGED_Previous_Configured_2.toString(prms)));
        }
        expect.remove();
    }

    public void testSinglePRWithCustomExpiry() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(1);
        SerializableRunnable createPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                af.setPartitionAttributes(paf.create());
                af.setCustomEntryIdleTimeout((CustomExpiry)new TestCustomExpiration());
                af.setEntryIdleTimeout(new ExpirationAttributes(60, ExpirationAction.INVALIDATE));
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                RegionAttributes attr = af.create();
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, attr);
            }
        };
        vm0.invoke(createPR);
        this.createData(vm0, 0, 1, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        this.closeCache(vm0);
        vm0.invoke(createPR);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        this.checkData(vm0, 0, 1, "a");
    }

    public void testTotalRecoverRedundancy0() throws Throwable {
        this.totalRecoverTest(0);
    }

    public void testTotalRecoverRedundancy1() throws Throwable {
        this.totalRecoverTest(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadSerializationInAsyncThread() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 50;
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                FAIL_IN_THIS_VM = true;
            }
        });
        DistributedTestCase.ExpectedException expected1 = PersistentPartitionedRegionDUnitTest.addExpectedException("Fatal error from asynch");
        DistributedTestCase.ExpectedException expected2 = PersistentPartitionedRegionDUnitTest.addExpectedException("ToDataException");
        try {
            int redundancy = 1;
            this.createPR(vm0, redundancy, -1, 113, false);
            this.createPR(vm2, redundancy, -1, 113, false);
            this.createData(vm0, 0, 50, "a");
            this.createPR(vm1, redundancy, -1, 113, false);
            vm0.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    int i;
                    Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                    Region region = cache.getRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                    for (i = 0; i < 50; ++i) {
                        region.put((Object)i, (Object)new BadSerializer());
                    }
                    for (i = 0; i < 50; ++i) {
                        region.get((Object)i);
                    }
                }
            });
            Thread.sleep(2000L);
            this.createData(vm1, 0, 50, "b");
            this.createData(vm1, 50, 100, "b");
            this.createData(vm1, 50, 100, "c");
            this.checkData(vm2, 0, 50, "b");
            this.checkData(vm2, 50, 100, "c");
        }
        finally {
            expected1.remove();
            expected2.remove();
        }
    }

    public void totalRecoverTest(int redundancy) throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 50;
        this.createPR(vm0, redundancy);
        this.createPR(vm1, redundancy);
        this.createPR(vm2, redundancy);
        this.createData(vm0, 0, numBuckets, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        AsyncInvocation a1 = this.createPRAsync(vm0, redundancy);
        AsyncInvocation a2 = this.createPRAsync(vm1, redundancy);
        AsyncInvocation a3 = this.createPRAsync(vm2, redundancy);
        a1.getResult(65000L);
        a2.getResult(65000L);
        a3.getResult(65000L);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2));
        this.checkData(vm0, 0, numBuckets, "a");
        this.createData(vm0, numBuckets, 113, "b");
        this.checkData(vm0, numBuckets, 113, "b");
        this.destroyPR(vm0);
        this.destroyPR(vm1);
        this.destroyPR(vm2);
        a1 = this.createPRAsync(vm0, redundancy);
        a2 = this.createPRAsync(vm1, redundancy);
        a3 = this.createPRAsync(vm2, redundancy);
        a1.getResult(65000L);
        a2.getResult(65000L);
        a3.getResult(65000L);
        this.checkData(vm0, 0, numBuckets, null);
    }

    public void testRevokeAfterStartup() throws Throwable {
        DistributedTestCase.ExpectedException ex;
        block2: {
            Host host = Host.getHost(0);
            VM vm0 = host.getVM(0);
            VM vm1 = host.getVM(1);
            VM vm2 = host.getVM(2);
            int numBuckets = 50;
            this.createPR(vm0, 1);
            this.createPR(vm1, 1);
            this.createData(vm0, 0, numBuckets, "a");
            Set<Integer> vm0Buckets = this.getBucketList(vm0);
            Set<Integer> vm1Buckets = this.getBucketList(vm1);
            PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
            this.closeCache(vm0);
            this.createData(vm1, 0, numBuckets, "b");
            this.closeCache(vm1);
            AsyncInvocation a1 = this.createPRAsync(vm0, 1);
            Thread.sleep(500L);
            PersistentPartitionedRegionDUnitTest.assertTrue((boolean)a1.isAlive());
            this.revokeKnownMissingMembers(vm2, 1);
            a1.getResult(65000L);
            PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
            this.checkData(vm0, 0, numBuckets, "a");
            this.createData(vm0, numBuckets, 113, "b");
            this.checkData(vm0, numBuckets, 113, "b");
            ex = PersistentPartitionedRegionDUnitTest.addExpectedException(RevokedPersistentDataException.class.getName(), vm1);
            try {
                this.createPR(vm1, 1);
                PersistentPartitionedRegionDUnitTest.fail((String)"Should have recieved a SplitDistributedSystemException");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof RevokedPersistentDataException) break block2;
                throw e;
            }
        }
        ex.remove();
    }

    public void testRevokeBeforeStartup() throws Throwable {
        DistributedTestCase.ExpectedException ex;
        block5: {
            Set<Integer> vm0Buckets;
            int numBuckets;
            VM vm2;
            VM vm1;
            VM vm0;
            block4: {
                Host host = Host.getHost(0);
                vm0 = host.getVM(0);
                vm1 = host.getVM(1);
                vm2 = host.getVM(2);
                numBuckets = 50;
                this.createPR(vm0, 1);
                this.createPR(vm1, 1);
                this.createData(vm0, 0, numBuckets, "a");
                vm0Buckets = this.getBucketList(vm0);
                Set<Integer> vm1Buckets = this.getBucketList(vm1);
                PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
                try {
                    this.revokeAllMembers(vm2);
                    PersistentPartitionedRegionDUnitTest.fail((String)"The revoke should have failed, because members are running");
                }
                catch (RMIException e) {
                    if (e.getCause() instanceof RevokeFailedException) break block4;
                    throw e;
                }
            }
            this.closeCache(vm0);
            this.createData(vm1, 0, numBuckets, "b");
            File vm1Directory = this.getDiskDirectory(vm1);
            this.closeCache(vm1);
            vm0.invoke(new SerializableRunnable("get cache"){

                @Override
                public void run() {
                    PersistentPartitionedRegionDUnitTest.this.getCache();
                }
            });
            this.revokeMember(vm2, vm1Directory);
            AsyncInvocation a1 = this.createPRAsync(vm0, 1);
            a1.getResult(65000L);
            PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
            this.checkData(vm0, 0, numBuckets, "a");
            this.createData(vm0, numBuckets, 113, "b");
            this.checkData(vm0, numBuckets, 113, "b");
            ex = PersistentPartitionedRegionDUnitTest.addExpectedException(RevokedPersistentDataException.class.getName(), vm1);
            try {
                this.createPR(vm1, 1);
                PersistentPartitionedRegionDUnitTest.fail((String)"Should have recieved a SplitDistributedSystemException");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof RevokedPersistentDataException) break block5;
                throw e;
            }
        }
        ex.remove();
    }

    private File getDiskDirectory(VM vm0) {
        return (File)vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return CacheTestCase.getDiskDirs()[0];
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingMemberRedundancy0() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0, 0);
        this.createPR(vm1, 0);
        this.createData(vm0, 0, 15, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        int aVM0Bucket = vm0Buckets.iterator().next();
        int aVM1Bucket = vm1Buckets.iterator().next();
        this.closeCache(vm1);
        DistributedTestCase.ExpectedException ex = PersistentPartitionedRegionDUnitTest.addExpectedException("PartitionOfflineException");
        try {
            this.checkReadWriteOperationsWithOfflineMember(vm0, aVM0Bucket, aVM1Bucket);
            this.createPR(vm2, 0);
            this.checkReadWriteOperationsWithOfflineMember(vm2, aVM0Bucket, aVM1Bucket);
        }
        finally {
            ex.remove();
        }
        this.createData(vm0, 15, 113, "a");
        this.createPR(vm1, 0);
        this.checkData(vm0, 0, 113, "a");
        this.closeCache(vm0);
        this.closeCache(vm1);
    }

    private void checkReadWriteOperationsWithOfflineMember(VM vm0, final int aVM0Bucket, final int aVM1Bucket) {
        DistributedTestCase.ExpectedException expect;
        block5: {
            block4: {
                this.checkData(vm0, aVM0Bucket, aVM0Bucket + 1, "a");
                try {
                    this.checkData(vm0, aVM1Bucket, aVM1Bucket + 1, null);
                    PersistentPartitionedRegionDUnitTest.fail((String)"Should not have been able to read from missing buckets!");
                }
                catch (RMIException e) {
                    if (e.getCause() instanceof PartitionOfflineException) break block4;
                    throw e;
                }
            }
            expect = PersistentPartitionedRegionDUnitTest.addExpectedException("PartitionOfflineException", vm0);
            vm0.invoke(new SerializableRunnable("Test ways to read"){

                @Override
                public void run() {
                    Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                    Region region = cache.getRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                    try {
                        FunctionService.onRegion((Region)region).execute((Function)new TestFunction());
                        TestCase.fail((String)"Should not have been able to read from missing buckets!");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                    FunctionService.onRegion((Region)region).withFilter(Collections.singleton(aVM0Bucket)).execute((Function)new TestFunction());
                    try {
                        FunctionService.onRegion((Region)region).withFilter(Collections.singleton(aVM1Bucket)).execute((Function)new TestFunction());
                        TestCase.fail((String)"Should not have been able to read from missing buckets!");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                    try {
                        HashSet<Integer> filter = new HashSet<Integer>();
                        filter.add(aVM0Bucket);
                        filter.add(aVM1Bucket);
                        FunctionService.onRegion((Region)region).withFilter(filter).execute((Function)new TestFunction());
                        TestCase.fail((String)"Should not have been able to read from missing buckets!");
                    }
                    catch (PartitionOfflineException filter) {
                        // empty catch block
                    }
                    try {
                        FunctionService.onRegion((Region)region).execute((Function)new TestFunction());
                        TestCase.fail((String)"Should not have been able to read from missing buckets!");
                    }
                    catch (PartitionOfflineException filter) {
                        // empty catch block
                    }
                    try {
                        cache.getQueryService().newQuery("select * from /" + PersistentPartitionedRegionTestBase.PR_REGION_NAME).execute();
                        TestCase.fail((String)"Should not have been able to read from missing buckets!");
                    }
                    catch (PartitionOfflineException filter) {
                    }
                    catch (QueryException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        Set keys = region.keySet();
                        for (Object e : keys) {
                        }
                        TestCase.fail((String)"Should not have been able to iterate over keyset");
                    }
                    catch (PartitionOfflineException keys) {
                        // empty catch block
                    }
                    try {
                        for (Object e : region.values()) {
                        }
                        TestCase.fail((String)"Should not have been able to iterate over set");
                    }
                    catch (PartitionOfflineException i$) {
                        // empty catch block
                    }
                    try {
                        for (Object e : region.entrySet()) {
                        }
                        TestCase.fail((String)"Should not have been able to iterate over set");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                    try {
                        region.get((Object)aVM1Bucket);
                        TestCase.fail((String)"Should not have been able to get an offline key");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                    try {
                        region.containsKey((Object)aVM1Bucket);
                        TestCase.fail((String)"Should not have been able to get an offline key");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                    try {
                        region.getEntry((Object)aVM1Bucket);
                        TestCase.fail((String)"Should not have been able to get an offline key");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                    try {
                        region.invalidate((Object)aVM1Bucket);
                        TestCase.fail((String)"Should not have been able to get an offline key");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                    try {
                        region.destroy((Object)aVM1Bucket);
                        TestCase.fail((String)"Should not have been able to get an offline key");
                    }
                    catch (PartitionOfflineException partitionOfflineException) {
                        // empty catch block
                    }
                }
            });
            try {
                this.createData(vm0, aVM1Bucket, aVM1Bucket + 1, "b");
                PersistentPartitionedRegionDUnitTest.fail((String)"Should not have been able to write to missing buckets!");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof PartitionOfflineException) break block5;
                throw e;
            }
        }
        expect.remove();
    }

    public void testDestroyedMemberRedundancy0() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, 0);
        this.createPR(vm1, 0);
        this.createData(vm0, 0, 15, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        int aVM0Bucket = vm0Buckets.iterator().next();
        int aVM1Bucket = vm1Buckets.iterator().next();
        this.localDestroyPR(vm1);
        this.checkData(vm0, aVM0Bucket, aVM0Bucket + 1, "a");
        this.checkData(vm0, aVM1Bucket, aVM1Bucket + 1, null);
        this.createData(vm0, aVM1Bucket, aVM1Bucket + 1, "b");
        this.createPR(vm1, 0);
        this.checkData(vm0, aVM0Bucket, aVM0Bucket + 1, "a");
        this.checkData(vm0, aVM1Bucket, aVM1Bucket + 1, "b");
        PersistentPartitionedRegionDUnitTest.assertTrue((boolean)this.getBucketList(vm0).contains(aVM1Bucket));
    }

    public void testDestroyedMemberRedundancy1() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createData(vm0, 0, 15, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
        int aVM0Bucket = vm0Buckets.iterator().next();
        this.localDestroyPR(vm1);
        this.checkData(vm0, aVM0Bucket, aVM0Bucket + 1, "a");
        this.createPR(vm2, 1);
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, vm2Buckets);
    }

    public void testRevokedMemberRedundancy0() {
        DistributedTestCase.ExpectedException ex;
        block8: {
            DistributedTestCase.ExpectedException expect;
            int aVM1Bucket;
            VM vm2;
            VM vm1;
            VM vm0;
            block7: {
                block6: {
                    Host host = Host.getHost(0);
                    vm0 = host.getVM(0);
                    vm1 = host.getVM(1);
                    vm2 = host.getVM(2);
                    this.createPR(vm0, 0);
                    this.createPR(vm1, 0);
                    this.createData(vm0, 0, 15, "a");
                    Set<Integer> vm0Buckets = this.getBucketList(vm0);
                    Set<Integer> vm1Buckets = this.getBucketList(vm1);
                    int aVM0Bucket = vm0Buckets.iterator().next();
                    aVM1Bucket = vm1Buckets.iterator().next();
                    this.closeCache(vm1);
                    this.checkData(vm0, aVM0Bucket, aVM0Bucket + 1, "a");
                    expect = PersistentPartitionedRegionDUnitTest.addExpectedException("PartitionOfflineException", vm0);
                    try {
                        this.checkData(vm0, aVM1Bucket, aVM1Bucket + 1, "a");
                        PersistentPartitionedRegionDUnitTest.fail((String)"Should not have been able to read from missing buckets!");
                    }
                    catch (RMIException e) {
                        if (e.getCause() instanceof PartitionOfflineException) break block6;
                        throw e;
                    }
                }
                try {
                    this.createData(vm0, aVM1Bucket, aVM1Bucket + 1, "b");
                    PersistentPartitionedRegionDUnitTest.fail((String)"Should not have been able to write to missing buckets!");
                }
                catch (RMIException e) {
                    if (e.getCause() instanceof PartitionOfflineException) break block7;
                    throw e;
                }
            }
            expect.remove();
            this.createData(vm0, 15, 113, "a");
            this.revokeKnownMissingMembers(vm2, 1);
            this.createPR(vm2, 0);
            this.checkData(vm2, aVM1Bucket, aVM1Bucket + 1, null);
            this.createData(vm2, aVM1Bucket, aVM1Bucket + 1, "a");
            this.checkData(vm2, aVM1Bucket, aVM1Bucket + 1, "a");
            ex = PersistentPartitionedRegionDUnitTest.addExpectedException(RevokedPersistentDataException.class.getName(), vm1);
            try {
                this.createPR(vm1, 0);
                PersistentPartitionedRegionDUnitTest.fail((String)"Should have recieved a RevokedPersistentDataException");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof RevokedPersistentDataException) break block8;
                throw e;
            }
        }
        ex.remove();
    }

    public void testRevokedMemberRedundancy1() throws Throwable {
        DistributedTestCase.ExpectedException ex;
        VM vm2;
        block5: {
            VM vm1;
            VM vm0;
            block4: {
                Host host = Host.getHost(0);
                vm0 = host.getVM(0);
                vm1 = host.getVM(1);
                vm2 = host.getVM(2);
                this.createPR(vm0, 1);
                this.createPR(vm1, 1);
                this.createData(vm0, 0, 15, "a");
                Set<Integer> vm0Buckets = this.getBucketList(vm0);
                Set<Integer> vm1Buckets = this.getBucketList(vm1);
                PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
                this.closeCache(vm1);
                this.checkData(vm0, 0, 15, "a");
                this.createData(vm0, 0, 15, "b");
                this.revokeKnownMissingMembers(vm2, 1);
                this.createPR(vm2, 1);
                Set<Integer> vm2Buckets = this.getBucketList(vm2);
                PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, vm2Buckets);
                ex = PersistentPartitionedRegionDUnitTest.addExpectedException(RevokedPersistentDataException.class.getName(), vm1);
                try {
                    this.createPR(vm1, 1);
                    PersistentPartitionedRegionDUnitTest.fail((String)"Should have recieved a SplitDistributedSystemException");
                }
                catch (RMIException e) {
                    if (e.getCause() instanceof RevokedPersistentDataException) break block4;
                    throw e;
                }
            }
            this.closeCache(vm0);
            this.closeCache(vm2);
            AsyncInvocation async0 = this.createPRAsync(vm0, 1);
            AsyncInvocation async2 = this.createPRAsync(vm2, 1);
            async0.getResult();
            async2.getResult();
            try {
                this.createPR(vm1, 1);
                PersistentPartitionedRegionDUnitTest.fail((String)"Should have recieved a RevokedPersistentDataException");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof RevokedPersistentDataException) break block5;
                throw e;
            }
        }
        ex.remove();
        this.checkData(vm2, 0, 15, "b");
    }

    public void testRevokedMemberRedundancy1ImmediateRecovery() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final VM vm2 = host.getVM(2);
        this.createPR(vm0, 1, 0);
        this.createPR(vm1, 1, 0);
        this.createData(vm0, 0, 15, "a");
        this.createPR(vm2, 1, 0);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm2));
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        final Set<Integer> lostBuckets = this.getBucketList(vm1);
        this.closeCache(vm1);
        PersistentPartitionedRegionDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Set<Integer> vm2Buckets = PersistentPartitionedRegionDUnitTest.this.getBucketList(vm2);
                return lostBuckets.equals(vm2Buckets);
            }

            @Override
            public String description() {
                return "expected to recover " + lostBuckets + " buckets, now have " + PersistentPartitionedRegionDUnitTest.this.getBucketList(vm2);
            }
        }, 30000L, 500L, true);
        this.createData(vm0, 0, 15, "b");
        this.createPR(vm1, 1, 0);
        this.checkData(vm1, 0, 15, "b");
        this.closeCache(vm1);
        this.closeCache(vm0);
        this.closeCache(vm2);
        AsyncInvocation async1 = this.createPRAsync(vm1, 1);
        AsyncInvocation async0 = this.createPRAsync(vm0, 1);
        async1.join(50L);
        PersistentPartitionedRegionDUnitTest.assertTrue((boolean)async1.isAlive());
        AsyncInvocation async2 = this.createPRAsync(vm2, 1);
        async2.getResult(65000L);
        async0.getResult(65000L);
        async1.getResult(65000L);
        this.checkData(vm1, 0, 15, "b");
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm2));
    }

    public void testBug41340() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0, 1, 0);
        this.createPR(vm1, 1, 0);
        this.createData(vm0, 0, 15, "a");
        this.createPR(vm2, 1, 0);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm2));
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> lostBuckets = this.getBucketList(vm1);
        this.closeCache(vm1);
        this.waitForBucketRecovery(vm2, lostBuckets);
        this.createData(vm0, 0, 15, "b");
        this.createPR(vm1, 1, 0);
        this.checkData(vm1, 0, 15, "b");
        this.closeCache(vm2);
        this.waitForBucketRecovery(vm1, lostBuckets);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm1));
        this.checkData(vm1, 0, 15, "b");
        this.closeCache(vm0);
        this.closeCache(vm1);
        AsyncInvocation async1 = this.createPRAsync(vm1, 1);
        AsyncInvocation async0 = this.createPRAsync(vm0, 1);
        async0.getResult(65000L);
        async1.getResult(65000L);
        this.checkData(vm1, 0, 15, "b");
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm1));
    }

    public void testMissingMemberRedundancy1() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createData(vm0, 0, 15, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        this.closeCache(vm1);
        this.checkData(vm0, 0, 15, "a");
        this.removeData(vm0, 0, 7);
        this.createData(vm0, 7, 15, "b");
        this.createPR(vm2, 1);
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), vm2Buckets);
        this.createPR(vm1, 1);
        this.checkData(vm1, 0, 7, null);
        this.checkData(vm1, 7, 15, "b");
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm2));
    }

    public void testBug41341() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createData(vm0, 0, 1, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), vm0Buckets);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), vm1Buckets);
        this.closeCache(vm1);
        this.createPR(vm2, 1);
        PersistentPartitionedRegionDUnitTest.assertEquals((int)1, (int)this.getOfflineMembers(0, vm0).size());
        PersistentPartitionedRegionDUnitTest.assertEquals((int)2, (int)this.getOnlineMembers(0, vm2).size());
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), vm2Buckets);
        this.createPR(vm1, 1);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm2));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm1));
        this.moveBucket(0, vm1, vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm2));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm2));
        this.destroyPR(vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm1));
        this.closeCache(vm1);
        PersistentPartitionedRegionDUnitTest.assertEquals((int)0, (int)this.getOfflineMembers(0, vm0).size());
        this.createPR(vm1, 1);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getOfflineMembers(0, vm1));
    }

    public void z_testThrowAwayUneededBucket() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createData(vm0, 0, 15, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
        PersistentPartitionedRegionDUnitTest.assertEquals((int)15, (int)vm0Buckets.size());
        this.closeCache(vm1);
        this.createPR(vm2, 1);
        this.checkData(vm0, 0, 15, "a");
        vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, vm2Buckets);
        PersistentPartitionedRegionDUnitTest.assertEquals((int)15, (int)vm0Buckets.size());
        this.createPR(vm1, 1);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm1));
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createPR(vm2, 1);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2));
        this.checkData(vm0, 0, 15, "a");
    }

    public void testMoveBucket() throws Throwable {
        int redundancy = 0;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0, redundancy);
        this.createData(vm0, 0, 2, "a");
        this.createPR(vm1, redundancy);
        this.createPR(vm2, redundancy);
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        this.moveBucket(0, vm0, vm1);
        this.moveBucket(0, vm1, vm2);
        this.createData(vm0, 113, 114, "a");
        this.moveBucket(0, vm2, vm0);
        this.createData(vm0, 226, 227, "a");
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2));
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        AsyncInvocation a1 = this.createPRAsync(vm0, redundancy);
        AsyncInvocation a2 = this.createPRAsync(vm1, redundancy);
        AsyncInvocation a3 = this.createPRAsync(vm2, redundancy);
        a1.getResult(65000L);
        a2.getResult(65000L);
        a3.getResult(65000L);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        this.checkData(vm0, 0, 2, "a");
        this.checkData(vm0, 113, 114, "a");
        this.checkData(vm0, 226, 227, "a");
    }

    public void testCleanStop() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createData(vm0, 0, 1, "a");
        this.fakeCleanShutdown(vm1, 0);
        this.fakeCleanShutdown(vm0, 0);
        AsyncInvocation async1 = this.createPRAsync(vm0, 1);
        AsyncInvocation async2 = this.createPRAsync(vm1, 1);
        async1.getResult(65000L);
        async2.getResult(65000L);
        this.checkData(vm0, 0, 1, "a");
        this.checkData(vm1, 0, 1, "a");
        this.checkRecoveredFromDisk(vm0, 0, true);
        this.checkRecoveredFromDisk(vm1, 0, true);
        this.closePR(vm0);
        this.closePR(vm1);
        async1 = this.createPRAsync(vm0, 1);
        async2 = this.createPRAsync(vm1, 1);
        async1.getResult(65000L);
        async2.getResult(65000L);
        this.checkData(vm0, 0, 1, "a");
        this.checkData(vm1, 0, 1, "a");
        this.checkRecoveredFromDisk(vm0, 0, false);
        this.checkRecoveredFromDisk(vm1, 0, true);
    }

    public void testRegisterInterestNoDataStores() {
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final Integer serverPort = (Integer)vm0.invoke(new SerializableCallable("create per"){

            public Object call() {
                Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setLocalMaxMemory(0);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PARTITION);
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                CacheServer server = cache.addCacheServer();
                server.setPort(AvailablePort.getRandomAvailablePort((int)0));
                server.setNotifyBySubscription(true);
                try {
                    server.start();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return server.getPort();
            }
        });
        vm1.invoke(new SerializableRunnable("create client"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PersistentPartitionedRegionDUnitTest.this.getSystem(props);
                try {
                    Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                    PoolFactory pf = PoolManager.createFactory();
                    pf.addServer(DistributedTestCase.getServerHostName(host), serverPort.intValue());
                    pf.setSubscriptionEnabled(true);
                    pf.create("pool");
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    af.setPoolName("pool");
                    Region region = cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                    try {
                        region.registerInterestRegex(".*");
                    }
                    catch (ServerOperationException e) {
                        if (!(e.getCause() instanceof PartitionedRegionStorageException)) {
                            throw e;
                        }
                    }
                }
                finally {
                    CacheTestCase.disconnectFromDS();
                }
            }
        });
    }

    public void testOverflowCacheClose() {
        Cache cache = this.getCache();
        RegionFactory rf = new RegionFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        rf.setPartitionAttributes(paf.create());
        rf.setDataPolicy(DataPolicy.PARTITION);
        rf.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)50, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        rf.setDiskDirs(PersistentPartitionedRegionDUnitTest.getDiskDirs());
        Region region = rf.create(PR_REGION_NAME);
        region.get((Object)0);
        cache.getDistributedSystem().disconnect();
    }

    public void testCrashDuringBucketCreation() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new SerializableRunnable("Install observer"){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                        if (msg instanceof ManageBucketMessage.ManageBucketReplyMessage) {
                            DistributedTestCase.disconnectFromDS();
                        }
                    }
                });
            }
        });
        this.createPR(vm0, 0);
        this.createPR(vm1, 0);
        this.createData(vm1, 0, 4, "a");
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        vm0.invoke(new SerializableRunnable("Check for no distributed system"){

            @Override
            public void run() {
                TestCase.assertEquals(null, (Object)GemFireCacheImpl.getInstance());
            }
        });
        this.checkData(vm1, 0, 4, "a");
        PersistentPartitionedRegionDUnitTest.assertEquals((int)4, (int)vm1Buckets.size());
        this.createPR(vm0, 0);
        this.checkData(vm0, 0, 4, "a");
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm0));
        this.closeCache(vm0);
        this.closeCache(vm1);
        AsyncInvocation async0 = this.createPRAsync(vm0, 0);
        AsyncInvocation async1 = this.createPRAsync(vm1, 0);
        async0.getResult();
        async1.getResult();
        this.checkData(vm0, 0, 4, "a");
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm0));
    }

    public void testNestedPRRegions() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 50;
        this.createNestedPR(vm0);
        this.createNestedPR(vm1);
        this.createNestedPR(vm2);
        this.createData(vm0, 0, numBuckets, "a", "parent1/" + PR_REGION_NAME);
        this.createData(vm0, 0, numBuckets, "b", "parent2/" + PR_REGION_NAME);
        this.checkData(vm2, 0, numBuckets, "a", "parent1/" + PR_REGION_NAME);
        this.checkData(vm2, 0, numBuckets, "b", "parent2/" + PR_REGION_NAME);
        Set<Integer> vm1_0Buckets = this.getBucketList(vm0, "parent1/" + PR_REGION_NAME);
        Set<Integer> vm1_1Buckets = this.getBucketList(vm1, "parent1/" + PR_REGION_NAME);
        Set<Integer> vm1_2Buckets = this.getBucketList(vm2, "parent1/" + PR_REGION_NAME);
        Set<Integer> vm2_0Buckets = this.getBucketList(vm0, "parent2/" + PR_REGION_NAME);
        Set<Integer> vm2_1Buckets = this.getBucketList(vm1, "parent2/" + PR_REGION_NAME);
        Set<Integer> vm2_2Buckets = this.getBucketList(vm2, "parent2/" + PR_REGION_NAME);
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        AsyncInvocation async0 = this.createNestedPRAsync(vm0);
        Thread.sleep(50L);
        PersistentPartitionedRegionDUnitTest.assertTrue((boolean)async0.isAlive());
        AsyncInvocation async1 = this.createNestedPRAsync(vm1);
        AsyncInvocation async2 = this.createNestedPRAsync(vm2);
        async0.getResult();
        async1.getResult();
        async2.getResult();
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1_0Buckets, this.getBucketList(vm0, "parent1/" + PR_REGION_NAME));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1_1Buckets, this.getBucketList(vm1, "parent1/" + PR_REGION_NAME));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1_2Buckets, this.getBucketList(vm2, "parent1/" + PR_REGION_NAME));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2_0Buckets, this.getBucketList(vm0, "parent2/" + PR_REGION_NAME));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2_1Buckets, this.getBucketList(vm1, "parent2/" + PR_REGION_NAME));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2_2Buckets, this.getBucketList(vm2, "parent2/" + PR_REGION_NAME));
        this.checkData(vm0, 0, numBuckets, "a", "parent1/" + PR_REGION_NAME);
        this.checkData(vm0, 0, numBuckets, "b", "parent2/" + PR_REGION_NAME);
        this.createData(vm1, numBuckets, 113, "c", "parent1/" + PR_REGION_NAME);
        this.createData(vm1, numBuckets, 113, "d", "parent2/" + PR_REGION_NAME);
        this.checkData(vm2, numBuckets, 113, "c", "parent1/" + PR_REGION_NAME);
        this.checkData(vm2, numBuckets, 113, "d", "parent2/" + PR_REGION_NAME);
    }

    public void DISABLED_Bug48435_testCloseDuringRegionOperation() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, 1, -1, 1);
        this.createPR(vm1, 1, -1, 1);
        this.createData(vm1, 0, 1, "a");
        SerializableCallable createData = new SerializableCallable(){

            public Object call() {
                Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                int i = 0;
                try {
                    while (true) {
                        region.put((Object)0, (Object)i);
                        ++i;
                    }
                }
                catch (CacheClosedException e) {
                    return i - 1;
                }
            }
        };
        AsyncInvocation asyncCreate = vm0.invokeAsync(createData);
        Thread.sleep(100L);
        AsyncInvocation close0 = this.closeCacheAsync(vm0);
        AsyncInvocation close1 = this.closeCacheAsync(vm1);
        close0.getResult();
        close1.getResult();
        Integer lastSuccessfulInt = (Integer)asyncCreate.getResult();
        System.err.println("Cache was closed on integer " + lastSuccessfulInt);
        AsyncInvocation create1 = this.createPRAsync(vm0, 1, -1, 1);
        AsyncInvocation create2 = this.createPRAsync(vm1, 1, -1, 1);
        create1.getResult(65000L);
        create2.getResult(65000L);
        SerializableCallable getValue = new SerializableCallable(){

            public Object call() {
                Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                int value = (Integer)region.get((Object)0);
                return value;
            }
        };
        int vm1Value = (Integer)vm0.invoke(getValue);
        int vm2Value = (Integer)vm1.invoke(getValue);
        PersistentPartitionedRegionDUnitTest.assertEquals((int)vm1Value, (int)vm2Value);
        PersistentPartitionedRegionDUnitTest.assertTrue((String)("value = " + vm1Value + ", lastSuccessfulInt=" + lastSuccessfulInt), (vm1Value == lastSuccessfulInt || vm1Value == lastSuccessfulInt + 1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42226() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            InitialImageOperation.RequestImageMessage rim = (InitialImageOperation.RequestImageMessage)message;
                            if (rim.regionPath.contains("_B_")) {
                                DistributionMessageObserver.setInstance(null);
                                CacheTestCase.disconnectFromDS();
                            }
                        }
                    }

                    public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
                    }
                });
            }
        });
        PersistentPartitionedRegionDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPR(vm0, 1, 0, 1);
        this.createData(vm0, 0, 1, "a");
        DistributedTestCase.ExpectedException ex = PersistentPartitionedRegionDUnitTest.addExpectedException("PartitionOfflineException");
        try {
            PersistentPartitionedRegionDUnitTest.getLogWriter().info("Creating region in VM1");
            this.createPR(vm1, 1, 0, 1);
            try {
                this.createData(vm1, 0, 1, "a");
            }
            catch (RMIException e) {
                if (!(e.getCause() instanceof PartitionOfflineException)) {
                    throw e;
                }
            }
        }
        finally {
            ex.remove();
        }
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        });
        AsyncInvocation async1 = this.createPRAsync(vm0, 1, 0, 1);
        async1.getResult(65000L);
        this.checkData(vm1, 0, 1, "a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowRegionUseBeforeRedundancyRecovery() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        boolean redundancy = true;
        int numBuckets = 20;
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createPR(vm2, 1);
        this.createData(vm0, 0, numBuckets, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        SerializableRunnable slowGII = new SerializableRunnable("Slow down GII"){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new RecoveryObserver());
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new BlockGIIMessageObserver());
            }
        };
        SerializableRunnable resetSlowGII = new SerializableRunnable("Unset the slow GII"){

            @Override
            public void run() {
                BlockGIIMessageObserver messageObserver = (BlockGIIMessageObserver)DistributionMessageObserver.setInstance(null);
                RecoveryObserver recoveryObserver = (RecoveryObserver)InternalResourceManager.getResourceObserver();
                messageObserver.cdl.countDown();
                try {
                    recoveryObserver.recoveryDone.await();
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("Interrupted", e);
                }
                InternalResourceManager.setResourceObserver(null);
            }
        };
        try {
            vm0.invoke(slowGII);
            vm1.invoke(slowGII);
            vm2.invoke(slowGII);
            SerializableRunnable createPR = new SerializableRunnable("create PR"){

                @Override
                public void run() {
                    Cache cache = PersistentPartitionedRegionDUnitTest.this.getCache();
                    RegionAttributes attr = PersistentPartitionedRegionDUnitTest.this.getPersistentPRAttributes(1, -1, cache, 113, true);
                    cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, attr);
                }
            };
            AsyncInvocation a1 = vm0.invokeAsync(createPR);
            AsyncInvocation a2 = vm1.invokeAsync(createPR);
            AsyncInvocation a3 = vm2.invokeAsync(createPR);
            a1.getResult(65000L);
            a2.getResult(65000L);
            a3.getResult(65000L);
            this.checkData(vm0, 0, numBuckets, "a");
            this.createData(vm0, 113, 113 + numBuckets, "b");
            Set<Integer> vm0InitialBuckets = this.getBucketList(vm0);
            Set<Integer> vm1InitialBuckets = this.getBucketList(vm1);
            Set<Integer> vm2InitialBuckets = this.getBucketList(vm2);
            PersistentPartitionedRegionDUnitTest.assertEquals((String)("vm0=" + vm0InitialBuckets + ",vm1=" + vm1InitialBuckets + "vm2=" + vm2InitialBuckets), (int)numBuckets, (int)(vm0InitialBuckets.size() + vm1InitialBuckets.size() + vm2InitialBuckets.size()));
        }
        finally {
            AsyncInvocation reset0 = vm0.invokeAsync(resetSlowGII);
            AsyncInvocation reset1 = vm1.invokeAsync(resetSlowGII);
            AsyncInvocation reset2 = vm2.invokeAsync(resetSlowGII);
            reset0.getResult(65000L);
            reset1.getResult(65000L);
            reset2.getResult(65000L);
        }
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2));
        this.checkData(vm0, 0, numBuckets, "a");
        this.checkData(vm1, 0, numBuckets, "a");
        this.checkData(vm0, 113, 113 + numBuckets, "b");
        this.checkData(vm1, 113, 113 + numBuckets, "b");
    }

    public void testCrashDuringBucketGII() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        host.getVM(2);
        this.createPR(vm0, 1);
        this.createData(vm0, 0, 1, "value");
        vm0.invoke(new SerializableRunnable("Set crashing observer"){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            InitialImageOperation.RequestImageMessage rim = (InitialImageOperation.RequestImageMessage)message;
                            if (rim.regionPath.contains("_0")) {
                                DistributionMessageObserver.setInstance(null);
                                PersistentPartitionedRegionDUnitTest.this.getCache().close();
                            }
                        }
                    }
                });
            }
        });
        this.createPR(vm1, 1);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm1));
        this.createPR(vm0, 1, 0);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm1));
    }

    public void testCrashDuringBucketGII2() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final VM vm1 = host.getVM(1);
        host.getVM(2);
        this.createPR(vm0, 1);
        this.createData(vm0, 0, 1, "value");
        vm0.invoke(new SerializableRunnable("Set crashing observer"){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage) {
                            InitialImageOperation.RequestImageMessage rim = (InitialImageOperation.RequestImageMessage)message;
                            if (rim.regionPath.contains("_0")) {
                                DistributionMessageObserver.setInstance(null);
                                PersistentPartitionedRegionDUnitTest.this.getCache().close();
                            }
                        }
                    }
                });
            }
        });
        this.createPR(vm1, 1);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm1));
        this.closeCache(vm1);
        AsyncInvocation async0 = this.createPRAsync(vm0, 1, 0, 113);
        async0.join(500L);
        PersistentPartitionedRegionDUnitTest.assertTrue((boolean)async0.isAlive());
        this.createPR(vm1, 1, 0);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm0));
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return Collections.singleton(0).equals(PersistentPartitionedRegionDUnitTest.this.getBucketList(vm1));
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
        PersistentPartitionedRegionDUnitTest.assertEquals(Collections.singleton(0), this.getBucketList(vm1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCleanupAfterConflict() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, 0);
        this.createData(vm0, 0, 2, "a");
        this.closePR(vm0);
        this.createPR(vm1, 0);
        this.createData(vm1, 1, 2, "a");
        DistributedTestCase.ExpectedException expect = PersistentPartitionedRegionDUnitTest.addExpectedException("ConflictingPersistentDataException", vm0);
        try {
            this.createPR(vm0, 0);
            PersistentPartitionedRegionDUnitTest.fail((String)"should have seen a conflicting data exception");
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof ConflictingPersistentDataException)) {
                throw e;
            }
        }
        finally {
            expect.remove();
        }
        expect = PersistentPartitionedRegionDUnitTest.addExpectedException("PartitionOfflineException", vm1);
        try {
            this.createData(vm1, 0, 1, "a");
            PersistentPartitionedRegionDUnitTest.fail((String)"Should have seen a PartitionOfflineException for bucket 0");
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof PartitionOfflineException)) {
                throw e;
            }
        }
        finally {
            expect.remove();
        }
        this.closePR(vm1);
        this.createPR(vm0, 0);
        this.checkData(vm0, 0, 2, "a");
        this.checkData(vm0, 2, 3, null);
    }

    public void testPrimaryBalanceAfterRecovery() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 30;
        this.createPR(vm0, 1);
        this.createPR(vm1, 1);
        this.createPR(vm2, 1);
        this.createData(vm0, 0, numBuckets, "a");
        Set<Integer> vm0Buckets = this.getBucketList(vm0);
        Set<Integer> vm1Buckets = this.getBucketList(vm1);
        Set<Integer> vm2Buckets = this.getBucketList(vm2);
        Set<Integer> vm0Primaries = this.getPrimaryBucketList(vm0);
        PersistentPartitionedRegionDUnitTest.assertEquals((String)("Expected 10 primaries " + vm0Primaries), (int)10, (int)vm0Primaries.size());
        Set<Integer> vm1Primaries = this.getPrimaryBucketList(vm1);
        PersistentPartitionedRegionDUnitTest.assertEquals((String)("Expected 10 primaries " + vm1Primaries), (int)10, (int)vm1Primaries.size());
        Set<Integer> vm2Primaries = this.getPrimaryBucketList(vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals((String)("Expected 10 primaries " + vm2Primaries), (int)10, (int)vm2Primaries.size());
        this.closeCache(vm0);
        this.createPR(vm0, 1);
        this.waitForBucketRecovery(vm0, vm0Buckets);
        PersistentPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1));
        PersistentPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2));
        vm0Primaries = this.getPrimaryBucketList(vm0);
        PersistentPartitionedRegionDUnitTest.assertEquals((String)("Expected 10 primaries " + vm0Primaries), (int)10, (int)vm0Primaries.size());
        vm1Primaries = this.getPrimaryBucketList(vm1);
        PersistentPartitionedRegionDUnitTest.assertEquals((String)("Expected 10 primaries " + vm1Primaries), (int)10, (int)vm1Primaries.size());
        vm2Primaries = this.getPrimaryBucketList(vm2);
        PersistentPartitionedRegionDUnitTest.assertEquals((String)("Expected 10 primaries " + vm2Primaries), (int)10, (int)vm2Primaries.size());
    }

    public void testConcurrencyChecksEnabled() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final String regionName = this.getName();
        SerializableCallable createPR = new SerializableCallable(){

            public Object call() throws Exception {
                RegionFactory rf = PersistentPartitionedRegionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION_PERSISTENT);
                Region r = rf.create(regionName);
                TestCase.assertTrue((boolean)r.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        };
        SerializableCallable createPRProxy = new SerializableCallable(){

            public Object call() throws Exception {
                RegionFactory rf = PersistentPartitionedRegionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION_PROXY);
                Region r = rf.create(regionName);
                return null;
            }
        };
        vm0.invoke(createPRProxy);
        vm1.invoke(createPR);
        vm2.invoke(createPR);
        vm3.invoke(createPRProxy);
        SerializableCallable verifyConcurrenyChecks = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PersistentPartitionedRegionDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertTrue((boolean)r.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        };
        vm0.invoke(verifyConcurrenyChecks);
        vm3.invoke(verifyConcurrenyChecks);
    }

    public void testNonPersistentProxy() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        final String regionName = this.getName();
        SerializableCallable createAccessor = new SerializableCallable(){

            public Object call() throws Exception {
                PersistentPartitionedRegionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION_PROXY).create(regionName);
                return null;
            }
        };
        vm1.invoke(createAccessor);
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PersistentPartitionedRegionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION_PERSISTENT).create(regionName);
                TestCase.assertTrue((boolean)r.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        });
        vm3.invoke(createAccessor);
        SerializableCallable verifyConcurrencyChecks = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PersistentPartitionedRegionDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertTrue((boolean)r.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        };
        vm1.invoke(verifyConcurrencyChecks);
        vm3.invoke(verifyConcurrencyChecks);
    }

    public void testReplicateAfterPersistent() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        final String regionName = this.getName();
        SerializableCallable createPersistentReplicate = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PersistentPartitionedRegionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT).create(regionName);
                return null;
            }
        };
        SerializableCallable createNonPersistentReplicate = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PersistentPartitionedRegionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                return null;
            }
        };
        vm1.invoke(createPersistentReplicate);
        vm2.invoke(createNonPersistentReplicate);
        vm3.invoke(createPersistentReplicate);
    }

    private static class TestCustomExpiration
    implements CustomExpiry {
        private TestCustomExpiration() {
        }

        public void close() {
        }

        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return new ExpirationAttributes((entry.getKey().hashCode() + entry.getValue().hashCode()) % 100, ExpirationAction.INVALIDATE);
        }
    }

    private static class BlockGIIMessageObserver
    extends DistributionMessageObserver {
        CountDownLatch cdl = new CountDownLatch(1);

        private BlockGIIMessageObserver() {
        }

        public void beforeSendMessage(DistributionManager dm, DistributionMessage message) {
            if (message instanceof InitialImageOperation.RequestImageMessage) {
                InitialImageOperation.RequestImageMessage rim = (InitialImageOperation.RequestImageMessage)message;
                if (rim.regionPath.contains("B_")) {
                    try {
                        this.cdl.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private static class TestFunction
    implements Function,
    Serializable {
        private TestFunction() {
        }

        public void execute(FunctionContext context) {
            context.getResultSender().lastResult(null);
        }

        public String getId() {
            return TestFunction.class.getSimpleName();
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public boolean isHA() {
            return false;
        }
    }

    private static final class RecoveryObserver
    extends InternalResourceManager.ResourceObserverAdapter {
        final CountDownLatch recoveryDone = new CountDownLatch(1);

        private RecoveryObserver() {
        }

        public void rebalancingOrRecoveryFinished(Region region) {
            if (region.getName().equals(PersistentPartitionedRegionTestBase.PR_REGION_NAME)) {
                this.recoveryDone.countDown();
            }
        }
    }

    public static class BadSerializer
    implements DataSerializable {
        public void toData(DataOutput out) throws IOException {
            if (Thread.currentThread().getName().contains("Asynchronous disk writer") && FAIL_IN_THIS_VM) {
                throw new ConcurrentModificationException();
            }
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }
    }
}

