/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.fixed;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionManager;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionedRegionObserver;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionedRegionObserverAdapter;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionedRegionObserverHolder;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.MyDate1;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.MyDate2;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.MyDate3;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class FixedPartitioningTestBase
extends DistributedTestCase {
    private static final long serialVersionUID = 1L;
    protected static String Quarter1 = "Q1";
    protected static String Quarter2 = "Q2";
    protected static String Quarter3 = "Q3";
    protected static String Quarter4 = "Q4";
    protected static VM member1 = null;
    protected static VM member2 = null;
    protected static VM member3 = null;
    protected static VM member4 = null;
    static Cache cache = null;
    protected static PartitionedRegion region_FPR = null;
    protected static int redundantCopies;
    private static PartitionedRegionObserver origObserver;

    public FixedPartitioningTestBase(String name) {
        super(name);
    }

    public static void createCacheOnMember() {
        new FixedPartitioningTestBase("Temp").createCache();
    }

    public static void createCacheOnMember_DisableMovePrimary() {
        System.setProperty("gemfire.DISABLE_MOVE_PRIMARIES_ON_STARTUP", "true");
        new FixedPartitioningTestBase("Temp").createCache();
    }

    private void createCache() {
        try {
            Properties props = new Properties();
            cache = null;
            InternalDistributedSystem ds = this.getSystem(props);
            FixedPartitioningTestBase.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            FixedPartitioningTestBase.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            FixedPartitioningTestBase.fail("Failed while creating the cache", e);
        }
    }

    public static void createRegionWithPartitionAttributes(String regionName, List<FixedPartitionAttributes> fpaList, Integer redCopies, Integer localMaxMemory, Integer totalNumBuckets, PartitionResolver resolver, String colocatedWith, boolean isPersistence) {
        PartitionAttributesFactory paf_FPR = new PartitionAttributesFactory();
        paf_FPR.setRedundantCopies(redCopies.intValue());
        paf_FPR.setLocalMaxMemory(localMaxMemory.intValue());
        paf_FPR.setTotalNumBuckets(totalNumBuckets.intValue());
        paf_FPR.setPartitionResolver(resolver);
        paf_FPR.setColocatedWith(colocatedWith);
        if (fpaList != null) {
            for (FixedPartitionAttributes fpa : fpaList) {
                paf_FPR.addFixedPartitionAttributes(fpa);
            }
        }
        AttributesFactory af_FPR = new AttributesFactory();
        af_FPR.setPartitionAttributes(paf_FPR.create());
        if (isPersistence) {
            DiskStore ds = cache.findDiskStore("disk");
            if (ds == null) {
                ds = cache.createDiskStoreFactory().setDiskDirs(FixedPartitioningTestBase.getDiskDirs()).create("disk");
            }
            af_FPR.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
            af_FPR.setDiskStoreName("disk");
        }
        region_FPR = (PartitionedRegion)cache.createRegion(regionName, af_FPR.create());
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
    }

    public static void doRebalance() {
        ResourceManager manager = cache.getResourceManager();
        RebalanceOperation operation = manager.createRebalanceFactory().start();
        try {
            RebalanceResults rebalanceResults = operation.getResults();
        }
        catch (InterruptedException e) {
            FixedPartitioningTestBase.fail("Not expecting exception", e);
        }
    }

    public static File[] getDiskDirs() {
        return new File[]{FixedPartitioningTestBase.getDiskDir()};
    }

    private static File getDiskDir() {
        int vmNum = VM.getCurrentVMNum();
        File dir = new File("diskDir", String.valueOf(vmNum)).getAbsoluteFile();
        dir.mkdirs();
        return dir;
    }

    public static void putThorughAccessor(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (Months_Accessor month : Months_Accessor.values()) {
            for (int i = 1; i < 10; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                String value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value);
            }
        }
    }

    public static void putThorughAccessor_Immediate(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (int i = 1; i < 10; ++i) {
            for (Months_Accessor month : Months_Accessor.values()) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                String value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value);
            }
        }
    }

    public static void putThroughDataStore(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (Months_DataStore month : Months_DataStore.values()) {
            for (int i = 1; i < 10; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                String value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value);
            }
        }
    }

    public static void putForQuarter(String regionName, String quarters) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        if (quarters.equals("Q1")) {
            for (Q1_Months month : Q1_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    region_FPR.put((Object)date, (Object)value);
                }
            }
        } else if (quarters.equals("Q2")) {
            for (Q2_Months month : Q2_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    region_FPR.put((Object)date, (Object)value);
                }
            }
        } else if (quarters.equals("Q3")) {
            for (Q3_Months month : Q3_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    region_FPR.put((Object)date, (Object)value);
                }
            }
        } else if (quarters.equals("Q4")) {
            for (Q4_Months month : Q4_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    region_FPR.put((Object)date, (Object)value);
                }
            }
        } else {
            FixedPartitioningTestBase.fail((String)"Wrong Quarter");
        }
    }

    public static void getForQuarter(String regionName, String quarters) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        if (quarters.equals(Quarter1)) {
            for (Q1_Months month : Q1_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    FixedPartitioningTestBase.assertEquals((Object)value, (Object)region_FPR.get((Object)date));
                }
            }
        } else if (quarters.equals(Quarter2)) {
            for (Q2_Months month : Q2_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    FixedPartitioningTestBase.assertEquals((Object)value, (Object)region_FPR.get((Object)date));
                }
            }
        } else if (quarters.equals(Quarter3)) {
            for (Q3_Months month : Q3_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    FixedPartitioningTestBase.assertEquals((Object)value, (Object)region_FPR.get((Object)date));
                }
            }
        } else if (quarters.equals(Quarter4)) {
            for (Q4_Months month : Q4_Months.values()) {
                for (int i = 1; i < 10; ++i) {
                    Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                    String value = month.toString() + i;
                    FixedPartitioningTestBase.assertEquals((Object)value, (Object)region_FPR.get((Object)date));
                }
            }
        } else {
            FixedPartitioningTestBase.fail((String)"Wrong Quarter");
        }
    }

    public static void getForColocation(String customerRegion, String order, String shipment) {
        PartitionedRegion region_Cust = (PartitionedRegion)cache.getRegion(customerRegion);
        FixedPartitioningTestBase.assertNotNull((Object)region_Cust);
        for (int i = 1; i <= 20; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                FixedPartitioningTestBase.assertEquals((Object)customer, (Object)region_Cust.get((Object)custid));
                continue;
            }
            catch (Exception e) {
                FixedPartitioningTestBase.fail("getForColocation : failed while doing get operation in CustomerPartitionedRegion ", e);
            }
        }
        PartitionedRegion region_Ord = (PartitionedRegion)cache.getRegion(order);
        FixedPartitioningTestBase.assertNull((Object)region_Ord);
        PartitionedRegion region_Ship = (PartitionedRegion)cache.getRegion(shipment);
        FixedPartitioningTestBase.assertNull((Object)region_Ship);
    }

    public static void getThroughDataStore(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (Months_DataStore month : Months_DataStore.values()) {
            for (int i = 1; i < 10; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                String value = month.toString() + i;
                FixedPartitioningTestBase.assertEquals((Object)value, (Object)region_FPR.get((Object)date));
            }
        }
    }

    public static void putThroughDataStore_NoResolver(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (Months_DataStore month : Months_DataStore.values()) {
            for (int i = 1; i < 10; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                String value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value);
            }
        }
    }

    public static void putThroughDataStore_CallBackWithResolver(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (Months_DataStore month : Months_DataStore.values()) {
            for (int i = 1; i < 10; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                Date callbackDate = FixedPartitioningTestBase.generateDate(i, month.toString(), "MyDate3");
                String value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value, (Object)callbackDate);
            }
        }
    }

    public static void putThroughDataStore_FixedPartitionResolver_NoResolver(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (Months_DataStore month : Months_DataStore.values()) {
            for (int i = 1; i < 10; ++i) {
                String value;
                Date date;
                if (i % 2 == 1) {
                    date = (MyDate1)FixedPartitioningTestBase.generateDate(i, month.toString(), "MyDate1");
                    value = month.toString() + i;
                    region_FPR.put((Object)date, (Object)value);
                    continue;
                }
                date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value);
            }
        }
    }

    public static void putThroughDataStore_FixedPartitionResolver_PartitionResolver(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (int i = 1; i < 10; ++i) {
            for (Months_DataStore month : Months_DataStore.values()) {
                String value;
                Date date;
                if (month.ordinal() % 2 == 1) {
                    date = (MyDate1)FixedPartitioningTestBase.generateDate(i, month.toString(), "MyDate1");
                    value = month.toString() + i;
                    region_FPR.put((Object)date, (Object)value);
                    continue;
                }
                date = (MyDate2)FixedPartitioningTestBase.generateDate(i, month.toString(), "MyDate2");
                value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value);
            }
        }
    }

    public static void deleteOperation(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        Date date = FixedPartitioningTestBase.generateDate(1, "JAN", "Date");
        region_FPR.destroy((Object)date);
    }

    public static void putOperation(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        Date date = FixedPartitioningTestBase.generateDate(1, "JAN", "Date");
        region_FPR.put((Object)date, (Object)"Jan1");
    }

    public static void putCustomerPartitionedRegion(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 40; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                partitionedregion.put((Object)custid, (Object)customer);
                continue;
            }
            catch (Exception e) {
                FixedPartitioningTestBase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
            }
        }
    }

    public static void putOrderPartitionedRegion(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 40; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                try {
                    partitionedregion.put((Object)orderId, (Object)order);
                    continue;
                }
                catch (Exception e) {
                    FixedPartitioningTestBase.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
    }

    public static void putShipmentPartitionedRegion(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 40; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                for (int k = 1; k <= 10; ++k) {
                    int sid = oid * 10 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    try {
                        partitionedregion.put((Object)shipmentId, (Object)shipment);
                        continue;
                    }
                    catch (Exception e) {
                        FixedPartitioningTestBase.fail("putShipmentPartitionedRegion : failed while doing put operation in ShipmentPartitionedRegion ", e);
                    }
                }
            }
        }
    }

    public static void putCustomerPartitionedRegion_Persistence(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                partitionedregion.put((Object)custid, (Object)customer);
                continue;
            }
            catch (Exception e) {
                FixedPartitioningTestBase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
            }
        }
    }

    public static void putOrderPartitionedRegion_Persistence(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                try {
                    partitionedregion.put((Object)orderId, (Object)order);
                    continue;
                }
                catch (Exception e) {
                    FixedPartitioningTestBase.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
    }

    public static void putShipmentPartitionedRegion_Persistence(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                for (int k = 1; k <= 10; ++k) {
                    int sid = oid * 10 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    try {
                        partitionedregion.put((Object)shipmentId, (Object)shipment);
                        continue;
                    }
                    catch (Exception e) {
                        FixedPartitioningTestBase.fail("putShipmentPartitionedRegion : failed while doing put operation in ShipmentPartitionedRegion ", e);
                    }
                }
            }
        }
    }

    public static void putCustomerPartitionedRegion_Persistence1(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            if (i % 2 != 0) continue;
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                partitionedregion.put((Object)custid, (Object)customer);
                continue;
            }
            catch (Exception e) {
                FixedPartitioningTestBase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
            }
        }
    }

    public static void putOrderPartitionedRegion_Persistence1(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            if (i % 2 != 0) continue;
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                try {
                    partitionedregion.put((Object)orderId, (Object)order);
                    continue;
                }
                catch (Exception e) {
                    FixedPartitioningTestBase.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
    }

    public static void putShipmentPartitionedRegion_Persistence1(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            if (i % 2 != 0) continue;
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                for (int k = 1; k <= 10; ++k) {
                    int sid = oid * 10 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    try {
                        partitionedregion.put((Object)shipmentId, (Object)shipment);
                        continue;
                    }
                    catch (Exception e) {
                        FixedPartitioningTestBase.fail("putShipmentPartitionedRegion : failed while doing put operation in ShipmentPartitionedRegion ", e);
                    }
                }
            }
        }
    }

    public static void putCustomerPartitionedRegion_Persistence2(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            if (i % 2 != 1) continue;
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                partitionedregion.put((Object)custid, (Object)customer);
                continue;
            }
            catch (Exception e) {
                FixedPartitioningTestBase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
            }
        }
    }

    public static void putOrderPartitionedRegion_Persistence2(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            if (i % 2 != 1) continue;
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                try {
                    partitionedregion.put((Object)orderId, (Object)order);
                    continue;
                }
                catch (Exception e) {
                    FixedPartitioningTestBase.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
    }

    public static void putShipmentPartitionedRegion_Persistence2(String partitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        Region partitionedregion = cache.getRegion("/" + partitionedRegionName);
        FixedPartitioningTestBase.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 20; ++i) {
            if (i % 2 != 1) continue;
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                for (int k = 1; k <= 10; ++k) {
                    int sid = oid * 10 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    try {
                        partitionedregion.put((Object)shipmentId, (Object)shipment);
                        continue;
                    }
                    catch (Exception e) {
                        FixedPartitioningTestBase.fail("putShipmentPartitionedRegion : failed while doing put operation in ShipmentPartitionedRegion ", e);
                    }
                }
            }
        }
    }

    public static void putHAData(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        for (Months_DataStore month : Months_DataStore.values()) {
            for (int i = 10; i < 20; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                String value = month.toString() + i;
                region_FPR.put((Object)date, (Object)value);
            }
        }
    }

    private static Date generateDate(int i, String month, String dateType) {
        String year = "2010";
        String day = null;
        day = i > 0 && i < 10 ? "0" + i : new Integer(i).toString();
        String dateString = day + "-" + month + "-" + year;
        String DATE_FORMAT = "dd-MMM-yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        try {
            if (dateType == "Date") {
                return sdf.parse(dateString);
            }
            if (dateType == "MyDate1") {
                return new MyDate1(sdf.parse(dateString).getTime());
            }
            if (dateType == "MyDate2") {
                return new MyDate2(sdf.parse(dateString).getTime());
            }
            if (dateType == "MyDate3") {
                return new MyDate3(sdf.parse(dateString).getTime());
            }
            return null;
        }
        catch (ParseException e) {
            FixedPartitioningTestBase.fail("Exception Occured while parseing date", e);
            return null;
        }
    }

    public static void validateAfterPutPartitionedRegion(String customerPartitionedRegionName, String orderPartitionedRegionName, String shipmentPartitionedRegionName) throws ClassNotFoundException {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        PartitionedRegion customerPartitionedregion = null;
        PartitionedRegion orderPartitionedregion = null;
        PartitionedRegion shipmentPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)cache.getRegion("/" + customerPartitionedRegionName);
            orderPartitionedregion = (PartitionedRegion)cache.getRegion("/" + orderPartitionedRegionName);
            shipmentPartitionedregion = (PartitionedRegion)cache.getRegion("/" + shipmentPartitionedRegionName);
        }
        catch (Exception e) {
            FixedPartitioningTestBase.fail("validateAfterPutPartitionedRegion : failed while getting the region", e);
        }
        FixedPartitioningTestBase.assertNotNull(customerPartitionedregion);
        for (int i = 0; i < 10; ++i) {
            InternalDistributedMember idmForCustomer = customerPartitionedregion.getBucketPrimary(i);
            InternalDistributedMember idmForOrder = orderPartitionedregion.getBucketPrimary(i);
            InternalDistributedMember idmForShipment = shipmentPartitionedregion.getBucketPrimary(i);
            Set customerKey = customerPartitionedregion.getBucketKeys(i);
            FixedPartitioningTestBase.assertNotNull((Object)customerKey);
            for (CustId custId : customerKey) {
                FixedPartitioningTestBase.assertNotNull((Object)customerPartitionedregion.get((Object)custId));
                Set orderKey = orderPartitionedregion.getBucketKeys(i);
                FixedPartitioningTestBase.assertNotNull((Object)orderKey);
                for (OrderId orderId : orderKey) {
                    if (custId.equals(orderId.getCustId())) {
                        FixedPartitioningTestBase.assertEquals((Object)idmForCustomer, (Object)idmForOrder);
                    }
                    Set shipmentKey = shipmentPartitionedregion.getBucketKeys(i);
                    FixedPartitioningTestBase.assertNotNull((Object)shipmentKey);
                    for (ShipmentId shipmentId : shipmentKey) {
                        if (!orderId.equals(shipmentId.getOrderId())) continue;
                    }
                }
            }
        }
    }

    public static void checkPrimaryData(String partitionName) {
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        if (partitionName.equals(Quarter1)) {
            FixedPartitioningTestBase.assertEquals((int)27, (int)localRegion.size());
            FixedPartitioningTestBase.assertTRUE_Q1(false);
            FixedPartitioningTestBase.assertFALSE_Q2(false);
            FixedPartitioningTestBase.assertFALSE_Q3(false);
            FixedPartitioningTestBase.assertFALSE_Q4(false);
        } else if (partitionName.equals(Quarter2)) {
            FixedPartitioningTestBase.assertEquals((int)27, (int)localRegion.size());
            FixedPartitioningTestBase.assertFALSE_Q1(false);
            FixedPartitioningTestBase.assertTRUE_Q2(false);
            FixedPartitioningTestBase.assertFALSE_Q3(false);
            FixedPartitioningTestBase.assertFALSE_Q4(false);
        } else if (partitionName.equals(Quarter3)) {
            FixedPartitioningTestBase.assertEquals((int)27, (int)localRegion.size());
            FixedPartitioningTestBase.assertFALSE_Q1(false);
            FixedPartitioningTestBase.assertFALSE_Q2(false);
            FixedPartitioningTestBase.assertTRUE_Q3(false);
            FixedPartitioningTestBase.assertFALSE_Q4(false);
        } else if (partitionName.equals(Quarter4)) {
            FixedPartitioningTestBase.assertEquals((int)27, (int)localRegion.size());
            FixedPartitioningTestBase.assertFALSE_Q1(false);
            FixedPartitioningTestBase.assertFALSE_Q2(false);
            FixedPartitioningTestBase.assertFALSE_Q3(false);
            FixedPartitioningTestBase.assertTRUE_Q4(false);
        }
    }

    public static void checkPrimaryDataPersistence(String partitionName) {
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        if (partitionName.equals(Quarter1)) {
            FixedPartitioningTestBase.assertEquals((int)54, (int)localRegion.size());
            FixedPartitioningTestBase.assertTRUE_Q1(false);
            FixedPartitioningTestBase.assertTRUE_Q2(false);
            FixedPartitioningTestBase.assertFALSE_Q3(false);
            FixedPartitioningTestBase.assertFALSE_Q4(false);
        } else if (partitionName.equals(Quarter2)) {
            FixedPartitioningTestBase.assertEquals((int)54, (int)localRegion.size());
            FixedPartitioningTestBase.assertTRUE_Q1(false);
            FixedPartitioningTestBase.assertTRUE_Q2(false);
            FixedPartitioningTestBase.assertFALSE_Q3(false);
            FixedPartitioningTestBase.assertFALSE_Q4(false);
        } else if (partitionName.equals(Quarter3)) {
            FixedPartitioningTestBase.assertEquals((int)27, (int)localRegion.size());
            FixedPartitioningTestBase.assertFALSE_Q1(false);
            FixedPartitioningTestBase.assertFALSE_Q2(false);
            FixedPartitioningTestBase.assertTRUE_Q3(false);
            FixedPartitioningTestBase.assertFALSE_Q4(false);
        } else if (partitionName.equals(Quarter4)) {
            FixedPartitioningTestBase.assertEquals((int)27, (int)localRegion.size());
            FixedPartitioningTestBase.assertFALSE_Q1(false);
            FixedPartitioningTestBase.assertFALSE_Q2(false);
            FixedPartitioningTestBase.assertFALSE_Q3(false);
            FixedPartitioningTestBase.assertTRUE_Q4(false);
        }
    }

    public static void checkPrimarySecondaryData(String partitionName, Boolean isHA) {
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        if (partitionName.equals(Quarter1)) {
            FixedPartitioningTestBase.assertTRUE_Q1(isHA);
            FixedPartitioningTestBase.assertTRUE_Q2(isHA);
            FixedPartitioningTestBase.assertFALSE_Q3(isHA);
            FixedPartitioningTestBase.assertFALSE_Q4(isHA);
        } else if (partitionName.equals(Quarter2)) {
            FixedPartitioningTestBase.assertFALSE_Q1(isHA);
            FixedPartitioningTestBase.assertTRUE_Q2(isHA);
            FixedPartitioningTestBase.assertTRUE_Q3(isHA);
            FixedPartitioningTestBase.assertFALSE_Q4(isHA);
        } else if (partitionName.equals(Quarter3)) {
            FixedPartitioningTestBase.assertFALSE_Q1(isHA);
            FixedPartitioningTestBase.assertFALSE_Q2(isHA);
            FixedPartitioningTestBase.assertTRUE_Q3(isHA);
            FixedPartitioningTestBase.assertTRUE_Q4(isHA);
        } else if (partitionName.equals(Quarter4)) {
            FixedPartitioningTestBase.assertTRUE_Q1(isHA);
            FixedPartitioningTestBase.assertFALSE_Q2(isHA);
            FixedPartitioningTestBase.assertFALSE_Q3(isHA);
            FixedPartitioningTestBase.assertTRUE_Q4(isHA);
        }
    }

    public static void checkPrimarySecondaryData_TwoSecondaries(String partitionName, Boolean isHA) {
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        if (partitionName.equals(Quarter1)) {
            FixedPartitioningTestBase.assertTRUE_Q1(isHA);
            FixedPartitioningTestBase.assertFALSE_Q2(isHA);
            FixedPartitioningTestBase.assertTRUE_Q3(isHA);
            FixedPartitioningTestBase.assertTRUE_Q4(isHA);
        } else if (partitionName.equals(Quarter2)) {
            FixedPartitioningTestBase.assertFALSE_Q1(isHA);
            FixedPartitioningTestBase.assertTRUE_Q2(isHA);
            FixedPartitioningTestBase.assertTRUE_Q3(isHA);
            FixedPartitioningTestBase.assertTRUE_Q4(isHA);
        } else if (partitionName.equals(Quarter3)) {
            FixedPartitioningTestBase.assertTRUE_Q1(isHA);
            FixedPartitioningTestBase.assertTRUE_Q2(isHA);
            FixedPartitioningTestBase.assertTRUE_Q3(isHA);
            FixedPartitioningTestBase.assertFALSE_Q4(isHA);
        } else if (partitionName.equals(Quarter4)) {
            FixedPartitioningTestBase.assertTRUE_Q1(isHA);
            FixedPartitioningTestBase.assertTRUE_Q2(isHA);
            FixedPartitioningTestBase.assertFALSE_Q3(isHA);
            FixedPartitioningTestBase.assertTRUE_Q4(isHA);
        }
    }

    public static void assertTRUE_Q1(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q1_Months month : Q1_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertTrue((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void assertTRUE_Q2(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q2_Months month : Q2_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertTrue((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void assertTRUE_Q3(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q3_Months month : Q3_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertTrue((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void assertTRUE_Q4(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q4_Months month : Q4_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertTrue((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void assertFALSE_Q1(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q1_Months month : Q1_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertFalse((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void assertFALSE_Q2(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q2_Months month : Q2_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertFalse((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void assertFALSE_Q3(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q3_Months month : Q3_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertFalse((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void assertFALSE_Q4(boolean isHA) {
        int day = isHA ? 20 : 10;
        Region localRegion = PartitionRegionHelper.getLocalData((Region)region_FPR);
        for (Q4_Months month : Q4_Months.values()) {
            for (int i = 1; i < day; ++i) {
                Date date = FixedPartitioningTestBase.generateDate(i, month.toString(), "Date");
                FixedPartitioningTestBase.assertFalse((boolean)localRegion.keySet().contains(date));
            }
        }
    }

    public static void checkPrimaryBucketsForQuarter(Integer numBuckets, Integer primaryBuckets) {
        HashMap localBucket2RegionMap = (HashMap)region_FPR.getDataStore().getSizeLocally();
        FixedPartitioningTestBase.getLogWriter().info("Size of the " + region_FPR + " in this VM :- " + localBucket2RegionMap.size() + "List of buckets : " + localBucket2RegionMap.keySet());
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap.size());
        FixedPartitioningTestBase.getLogWriter().info("Size of primary buckets the " + region_FPR + " in this VM :- " + region_FPR.getDataStore().getNumberOfPrimaryBucketsManaged());
        FixedPartitioningTestBase.getLogWriter().info("List of Primaries in this VM :- " + region_FPR.getDataStore().getAllLocalPrimaryBucketIds());
        FixedPartitioningTestBase.assertEquals((int)primaryBuckets, (int)region_FPR.getDataStore().getNumberOfPrimaryBucketsManaged());
    }

    public static void checkPrimaryBucketsForQuarterAfterCacheClosed(Integer numBuckets, Integer primaryBuckets) {
        HashMap localBucket2RegionMap = (HashMap)region_FPR.getDataStore().getSizeLocally();
        FixedPartitioningTestBase.getLogWriter().info("Size of the " + region_FPR + " in this VM :- " + localBucket2RegionMap.size() + "List of buckets : " + localBucket2RegionMap.keySet());
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap.size());
        FixedPartitioningTestBase.getLogWriter().info("Size of primary buckets the " + region_FPR + " in this VM :- " + region_FPR.getDataStore().getNumberOfPrimaryBucketsManaged());
        FixedPartitioningTestBase.getLogWriter().info("List of Primaries in this VM :- " + region_FPR.getDataStore().getAllLocalPrimaryBucketIds());
        FixedPartitioningTestBase.assertEquals((int)(region_FPR.getDataStore().getNumberOfPrimaryBucketsManaged() % primaryBuckets), (int)0);
    }

    public static void checkPrimaryBucketsForCustomer(Integer numBuckets, Integer primaryBuckets, String customerPartitionedRegionName) {
        PartitionedRegion customerPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)cache.getRegion("/" + customerPartitionedRegionName);
        }
        catch (Exception e) {
            FixedPartitioningTestBase.fail("validateAfterPutPartitionedRegion : failed while getting the region", e);
        }
        HashMap localBucket2RegionMap_Customer = (HashMap)customerPartitionedregion.getDataStore().getSizeLocally();
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap_Customer.size());
        List primaryBuckets_Customer = customerPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        FixedPartitioningTestBase.assertEquals((int)primaryBuckets, (int)primaryBuckets_Customer.size());
    }

    public static void checkPrimaryBucketsForColocation(Integer numBuckets, Integer primaryBuckets, String customerPartitionedRegionName, String orderPartitionedRegionName, String shipmentPartitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        PartitionedRegion customerPartitionedregion = null;
        PartitionedRegion orderPartitionedregion = null;
        PartitionedRegion shipmentPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)cache.getRegion("/" + customerPartitionedRegionName);
            orderPartitionedregion = (PartitionedRegion)cache.getRegion("/" + orderPartitionedRegionName);
            shipmentPartitionedregion = (PartitionedRegion)cache.getRegion("/" + shipmentPartitionedRegionName);
        }
        catch (Exception e) {
            FixedPartitioningTestBase.fail("validateAfterPutPartitionedRegion : failed while getting the region", e);
        }
        HashMap localBucket2RegionMap_Customer = (HashMap)customerPartitionedregion.getDataStore().getSizeLocally();
        HashMap localBucket2RegionMap_Order = (HashMap)orderPartitionedregion.getDataStore().getSizeLocally();
        HashMap localBucket2RegionMap_Shipment = (HashMap)shipmentPartitionedregion.getDataStore().getSizeLocally();
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap_Customer.size());
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap_Order.size());
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap_Shipment.size());
        FixedPartitioningTestBase.assertEquals(localBucket2RegionMap_Customer.keySet(), localBucket2RegionMap_Order.keySet());
        FixedPartitioningTestBase.assertEquals(localBucket2RegionMap_Customer.keySet(), localBucket2RegionMap_Shipment.keySet());
        FixedPartitioningTestBase.assertEquals(localBucket2RegionMap_Order.keySet(), localBucket2RegionMap_Shipment.keySet());
        List primaryBuckets_Customer = customerPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        List primaryBuckets_Order = orderPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        List primaryBuckets_Shipment = shipmentPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        FixedPartitioningTestBase.assertEquals((int)primaryBuckets, (int)primaryBuckets_Customer.size());
        FixedPartitioningTestBase.assertEquals((int)primaryBuckets, (int)primaryBuckets_Order.size());
        FixedPartitioningTestBase.assertEquals((int)primaryBuckets, (int)primaryBuckets_Shipment.size());
        FixedPartitioningTestBase.assertEquals((Object)primaryBuckets_Customer, (Object)primaryBuckets_Order);
        FixedPartitioningTestBase.assertEquals((Object)primaryBuckets_Customer, (Object)primaryBuckets_Shipment);
        FixedPartitioningTestBase.assertEquals((Object)primaryBuckets_Order, (Object)primaryBuckets_Shipment);
    }

    public static void checkPrimaryBucketsForColocationAfterCacheClosed(Integer numBuckets, Integer primaryBuckets, String customerPartitionedRegionName, String orderPartitionedRegionName, String shipmentPartitionedRegionName) {
        FixedPartitioningTestBase.assertNotNull((Object)cache);
        PartitionedRegion customerPartitionedregion = null;
        PartitionedRegion orderPartitionedregion = null;
        PartitionedRegion shipmentPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)cache.getRegion("/" + customerPartitionedRegionName);
            orderPartitionedregion = (PartitionedRegion)cache.getRegion("/" + orderPartitionedRegionName);
            shipmentPartitionedregion = (PartitionedRegion)cache.getRegion("/" + shipmentPartitionedRegionName);
        }
        catch (Exception e) {
            FixedPartitioningTestBase.fail("validateAfterPutPartitionedRegion : failed while getting the region", e);
        }
        HashMap localBucket2RegionMap_Customer = (HashMap)customerPartitionedregion.getDataStore().getSizeLocally();
        HashMap localBucket2RegionMap_Order = (HashMap)orderPartitionedregion.getDataStore().getSizeLocally();
        HashMap localBucket2RegionMap_Shipment = (HashMap)shipmentPartitionedregion.getDataStore().getSizeLocally();
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap_Customer.size());
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap_Order.size());
        FixedPartitioningTestBase.assertEquals((int)numBuckets, (int)localBucket2RegionMap_Shipment.size());
        FixedPartitioningTestBase.assertEquals(localBucket2RegionMap_Customer.keySet(), localBucket2RegionMap_Order.keySet());
        FixedPartitioningTestBase.assertEquals(localBucket2RegionMap_Customer.keySet(), localBucket2RegionMap_Shipment.keySet());
        FixedPartitioningTestBase.assertEquals(localBucket2RegionMap_Order.keySet(), localBucket2RegionMap_Shipment.keySet());
        List primaryBuckets_Customer = customerPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        List primaryBuckets_Order = orderPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        List primaryBuckets_Shipment = shipmentPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        FixedPartitioningTestBase.assertEquals((int)(primaryBuckets_Customer.size() % primaryBuckets), (int)0);
        FixedPartitioningTestBase.assertEquals((int)(primaryBuckets_Order.size() % primaryBuckets), (int)0);
        FixedPartitioningTestBase.assertEquals((int)(primaryBuckets_Shipment.size() % primaryBuckets), (int)0);
        FixedPartitioningTestBase.assertEquals((Object)primaryBuckets_Customer, (Object)primaryBuckets_Order);
        FixedPartitioningTestBase.assertEquals((Object)primaryBuckets_Customer, (Object)primaryBuckets_Shipment);
        FixedPartitioningTestBase.assertEquals((Object)primaryBuckets_Order, (Object)primaryBuckets_Shipment);
    }

    public static void checkFPR(String regionName) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        PartitionedRegion colocatedRegion = (PartitionedRegion)cache.getRegion(region_FPR.getColocatedWith());
        List childFPAs = region_FPR.getFixedPartitionAttributesImpl();
        List parentFPAs = colocatedRegion.getFixedPartitionAttributesImpl();
        FixedPartitioningTestBase.assertEquals((Object)parentFPAs, (Object)childFPAs);
    }

    public static void checkStartingBucketIDs() {
        FixedPartitioningTestBase.assertEquals((int)(region_FPR.getDataStore().getAllLocalPrimaryBucketIds().size() % 3), (int)0);
    }

    public static void checkStartingBucketIDs_Nodedown() {
        FixedPartitioningTestBase.assertEquals((int)(region_FPR.getDataStore().getAllLocalPrimaryBucketIds().size() % 3), (int)0);
    }

    public static void checkStartingBucketIDs_Nodeup() {
        FixedPartitioningTestBase.assertEquals((int)(region_FPR.getDataStore().getAllLocalPrimaryBucketIds().size() % 3), (int)0);
    }

    public static void createPrimaryBucketsBelongingToThisPartition(String regionName, Boolean destroyExistingRemote, Boolean destroyExistingLocal) {
        region_FPR = (PartitionedRegion)cache.getRegion(regionName);
        FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
        int startingBucketId = 0;
        List fpas = region_FPR.getFixedPartitionAttributesImpl();
        for (FixedPartitionAttributesImpl fpa : fpas) {
            if (fpa.isPrimary()) {
                startingBucketId = fpa.getStartingBucketID();
                break;
            }
            startingBucketId = 0;
        }
        final int bucketId = startingBucketId;
        try {
            PartitionManager.createPrimaryBucket((Region)region_FPR, (int)startingBucketId, (boolean)destroyExistingRemote, (boolean)destroyExistingLocal);
            FixedPartitioningTestBase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return region_FPR.getBucketPrimary(bucketId) != null;
                }

                @Override
                public String description() {
                    return null;
                }
            }, 10000L, 100L, false);
        }
        catch (Exception e) {
            FixedPartitioningTestBase.fail("Caught exception while creating primary bucket using PartitionManager for FPR", e);
        }
    }

    public static void createPrimaryBucketsBelongingToOtherPartition(String regionName, Boolean destroyExistingRemote, Boolean destroyExistingLocal) {
        block3: {
            region_FPR = (PartitionedRegion)cache.getRegion(regionName);
            FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
            int bucketId = 13;
            List fpas = region_FPR.getRegionAdvisor().adviseRemotePrimaryFPAs();
            for (FixedPartitionAttributesImpl fpa : fpas) {
                if (!fpa.isPrimary()) continue;
                bucketId = fpa.getStartingBucketID();
            }
            try {
                PartitionManager.createPrimaryBucket((Region)region_FPR, (int)bucketId, (boolean)destroyExistingRemote, (boolean)destroyExistingLocal);
                FixedPartitioningTestBase.fail((String)"PartitionManager created primary bucket not belonging to the node.");
            }
            catch (Exception expected) {
                if (expected instanceof IllegalArgumentException && expected.getMessage().contains("not part of any primary partition on this node for the FixedPartitionRegion")) break block3;
                FixedPartitioningTestBase.fail("Expected IllegalArgumentException ", expected);
            }
        }
    }

    public static void createOutOfRangePrimaryBucketUsingPartitionManager(String regionName, Integer bucketId, Boolean destroyExistingRemote, Boolean destroyExistingLocal) {
        block2: {
            region_FPR = (PartitionedRegion)cache.getRegion(regionName);
            FixedPartitioningTestBase.assertNotNull((Object)region_FPR);
            try {
                PartitionManager.createPrimaryBucket((Region)region_FPR, (int)bucketId, (boolean)destroyExistingRemote, (boolean)destroyExistingLocal);
                FixedPartitioningTestBase.fail((String)"PartitionManager created out of range primary bucket .");
            }
            catch (Exception expected) {
                if (expected instanceof IllegalArgumentException && expected.getMessage().contains("must be in the range")) break block2;
                FixedPartitioningTestBase.fail("Expected IllegalArgumentException ", expected);
            }
        }
    }

    public static void setPRObserverBeforeCalculateStartingBucketId() {
        PartitionedRegion.BEFORE_CALCULATE_STARTING_BUCKET_FLAG = true;
        origObserver = PartitionedRegionObserverHolder.setInstance((PartitionedRegionObserver)new PartitionedRegionObserverAdapter(){

            public void beforeCalculatingStartingBucketId() {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot((Cache)cache);
                        PartitionRegionConfig regionConfig = (PartitionRegionConfig)prRoot.get((Object)"#Quarter");
                        if (regionConfig == null) {
                            return false;
                        }
                        return !regionConfig.isFirstDataStoreCreated();
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 20000L, 500L, false);
                DistributedTestCase.getLogWriter().info("end of beforeCalculatingStartingBucketId");
            }
        });
    }

    public static void resetPRObserverBeforeCalculateStartingBucketId() throws Exception {
        PartitionedRegion.BEFORE_CALCULATE_STARTING_BUCKET_FLAG = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            FixedPartitioningTestBase.closeCache();
            member1.invoke(FixedPartitioningTestBase.class, "closeCache");
            member2.invoke(FixedPartitioningTestBase.class, "closeCache");
            member3.invoke(FixedPartitioningTestBase.class, "closeCache");
            member4.invoke(FixedPartitioningTestBase.class, "closeCache");
        }
        finally {
            FixedPartitioningTestBase.remoteTearDown();
            for (int h = 0; h < Host.getHostCount(); ++h) {
                Host host = Host.getHost(h);
                for (int v = 0; v < host.getVMCount(); ++v) {
                    VM vm = host.getVM(v);
                    vm.invoke(FixedPartitioningTestBase.class, "remoteTearDown");
                }
            }
            super.tearDown2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void remoteTearDown() {
        try {
            if (cache != null && !cache.isClosed()) {
                for (Region root : cache.rootRegions()) {
                    if (root.isDestroyed() || root instanceof HARegion || root instanceof PartitionedRegion) continue;
                    try {
                        root.localDestroyRegion((Object)"teardown");
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure((Error)e);
                        throw e;
                    }
                    catch (Throwable t) {
                        FixedPartitioningTestBase.getLogWriter().error(t);
                    }
                }
            }
        }
        finally {
            try {
                FixedPartitioningTestBase.closeCache();
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                FixedPartitioningTestBase.getLogWriter().error("Error in closing the cache ", t);
            }
        }
        try {
            FixedPartitioningTestBase.cleanDiskDirs();
        }
        catch (IOException e) {
            FixedPartitioningTestBase.getLogWriter().error("Error cleaning disk dirs", (Throwable)e);
        }
    }

    public static void cleanDiskDirs() throws IOException {
        FileUtil.delete((File)FixedPartitioningTestBase.getDiskDir());
    }

    public static void closeCache() {
        System.clearProperty("gemfire.DISABLE_MOVE_PRIMARIES_ON_STARTUP");
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static enum Q4_Months {
        OCT,
        NOV,
        DEC;

    }

    public static enum Q3_Months {
        JUL,
        AUG,
        SEP;

    }

    public static enum Q2_Months {
        APR,
        MAY,
        JUN;

    }

    public static enum Q1_Months {
        JAN,
        FEB,
        MAR;

    }

    public static enum Months_DataStore {
        JAN,
        FEB,
        MAR,
        APR,
        MAY,
        JUN,
        JUL,
        AUG,
        SEP,
        OCT,
        NOV,
        DEC;

    }

    public static enum Months_Accessor {
        JAN,
        FEB,
        MAR,
        APR,
        MAY,
        JUN,
        JUL,
        AUG,
        SEP;

    }
}

