/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.fixed;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.CustomerFixedPartitionResolver;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.FixedPartitioningTestBase;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.QuarterPartitionResolver;
import dunit.AsyncInvocation;
import dunit.Host;
import java.util.ArrayList;

public class FixedPartitioningWithColocationAndPersistenceDUnitTest
extends FixedPartitioningTestBase {
    private static final long serialVersionUID = 1L;

    public FixedPartitioningWithColocationAndPersistenceDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        member1 = host.getVM(0);
        member2 = host.getVM(1);
        member3 = host.getVM(2);
        member4 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testColocation_WithFPROnChildRegion() {
        block2: {
            try {
                member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Customer100", (boolean)true, (int)2);
                ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
                fpaList.add(fpa1);
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 0, 40, 8, null, null, false});
                fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Order100", (boolean)true, (int)2);
                fpaList = new ArrayList();
                fpaList.add(fpa1);
                member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", fpaList, 0, 40, 8, null, "Customer", false});
                FixedPartitioningWithColocationAndPersistenceDUnitTest.fail((String)"IllegalStateException expected");
            }
            catch (Exception illegal) {
                if (illegal.getCause() instanceof IllegalStateException && illegal.getCause().getMessage().contains("not be specified in PartitionAttributesFactory if colocated-with is specified")) break block2;
                FixedPartitioningWithColocationAndPersistenceDUnitTest.fail("Expected IllegalStateException ", illegal);
            }
        }
    }

    public void testColocation_FPRs_ChildUsingAttributesOfParent() {
        try {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)true, (int)5);
            FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member4.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "putOrderPartitionedRegion", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "putCustomerPartitionedRegion", new Object[]{"Customer"});
            member1.invoke(FixedPartitioningTestBase.class, "putShipmentPartitionedRegion", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
        }
        catch (Exception e) {
            FixedPartitioningWithColocationAndPersistenceDUnitTest.fail("Unexpected Exception ", e);
        }
    }

    public void testColocation_FPR_Persistence_ChildUsingAttributesOfParent() {
        try {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)true, (int)5);
            FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member4.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "putOrderPartitionedRegion", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "putCustomerPartitionedRegion", new Object[]{"Customer"});
            member1.invoke(FixedPartitioningTestBase.class, "putShipmentPartitionedRegion", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
        }
        catch (Exception e) {
            FixedPartitioningWithColocationAndPersistenceDUnitTest.fail("Unexpected Exception ", e);
        }
    }

    public void testColocation_FPRs_ChildUsingAttributesOfParent_HA() {
        try {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)true, (int)5);
            FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)true, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            FixedPartitionAttributes fpa4 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            fpaList.add(fpa4);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "putCustomerPartitionedRegion", new Object[]{"Customer"});
            member1.invoke(FixedPartitioningTestBase.class, "putOrderPartitionedRegion", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "putShipmentPartitionedRegion", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{20, 10, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "closeCache");
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocationAfterCacheClosed", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocationAfterCacheClosed", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
        }
        catch (Exception e) {
            FixedPartitioningWithColocationAndPersistenceDUnitTest.fail("Unexpected Exception ", e);
        }
    }

    public void testColocation_FPR_Persistence_ChildUsingAttributesOfParent_HA() {
        try {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)true, (int)5);
            FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)true, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            FixedPartitionAttributes fpa4 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            fpaList.add(fpa4);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member3.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "putCustomerPartitionedRegion", new Object[]{"Customer"});
            member1.invoke(FixedPartitioningTestBase.class, "putOrderPartitionedRegion", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "putShipmentPartitionedRegion", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{20, 10, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "closeCache");
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocationAfterCacheClosed", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocationAfterCacheClosed", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"30", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"40", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpa3 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            fpaList.add(fpa3);
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 2, 50, 20, new CustomerFixedPartitionResolver(), null, false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 2, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
            member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{15, 5, "Customer", "Order", "Shipment"});
        }
        catch (Exception e) {
            FixedPartitioningWithColocationAndPersistenceDUnitTest.fail("Unexpected Exception ", e);
        }
    }

    public void testPartitionManagerWithFPR_NoBucketsCreatedYet() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 6, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 6, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "createPrimaryBucketsBelongingToThisPartition", new Object[]{"Quarter", Boolean.FALSE, Boolean.FALSE});
        member1.invoke(FixedPartitioningTestBase.class, "createPrimaryBucketsBelongingToOtherPartition", new Object[]{"Quarter", Boolean.FALSE, Boolean.FALSE});
        int outOfRangeBucketId = 13;
        member1.invoke(FixedPartitioningTestBase.class, "createOutOfRangePrimaryBucketUsingPartitionManager", new Object[]{"Quarter", 13, Boolean.FALSE, Boolean.FALSE});
    }

    public void testPartitionManagerWithFPR_BucketsAlreadyCreated() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, false});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "createPrimaryBucketsBelongingToThisPartition", new Object[]{"Quarter", Boolean.FALSE, Boolean.TRUE});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
    }

    public void testFPR_Persistence_OneMemberAlive() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "putForQuarter", new Object[]{"Quarter", "Q1"});
        member1.invoke(FixedPartitioningTestBase.class, "putForQuarter", new Object[]{"Quarter", "Q2"});
        member2.invoke(FixedPartitioningTestBase.class, "closeCache");
        FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(1000);
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "getForQuarter", new Object[]{"Quarter", "Q2"});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter2});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryData", new Object[]{Quarter4});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{3, 3});
    }

    public void testFPR_Persistence() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "putForQuarter", new Object[]{"Quarter", "Q1"});
        member1.invoke(FixedPartitioningTestBase.class, "putForQuarter", new Object[]{"Quarter", "Q2"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryDataPersistence", new Object[]{Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryDataPersistence", new Object[]{Quarter2});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member1.invoke(FixedPartitioningTestBase.class, "closeCache");
        member2.invoke(FixedPartitioningTestBase.class, "closeCache");
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
        member2.invoke(FixedPartitioningTestBase.class, "getForQuarter", new Object[]{"Quarter", Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "getForQuarter", new Object[]{"Quarter", Quarter2});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryDataPersistence", new Object[]{Quarter2});
        FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(2000);
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryDataPersistence", new Object[]{Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryDataPersistence", new Object[]{Quarter2});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member1.invoke(FixedPartitioningTestBase.class, "getForQuarter", new Object[]{"Quarter", Quarter1});
        member2.invoke(FixedPartitioningTestBase.class, "getForQuarter", new Object[]{"Quarter", Quarter2});
    }

    public void testColocation_FPR_Persistence_Colocation_OneMemberAlive() {
        try {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)true, (int)5);
            FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 1, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 1, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "putCustomerPartitionedRegion_Persistence1", new Object[]{"Customer"});
            member1.invoke(FixedPartitioningTestBase.class, "putOrderPartitionedRegion_Persistence1", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "putShipmentPartitionedRegion_Persistence1", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{10, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{10, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "closeCache");
            member1.invoke(FixedPartitioningTestBase.class, "putCustomerPartitionedRegion_Persistence2", new Object[]{"Customer"});
            member1.invoke(FixedPartitioningTestBase.class, "putOrderPartitionedRegion_Persistence2", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "putShipmentPartitionedRegion_Persistence2", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{10, 10, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            AsyncInvocation[] async = new AsyncInvocation[2];
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 1, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{10, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{10, 5, "Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
        }
        catch (Exception e) {
            FixedPartitioningWithColocationAndPersistenceDUnitTest.fail("Unexpected Exception ", e);
        }
    }

    public void testColocation_FPR_Persistence_Colocation() {
        try {
            member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)true, (int)5);
            FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)false, (int)5);
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 1, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 1, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Order", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Customer", false});
            member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Shipment", null, 1, 50, 20, new CustomerFixedPartitionResolver(), "Order", false});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Order"});
            member2.invoke(FixedPartitioningTestBase.class, "checkFPR", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "putCustomerPartitionedRegion_Persistence", new Object[]{"Customer"});
            member1.invoke(FixedPartitioningTestBase.class, "putOrderPartitionedRegion_Persistence", new Object[]{"Order"});
            member1.invoke(FixedPartitioningTestBase.class, "putShipmentPartitionedRegion_Persistence", new Object[]{"Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "validateAfterPutPartitionedRegion", new Object[]{"Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{10, 5, "Customer", "Order", "Shipment"});
            member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForColocation", new Object[]{10, 5, "Customer", "Order", "Shipment"});
            member1.invoke(FixedPartitioningTestBase.class, "closeCache");
            member2.invoke(FixedPartitioningTestBase.class, "closeCache");
            member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
            fpa1 = FixedPartitionAttributes.createFixedPartition((String)"20", (boolean)true, (int)5);
            fpa2 = FixedPartitionAttributes.createFixedPartition((String)"10", (boolean)false, (int)5);
            fpaList = new ArrayList();
            fpaList.add(fpa1);
            fpaList.add(fpa2);
            member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Customer", fpaList, 1, 50, 20, new CustomerFixedPartitionResolver(), null, true});
            FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
            member2.invoke(FixedPartitioningTestBase.class, "getForColocation", new Object[]{"Customer", "Order", "Shipment"});
        }
        catch (Exception e) {
            FixedPartitioningWithColocationAndPersistenceDUnitTest.fail("Unexpected Exception ", e);
        }
    }

    public void testFPR_Persistence2() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
        member1.invoke(FixedPartitioningTestBase.class, "closeCache");
        member2.invoke(FixedPartitioningTestBase.class, "closeCache");
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 0, 40, 12, new QuarterPartitionResolver(), null, true});
        FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 6});
    }

    public void testFPR_Persistence3() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member3.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member4.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter2, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter4, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member1.invoke(FixedPartitioningTestBase.class, "closeCache");
        member2.invoke(FixedPartitioningTestBase.class, "closeCache");
        member3.invoke(FixedPartitioningTestBase.class, "closeCache");
        member4.invoke(FixedPartitioningTestBase.class, "closeCache");
        member4.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member4.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member3.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter4, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member3.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter3, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member2.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        fpa1 = FixedPartitionAttributes.createFixedPartition((String)Quarter1, (boolean)true, (int)3);
        fpa2 = FixedPartitionAttributes.createFixedPartition((String)Quarter2, (boolean)false, (int)3);
        fpaList = new ArrayList();
        fpaList.add(fpa1);
        fpaList.add(fpa2);
        member1.invokeAsync(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", fpaList, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(4000);
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter4, false});
        member4.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter3, false});
        member3.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter2, false});
        member2.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimarySecondaryData", new Object[]{Quarter1, false});
        member1.invoke(FixedPartitioningTestBase.class, "checkPrimaryBucketsForQuarter", new Object[]{6, 3});
    }

    public void testPR_Persistence() {
        member1.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member1.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member1.invoke(FixedPartitioningTestBase.class, "putThroughDataStore", new Object[]{"Quarter"});
        member1.invoke(FixedPartitioningTestBase.class, "closeCache");
        member2.invoke(FixedPartitioningTestBase.class, "closeCache");
        FixedPartitioningWithColocationAndPersistenceDUnitTest.pause(1000);
        member2.invoke(FixedPartitioningTestBase.class, "createCacheOnMember");
        member2.invoke(FixedPartitioningTestBase.class, "createRegionWithPartitionAttributes", new Object[]{"Quarter", null, 1, 40, 12, new QuarterPartitionResolver(), null, true});
        member2.invoke(FixedPartitioningTestBase.class, "getThroughDataStore", new Object[]{"Quarter"});
    }
}

