/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public abstract class PersistentReplicatedTestBase
extends CacheTestCase {
    protected static final int MAX_WAIT = 60000;
    protected static String REGION_NAME = "region";
    protected File diskDir;
    protected static String SAVED_ACK_WAIT_THRESHOLD;

    public PersistentReplicatedTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        PersistentReplicatedTestBase.invokeInEveryVM(PersistentReplicatedTestBase.class, "setRegionName", new Object[]{this.getUniqueName()});
        PersistentReplicatedTestBase.setRegionName(this.getUniqueName());
        this.diskDir = new File("diskDir-" + this.getName()).getAbsoluteFile();
        FileUtil.delete((File)this.diskDir);
        this.diskDir.mkdir();
        this.diskDir.deleteOnExit();
    }

    public static void setRegionName(String testName) {
        REGION_NAME = testName + "Region";
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        FileUtil.delete((File)this.diskDir);
    }

    protected void waitForBlockedInitialization(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting for another persistent member to come online";
                    }

                    @Override
                    public boolean done() {
                        GemFireCacheImpl cache = (GemFireCacheImpl)PersistentReplicatedTestBase.this.getCache();
                        PersistentMemberManager mm = cache.getPersistentMemberManager();
                        Map regions = mm.getWaitingRegions();
                        boolean done = !regions.isEmpty();
                        return done;
                    }
                }, 60000L, 100L, true);
            }
        });
    }

    protected SerializableRunnable createPersistentRegionWithoutCompaction(final VM vm0) {
        SerializableRunnable createRegion = new SerializableRunnable("Create persistent region"){

            @Override
            public void run() {
                Cache cache = PersistentReplicatedTestBase.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File dir = PersistentReplicatedTestBase.this.getDiskDirForVM(vm0);
                dir.mkdirs();
                dsf.setDiskDirs(new File[]{dir});
                dsf.setMaxOplogSize(1L);
                dsf.setAutoCompact(false);
                dsf.setAllowForceCompaction(true);
                dsf.setCompactionThreshold(20);
                DiskStore ds = dsf.create(REGION_NAME);
                RegionFactory rf = new RegionFactory();
                rf.setDiskStoreName(ds.getName());
                rf.setDiskSynchronous(true);
                rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(REGION_NAME);
            }
        };
        vm0.invoke(createRegion);
        return createRegion;
    }

    protected void closeRegion(VM vm) {
        SerializableRunnable closeRegion = new SerializableRunnable("Close persistent region"){

            @Override
            public void run() {
                Cache cache = PersistentReplicatedTestBase.this.getCache();
                Region region = cache.getRegion(REGION_NAME);
                region.close();
            }
        };
        vm.invoke(closeRegion);
    }

    protected void closeCache(VM vm) {
        SerializableRunnable closeCache = new SerializableRunnable("close cache"){

            @Override
            public void run() {
                Cache cache = PersistentReplicatedTestBase.this.getCache();
                cache.close();
            }
        };
        vm.invoke(closeCache);
    }

    protected AsyncInvocation closeCacheAsync(VM vm0) {
        SerializableRunnable close = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentReplicatedTestBase.this.getCache();
                cache.close();
            }
        };
        return vm0.invokeAsync(close);
    }

    protected void createNonPersistentRegion(VM vm) throws Throwable {
        SerializableRunnable createRegion = new SerializableRunnable("Create non persistent region"){

            @Override
            public void run() {
                Cache cache = PersistentReplicatedTestBase.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(REGION_NAME);
            }
        };
        vm.invoke(createRegion);
    }

    protected AsyncInvocation createPersistentRegionWithWait(VM vm) throws Throwable {
        return this._createPersistentRegion(vm, true);
    }

    protected void createPersistentRegion(VM vm) throws Throwable {
        this._createPersistentRegion(vm, false);
    }

    private AsyncInvocation _createPersistentRegion(VM vm, boolean wait) throws Throwable {
        AsyncInvocation future = this.createPersistentRegionAsync(vm);
        long waitTime = wait ? 500L : 60000L;
        future.join(waitTime);
        if (future.isAlive() && !wait) {
            PersistentReplicatedTestBase.fail((String)"Region not created within60000");
        }
        if (!future.isAlive() && wait) {
            PersistentReplicatedTestBase.fail((String)"Did not expecte region creation to complete");
        }
        if (!wait && future.exceptionOccurred()) {
            throw new RuntimeException(future.getException());
        }
        return future;
    }

    protected AsyncInvocation createPersistentRegionAsync(final VM vm) {
        SerializableRunnable createRegion = new SerializableRunnable("Create persistent region"){

            @Override
            public void run() {
                Cache cache = PersistentReplicatedTestBase.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File dir = PersistentReplicatedTestBase.this.getDiskDirForVM(vm);
                dir.mkdirs();
                dsf.setDiskDirs(new File[]{dir});
                dsf.setMaxOplogSize(1L);
                DiskStore ds = dsf.create(REGION_NAME);
                RegionFactory rf = new RegionFactory();
                rf.setDiskStoreName(ds.getName());
                rf.setDiskSynchronous(true);
                rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(REGION_NAME);
            }
        };
        return vm.invokeAsync(createRegion);
    }

    protected File getDiskDirForVM(VM vm) {
        File dir = new File(this.diskDir, String.valueOf(vm.getPid()));
        return dir;
    }

    protected void backupDir(VM vm) throws IOException {
        File dirForVM = this.getDiskDirForVM(vm);
        File backFile = new File(dirForVM.getParent(), dirForVM.getName() + ".bk");
        FileUtil.copy((File)dirForVM, (File)backFile);
    }

    protected void restoreBackup(VM vm) throws IOException {
        File dirForVM = this.getDiskDirForVM(vm);
        File backFile = new File(dirForVM.getParent(), dirForVM.getName() + ".bk");
        if (!backFile.renameTo(dirForVM)) {
            FileUtil.delete((File)dirForVM);
            FileUtil.copy((File)backFile, (File)dirForVM);
            FileUtil.delete((File)backFile);
        }
    }
}

