/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentGatewayDUnitTest;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class ShutdownAllPersistentGatewayDUnitTest
extends PersistentGatewayDUnitTest {
    private static final long MAX_WAIT = 70000L;
    private static final int NUM_KEYS = 1000;
    final String expectedExceptions = CacheClosedException.class.getName();

    public ShutdownAllPersistentGatewayDUnitTest(String name) {
        super(name);
    }

    @Override
    public void testWaitForLatestMemberGateway() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int destinationPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm2);
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentGateway(vm0, destinationPort);
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentGateway(vm1, destinationPort);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ShutdownAllPersistentGatewayDUnitTest.this.getCache();
                Region region = cache.getRegion("REGION_NAME");
                for (int i = 0; i < 3; ++i) {
                    region.put((Object)i, (Object)("a" + i));
                }
            }
        });
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("closing region in vm0");
        this.closeCache(vm0);
        Thread.sleep(5000L);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ShutdownAllPersistentGatewayDUnitTest.this.getCache();
                Region region = cache.getRegion("REGION_NAME");
                for (int i = 3; i < 5; ++i) {
                    region.put((Object)i, (Object)("a" + i));
                }
            }
        });
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("closing region in vm1");
        this.closeCache(vm1);
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation future = this.createPersistentGatewayAsync(vm0, destinationPort);
        this.waitForBlockedInitialization(vm0);
        ShutdownAllPersistentGatewayDUnitTest.assertTrue((boolean)future.isAlive());
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("shutdown all vm0");
        this.shutDownAllMembers(vm0, 1, 70000L);
        future.join(70000L);
        if (future.isAlive()) {
            ShutdownAllPersistentGatewayDUnitTest.fail((String)"gatewayhub hang after 70000");
        }
    }

    private AsyncInvocation createPRAtOtherSideAsync(VM vm, String locatorString, boolean isServerLocator) {
        SerializableRunnable the_runnable = this.createPRAtOtherSide(locatorString, isServerLocator);
        return vm.invokeAsync(the_runnable);
    }

    private void createPRAtOtherSideSync(VM vm, String locatorString, boolean isServerLocator) {
        SerializableRunnable the_runnable = this.createPRAtOtherSide(locatorString, isServerLocator);
        vm.invoke(the_runnable);
    }

    private SerializableRunnable createPRAtOtherSide(final String locatorString, final boolean isServerLocator) {
        SerializableRunnable createPRAtOtherSide = new SerializableRunnable("Create gateway region with " + locatorString){

            @Override
            public void run() {
                final Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                if (isServerLocator) {
                    props.put("start-locator", locatorString);
                    props.put("locators", "");
                } else {
                    props.put("locators", locatorString);
                }
                CacheTestCase.disconnectFromDS();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "wait for the peer-locator to start";
                    }

                    @Override
                    public boolean done() {
                        try {
                            InternalDistributedSystem ds = ShutdownAllPersistentGatewayDUnitTest.this.getSystem(props);
                            return ds != null;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                }, 10000L, 100L, true);
                Cache cache = ShutdownAllPersistentGatewayDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                dsf.setDiskDirs(CacheTestCase.getDiskDirs());
                dsf.setMaxOplogSize(1L);
                DiskStore store = dsf.create("REGION_NAME");
                RegionFactory rf = new RegionFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                rf.setPartitionAttributes(paf.create());
                rf.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                rf.setEnableGateway(true);
                rf.setDiskStoreName(store.getName());
                Region region = rf.create("REGION_NAME");
                TestCase.assertTrue((!InternalLocator.isDedicatedLocator() ? 1 : 0) != 0);
            }
        };
        return createPRAtOtherSide;
    }

    public void testShutdownAllGatewayHubs() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        final int destinationPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm2);
        int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("mcastPort is " + mcastPort + ", destinationPort is " + destinationPort);
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentGateway(vm0, destinationPort);
        String locatorString1 = ShutdownAllPersistentGatewayDUnitTest.getServerHostName(host) + "[" + locatorPort + "]";
        String locatorString2 = ShutdownAllPersistentGatewayDUnitTest.getServerHostName(host) + "[" + locatorPort + "],peer=true,server=false";
        vm1.invoke(this.addExceptionTag1(this.expectedExceptions));
        vm2.invoke(this.addExceptionTag1(this.expectedExceptions));
        SerializableRunnable createGateWayHubAtOtherSide = new SerializableRunnable("Create gateway region"){

            @Override
            public void run() {
                GatewayHub hub = ShutdownAllPersistentGatewayDUnitTest.this.getCache().addGatewayHub("g1", destinationPort);
                Gateway gateway = hub.addGateway("h1");
                gateway.setQueueAttributes(new GatewayQueueAttributes(null, 5, 1, 100, false, false, 60000));
                try {
                    hub.start();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.createPRAtOtherSideSync(vm2, locatorString2, true);
        this.createPRAtOtherSideSync(vm1, locatorString1, false);
        vm1.invoke(createGateWayHubAtOtherSide);
        AsyncInvocation vm0_future = vm0.invokeAsync(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ShutdownAllPersistentGatewayDUnitTest.this.getRootRegion("REGION_NAME");
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)i, (Object)("a" + i));
                }
            }
        });
        ShutdownAllPersistentGatewayDUnitTest.pause(2000);
        this.shutDownAllMembers(vm2, 2, 70000L);
        ShutdownAllPersistentGatewayDUnitTest.getLogWriter().info("restart in VM1");
        AsyncInvocation vm2_future = this.createPRAtOtherSideAsync(vm2, locatorString2, true);
        this.createPRAtOtherSideSync(vm1, locatorString1, false);
        vm2_future.join(70000L);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ShutdownAllPersistentGatewayDUnitTest.this.getCache();
                Region region = cache.getRegion("REGION_NAME");
                cache.getLogger().info("vm1's region size before restart gatewayhub is " + region.size());
            }
        });
        vm1.invoke(createGateWayHubAtOtherSide);
        vm0_future.join(70000L);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ShutdownAllPersistentGatewayDUnitTest.this.getRootRegion("REGION_NAME");
                TestCase.assertEquals((int)1000, (int)region.size());
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ShutdownAllPersistentGatewayDUnitTest.this.getCache();
                final Region region = cache.getRegion("REGION_NAME");
                cache.getLogger().info("vm1's region size after restart gatewayhub is " + region.size());
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        Object lastvalue = region.get((Object)999);
                        if (lastvalue != null && lastvalue.equals("a999")) {
                            region.getCache().getLogger().info("Last key has arrived, its value is " + lastvalue + ", end of wait.");
                            return true;
                        }
                        return region.size() == 1000;
                    }

                    @Override
                    public String description() {
                        return "Waiting for destination region to reach size: 1000, current is " + region.size();
                    }
                }, 70000L, 100L, true);
                TestCase.assertEquals((int)1000, (int)region.size());
                for (int i = 0; i < 5; ++i) {
                    TestCase.assertEquals((Object)("a" + (999 - i)), (Object)region.get((Object)(999 - i)));
                }
            }
        });
        vm1.invoke(this.removeExceptionTag1(this.expectedExceptions));
        vm2.invoke(this.removeExceptionTag1(this.expectedExceptions));
        ShutdownAllPersistentGatewayDUnitTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
        this.deleteStateFile(locatorPort);
    }

    private void deleteStateFile(int port) {
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
    }

    private void waitForBlockedInitialization(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Waiting to blocked waiting for anothe persistent member to come online";
                    }

                    @Override
                    public boolean done() {
                        GemFireCacheImpl cache = (GemFireCacheImpl)ShutdownAllPersistentGatewayDUnitTest.this.getCache();
                        PersistentMemberManager mm = cache.getPersistentMemberManager();
                        Map regions = mm.getWaitingRegions();
                        boolean done = !regions.isEmpty();
                        return done;
                    }
                }, 70000L, 100L, true);
            }
        });
    }

    private void shutDownAllMembers(VM vm, final int expnum, final long timeout) {
        vm.invoke(new SerializableRunnable("Shutdown all the members"){

            @Override
            public void run() {
                AdminDistributedSystemImpl adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)ShutdownAllPersistentGatewayDUnitTest.this.getSystem(), (String)"");
                    adminDS = (AdminDistributedSystemImpl)AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    Set members = adminDS.shutDownAllMembers(timeout);
                    int num = members == null ? 0 : members.size();
                    TestCase.assertEquals((int)expnum, (int)num);
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }
}

