/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.sockets.DeltaEOFException;
import com.gemstone.gemfire.internal.cache.tier.sockets.FaultyDelta;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class Bug40396DUnitTest
extends DistributedTestCase {
    private static Cache cache;
    private static final String REGION_NAME = "Bug40396DUnitTest_region";
    private static final String END_OF_FILE_EX = "eofe";
    private static final String ARRAY_INDEX_OUT_BOUND_EX = "aiob";
    private static int counter;
    private VM server;
    private VM server2;
    private static final int PUT_COUNT = 10;

    public Bug40396DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Bug40396DUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.server = host.getVM(0);
        this.server2 = host.getVM(2);
    }

    public static Integer createServerCache() throws Exception {
        new Bug40396DUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.getAttributesMutator().setCloningEnabled(false);
        CacheServer server = cache.addCacheServer();
        Bug40396DUnitTest.addExceptions();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void addExceptions() throws Exception {
        if (cache != null && !cache.isClosed()) {
            cache.getLogger().info("<ExpectedException action=add>java.io.EOFException</ExpectedException>");
            cache.getLogger().info("<ExpectedException action=add>java.lang.ArrayIndexOutOfBoundsException</ExpectedException>");
        }
    }

    public static void removeExceptions() {
        if (cache != null && !cache.isClosed()) {
            cache.getLogger().info("<ExpectedException action=remove>java.io.EOFException</ExpectedException>");
            cache.getLogger().info("<ExpectedException action=remove>java.lang.ArrayIndexOutOfBoundsException</ExpectedException>");
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug40396DUnitTest.assertNotNull((Object)cache);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static Exception putDelta(String regName, String type) {
        Region reg = cache.getRegion("/" + regName);
        try {
            if (type.equals(END_OF_FILE_EX)) {
                DeltaEOFException obj = new DeltaEOFException();
                for (int i = 0; i < 10; ++i) {
                    obj.setIntVal(i);
                    obj.setBigObj(new byte[]{(byte)(i + 3), (byte)(i + 3)});
                    reg.put((Object)"key", (Object)obj);
                }
            } else if (type.equals(ARRAY_INDEX_OUT_BOUND_EX)) {
                FaultyDelta obj = new FaultyDelta();
                for (int i = 0; i < 10; ++i) {
                    obj.setIntVal(i);
                    obj.setBigObj(new byte[]{(byte)(i + 3), (byte)(i + 3)});
                    reg.put((Object)"key", (Object)obj);
                }
            }
        }
        catch (Exception ex) {
            return ex;
        }
        return new Exception();
    }

    public void testForFaultyDeltaImplementationForEOFEX() {
        boolean matched = false;
        ((Integer)this.server.invoke(Bug40396DUnitTest.class, "createServerCache")).intValue();
        ((Integer)this.server2.invoke(Bug40396DUnitTest.class, "createServerCache")).intValue();
        Exception xp = (Exception)this.server.invoke(Bug40396DUnitTest.class, "putDelta", new Object[]{REGION_NAME, END_OF_FILE_EX});
        StackTraceElement[] st = xp.getCause().getStackTrace();
        matched = this.getMatched(st);
        Bug40396DUnitTest.assertTrue((String)"pattern not found", (boolean)matched);
    }

    private boolean getMatched(StackTraceElement[] ste) {
        boolean mched = false;
        for (int i = 0; i < ste.length && !mched; ++i) {
            if (ste[i].toString().indexOf("fromDelta") == -1) continue;
            mched = true;
        }
        return mched;
    }

    public void testForFaultyDeltaImplementationForAIOBEX() {
        boolean matched = false;
        ((Integer)this.server.invoke(Bug40396DUnitTest.class, "createServerCache")).intValue();
        ((Integer)this.server2.invoke(Bug40396DUnitTest.class, "createServerCache")).intValue();
        Exception xp = (Exception)this.server.invoke(Bug40396DUnitTest.class, "putDelta", new Object[]{REGION_NAME, ARRAY_INDEX_OUT_BOUND_EX});
        StackTraceElement[] st = xp.getStackTrace();
        matched = this.getMatched(st);
        Bug40396DUnitTest.assertTrue((String)"pattern not found", (boolean)matched);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.server.invoke(Bug40396DUnitTest.class, "removeExceptions");
        this.server.invoke(Bug40396DUnitTest.class, "closeCache");
        this.server2.invoke(Bug40396DUnitTest.class, "closeCache");
        cache = null;
        Bug40396DUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }
}

