/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.ConnectionProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CommandInitializer;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BackwardCompatibilityHandshakeDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server1 = null;
    private static VM client1 = null;
    private static VM client2 = null;
    private static final String REGION_NAME = "BackwardCompatibilityHandshakeDUnitTest_Region";
    static int CLIENT_ACK_INTERVAL = 5000;
    private static short clientVersionForTesting = Version.TEST_VERSION.ordinal();
    private static short currentClientVersion = ConnectionProxy.VERSION.ordinal();

    public BackwardCompatibilityHandshakeDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        client1 = host.getVM(1);
        client2 = host.getVM(2);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        BackwardCompatibilityHandshakeDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        BackwardCompatibilityHandshakeDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        new BackwardCompatibilityHandshakeDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new BackwardCompatibilityHandshakeDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(true).setThreadLocalConnections(true).setMinConnections(1).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(1).setSubscriptionAckInterval(CLIENT_ACK_INTERVAL).create("BackwardCompatibilityHandshakeDUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.registerInterest((Object)"ALL_KEYS");
    }

    public static Integer createServerCache(String serverHostName) throws Exception {
        new BackwardCompatibilityHandshakeDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setBindAddress(serverHostName);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client2.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "unsetHandshakeVersionForTesting");
        client2.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "unsetTestVersionAfterHandshake");
        client1.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "closeCache");
        client2.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "closeCache");
        server1.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testHandShake() {
        server1.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "setTestCommands");
        String serverHostName = BackwardCompatibilityHandshakeDUnitTest.getServerHostName(server1.getHost());
        Integer port1 = (Integer)server1.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "createServerCache", new Object[]{serverHostName});
        client1.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "createClientCache", new Object[]{serverHostName, port1});
        client2.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "setHandshakeVersionForTesting");
        client2.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "setTestVersionAfterHandshake");
        client2.invoke(BackwardCompatibilityHandshakeDUnitTest.class, "createClientCache", new Object[]{serverHostName, port1});
    }

    public static void setTestCommands() throws Exception {
        BackwardCompatibilityHandshakeDUnitTest.getLogWriter().info("setTestCommands invoked");
        HashMap testCommands = new HashMap();
        testCommands.putAll((Map)CommandInitializer.ALL_COMMANDS.get(Version.GFE_57));
        CommandInitializer.testSetCommands(testCommands);
        BackwardCompatibilityHandshakeDUnitTest.getLogWriter().info("end of setTestCommands");
    }

    public static void setHandshakeVersionForTesting() throws Exception {
        HandShake.setVersionForTesting((short)clientVersionForTesting);
    }

    public static void setTestVersionAfterHandshake() throws Exception {
        ServerConnection.TEST_VERSION_AFTER_HANDSHAKE_FLAG = true;
        ServerConnection.testVersionAfterHandshake = clientVersionForTesting;
    }

    public static void unsetHandshakeVersionForTesting() throws Exception {
        HandShake.setVersionForTesting((short)currentClientVersion);
    }

    public static void unsetTestVersionAfterHandshake() throws Exception {
        ServerConnection.TEST_VERSION_AFTER_HANDSHAKE_FLAG = false;
        ServerConnection.testVersionAfterHandshake = currentClientVersion;
    }
}

