/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.NoAvailableServersException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class BridgeWriterMiscDUnitTest
extends CacheTestCase {
    protected static PoolImpl pool = null;
    protected static Connection conn = null;
    private static Cache static_cache;
    private static int PORT1;
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String server_k1 = "server-k1";
    private static final String server_k2 = "server-k2";
    private static final String REGION_NAME1 = "BridgeWriterMiscDUnitTest_region1";
    private static final String REGION_NAME2 = "BridgeWriterMiscDUnitTest_region2";
    private static final String PR_REGION_NAME = "BridgeWriterMiscDUnitTest_PRregion";
    private static Host host;
    private static VM server1;
    private static VM server2;
    private static RegionAttributes attrs;
    Properties props = new Properties();
    final int putRange_1Start = 1;
    final int putRange_1End = 5;
    final int putRange_2Start = 6;
    final int putRange_2End = 10;
    final int putRange_3Start = 11;
    final int putRange_3End = 15;
    final int putRange_4Start = 16;
    final int putRange_4End = 20;
    final int removeRange_1Start = 2;
    final int removeRange_1End = 4;
    final int removeRange_2Start = 7;
    final int removeRange_2End = 9;

    public BridgeWriterMiscDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
    }

    private int initServerCache(boolean notifyBySub) {
        Object[] args = new Object[]{notifyBySub, this.getMaxThreads()};
        return (Integer)server1.invoke(BridgeWriterMiscDUnitTest.class, "createServerCache", args);
    }

    private int initServerCache2(boolean notifyBySub) {
        Object[] args = new Object[]{notifyBySub, this.getMaxThreads()};
        return (Integer)server2.invoke(BridgeWriterMiscDUnitTest.class, "createServerCache", args);
    }

    public void testConcurrentOperationsWithDRandPR() throws Exception {
        int port1 = this.initServerCache(true);
        int port2 = this.initServerCache2(true);
        String serverName = BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0));
        host.getVM(2).invoke(this.getClass(), "createClientCacheV", new Object[]{serverName, port1});
        host.getVM(3).invoke(this.getClass(), "createClientCacheV", new Object[]{serverName, port2});
        BridgeWriterMiscDUnitTest.getLogWriter().info("Testing concurrent map operations from a client with a distributed region");
        this.concurrentMapTest(host.getVM(2), "/BridgeWriterMiscDUnitTest_region1");
        BridgeWriterMiscDUnitTest.getLogWriter().info("Testing concurrent map operations from a client with a partitioned region");
        this.concurrentMapTest(host.getVM(2), "/BridgeWriterMiscDUnitTest_PRregion");
    }

    public void testConcurrentOperationsWithDRandPRandEmptyClient() throws Exception {
        int port1 = this.initServerCache(true);
        int port2 = this.initServerCache2(true);
        String serverName = BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0));
        host.getVM(2).invoke(this.getClass(), "createEmptyClientCache", new Object[]{serverName, port1});
        host.getVM(3).invoke(this.getClass(), "createClientCacheV", new Object[]{serverName, port2});
        BridgeWriterMiscDUnitTest.getLogWriter().info("Testing concurrent map operations from a client with a distributed region");
        this.concurrentMapTest(host.getVM(2), "/BridgeWriterMiscDUnitTest_region1");
        BridgeWriterMiscDUnitTest.getLogWriter().info("Testing concurrent map operations from a client with a partitioned region");
        this.concurrentMapTest(host.getVM(2), "/BridgeWriterMiscDUnitTest_PRregion");
    }

    public void concurrentMapTest(VM clientVM, final String rName) {
        clientVM.invoke(new CacheSerializableRunnable("doConcurrentMapOperations"){

            @Override
            public void run2() throws CacheException {
                int i;
                int size;
                Cache cache = BridgeWriterMiscDUnitTest.this.getCache();
                Region pr = cache.getRegion(rName);
                TestCase.assertNotNull((String)(rName + " not created"), (Object)pr);
                boolean isEmpty = pr.getAttributes().getDataPolicy() == DataPolicy.EMPTY;
                for (int i2 = 1; i2 <= 5; ++i2) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i2), (Object)Integer.toString(i2));
                    TestCase.assertNull((String)("Expected null, but got " + putResult + " for key " + i2), (Object)putResult);
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                    TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i), (Object)Integer.toString(i + 1));
                    TestCase.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)putResult);
                    TestCase.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                    TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("replaced" + i));
                    TestCase.assertTrue((String)("for i=" + i), (boolean)replaceSucceeded);
                    TestCase.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                    TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 10; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("not" + i));
                    TestCase.assertFalse((String)("for i=" + i), (boolean)replaceSucceeded);
                    TestCase.assertEquals((String)("for i=" + i), i <= 5 ? "replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                    TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    TestCase.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)replaceResult);
                    TestCase.assertEquals((String)("for i=" + i), (Object)("twice replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                    TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 6; i <= 10; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("thrice replaced" + i));
                    TestCase.assertNull((String)("for i=" + i), (Object)replaceResult);
                    TestCase.assertNull((String)("for i=" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                    TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 10; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)Integer.toString(-i));
                    TestCase.assertFalse((String)("for i=" + i), (boolean)removeResult);
                    TestCase.assertEquals((String)("for i=" + i), i <= 5 ? "twice replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                    TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                for (i = 1; i <= 5; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    TestCase.assertTrue((String)("for i=" + i), (boolean)removeResult);
                    TestCase.assertEquals((String)("for i=" + i), null, (Object)pr.get((Object)Integer.toString(i)));
                }
                if (!isEmpty) {
                    size = pr.size();
                    TestCase.assertEquals((String)"Size doesn't return expected value", (int)0, (int)size);
                    pr.localClear();
                    TestCase.assertTrue((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                }
                if (!isEmpty) {
                    String key42169 = "key42169";
                    pr.put((Object)key42169, (Object)"initialValue42169");
                    pr.localDestroy((Object)key42169);
                    boolean success = pr.replace((Object)key42169, (Object)"initialValue42169", (Object)"newValue42169");
                    TestCase.assertTrue((String)"expected replace to succeed", (boolean)success);
                    pr.destroy((Object)key42169);
                    pr.put((Object)key42169, (Object)"secondRound");
                    pr.localDestroy((Object)key42169);
                    Object result = pr.putIfAbsent((Object)key42169, null);
                    TestCase.assertEquals((String)"expected putIfAbsent to fail", (Object)result, (Object)"secondRound");
                    pr.destroy((Object)key42169);
                }
                if (isEmpty) {
                    String key41265 = "key41265";
                    boolean success = pr.remove((Object)key41265, null);
                    TestCase.assertFalse((String)"expected remove to fail because key does not exist", (boolean)success);
                }
                Object oldValue = pr.putIfAbsent((Object)"keyForNull", null);
                TestCase.assertNull((Object)oldValue);
                if (!isEmpty) {
                    TestCase.assertTrue((boolean)pr.containsKey((Object)"keyForNull"));
                    TestCase.assertTrue((!pr.containsValueForKey((Object)"keyForNull") ? 1 : 0) != 0);
                }
                TestCase.assertTrue((boolean)pr.replace((Object)"keyForNull", null, (Object)"no longer invalid"));
                try {
                    pr.replace((Object)"keyForNull", (Object)"no longer invalid", null);
                    TestCase.fail((String)"expected a NullPointerException");
                }
                catch (NullPointerException success) {
                    // empty catch block
                }
                try {
                    pr.replace((Object)"keyForNull", null);
                    TestCase.fail((String)"expected a NullPointerException");
                }
                catch (NullPointerException success) {
                    // empty catch block
                }
                pr.putIfAbsent((Object)"otherKeyForNull", null);
                int puts = ((GemFireCacheImpl)pr.getCache()).getCachePerfStats().getPuts();
                boolean success = pr.replace((Object)"otherKeyForNull", null, (Object)"no longer invalid");
                TestCase.assertTrue((boolean)success);
                int newputs = ((GemFireCacheImpl)pr.getCache()).getCachePerfStats().getPuts();
                TestCase.assertTrue((String)"stats not updated properly or replace malfunctioned", (newputs == puts + 1 ? 1 : 0) != 0);
            }
        });
    }

    public void testSameBridgeWriterForTwoRegionHavingDifferentInterestList() throws Exception {
        PORT1 = this.initServerCache(true);
        BridgeWriterMiscDUnitTest.createClientCache(BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0)), PORT1);
        BridgeWriterMiscDUnitTest.populateCache();
        BridgeWriterMiscDUnitTest.registerInterest();
        server1.invoke(BridgeWriterMiscDUnitTest.class, "put");
        BridgeWriterMiscDUnitTest.verifyUpdates();
    }

    public void testSameBridgeWriterForTwoRegionHavingALLKEYSInterest() throws Exception {
        PORT1 = this.initServerCache(true);
        BridgeWriterMiscDUnitTest.createClientCache(BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0)), PORT1);
        BridgeWriterMiscDUnitTest.populateCache();
        BridgeWriterMiscDUnitTest.registerInterestInBothTheRegions();
        BridgeWriterMiscDUnitTest.closeRegion1();
        BridgeWriterMiscDUnitTest.pause(6000);
        server1.invoke(BridgeWriterMiscDUnitTest.class, "verifyInterestListOnServer");
        server1.invoke(BridgeWriterMiscDUnitTest.class, "put");
        BridgeWriterMiscDUnitTest.verifyUpdatesOnRegion2();
    }

    public void testRegionCloseWithSameBridgeWriter() throws Exception {
        PORT1 = this.initServerCache(true);
        pool = (PoolImpl)BridgeWriterMiscDUnitTest.createClientCache(BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0)), PORT1);
        BridgeWriterMiscDUnitTest.populateCache();
        BridgeWriterMiscDUnitTest.registerInterestInBothTheRegions();
        BridgeWriterMiscDUnitTest.closeBothRegions();
        BridgeWriterMiscDUnitTest.assertEquals((boolean)false, (boolean)pool.isDestroyed());
        pool.destroy();
        BridgeWriterMiscDUnitTest.assertEquals((boolean)true, (boolean)pool.isDestroyed());
        server1.invoke(BridgeWriterMiscDUnitTest.class, "verifyNoCacheClientProxyOnServer");
    }

    public void testCCPDestroyOnLastDestroyRegion() throws Exception {
        PORT1 = this.initServerCache(true);
        PoolImpl pool = (PoolImpl)BridgeWriterMiscDUnitTest.createClientCache(BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0)), PORT1);
        BridgeWriterMiscDUnitTest.destroyRegion1();
        server1.invoke(BridgeWriterMiscDUnitTest.class, "verifyCacheClientProxyOnServer", new Object[]{new String(REGION_NAME1)});
        Connection conn = pool.acquireConnection();
        BridgeWriterMiscDUnitTest.assertNotNull((Object)conn);
        BridgeWriterMiscDUnitTest.assertEquals((int)1, (int)pool.getConnectedServerCount());
        BridgeWriterMiscDUnitTest.assertEquals((boolean)false, (boolean)pool.isDestroyed());
        BridgeWriterMiscDUnitTest.destroyRegion2();
        BridgeWriterMiscDUnitTest.assertEquals((boolean)false, (boolean)pool.isDestroyed());
        BridgeWriterMiscDUnitTest.destroyPRRegion();
        BridgeWriterMiscDUnitTest.assertEquals((boolean)false, (boolean)pool.isDestroyed());
        pool.destroy();
        BridgeWriterMiscDUnitTest.assertEquals((boolean)true, (boolean)pool.isDestroyed());
        server1.invoke(BridgeWriterMiscDUnitTest.class, "verifyNoCacheClientProxyOnServer");
        try {
            this.getCache().createRegion(REGION_NAME2, attrs);
            BridgeWriterMiscDUnitTest.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInvalidatesPropagateOnTwoRegionsHavingCommonBridgeWriter() throws Exception {
        PORT1 = this.initServerCache(false);
        BridgeWriterMiscDUnitTest.createClientCache(BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0)), PORT1);
        BridgeWriterMiscDUnitTest.registerInterestForInvalidatesInBothTheRegions();
        BridgeWriterMiscDUnitTest.populateCache();
        server1.invoke(BridgeWriterMiscDUnitTest.class, "put");
        BridgeWriterMiscDUnitTest.verifyInvalidatesOnBothRegions();
    }

    public void testBug43407() throws Exception {
        Object value;
        PORT1 = this.initServerCache(false);
        BridgeWriterMiscDUnitTest.createClientCache(BridgeWriterMiscDUnitTest.getServerHostName(Host.getHost(0)), PORT1);
        BridgeWriterMiscDUnitTest.registerInterestForInvalidatesInBothTheRegions();
        Region region = static_cache.getRegion(REGION_NAME1);
        BridgeWriterMiscDUnitTest.populateCache();
        region.put((Object)"invalidationKey", (Object)"invalidationValue");
        region.localDestroy((Object)"invalidationKey");
        if (region.containsKey((Object)"invalidationKey")) {
            BridgeWriterMiscDUnitTest.fail((String)"region still contains invalidationKey");
        }
        region.invalidate((Object)"invalidationKey");
        if (region.containsKey((Object)"invalidationKey")) {
            BridgeWriterMiscDUnitTest.fail((String)"this test expects the entry is not created on invalidate() if not there before the operation");
        }
        if ((value = region.get((Object)"invalidationKey")) != null) {
            BridgeWriterMiscDUnitTest.fail((String)"this test expected a null response to get('invalidationKey')");
        }
        if (!region.containsKeyOnServer((Object)"invalidationKey")) {
            BridgeWriterMiscDUnitTest.fail((String)"expected an entry on the server after invalidation");
        }
        if (region.containsKey((Object)"invalidationKey")) {
            BridgeWriterMiscDUnitTest.fail((String)"expected no entry after invalidation when entry was not in client but was on server");
        }
    }

    public void testInvalidatesPropagateOnRegionHavingNoBridgeWriter() throws Exception {
        PORT1 = this.initServerCache(false);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new BridgeWriterMiscDUnitTest("temp").createCache(props);
        String host = BridgeWriterMiscDUnitTest.getServerHostName(server1.getHost());
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setThreadLocalConnections(true).setReadTimeout(1000).setSocketBufferSize(32768).setMinConnections(3).setSubscriptionRedundancy(-1).setPingInterval(2000L).create("testInvalidatesPropagateOnRegionHavingNoBridgeWriter");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        attrs = factory.create();
        final Region region1 = this.getCache().createRegion(REGION_NAME1, attrs);
        final Region region2 = this.getCache().createRegion(REGION_NAME2, attrs);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region1);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region2);
        pool = p;
        conn = pool.acquireConnection();
        BridgeWriterMiscDUnitTest.assertNotNull((Object)conn);
        BridgeWriterMiscDUnitTest.populateCache();
        server1.invoke(BridgeWriterMiscDUnitTest.class, "put");
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Object val = region1.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                return BridgeWriterMiscDUnitTest.k1.equals(val);
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Object val = region1.getEntry((Object)BridgeWriterMiscDUnitTest.k2).getValue();
                return BridgeWriterMiscDUnitTest.k2.equals(val);
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Object val = region2.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                return BridgeWriterMiscDUnitTest.k1.equals(val);
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Object val = region2.getEntry((Object)BridgeWriterMiscDUnitTest.k2).getValue();
                return BridgeWriterMiscDUnitTest.k2.equals(val);
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public void testProxyCreationBeforeCacheCreation() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(props);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        PORT1 = this.initServerCache(true);
        String host = BridgeWriterMiscDUnitTest.getServerHostName(server1.getHost());
        Pool p = PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).create("testProxyCreationBeforeCacheCreationPool");
        Cache cache = this.getCache();
        BridgeWriterMiscDUnitTest.assertNotNull((Object)cache);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes myAttrs = factory.create();
        Region region1 = cache.createRegion(REGION_NAME1, myAttrs);
        Region region2 = cache.createRegion(REGION_NAME2, myAttrs);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region1);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region2);
        region2.registerInterest((Object)"ALL_KEYS");
        BridgeWriterMiscDUnitTest.pause(6000);
        server1.invoke(BridgeWriterMiscDUnitTest.class, "verifyInterestListOnServer");
    }

    public void testBug35380() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(props);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)ds);
        PORT1 = this.initServerCache(true);
        String host = BridgeWriterMiscDUnitTest.getServerHostName(server1.getHost());
        Pool p = PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).create("testBug35380Pool");
        Cache cache = this.getCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes myAttrs = factory.create();
        Region region1 = cache.createRegion(REGION_NAME1, myAttrs);
        Region region2 = cache.createRegion(REGION_NAME2, myAttrs);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region1);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region2);
        region2.registerInterest((Object)"ALL_KEYS");
        ds.disconnect();
        Properties prop = new Properties();
        prop.setProperty("mcast-port", "0");
        prop.setProperty("locators", "");
        ds = this.getSystem(prop);
        cache = this.getCache();
        BridgeWriterMiscDUnitTest.assertNotNull((Object)cache);
        AttributesFactory factory1 = new AttributesFactory();
        factory1.setScope(Scope.DISTRIBUTED_ACK);
        factory1.setPoolName(p.getName());
        RegionAttributes attrs1 = factory1.create();
        try {
            cache.createRegion(REGION_NAME1, attrs1);
            BridgeWriterMiscDUnitTest.fail((String)"expected ShutdownException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (BridgeWriterException bridgeWriterException) {
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    private void createCache(Properties props) throws Exception {
        this.createCacheV(props);
    }

    private Cache createCacheV(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        Cache cache = this.getCache();
        BridgeWriterMiscDUnitTest.assertNotNull((Object)cache);
        return cache;
    }

    public static void createClientCacheV(String h, int port) throws Exception {
        BridgeWriterMiscDUnitTest._createClientCache(h, port, false);
    }

    public static void createEmptyClientCache(String h, int port) throws Exception {
        BridgeWriterMiscDUnitTest._createClientCache(h, port, true);
    }

    public static Pool createClientCache(String h, int port) throws Exception {
        return BridgeWriterMiscDUnitTest._createClientCache(h, port, false);
    }

    public static Pool _createClientCache(String h, int port, boolean empty) throws Exception {
        Cache cache;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        static_cache = cache = new BridgeWriterMiscDUnitTest("temp").createCacheV(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(h, port).setSubscriptionEnabled(true).setThreadLocalConnections(true).setReadTimeout(1000).setSocketBufferSize(32768).setMinConnections(3).setSubscriptionRedundancy(-1).setPingInterval(2000L).create("BridgeWriterMiscDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        if (empty) {
            factory.setDataPolicy(DataPolicy.EMPTY);
        }
        factory.setPoolName(p.getName());
        attrs = factory.create();
        Region region1 = cache.createRegion(REGION_NAME1, attrs);
        Region region2 = cache.createRegion(REGION_NAME2, attrs);
        Region prRegion = cache.createRegion(PR_REGION_NAME, attrs);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region1);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)region2);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)prRegion);
        pool = p;
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                try {
                    conn = pool.acquireConnection();
                    if (conn == null) {
                        this.excuse = "acquireConnection returned null?";
                        return false;
                    }
                    return true;
                }
                catch (NoAvailableServersException e) {
                    this.excuse = "Cannot find a server: " + (Object)((Object)e);
                    return false;
                }
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        return p;
    }

    public static Integer createServerCache(Boolean notifyBySubscription, Integer maxThreads) throws Exception {
        Cache cache = new BridgeWriterMiscDUnitTest("temp").createCacheV(new Properties());
        BridgeWriterMiscDUnitTest.unsetSlowDispatcherFlag();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes myAttrs = factory.create();
        Region r1 = cache.createRegion(REGION_NAME1, myAttrs);
        Region r2 = cache.createRegion(REGION_NAME2, myAttrs);
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.PARTITION);
        RegionAttributes prAttrs = factory.create();
        Region pr = cache.createRegion(PR_REGION_NAME, prAttrs);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
        BridgeWriterMiscDUnitTest.assertNotNull((Object)pr);
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        r1.getCache().getDistributedSystem().getLogWriter().info("Starting server on port " + port);
        server.setPort(port);
        server.setMaxThreads(maxThreads.intValue());
        server.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server.start();
        r1.getCache().getDistributedSystem().getLogWriter().info("Started server on port " + server.getPort());
        return new Integer(server.getPort());
    }

    protected int getMaxThreads() {
        return 0;
    }

    public static void registerInterest() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"ALL_KEYS");
        }
        catch (CacheWriterException e) {
            e.printStackTrace();
            BridgeWriterMiscDUnitTest.fail("Test failed due to CacheWriterException during registerInterest", e);
        }
    }

    public static void registerInterestForInvalidatesInBothTheRegions() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            r1.registerInterest((Object)"ALL_KEYS", false, false);
            r2.registerInterest((Object)"ALL_KEYS", false, false);
        }
        catch (CacheWriterException e) {
            e.printStackTrace();
            BridgeWriterMiscDUnitTest.fail("Test failed due to CacheWriterException during registerInterestnBothRegions", e);
        }
    }

    public static void registerInterestInBothTheRegions() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            r1.registerInterest((Object)"ALL_KEYS");
            r2.registerInterest((Object)"ALL_KEYS");
        }
        catch (CacheWriterException e) {
            e.printStackTrace();
            BridgeWriterMiscDUnitTest.fail("Test failed due to CacheWriterException during registerInterestnBothRegions", e);
        }
    }

    public static void closeRegion1() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            r1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            BridgeWriterMiscDUnitTest.fail("Test failed due to Exception during closeRegion1", e);
        }
    }

    public static void closeBothRegions() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            Region pr = cache.getRegion("/BridgeWriterMiscDUnitTest_PRregion");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)pr);
            r1.close();
            r2.close();
            pr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            BridgeWriterMiscDUnitTest.fail("Test failed due to Exception during closeBothRegions", e);
        }
    }

    public static void destroyRegion1() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            r1.destroyRegion();
        }
        catch (Exception e) {
            e.printStackTrace();
            BridgeWriterMiscDUnitTest.fail("Test failed due to Exception during closeBothRegions", e);
        }
    }

    public static void destroyRegion2() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            r2.destroyRegion();
        }
        catch (Exception e) {
            e.printStackTrace();
            BridgeWriterMiscDUnitTest.fail("Test failed due to Exception during closeBothRegions", e);
        }
    }

    public static void destroyPRRegion() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_PRregion");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            r2.destroyRegion();
        }
        catch (Exception e) {
            BridgeWriterMiscDUnitTest.fail("Test failed due to Exception during closeBothRegions", e);
        }
    }

    public static void verifyInterestListOnServer() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            BridgeWriterMiscDUnitTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            BridgeWriterMiscDUnitTest.assertNotNull((Object)bs);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)bs.getAcceptor());
            BridgeWriterMiscDUnitTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            for (CacheClientProxy ccp : bs.getAcceptor().getCacheClientNotifier().getClientProxies()) {
                Set akr = ccp.cils[0].regions;
                BridgeWriterMiscDUnitTest.assertNotNull((Object)akr);
                BridgeWriterMiscDUnitTest.assertTrue((!akr.contains("/BridgeWriterMiscDUnitTest_region1") ? 1 : 0) != 0);
                BridgeWriterMiscDUnitTest.assertTrue((boolean)akr.contains("/BridgeWriterMiscDUnitTest_region2"));
                BridgeWriterMiscDUnitTest.assertEquals((int)1, (int)akr.size());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BridgeWriterMiscDUnitTest.fail((String)("while setting verifyInterestListOnServer  " + ex));
        }
    }

    public static void verifyNoCacheClientProxyOnServer() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            BridgeWriterMiscDUnitTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            BridgeWriterMiscDUnitTest.assertNotNull((Object)bs);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)bs.getAcceptor());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            BridgeWriterMiscDUnitTest.assertNotNull((Object)ccn);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() == 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 40000L, 1000L, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BridgeWriterMiscDUnitTest.fail((String)("while setting verifyNoCacheClientProxyOnServer  " + ex));
        }
    }

    public static void verifyCacheClientProxyOnServer(String regionName) {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            BridgeWriterMiscDUnitTest.assertNull((Object)cache.getRegion("/" + regionName));
            BridgeWriterMiscDUnitTest.verifyCacheClientProxyOnServer();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BridgeWriterMiscDUnitTest.fail((String)("while setting verifyNoCacheClientProxyOnServer  " + ex));
        }
    }

    public static void verifyCacheClientProxyOnServer() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            BridgeWriterMiscDUnitTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            BridgeWriterMiscDUnitTest.assertNotNull((Object)bs);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)bs.getAcceptor());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            BridgeWriterMiscDUnitTest.assertNotNull((Object)ccn);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 40000L, 1000L, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BridgeWriterMiscDUnitTest.fail((String)("while setting verifyNoCacheClientProxyOnServer  " + ex));
        }
    }

    public static void populateCache() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            if (!r1.containsKey((Object)k1)) {
                r1.create((Object)k1, (Object)k1);
            }
            if (!r1.containsKey((Object)k2)) {
                r1.create((Object)k2, (Object)k2);
            }
            if (!r2.containsKey((Object)k1)) {
                r2.create((Object)k1, (Object)k1);
            }
            if (!r2.containsKey((Object)k2)) {
                r2.create((Object)k2, (Object)k2);
            }
            BridgeWriterMiscDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)k1);
            BridgeWriterMiscDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)k2);
            BridgeWriterMiscDUnitTest.assertEquals((Object)r2.getEntry((Object)k1).getValue(), (Object)k1);
            BridgeWriterMiscDUnitTest.assertEquals((Object)r2.getEntry((Object)k2).getValue(), (Object)k2);
        }
        catch (Exception ex) {
            BridgeWriterMiscDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void put() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            r1.put((Object)k1, (Object)server_k1);
            r1.put((Object)k2, (Object)server_k2);
            r2.put((Object)k1, (Object)server_k1);
            r2.put((Object)k2, (Object)server_k2);
            BridgeWriterMiscDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)server_k1);
            BridgeWriterMiscDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)server_k2);
            BridgeWriterMiscDUnitTest.assertEquals((Object)r2.getEntry((Object)k1).getValue(), (Object)server_k1);
            BridgeWriterMiscDUnitTest.assertEquals((Object)r2.getEntry((Object)k2).getValue(), (Object)server_k2);
        }
        catch (Exception ex) {
            BridgeWriterMiscDUnitTest.fail("failed while put()", ex);
        }
    }

    public static void verifyUpdates() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            final Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            final Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r1.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                    return BridgeWriterMiscDUnitTest.k1.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r1.getEntry((Object)BridgeWriterMiscDUnitTest.k2).getValue();
                    return BridgeWriterMiscDUnitTest.k2.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r2.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                    return BridgeWriterMiscDUnitTest.server_k1.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r2.getEntry((Object)BridgeWriterMiscDUnitTest.k2).getValue();
                    return BridgeWriterMiscDUnitTest.server_k2.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        }
        catch (Exception ex) {
            BridgeWriterMiscDUnitTest.fail("failed while verifyUpdates()", ex);
        }
    }

    public static void verifyInvalidatesOnBothRegions() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            final Region r1 = cache.getRegion("/BridgeWriterMiscDUnitTest_region1");
            final Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r1);
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r1.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                    return val == null;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 90000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r1.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                    return val == null;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 90000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r1.getEntry((Object)BridgeWriterMiscDUnitTest.k2).getValue();
                    return val == null;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 90000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r2.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                    return val == null;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 90000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r2.getEntry((Object)BridgeWriterMiscDUnitTest.k2).getValue();
                    return val == null;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 90000L, 1000L, true);
        }
        catch (Exception ex) {
            BridgeWriterMiscDUnitTest.fail("failed while verifyInvalidatesOnBothRegions()", ex);
        }
    }

    public static void verifyUpdatesOnRegion2() {
        try {
            Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
            final Region r2 = cache.getRegion("/BridgeWriterMiscDUnitTest_region2");
            BridgeWriterMiscDUnitTest.assertNotNull((Object)r2);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r2.getEntry((Object)BridgeWriterMiscDUnitTest.k1).getValue();
                    return BridgeWriterMiscDUnitTest.server_k1.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    Object val = r2.getEntry((Object)BridgeWriterMiscDUnitTest.k2).getValue();
                    return BridgeWriterMiscDUnitTest.server_k2.equals(val);
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        }
        catch (Exception ex) {
            BridgeWriterMiscDUnitTest.fail("failed while verifyUpdatesOnRegion2()", ex);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        BridgeWriterMiscDUnitTest.closeCache();
        server1.invoke(BridgeWriterMiscDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        Cache cache = new BridgeWriterMiscDUnitTest("temp").getCache();
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void unsetSlowDispatcherFlag() {
        CacheClientProxy.isSlowStartForTesting = false;
    }
}

