/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Properties;

public class Bug36805DUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server1 = null;
    private static VM server2 = null;
    private static VM client1 = null;
    private static VM client2 = null;
    protected static PoolImpl pool = null;
    private static final String regionName = "Bug36805DUnitTest_Region";

    public Bug36805DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Bug36805DUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug36805DUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new Bug36805DUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).setSubscriptionEnabled(true).setMinConnections(4).create("Bug36805UnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        pool = p;
    }

    public static Integer createServerCache() throws Exception {
        new Bug36805DUnitTest("temp").createCache(new Properties());
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(Bug36805DUnitTest.class, "closeCache");
        client2.invoke(Bug36805DUnitTest.class, "closeCache");
        server1.invoke(Bug36805DUnitTest.class, "closeCache");
        server2.invoke(Bug36805DUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testBug36805() {
        Integer port1 = (Integer)server1.invoke(Bug36805DUnitTest.class, "createServerCache");
        Integer port2 = (Integer)server2.invoke(Bug36805DUnitTest.class, "createServerCache");
        client1.invoke(Bug36805DUnitTest.class, "createClientCache", new Object[]{Bug36805DUnitTest.getServerHostName(server1.getHost()), port1, port2});
        client2.invoke(Bug36805DUnitTest.class, "createClientCache", new Object[]{Bug36805DUnitTest.getServerHostName(server1.getHost()), port1, port2});
        client1.invoke(Bug36805DUnitTest.class, "registerInterest");
        client2.invoke(Bug36805DUnitTest.class, "verifyDeadAndLiveServers", new Object[]{new Integer(0), new Integer(2)});
        client1.invoke(Bug36805DUnitTest.class, "verifyDeadAndLiveServers", new Object[]{new Integer(0), new Integer(2)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInterest() {
        cache.getLogger().info("<ExpectedException action=add>RegionDestroyedException</ExpectedException>");
        try {
            Region r = cache.getRegion("/Bug36805DUnitTest_Region");
            Bug36805DUnitTest.assertNotNull((Object)r);
            ArrayList<String> listOfKeys = new ArrayList<String>();
            listOfKeys.add("key-1");
            listOfKeys.add("key-2");
            listOfKeys.add("key-3");
            listOfKeys.add("key-4");
            listOfKeys.add("key-5");
            r.registerInterest(listOfKeys);
            Bug36805DUnitTest.fail((String)"expected RegionDestroyedException");
        }
        catch (ServerOperationException expected) {
            Bug36805DUnitTest.assertEquals(RegionDestroyedException.class, expected.getCause().getClass());
        }
        finally {
            cache.getLogger().info("<ExpectedException action=remove>RegionDestroyedException</ExpectedException>");
        }
    }

    public static void verifyDeadAndLiveServers(Integer expectedDeadServers, final Integer expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return pool.getConnectedServerCount() == expectedLiveServers.intValue();
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
    }
}

