/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class Bug36829DUnitTest
extends DistributedTestCase {
    private VM serverVM;
    private VM ClientVM;
    private String regionName;
    private int PORT;

    public Bug36829DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        this.serverVM = host.getVM(0);
        this.ClientVM = host.getVM(1);
        this.regionName = Bug36829DUnitTest.class.getName() + "_region";
        CacheServerTestUtil.disableShufflingOfEndpoints();
    }

    public void testBug36829() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 600;
        this.PORT = (Integer)this.serverVM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{"DUMMY_REGION", new Boolean(true), new Integer(mcastPort)});
        this.ClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(Bug36829DUnitTest.getServerHostName(this.ClientVM.getHost()), this.PORT, true, 0), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 600), Boolean.TRUE});
        this.ClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.ClientVM.invoke(Bug36829DUnitTest.class, "registerKey", new Object[]{"Key1"});
        this.ClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.serverVM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    private static void registerKey(String key) throws Exception {
        try {
            Region region = CacheServerTestUtil.getCache().getRegion(Bug36829DUnitTest.class.getName() + "_region");
            Bug36829DUnitTest.assertNotNull((Object)region);
            try {
                region.registerInterest((Object)key, InterestResultPolicy.NONE);
                Bug36829DUnitTest.fail((String)"expected ServerOperationException");
            }
            catch (ServerOperationException serverOperationException) {}
        }
        catch (Exception ex) {
            Bug36829DUnitTest.fail("failed while registering interest in registerKey function", ex);
        }
    }

    private static void registerKeyAfterRegionCreation(String key) throws Exception {
        try {
            Region region = CacheServerTestUtil.getCache().getRegion(Bug36829DUnitTest.class.getName() + "_region");
            Bug36829DUnitTest.assertNotNull((Object)region);
            try {
                region.registerInterest((Object)key, InterestResultPolicy.NONE);
            }
            catch (Exception e) {
                Bug36829DUnitTest.fail((String)("unexpected Exception while registerInterest inspite of region present on the server. Details of Exception:\ne.getCause:" + e.getCause() + "\ne.getMessage:" + e.getMessage()));
            }
        }
        catch (Exception ex) {
            Bug36829DUnitTest.fail("failed while registering interest in registerKey function", ex);
        }
    }

    private Pool getClientPool(String host, int server1Port, boolean establishCallbackConnection, int redundancyLevel) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, server1Port).setSubscriptionEnabled(establishCallbackConnection).setSubscriptionRedundancy(redundancyLevel);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    private Properties getClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }
}

