/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.Properties;

public class Bug36995DUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server1 = null;
    private static VM server2 = null;
    private static VM server3 = null;
    protected static PoolImpl pool = null;
    private static final String regionName = "Bug36995DUnitTest_Region";

    public Bug36995DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        server3 = host.getVM(2);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Bug36995DUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug36995DUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, int port1, int port2, int port3) {
        try {
            Properties props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "");
            new Bug36995DUnitTest("temp").createCache(props);
            PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1).addServer(host, port2).addServer(host, port3).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setSubscriptionMessageTrackingTimeout(54321).setIdleTimeout(-1L).setPingInterval(200L).create("Bug36995UnitTestPool1");
            AttributesFactory factory = new AttributesFactory();
            factory.setPoolName(p.getName());
            RegionAttributes attrs = factory.create();
            cache.createRegion(regionName, attrs);
            pool = p;
        }
        catch (Exception e) {
            Bug36995DUnitTest.fail((String)("Test failed due to " + e));
        }
    }

    public static void createClientCacheWithDefaultMessageTrackingTimeout(String host, int port1, int port2, int port3) {
        try {
            Properties props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "");
            new Bug36995DUnitTest("temp").createCache(props);
            PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1).addServer(host, port2).addServer(host, port3).create("Bug36995UnitTestPool2");
            AttributesFactory factory = new AttributesFactory();
            factory.setPoolName(p.getName());
            RegionAttributes attrs = factory.create();
            cache.createRegion(regionName, attrs);
            pool = p;
        }
        catch (Exception e) {
            Bug36995DUnitTest.fail((String)("Test failed due to " + e));
        }
    }

    public static Integer createServerCache() throws Exception {
        new Bug36995DUnitTest("temp").createCache(new Properties());
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.start();
        return new Integer(server1.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        Bug36995DUnitTest.closeCache();
        server1.invoke(Bug36995DUnitTest.class, "closeCache");
        server2.invoke(Bug36995DUnitTest.class, "closeCache");
        server3.invoke(Bug36995DUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testBug36995_Default() {
        Integer port1 = (Integer)server1.invoke(Bug36995DUnitTest.class, "createServerCache");
        Integer port2 = (Integer)server2.invoke(Bug36995DUnitTest.class, "createServerCache");
        Integer port3 = (Integer)server3.invoke(Bug36995DUnitTest.class, "createServerCache");
        Bug36995DUnitTest.createClientCacheWithDefaultMessageTrackingTimeout(Bug36995DUnitTest.getServerHostName(server1.getHost()), port1, port2, port3);
        Bug36995DUnitTest.assertEquals((int)900000, (int)pool.getSubscriptionMessageTrackingTimeout());
    }

    public void testBug36995_UserSpecified() {
        Integer port1 = (Integer)server1.invoke(Bug36995DUnitTest.class, "createServerCache");
        Integer port2 = (Integer)server2.invoke(Bug36995DUnitTest.class, "createServerCache");
        Integer port3 = (Integer)server3.invoke(Bug36995DUnitTest.class, "createServerCache");
        Bug36995DUnitTest.createClientCache(Bug36995DUnitTest.getServerHostName(server1.getHost()), port1, port2, port3);
        Bug36995DUnitTest.assertEquals((int)54321, (int)pool.getSubscriptionMessageTrackingTimeout());
    }

    public void testBug36526() {
        Integer port1 = (Integer)server1.invoke(Bug36995DUnitTest.class, "createServerCache");
        Integer port2 = (Integer)server2.invoke(Bug36995DUnitTest.class, "createServerCache");
        Integer port3 = (Integer)server3.invoke(Bug36995DUnitTest.class, "createServerCache");
        Bug36995DUnitTest.createClientCache(Bug36995DUnitTest.getServerHostName(server1.getHost()), port1, port2, port3);
        Bug36995DUnitTest.verifyDeadAndLiveServers(0, 3);
        server2.invoke(Bug36995DUnitTest.class, "stopServer");
        Bug36995DUnitTest.verifyDeadAndLiveServers(1, 2);
    }

    public static void stopServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            Bug36995DUnitTest.fail((String)("failed while stopServer()" + e));
        }
    }

    public static void verifyDeadAndLiveServers(int expectedDeadServers, final int expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return pool.getConnectedServerCount() == expectedLiveServers;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
    }
}

