/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import java.util.Set;

public class Bug37805DUnitTest
extends DistributedTestCase {
    private VM server1VM;
    private VM durableClientVM;
    private String regionName;
    private int PORT1;

    public Bug37805DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        this.server1VM = host.getVM(0);
        this.durableClientVM = host.getVM(1);
        this.regionName = Bug37805DUnitTest.class.getName() + "_region";
        CacheServerTestUtil.disableShufflingOfEndpoints();
    }

    @Override
    public void tearDown2() throws Exception {
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }

    public void testFunctionality() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.PORT1 = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        int durableClientTimeout = 600;
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(Bug37805DUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, true, 0), this.regionName, this.getDurableClientDistributedSystemProperties(durableClientId, 600), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(Bug37805DUnitTest.class, "checkRootRegions");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public static void checkRootRegions() {
        Set rootRegions = CacheServerTestUtil.getCache().rootRegions();
        if (rootRegions != null) {
            for (Region region : rootRegions) {
                if (!(region instanceof HARegion)) continue;
                Bug37805DUnitTest.fail((String)"region of HARegion present");
            }
        }
    }

    private Pool getClientPool(String host, int server1Port, boolean establishCallbackConnection, int redundancyLevel) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, server1Port).setSubscriptionEnabled(establishCallbackConnection).setSubscriptionRedundancy(redundancyLevel);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    private Properties getDurableClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }
}

