/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.Properties;

public class CacheServerTransactionsDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static PoolImpl pool = null;
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String k3 = "k3";
    private static final String server1_k1 = "server1-k1";
    private static final String server1_k2 = "server1-k2";
    private static final String server2_k3 = "server2-k3";
    private static final String server2_k2 = "server2-k2";
    private static final String client_k2 = "client-k2";
    private static final String client_k1 = "client-k1";
    private static final String REGION_NAME = "CacheServerTransactionsDUnitTest_region";
    private static Host host = null;
    private static VM server1 = null;
    private static VM server2 = null;
    private static VM client1 = null;
    private static VM client2 = null;
    protected static boolean destroyed = false;
    protected static boolean invalidated = false;
    private static final int PAUSE = 5000;

    public CacheServerTransactionsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
    }

    public void testOneServerToClientTransactionsPropagation() {
        Integer port1 = this.initServerCache(server1);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "putInTransaction", new Object[]{"server1"});
        CacheServerTransactionsDUnitTest.pause(5000);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
    }

    public void testServerToClientTransactionsPropagation() {
        Integer port1 = this.initServerCache(server1);
        Integer port2 = this.initServerCache(server2);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1, port2});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1, port2});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        server2.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "putInTransaction", new Object[]{"server1"});
        CacheServerTransactionsDUnitTest.pause(5000);
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
    }

    public void testServerToClientTransactionsPropagationWithOneClientConnectedToOneServer() {
        Integer port1 = this.initServerCache(server1);
        Integer port2 = this.initServerCache(server2);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port2});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        server2.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "putInTransaction", new Object[]{"server1"});
        CacheServerTransactionsDUnitTest.pause(5000);
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyNotUpdated");
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdates");
    }

    public void testInvalidatesOneServerToClientTransactionsPropagation() {
        Integer port1 = this.initServerCache(server1);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "invalidateInTransaction", new Object[]{"server1"});
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
    }

    public void testInvalidatesServerToClientTransactionsPropagation() {
        Integer port1 = this.initServerCache(server1);
        Integer port2 = this.initServerCache(server2);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1, port2});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1, port2});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        server2.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "invalidateInTransaction", new Object[]{"server1"});
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
    }

    public void testInvalidatesServerToClientTransactionsPropagationWithOneConnection() {
        Integer port1 = this.initServerCache(server1);
        Integer port2 = this.initServerCache(server2);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port2});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        server2.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "invalidateInTransaction", new Object[]{"server1"});
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyInvalidates");
    }

    public void testDestroysOneServerToClientTransactionsPropagation() {
        Integer port1 = this.initServerCache(server1);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "destroyInTransaction", new Object[]{"server1"});
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
    }

    public void testDestroysServerToClientTransactionsPropagation() {
        Integer port1 = this.initServerCache(server1);
        Integer port2 = this.initServerCache(server2);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1, port2});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1, port2});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        server2.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "destroyInTransaction", new Object[]{"server1"});
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
    }

    public void testDestroysServerToClientTransactionsPropagationWithOneConnection() {
        Integer port1 = this.initServerCache(server1);
        Integer port2 = this.initServerCache(server2);
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port2});
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(this.resetFlags());
        server2.invoke(this.resetFlags());
        client1.invoke(this.resetFlags());
        client2.invoke(this.resetFlags());
        server1.invoke(CacheServerTransactionsDUnitTest.class, "destroyInTransaction", new Object[]{"server1"});
        server1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnServer1");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyDestroys");
    }

    public void YOGESH_testClientToServerCommits() {
        Integer port1 = (Integer)server1.invoke(CacheServerTransactionsDUnitTest.class, "createServerCache");
        Integer port2 = (Integer)server2.invoke(CacheServerTransactionsDUnitTest.class, "createServerCache");
        client1.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port1});
        client2.invoke(CacheServerTransactionsDUnitTest.class, "createClientCache", new Object[]{CacheServerTransactionsDUnitTest.getServerHostName(server1.getHost()), port2});
        client1.invoke(CacheServerTransactionsDUnitTest.class, "commitTransactionOnClient");
        CacheServerTransactionsDUnitTest.pause(5000);
        server1.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdatesOnServer");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdatesOnServer");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "verifyUpdatesOnServer");
    }

    private CacheSerializableRunnable resetFlags() {
        CacheSerializableRunnable resetFlags = new CacheSerializableRunnable("resetFlags"){

            @Override
            public void run2() throws CacheException {
                destroyed = false;
                invalidated = false;
            }
        };
        return resetFlags;
    }

    public static void commitTransactionOnClient() {
        Region r1 = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        try {
            cache.getCacheTransactionManager().begin();
            r1.put((Object)k1, (Object)client_k1);
            r1.put((Object)k2, (Object)client_k2);
            cache.getCacheTransactionManager().commit();
        }
        catch (ConflictException e) {
            CacheServerTransactionsDUnitTest.fail((String)"Test failed due to ConflictException on client , which is not expected");
        }
        CacheServerTransactionsDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)client_k1);
        CacheServerTransactionsDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)client_k2);
    }

    public static void verifyUpdatesOnServer() {
        final Region r1 = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        try {
            Log.getLogWriter().info("vlaue for the key k1" + r1.getEntry((Object)k1).getValue());
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Thread.yield();
                    return r1.getEntry((Object)CacheServerTransactionsDUnitTest.k1).getValue().equals(CacheServerTransactionsDUnitTest.client_k1);
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Thread.yield();
                    return r1.getEntry((Object)CacheServerTransactionsDUnitTest.k2).getValue().equals(CacheServerTransactionsDUnitTest.client_k2);
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
        }
        catch (Exception e) {
            CacheServerTransactionsDUnitTest.fail((String)("Exception in trying to get due to " + e));
        }
    }

    public static void putInTransaction(String server) {
        Region r1 = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        cache.getCacheTransactionManager().begin();
        if (server.equals("server1")) {
            r1.put((Object)k1, (Object)server1_k1);
            r1.put((Object)k2, (Object)server1_k2);
            CacheServerTransactionsDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)server1_k1);
            CacheServerTransactionsDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)server1_k2);
        } else if (server.equals("server2")) {
            r1.put((Object)k1, (Object)server2_k2);
            r1.put((Object)k2, (Object)server2_k3);
            CacheServerTransactionsDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)server2_k2);
            CacheServerTransactionsDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)server2_k3);
        }
    }

    public static void invalidateInTransaction(String server) throws Exception {
        Region r1 = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        cache.getCacheTransactionManager().begin();
        if (server.equals("server1")) {
            r1.invalidate((Object)k1);
            CacheServerTransactionsDUnitTest.assertNull((Object)r1.getEntry((Object)k1).getValue());
        } else if (server.equals("server2")) {
            r1.invalidate((Object)k1);
            CacheServerTransactionsDUnitTest.assertNull((Object)r1.getEntry((Object)k1).getValue());
        }
    }

    public static void destroyInTransaction(String server) throws Exception {
        Region r1 = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        cache.getCacheTransactionManager().begin();
        if (server.equals("server1")) {
            r1.destroy((Object)k1);
            CacheServerTransactionsDUnitTest.assertNull((Object)r1.getEntry((Object)k1));
        } else if (server.equals("server2")) {
            r1.destroy((Object)k1);
            CacheServerTransactionsDUnitTest.assertNull((Object)r1.getEntry((Object)k1));
        }
    }

    public static void commitTransactionOnServer2() {
        try {
            cache.getCacheTransactionManager().commit();
            CacheServerTransactionsDUnitTest.fail((String)"ConflictException is expected on server2 , as server1 has not commited the transaction yet");
        }
        catch (ConflictException conflictException) {
            // empty catch block
        }
    }

    public static void commitTransactionOnServer1() {
        try {
            cache.getCacheTransactionManager().commit();
        }
        catch (ConflictException cce) {
            CacheServerTransactionsDUnitTest.fail((String)"Test failed due to a ConflictException on server1 , which is not expected");
        }
    }

    public static void verifyNotUpdated() {
        final Region r1 = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        try {
            Log.getLogWriter().info("vlaue for the key k1" + r1.getEntry((Object)k1).getValue());
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Thread.yield();
                    return r1.getEntry((Object)CacheServerTransactionsDUnitTest.k1).getValue().equals(CacheServerTransactionsDUnitTest.k1);
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Thread.yield();
                    return r1.getEntry((Object)CacheServerTransactionsDUnitTest.k2).getValue().equals(CacheServerTransactionsDUnitTest.k2);
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
        }
        catch (Exception e) {
            CacheServerTransactionsDUnitTest.fail((String)("Exception in trying to get due to " + e));
        }
    }

    public static void verifyUpdates() {
        final Region r1 = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        try {
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Thread.yield();
                    return r1.getEntry((Object)CacheServerTransactionsDUnitTest.k1).getValue().equals(CacheServerTransactionsDUnitTest.server1_k1);
                }

                @Override
                public String description() {
                    return "Value for entry " + r1 + " never became " + CacheServerTransactionsDUnitTest.server1_k1 + "; it is still " + r1.getEntry((Object)CacheServerTransactionsDUnitTest.k1).getValue();
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Thread.yield();
                    return r1.getEntry((Object)CacheServerTransactionsDUnitTest.k2).getValue().equals(CacheServerTransactionsDUnitTest.server1_k2);
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
        }
        catch (Exception e) {
            CacheServerTransactionsDUnitTest.fail((String)("Exception in trying to get due to " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyInvalidates() {
        Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
        synchronized (CacheServerTransactionsDUnitTest.class) {
            if (!invalidated) {
                try {
                    CacheServerTransactionsDUnitTest.class.wait(60000L);
                }
                catch (InterruptedException e) {
                    CacheServerTransactionsDUnitTest.fail((String)"interrupted");
                }
                if (!invalidated) {
                    CacheServerTransactionsDUnitTest.fail((String)"failed to receive invalidation notification");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyDestroys() {
        Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
        synchronized (CacheServerTransactionsDUnitTest.class) {
            if (!destroyed) {
                try {
                    CacheServerTransactionsDUnitTest.class.wait(60000L);
                }
                catch (InterruptedException e) {
                    CacheServerTransactionsDUnitTest.fail((String)"interrupted");
                }
            }
            if (!destroyed) {
                CacheServerTransactionsDUnitTest.fail((String)"failed to receive destroy notification");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        CacheServerTransactionsDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServerTransactionsDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new CacheServerTransactionsDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port.intValue()).setSubscriptionEnabled(true).create("CacheServerTransctionDUnitTestPool2");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDestroy(EntryEvent event) {
                Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
                synchronized (CacheServerTransactionsDUnitTest.class) {
                    destroyed = true;
                    CacheServerTransactionsDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterInvalidate(EntryEvent event) {
                Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
                synchronized (CacheServerTransactionsDUnitTest.class) {
                    invalidated = true;
                    CacheServerTransactionsDUnitTest.class.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        Region region1 = cache.createRegion(REGION_NAME, factory.create());
        CacheServerTransactionsDUnitTest.assertNotNull((Object)region1);
        pool = p;
        CacheServerTransactionsDUnitTest.registerKeys();
    }

    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new CacheServerTransactionsDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).setSubscriptionEnabled(true).create("CacheServerTransctionDUnitTestPool2");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDestroy(EntryEvent event) {
                Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
                synchronized (CacheServerTransactionsDUnitTest.class) {
                    destroyed = true;
                    CacheServerTransactionsDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterInvalidate(EntryEvent event) {
                Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
                synchronized (CacheServerTransactionsDUnitTest.class) {
                    invalidated = true;
                    CacheServerTransactionsDUnitTest.class.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        Region region1 = cache.createRegion(REGION_NAME, factory.create());
        CacheServerTransactionsDUnitTest.assertNotNull((Object)region1);
        pool = p;
        CacheServerTransactionsDUnitTest.registerKeys();
    }

    protected int getMaxThreads() {
        return 0;
    }

    private Integer initServerCache(VM server) {
        Object[] args = new Object[]{new Integer(this.getMaxThreads())};
        return (Integer)server.invoke(CacheServerTransactionsDUnitTest.class, "createServerCache", args);
    }

    public static Integer createServerCache(Integer maxThreads) throws Exception {
        new CacheServerTransactionsDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDestroy(EntryEvent event) {
                Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
                synchronized (CacheServerTransactionsDUnitTest.class) {
                    destroyed = true;
                    CacheServerTransactionsDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterInvalidate(EntryEvent event) {
                Class<CacheServerTransactionsDUnitTest> clazz = CacheServerTransactionsDUnitTest.class;
                synchronized (CacheServerTransactionsDUnitTest.class) {
                    invalidated = true;
                    CacheServerTransactionsDUnitTest.class.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        Region r1 = cache.createRegion(REGION_NAME, factory.create());
        CacheServerTransactionsDUnitTest.assertNotNull((Object)r1);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
        CacheServerTransactionsDUnitTest.createEntries();
        return new Integer(server1.getPort());
    }

    public static void createEntries() {
        try {
            Region r = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
            CacheServerTransactionsDUnitTest.assertNotNull((Object)r);
            if (!r.containsKey((Object)k1)) {
                r.create((Object)k1, (Object)k1);
            }
            if (!r.containsKey((Object)k2)) {
                r.create((Object)k2, (Object)k2);
            }
            if (!r.containsKey((Object)k3)) {
                r.create((Object)k3, (Object)k3);
            }
            CacheServerTransactionsDUnitTest.assertEquals((Object)r.getEntry((Object)k1).getValue(), (Object)k1);
            CacheServerTransactionsDUnitTest.assertEquals((Object)r.getEntry((Object)k2).getValue(), (Object)k2);
            CacheServerTransactionsDUnitTest.assertEquals((Object)r.getEntry((Object)k3).getValue(), (Object)k3);
        }
        catch (Exception ex) {
            CacheServerTransactionsDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void registerKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            Region r = cache.getRegion("/CacheServerTransactionsDUnitTest_region");
            CacheServerTransactionsDUnitTest.assertNotNull((Object)r);
            keys.add(k1);
            keys.add(k2);
            keys.add(k3);
            r.registerInterest(keys);
        }
        catch (Exception ex) {
            CacheServerTransactionsDUnitTest.fail("failed while registering keys(" + keys + ")", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(CacheServerTransactionsDUnitTest.class, "closeCache");
        client2.invoke(CacheServerTransactionsDUnitTest.class, "closeCache");
        server1.invoke(CacheServerTransactionsDUnitTest.class, "closeCache");
        server2.invoke(CacheServerTransactionsDUnitTest.class, "closeCache");
    }
}

