/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.TestCase;

public class ClientInterestNotifyDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    private static Cache cacheServer = null;
    private static int PORT;
    private static int poolNameCounter;
    private static final String REGION_NAME1 = "ClientInterestNotifyDUnitTest_region1";
    private static final String REGION_NAME2 = "ClientInterestNotifyDUnitTest_region2";
    private static final String REGION_NAME3 = "ClientInterestNotifyDUnitTest_region3";

    public ClientInterestNotifyDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        ClientInterestNotifyDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
    }

    private Cache createCache(Properties props) throws Exception {
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        DistributedSystem ds = DistributedSystem.connect((Properties)props);
        Cache cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public void testInterestNotify() {
        try {
            this.performSteps();
        }
        catch (Exception e) {
            ClientInterestNotifyDUnitTest.fail("testInterestNotify failed due to exception", e);
        }
    }

    private void performSteps() throws Exception {
        PORT = ClientInterestNotifyDUnitTest.createServerCache();
        this.vm0.invoke(ClientInterestNotifyDUnitTest.class, "createClientCacheFeeder", new Object[]{ClientInterestNotifyDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "createClientCache", new Object[]{ClientInterestNotifyDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT), "ClientOn"});
        this.vm0.invoke(ClientInterestNotifyDUnitTest.class, "doFeed");
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "registerInterest");
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "getEntries");
        this.vm0.invoke(ClientInterestNotifyDUnitTest.class, "doEntryOps");
        ClientInterestNotifyDUnitTest.waitForQueuesToDrain();
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "unregisterInterest");
        this.vm0.invoke(ClientInterestNotifyDUnitTest.class, "doEntryOps");
        ClientInterestNotifyDUnitTest.assertAllQueuesEmpty();
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "registerInterest");
        this.vm0.invoke(ClientInterestNotifyDUnitTest.class, "doEntryOps");
        ClientInterestNotifyDUnitTest.waitForQueuesToDrain();
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "doValidation", new Object[]{REGION_NAME1, 1, 3, 2, 2});
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "doValidation", new Object[]{REGION_NAME2, 0, 0, 1, 1});
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "doValidation", new Object[]{REGION_NAME3, 1, 0, 0, 0});
    }

    private static Properties createProperties1() {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        return props;
    }

    private static void createPool2(String host, AttributesFactory factory, Integer port) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, port.intValue()).setSubscriptionEnabled(true).setThreadLocalConnections(true).setReadTimeout(10000).setSocketBufferSize(32768).setPingInterval(1000L).setMinConnections(3).setSubscriptionRedundancy(-1);
        Pool pool = pf.create("superpoolish" + poolNameCounter++);
        factory.setPoolName(pool.getName());
    }

    public static void doValidation(String region, int creates, int updates, int invalidates, int destroys) {
        GemFireCacheImpl cacheClient = GemFireCacheImpl.getInstance();
        EventListener listener = null;
        listener = (EventListener)cacheClient.getRegion(region).getAttributes().getCacheListeners()[0];
        listener.validate(creates, updates, invalidates, destroys);
    }

    public static void createClientCache(String host, Integer port, String name) throws Exception {
        ClientInterestNotifyDUnitTest test = new ClientInterestNotifyDUnitTest("temp");
        Cache cacheClient = test.createCache(ClientInterestNotifyDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(false);
        ClientInterestNotifyDUnitTest.createPool2(host, factory, port);
        ClientInterestNotifyDUnitTest clientInterestNotifyDUnitTest = test;
        clientInterestNotifyDUnitTest.getClass();
        factory.setCacheListener((CacheListener)clientInterestNotifyDUnitTest.new EventListener(name + REGION_NAME1));
        RegionAttributes attrs = factory.create();
        cacheClient.createRegion(REGION_NAME1, attrs);
        factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(false);
        ClientInterestNotifyDUnitTest.createPool2(host, factory, port);
        ClientInterestNotifyDUnitTest clientInterestNotifyDUnitTest2 = test;
        clientInterestNotifyDUnitTest2.getClass();
        factory.setCacheListener((CacheListener)clientInterestNotifyDUnitTest2.new EventListener(name + REGION_NAME2));
        attrs = factory.create();
        cacheClient.createRegion(REGION_NAME2, attrs);
        factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(false);
        ClientInterestNotifyDUnitTest.createPool2(host, factory, port);
        ClientInterestNotifyDUnitTest clientInterestNotifyDUnitTest3 = test;
        clientInterestNotifyDUnitTest3.getClass();
        factory.setCacheListener((CacheListener)clientInterestNotifyDUnitTest3.new EventListener(name + REGION_NAME3));
        attrs = factory.create();
        cacheClient.createRegion(REGION_NAME3, attrs);
    }

    public static void createClientCacheFeeder(String host, Integer port) throws Exception {
        ClientInterestNotifyDUnitTest test = new ClientInterestNotifyDUnitTest("temp");
        Cache cacheFeeder = test.createCache(ClientInterestNotifyDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(false);
        ClientInterestNotifyDUnitTest.createPool2(host, factory, port);
        RegionAttributes attrs = factory.create();
        cacheFeeder.createRegion(REGION_NAME1, attrs);
        cacheFeeder.createRegion(REGION_NAME2, attrs);
        cacheFeeder.createRegion(REGION_NAME3, attrs);
    }

    public static void assertAllQueuesEmpty() {
        Iterator servers = cacheServer.getBridgeServers().iterator();
        ClientInterestNotifyDUnitTest.assertTrue((String)"No servers found!", (boolean)servers.hasNext());
        while (servers.hasNext()) {
            Iterator proxies = ((BridgeServerImpl)servers.next()).getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
            ClientInterestNotifyDUnitTest.assertTrue((String)"No proxies found!", (boolean)proxies.hasNext());
            while (proxies.hasNext()) {
                int qsize = ((CacheClientProxy)proxies.next()).getQueueSize();
                ClientInterestNotifyDUnitTest.assertTrue((String)("Queue size expected to be zero but is " + qsize), (qsize == 0 ? 1 : 0) != 0);
            }
        }
    }

    public static void waitForQueuesToDrain() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                BridgeServerImpl bridgeServer = (BridgeServerImpl)cacheServer.getBridgeServers().iterator().next();
                if (bridgeServer == null) {
                    this.excuse = "No Cache Server";
                    return false;
                }
                Iterator proxies = bridgeServer.getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
                if (!proxies.hasNext()) {
                    this.excuse = "No CacheClientProxy";
                    return false;
                }
                while (proxies.hasNext()) {
                    CacheClientProxy proxy = (CacheClientProxy)proxies.next();
                    if (proxy == null) {
                        this.excuse = "No CacheClientProxy";
                        return false;
                    }
                    int sz = proxy.getQueueSize();
                    if (0 == sz) continue;
                    this.excuse = "Queue did not drain. Expected size = 0, actual = " + sz + "for " + proxy;
                    return false;
                }
                return true;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public static Integer createServerCache() throws Exception {
        ClientInterestNotifyDUnitTest test = new ClientInterestNotifyDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("delta-propagation", "false");
        cacheServer = test.createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setConcurrencyChecksEnabled(false);
        RegionAttributes attrs = factory.create();
        cacheServer.createRegion(REGION_NAME1, attrs);
        cacheServer.createRegion(REGION_NAME2, attrs);
        cacheServer.createRegion(REGION_NAME3, attrs);
        BridgeServer server = cacheServer.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.setSocketBufferSize(32768);
        server.start();
        return new Integer(server.getPort());
    }

    public static void closeCache() {
        GemFireCacheImpl cacheClient = GemFireCacheImpl.getInstance();
        if (cacheClient != null && !cacheClient.isClosed()) {
            cacheClient.close();
            cacheClient.getDistributedSystem().disconnect();
        }
    }

    public static void closeCacheServer() {
        if (cacheServer != null && !cacheServer.isClosed()) {
            cacheServer.close();
            cacheServer.getDistributedSystem().disconnect();
        }
    }

    public static void registerInterest() {
        try {
            GemFireCacheImpl cacheClient = GemFireCacheImpl.getInstance();
            Region region1 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region1");
            Region region2 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region2");
            Region region3 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region3");
            ClientInterestNotifyDUnitTest.assertTrue((region1 != null ? 1 : 0) != 0);
            ClientInterestNotifyDUnitTest.assertTrue((region2 != null ? 1 : 0) != 0);
            ClientInterestNotifyDUnitTest.assertTrue((region3 != null ? 1 : 0) != 0);
            region1.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES, false, true);
            region2.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES, false, false);
        }
        catch (CacheWriterException e) {
            ClientInterestNotifyDUnitTest.fail((String)("test failed due to " + (Object)((Object)e)));
        }
    }

    public static void unregisterInterest() {
        try {
            GemFireCacheImpl cacheClient = GemFireCacheImpl.getInstance();
            Region region1 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region1");
            Region region2 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region2");
            region1.unregisterInterest((Object)"ALL_KEYS");
            region2.unregisterInterest((Object)"ALL_KEYS");
        }
        catch (CacheWriterException e) {
            ClientInterestNotifyDUnitTest.fail((String)("test failed due to " + (Object)((Object)e)));
        }
    }

    public static void doEntryOps() {
        try {
            ClientInterestNotifyDUnitTest.getLogWriter().info("Putting entries...");
            GemFireCacheImpl cacheClient = GemFireCacheImpl.getInstance();
            Region r1 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region1");
            Region r2 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region2");
            Region r3 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region3");
            r1.put((Object)"key-1", (Object)"11");
            r2.put((Object)"key-1", (Object)"11");
            r3.put((Object)"key-1", (Object)"11");
            r1.put((Object)"key-1", (Object)"22");
            r2.put((Object)"key-1", (Object)"22");
            r3.put((Object)"key-1", (Object)"22");
            r1.invalidate((Object)"key-1");
            r2.invalidate((Object)"key-1");
            r3.invalidate((Object)"key-1");
            r1.destroy((Object)"key-1");
            r2.destroy((Object)"key-1");
            r3.destroy((Object)"key-1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientInterestNotifyDUnitTest.fail("failed while region doing ops", ex);
        }
    }

    public static void doFeed() {
        try {
            ClientInterestNotifyDUnitTest.getLogWriter().info("Putting entries...");
            GemFireCacheImpl cacheClient = GemFireCacheImpl.getInstance();
            Region r1 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region1");
            Region r2 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region2");
            Region r3 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region3");
            r1.put((Object)"key-1", (Object)"00");
            r2.put((Object)"key-1", (Object)"00");
            r3.put((Object)"key-1", (Object)"00");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientInterestNotifyDUnitTest.fail("failed while region doing ops", ex);
        }
    }

    public static void getEntries() {
        try {
            ClientInterestNotifyDUnitTest.getLogWriter().info("Getting entries...");
            GemFireCacheImpl cacheClient = GemFireCacheImpl.getInstance();
            Region r3 = cacheClient.getRegion("/ClientInterestNotifyDUnitTest_region3");
            r3.get((Object)"key-1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientInterestNotifyDUnitTest.fail("failed while region doing ops", ex);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.vm0.invoke(ClientInterestNotifyDUnitTest.class, "closeCache");
        this.vm1.invoke(ClientInterestNotifyDUnitTest.class, "closeCache");
        ClientInterestNotifyDUnitTest.closeCacheServer();
    }

    static {
        poolNameCounter = 0;
    }

    class EventListener
    extends CacheListenerAdapter {
        private String m_name = null;
        private int m_creates = 0;
        private int m_updates = 0;
        private int m_invalidates = 0;
        private int m_destroys = 0;

        public EventListener(String name) {
            this.m_name = name;
        }

        public void afterCreate(EntryEvent event) {
            ++this.m_creates;
        }

        public void afterUpdate(EntryEvent event) {
            ++this.m_updates;
        }

        public void afterInvalidate(EntryEvent event) {
            ++this.m_invalidates;
        }

        public void afterDestroy(EntryEvent event) {
            ++this.m_destroys;
        }

        public void reset() {
            this.m_creates = 0;
            this.m_updates = 0;
            this.m_invalidates = 0;
            this.m_destroys = 0;
        }

        public void validate(int creates, int updates, int invalidates, int destroys) {
            GemFireCacheImpl.getInstance().getLogger().info(this.m_name + ": creates: expected=" + creates + ", actual=" + this.m_creates);
            GemFireCacheImpl.getInstance().getLogger().info(this.m_name + ": updates: expected=" + updates + ", actual=" + this.m_updates);
            GemFireCacheImpl.getInstance().getLogger().info(this.m_name + ": invalidates: expected=" + invalidates + ", actual=" + this.m_invalidates);
            GemFireCacheImpl.getInstance().getLogger().info(this.m_name + ": destroys: expected=" + destroys + ", actual=" + this.m_destroys);
            TestCase.assertEquals((int)creates, (int)this.m_creates);
            TestCase.assertEquals((int)updates, (int)this.m_updates);
            TestCase.assertEquals((int)invalidates, (int)this.m_invalidates);
            TestCase.assertEquals((int)destroys, (int)this.m_destroys);
        }
    }
}

