/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CqListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;

public class ClientToServerDeltaDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static LogWriterI18n logger = null;
    VM server = null;
    VM server2 = null;
    VM client = null;
    VM client2 = null;
    private static final String KEY1 = "DELTA_KEY_1";
    private static final String REGION_NAME = "ClientToServerDeltaDunitTest_region";
    private static final int NO_PUT_OPERATION = 3;
    private static PoolImpl pool;
    private static Object[] putDelta;
    private static int updates;
    private static int cqUpdates;
    private static int create;
    private static Object firstUpdate;
    private static Object secondUpdate;
    private static Boolean error;
    private static boolean lastKeyReceived;
    private static Region region;
    private static CSDeltaTestImpl csDelta;
    public static String DELTA_KEY;
    private static final String[] CQs;
    public static String LAST_KEY;

    public ClientToServerDeltaDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        ClientToServerDeltaDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.server = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client = host.getVM(2);
        this.client2 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DeltaTestImpl.resetDeltaInvokationCounters();
        this.server.invoke(DeltaTestImpl.class, "resetDeltaInvokationCounters");
        this.server2.invoke(DeltaTestImpl.class, "resetDeltaInvokationCounters");
        this.client.invoke(DeltaTestImpl.class, "resetDeltaInvokationCounters");
        this.client2.invoke(DeltaTestImpl.class, "resetDeltaInvokationCounters");
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "closeCache");
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "closeCache");
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "closeCache");
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "closeCache");
    }

    public void initialise(Boolean cq) {
        this.initialise(Boolean.TRUE, null, cq, Boolean.TRUE, Boolean.TRUE);
    }

    public void initialise(Boolean clone, String[] queries, Boolean cq, Boolean RI, Boolean enableDelta) {
        Integer PORT1 = (int)((Integer)this.server.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.TRUE, Boolean.FALSE, clone, enableDelta}));
        Integer PORT2 = (int)((Integer)this.server2.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.TRUE, Boolean.FALSE, clone, enableDelta}));
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE});
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server2.getHost()), new Integer(PORT2), Boolean.TRUE, Boolean.FALSE, cq, queries, RI});
    }

    public void initialise2(Boolean clone, String[] queries, Boolean cq, Boolean RI, Boolean enableDelta) {
        Integer PORT1 = (int)((Integer)this.server.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.FALSE, clone, enableDelta}));
        Integer PORT2 = (int)((Integer)this.server2.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.FALSE, clone, enableDelta}));
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE});
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server2.getHost()), new Integer(PORT2), Boolean.TRUE, Boolean.FALSE, cq, queries, RI});
    }

    public void testSendingofFullDeltaObjectsWhenFromDeltaFails() {
        this.initialise(false);
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "setFirstSecondUpdate", new Object[]{putDelta[1], (Integer)putDelta[2]});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putWithFromDeltaERR", new Object[]{KEY1});
        ClientToServerDeltaDUnitTest.assertTrue((String)"to Delta Propagation feature NOT used.", (boolean)((Boolean)this.client.invoke(DeltaTestImpl.class, "toDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertTrue((String)"from Delta Propagation feature NOT used.", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "fromDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"Delta Propagation toDeltaFailed", (boolean)((Boolean)this.client.invoke(DeltaTestImpl.class, "isToDeltaFailure")));
        ClientToServerDeltaDUnitTest.assertTrue((String)"Delta Propagation fromDelta not Failed", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "isFromDeltaFailure")));
        boolean err = (Boolean)this.server.invoke(ClientToServerDeltaDUnitTest.class, "getError");
        ClientToServerDeltaDUnitTest.assertFalse((String)"validation fails", (boolean)err);
    }

    public void testPutForDeltaObjects() {
        this.initialise(false);
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "setFirstSecondUpdate", new Object[]{putDelta[0], (Integer)putDelta[2]});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "put", new Object[]{KEY1});
        ClientToServerDeltaDUnitTest.assertTrue((String)"to Delta Propagation feature NOT used.", (boolean)((Boolean)this.client.invoke(DeltaTestImpl.class, "toDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertTrue((String)"from Delta Propagation feature NOT used.", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "fromDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"Delta Propagation toDeltaFailed", (boolean)((Boolean)this.client.invoke(DeltaTestImpl.class, "isToDeltaFailure")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"Delta Propagation fromDeltaFailed", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "isFromDeltaFailure")));
        boolean err = (Boolean)this.server.invoke(ClientToServerDeltaDUnitTest.class, "getError");
        ClientToServerDeltaDUnitTest.assertFalse((String)"validation fails", (boolean)err);
    }

    public void testClientToClientDeltaPropagation() throws Exception {
        this.initialise(false);
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "setFirstSecondUpdate", new Object[]{putDelta[0], (Integer)putDelta[2]});
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "setFirstSecondUpdate", new Object[]{putDelta[0], (Integer)putDelta[2]});
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "setFirstSecondUpdate", new Object[]{putDelta[0], (Integer)putDelta[2]});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putDelta", new Object[]{KEY1});
        Thread.sleep(5000L);
        ClientToServerDeltaDUnitTest.assertTrue((String)"To Delta Propagation feature NOT used.", (boolean)((Boolean)this.client.invoke(DeltaTestImpl.class, "toDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertTrue((String)"From Delta Propagation feature NOT used.", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "fromDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"To Delta Propagation feature used.", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "toDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertTrue((String)"From Delta Propagation feature NOT used.", (boolean)((Boolean)this.server2.invoke(DeltaTestImpl.class, "fromDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"To Delta Propagation feature used.", (boolean)((Boolean)this.server2.invoke(DeltaTestImpl.class, "toDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertTrue((String)"from Delta Propagation feature NOT used.", (boolean)((Boolean)this.client2.invoke(DeltaTestImpl.class, "fromDeltaFeatureUsed")));
        boolean err = (Boolean)this.server.invoke(ClientToServerDeltaDUnitTest.class, "getError");
        err = (Boolean)this.server2.invoke(ClientToServerDeltaDUnitTest.class, "getError");
        err = (Boolean)this.client2.invoke(ClientToServerDeltaDUnitTest.class, "getError");
        ClientToServerDeltaDUnitTest.assertFalse((String)"validation fails", (boolean)err);
    }

    private static void putDeltaForCQ(String key, Integer numOfPuts, Integer[] cqIndices, Boolean[] satisfyQuery) {
        Region region = cache.getRegion(REGION_NAME);
        DeltaTestImpl val = null;
        for (int j = 0; j < numOfPuts; ++j) {
            val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
            block7: for (int i = 0; i < cqIndices.length; ++i) {
                switch (i) {
                    case 0: {
                        val.setStr("CASE_0");
                        continue block7;
                    }
                    case 1: {
                        val.setStr("CASE_1");
                        if (satisfyQuery[i].booleanValue()) {
                            val.setIntVar(0);
                            continue block7;
                        }
                        val.setIntVar(100);
                        continue block7;
                    }
                    case 2: {
                        val.setStr("CASE_2");
                        if (satisfyQuery[i].booleanValue()) {
                            val.setIntVar(100);
                            continue block7;
                        }
                        val.setIntVar(-100);
                        continue block7;
                    }
                    case 3: {
                        val.setStr("CASE_3");
                        if (satisfyQuery[i].booleanValue()) {
                            val.setIntVar(-100);
                            continue block7;
                        }
                        val.setIntVar(100);
                        continue block7;
                    }
                }
            }
            region.put((Object)key, (Object)val);
        }
    }

    private static void putDelta(String key) {
        Region r = cache.getRegion(REGION_NAME);
        DeltaTestImpl val = null;
        for (int i = 0; i < 3; ++i) {
            val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
            switch (i) {
                case 1: {
                    val.setStr((String)putDelta[0]);
                    break;
                }
                case 2: {
                    val.setIntVar(((Integer)putDelta[2]).intValue());
                }
            }
            r.put((Object)key, (Object)val);
        }
    }

    private static void putLastKey() {
        Region r = cache.getRegion(REGION_NAME);
        r.put((Object)LAST_KEY, (Object)LAST_KEY);
    }

    private static void putLastKeyWithDelta() {
        Region r = cache.getRegion(REGION_NAME);
        r.put((Object)LAST_KEY, (Object)new DeltaTestImpl());
    }

    private static void setFirstSecondUpdate(Object first, Object second) {
        firstUpdate = first;
        secondUpdate = second;
    }

    private static Boolean getError() {
        return error;
    }

    private static void put(String key) {
        Region r = cache.getRegion(REGION_NAME);
        DeltaTestImpl val = null;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    break;
                }
                case 1: {
                    val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    val.setStr((String)putDelta[0]);
                    break;
                }
                case 2: {
                    val = new DeltaTestImpl(0, (String)putDelta[1], new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    val.setIntVar(((Integer)putDelta[2]).intValue());
                }
            }
            r.put((Object)key, val);
        }
    }

    private static void putWithFromDeltaERR(String key) {
        Region r = cache.getRegion(REGION_NAME);
        DeltaTestImpl val = null;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    break;
                }
                case 1: {
                    val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    val.setStr((String)putDelta[1]);
                    break;
                }
                case 2: {
                    val = new DeltaTestImpl(0, (String)putDelta[1], new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    val.setIntVar(((Integer)putDelta[2]).intValue());
                }
            }
            r.put((Object)key, val);
        }
    }

    private static void putWithTODeltaERR(String key) {
        Region r = cache.getRegion(REGION_NAME);
        DeltaTestImpl val = null;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    break;
                }
                case 1: {
                    val = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    val.setIntVar(((Integer)putDelta[3]).intValue());
                    break;
                }
                case 2: {
                    val = new DeltaTestImpl(((Integer)putDelta[3]).intValue(), "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
                    val.setStr((String)putDelta[0]);
                }
            }
            r.put((Object)key, val);
        }
    }

    public static Integer createServerCache(Boolean attachListener, Boolean isEmpty) throws Exception {
        return ClientToServerDeltaDUnitTest.createServerCache(attachListener, isEmpty, Boolean.TRUE, Boolean.TRUE);
    }

    public static Integer createServerCache(Boolean attachListener, Boolean isEmpty, Boolean clone, Boolean enableDelta) throws Exception {
        updates = 0;
        create = 0;
        firstUpdate = null;
        secondUpdate = null;
        error = false;
        Properties props = new Properties();
        props.setProperty("delta-propagation", enableDelta.toString());
        new ClientToServerDeltaDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setConcurrencyChecksEnabled(true);
        if (isEmpty.booleanValue()) {
            factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
            factory.setDataPolicy(DataPolicy.EMPTY);
        } else {
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        factory.setCloningEnabled(clone.booleanValue());
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(REGION_NAME, attrs);
        AttributesMutator am = region.getAttributesMutator();
        if (attachListener.booleanValue()) {
            am.addCacheListener((CacheListener)new CacheListenerAdapter(){

                public void afterCreate(EntryEvent event) {
                    create++;
                }

                public void afterUpdate(EntryEvent event) {
                    switch (updates) {
                        case 0: {
                            ClientToServerDeltaDUnitTest.validateUpdates(event, firstUpdate, "FIRST");
                            updates++;
                            break;
                        }
                        case 1: {
                            ClientToServerDeltaDUnitTest.validateUpdates(event, firstUpdate, "FIRST");
                            ClientToServerDeltaDUnitTest.validateUpdates(event, secondUpdate, "SECOND");
                            updates++;
                            break;
                        }
                    }
                }
            });
        } else if (!isEmpty.booleanValue()) {
            am.addCacheListener((CacheListener)new CacheListenerAdapter(){

                public void afterCreate(EntryEvent event) {
                    switch (create) {
                        case 1: {
                            ClientToServerDeltaDUnitTest.validateUpdates(event, firstUpdate, "FIRST");
                            create++;
                            break;
                        }
                        case 2: {
                            ClientToServerDeltaDUnitTest.validateUpdates(event, secondUpdate, "SECOND");
                            create++;
                            break;
                        }
                        default: {
                            create++;
                        }
                    }
                }
            });
        }
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache(String host, Integer port, Boolean attachListener, Boolean isEmpty, Boolean isCq) throws Exception {
        ClientToServerDeltaDUnitTest.createClientCache(host, port, attachListener, isEmpty, isCq, new String[0], true);
    }

    public static void createClientCache(String host, Integer port, Boolean attachListener, Boolean isEmpty, Boolean isCq, String[] cqQueryString) throws Exception {
        ClientToServerDeltaDUnitTest.createClientCache(host, port, attachListener, isEmpty, isCq, cqQueryString, true);
    }

    public static void createClientCache(String host, Integer port, Boolean attachListener, Boolean isEmpty, Boolean isCq, String[] cqQueryString, Boolean registerInterestAll) throws Exception {
        ClientToServerDeltaDUnitTest.createClientCache(host, port, attachListener, isEmpty, isCq, cqQueryString, registerInterestAll, true);
    }

    public static void createClientCache(String host, Integer port, Boolean attachListener, Boolean isEmpty, Boolean isCq, String[] cqQueryString, Boolean registerInterestAll, Boolean enableSubscription) throws Exception {
        updates = 0;
        create = 0;
        firstUpdate = null;
        secondUpdate = null;
        error = false;
        lastKeyReceived = false;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new ClientToServerDeltaDUnitTest("temp").createCache(props);
        pool = (PoolImpl)PoolManager.createFactory().addServer(host, port.intValue()).setThreadLocalConnections(true).setMinConnections(2).setSubscriptionEnabled(enableSubscription.booleanValue()).setSubscriptionRedundancy(0).setReadTimeout(10000).setPingInterval(1000L).setSocketBufferSize(32768).create("ClientToServerDeltaDunitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setConcurrencyChecksEnabled(true);
        if (isEmpty.booleanValue()) {
            factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
            factory.setDataPolicy(DataPolicy.EMPTY);
        } else {
            factory.setDataPolicy(DataPolicy.NORMAL);
        }
        factory.setPoolName(pool.getName());
        factory.setCloningEnabled(false);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(REGION_NAME, attrs);
        if (attachListener.booleanValue()) {
            region.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter(){

                public void afterCreate(EntryEvent event) {
                    create++;
                    if (LAST_KEY.equals(event.getKey())) {
                        lastKeyReceived = true;
                    }
                }

                public void afterUpdate(EntryEvent event) {
                    switch (updates) {
                        case 0: {
                            ClientToServerDeltaDUnitTest.validateUpdates(event, firstUpdate, "FIRST");
                            updates++;
                            break;
                        }
                        case 1: {
                            ClientToServerDeltaDUnitTest.validateUpdates(event, firstUpdate, "FIRST");
                            ClientToServerDeltaDUnitTest.validateUpdates(event, secondUpdate, "SECOND");
                            updates++;
                            break;
                        }
                    }
                }
            });
        }
        if (registerInterestAll.booleanValue()) {
            region.registerInterest((Object)"ALL_KEYS");
        }
        if (isCq.booleanValue()) {
            CqAttributesFactory cqf = new CqAttributesFactory();
            CqListenerAdapter cqlist = new CqListenerAdapter(){

                public void onEvent(CqEvent cqEvent) {
                    Object key = cqEvent.getKey();
                    if (LAST_KEY.equals(key)) {
                        lastKeyReceived = true;
                    }
                    logger.fine("CQ event received for (key, value): (" + key + ", " + cqEvent.getNewValue() + ")");
                }

                public void onError(CqEvent cqEvent) {
                    logger.fine("CQ error received for key: " + cqEvent.getKey());
                }
            };
            cqf.addCqListener((CqListener)cqlist);
            CqAttributes cqa = cqf.create();
            for (int i = 0; i < cqQueryString.length; ++i) {
                CqQuery cq = cache.getQueryService().newCq("Delta_Query_" + i, cqQueryString[i], cqa);
                cq.execute();
            }
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        ClientToServerDeltaDUnitTest.assertNotNull((Object)cache);
        logger = cache.getLoggerI18n();
    }

    private static void validateUpdates(EntryEvent event, Object obj, String str) {
        if (obj instanceof String) {
            ClientToServerDeltaDUnitTest.assertTrue((String)(str + " update missed "), (boolean)((DeltaTestImpl)event.getNewValue()).getStr().equals((String)obj));
        } else if (obj instanceof Integer) {
            ClientToServerDeltaDUnitTest.assertTrue((String)(str + " update missed "), (((DeltaTestImpl)event.getNewValue()).getIntVar() == ((Integer)obj).intValue() ? 1 : 0) != 0);
        } else {
            error = true;
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
            lastKeyReceived = false;
        }
    }

    public void testEmptyClientAsFeederToServer() {
        Integer PORT1 = (int)((Integer)this.server.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.FALSE}));
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.FALSE});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), Boolean.FALSE, Boolean.TRUE, Boolean.FALSE});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putDelta", new Object[]{KEY1});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "checkTodeltaCounter", new Object[]{new Integer(2)});
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "checkFromdeltaCounter");
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "checkTodeltaCounter", new Object[]{new Integer(0)});
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "checkFromdeltaCounter");
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "checkTodeltaCounter", new Object[]{new Integer(0)});
    }

    public void testEmptyServerAsFeederToPeer() {
        Integer PORT1 = (int)((Integer)this.server.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.TRUE}));
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.FALSE});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), Boolean.FALSE, Boolean.TRUE, Boolean.FALSE});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putDelta", new Object[]{KEY1});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "checkTodeltaCounter", new Object[]{new Integer(2)});
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "checkDeltaFeatureNotUsed");
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "checkTodeltaCounter", new Object[]{new Integer(0)});
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "checkFromdeltaCounter");
    }

    public void testClientsConnectedToEmptyServer() {
        Integer PORT1 = (int)((Integer)this.server.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.TRUE}));
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.FALSE});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), Boolean.TRUE, Boolean.FALSE, Boolean.FALSE});
        int deltaSent = (Integer)this.server2.invoke(ClientToServerDeltaDUnitTest.class, "putsWhichReturnsDeltaSent");
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "waitForLastKey");
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "checkForDelta");
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "waitForLastKey");
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "checkDeltaInvoked", new Object[]{new Integer(deltaSent)});
    }

    public void testClientNonEmptyEmptyServerAsFeederToPeer() {
        Integer PORT1 = (int)((Integer)this.server.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.TRUE}));
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE, Boolean.FALSE});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createClientCache", new Object[]{ClientToServerDeltaDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putDelta", new Object[]{KEY1});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "checkTodeltaCounter", new Object[]{new Integer(2)});
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "checkDeltaFeatureNotUsed");
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "checkTodeltaCounter", new Object[]{new Integer(0)});
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "checkFromdeltaCounter");
    }

    public void testC2CDeltaPropagationWithCQ() throws Exception {
        this.initialise(false, new String[]{CQs[1]}, true, true, true);
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createKeys", new Object[]{new String[]{KEY1}});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putDeltaForCQ", new Object[]{KEY1, new Integer(1), new Integer[]{1}, new Boolean[]{false, true, false, false}});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putLastKeyWithDelta");
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "waitForLastKey");
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "verifyDeltaReceived");
    }

    public void testC2CDeltaPropagationWithCQWithoutRI() throws Exception {
        this.initialise(false, new String[]{CQs[1]}, true, false, true);
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "createKeys", new Object[]{new String[]{KEY1}});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putDeltaForCQ", new Object[]{KEY1, new Integer(1), new Integer[]{1}, new Boolean[]{false, true, false, false}});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putLastKeyWithDelta");
        this.client2.invoke(ClientToServerDeltaDUnitTest.class, "waitForLastKey");
        this.server2.invoke(ClientToServerDeltaDUnitTest.class, "verifyDeltaSent", new Object[]{1});
    }

    public void testClientSendsFullValueToServerWhenDeltaOffAtServer() {
        this.initialise2(false, new String[]{CQs[1]}, false, true, false);
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "setFirstSecondUpdate", new Object[]{putDelta[0], (Integer)putDelta[2]});
        this.client.invoke(ClientToServerDeltaDUnitTest.class, "putDelta", new Object[]{DELTA_KEY});
        ClientToServerDeltaDUnitTest.assertFalse((String)"Delta Propagation feature used at client.", (boolean)((Boolean)this.client.invoke(DeltaTestImpl.class, "toDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"Delta Propagation feature used at server.", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "fromDeltaFeatureUsed")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"Failures at client while calculating delta. But delta-propagation is false at server.", (boolean)((Boolean)this.client.invoke(DeltaTestImpl.class, "isToDeltaFailure")));
        ClientToServerDeltaDUnitTest.assertFalse((String)"Failures at server while applying delta. But delta-propagation is false at server.", (boolean)((Boolean)this.server.invoke(DeltaTestImpl.class, "isFromDeltaFailure")));
    }

    public void testC2SDeltaPropagationWithOldValueInvalidatedAtServer() throws Exception {
        String key = "DELTA_KEY";
        Integer port1 = (Integer)this.server.invoke(ClientToServerDeltaDUnitTest.class, "createServerCache", new Object[]{false, false, false, true});
        ClientToServerDeltaDUnitTest.createClientCache("localhost", port1, false, false, false, null, false, false);
        LocalRegion region = (LocalRegion)cache.getRegion(REGION_NAME);
        region.put((Object)key, (Object)new DeltaTestImpl());
        this.server.invoke(ClientToServerDeltaDUnitTest.class, "doInvalidate", new Object[]{key});
        DeltaTestImpl value = new DeltaTestImpl();
        value.setStr("UPDATED_VALUE");
        region.put((Object)key, (Object)value);
        ClientToServerDeltaDUnitTest.assertTrue((region.getCachePerfStats().getDeltasSent() == 1 ? 1 : 0) != 0);
        ClientToServerDeltaDUnitTest.assertTrue((region.getCachePerfStats().getDeltaFullValuesSent() == 1 ? 1 : 0) != 0);
    }

    public static void doInvalidate(String key) {
        Region region = cache.getRegion(REGION_NAME);
        region.invalidate((Object)key);
    }

    public static void verifyDeltaReceived() {
        ClientToServerDeltaDUnitTest.assertTrue((String)("Expected 1 fromDelta() invokation but was " + DeltaTestImpl.getFromDeltaInvokations()), (DeltaTestImpl.getFromDeltaInvokations() == 1L ? 1 : 0) != 0);
    }

    public static void verifyDeltaSent(Integer deltas) {
        CacheClientNotifier ccn = ((BridgeServerImpl)cache.getCacheServers().toArray()[0]).getAcceptor().getCacheClientNotifier();
        int numOfDeltasSent = ((CacheClientProxy)ccn.getClientProxies().toArray()[0]).getStatistics().getDeltaMessagesSent();
        ClientToServerDeltaDUnitTest.assertTrue((String)("Expected " + deltas + " deltas to be sent but " + numOfDeltasSent + " were sent."), (numOfDeltasSent == deltas ? 1 : 0) != 0);
    }

    public static void checkFromdeltaCounter() {
        ClientToServerDeltaDUnitTest.assertTrue((String)("FromDelta counters do not match, expected: 2, actual: " + DeltaTestImpl.getFromDeltaInvokations()), (DeltaTestImpl.getFromDeltaInvokations() >= 2L ? 1 : 0) != 0);
    }

    public static void checkTodeltaCounter(Integer count) {
        ClientToServerDeltaDUnitTest.assertTrue((String)("ToDelta counters do not match, expected: " + count + ", actual: " + DeltaTestImpl.getToDeltaInvokations()), (DeltaTestImpl.getToDeltaInvokations() >= (long)count.intValue() ? 1 : 0) != 0);
    }

    public static void checkDeltaFeatureNotUsed() {
        ClientToServerDeltaDUnitTest.assertTrue((String)"Delta Propagation feature used.", (DeltaTestImpl.deltaFeatureUsed() == false ? 1 : 0) != 0);
    }

    public static void createKeys(String[] keys) {
        Region region = cache.getRegion(REGION_NAME);
        for (int i = 0; i < keys.length; ++i) {
            region.create((Object)keys[i], (Object)new DeltaTestImpl());
        }
    }

    public static int putsWhichReturnsDeltaSent() throws Exception {
        csDelta = new CSDeltaTestImpl();
        region.put((Object)DELTA_KEY, (Object)csDelta);
        for (int i = 0; i < 3; ++i) {
            csDelta.setIntVar(i);
            region.put((Object)DELTA_KEY, (Object)csDelta);
        }
        region.put((Object)LAST_KEY, (Object)"");
        return ClientToServerDeltaDUnitTest.csDelta.deltaSent;
    }

    public static void checkDeltaInvoked(Integer deltaSent) {
        ClientToServerDeltaDUnitTest.assertTrue((String)("Delta applied :" + ((CSDeltaTestImpl)((Object)region.get((Object)DELTA_KEY))).getDeltaApplied() + "\n Delta sent :" + deltaSent), (((CSDeltaTestImpl)((Object)region.get((Object)DELTA_KEY))).getDeltaApplied() == deltaSent.intValue() ? 1 : 0) != 0);
    }

    public static void checkForDelta() {
        ClientToServerDeltaDUnitTest.assertTrue((String)"Delta sent to EMPTY data policy region", (DeltaTestImpl.getFromDeltaInvokations() == 0L ? 1 : 0) != 0);
    }

    public static void waitForLastKey() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return lastKeyReceived;
            }

            @Override
            public String description() {
                return "Last key NOT received.";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
    }

    static {
        putDelta = new Object[]{"Anil", "ERRONEOUS_STRING", 100, -101};
        updates = 0;
        cqUpdates = 0;
        create = 0;
        firstUpdate = null;
        secondUpdate = null;
        lastKeyReceived = false;
        region = null;
        csDelta = null;
        DELTA_KEY = "DELTA_KEY";
        CQs = new String[]{"select * from /ClientToServerDeltaDunitTest_region", "select * from /ClientToServerDeltaDunitTest_region where intVar = 0", "select * from /ClientToServerDeltaDunitTest_region where intVar > 0", "select * from /ClientToServerDeltaDunitTest_region where intVar < 0"};
        LAST_KEY = "LAST_KEY";
    }

    static class CSDeltaTestImpl
    extends DeltaTestImpl {
        int deltaSent = 0;
        int deltaApplied = 0;

        public void toDelta(DataOutput out) throws IOException {
            super.toDelta(out);
            ++this.deltaSent;
        }

        public void fromDelta(DataInput in) throws IOException {
            super.fromDelta(in);
            ++this.deltaApplied;
        }

        public int getDeltaSent() {
            return this.deltaSent;
        }

        public int getDeltaApplied() {
            return this.deltaApplied;
        }

        public String toString() {
            return "CSDeltaTestImpl[deltaApplied=" + this.deltaApplied + "]" + super.toString();
        }
    }
}

