/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.ha.HAHelper;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.HaHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class ConflationDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm2 = null;
    private static Cache cache = null;
    private static int PORT;
    private static final String REGION_NAME1 = "ConflationDUnitTest_region1";
    private static final String REGION_NAME2 = "ConflationDUnitTest_region2";
    static final String MARKER = "markerKey";
    private static HashMap statMap;
    static volatile int count;
    static volatile int counterCreate;
    static volatile int counterUpdate;
    static volatile int counterDestroy;

    public ConflationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        ConflationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm2 = host.getVM(2);
        PORT = (Integer)this.vm0.invoke(ConflationDUnitTest.class, "createServerCache");
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public static void setIsSlowStart() {
        ConflationDUnitTest.setIsSlowStart("5000");
    }

    public static void setIsSlowStart(String milis) {
        CacheClientProxy.isSlowStartForTesting = true;
        System.setProperty("slowStartTimeForTesting", milis);
    }

    public static void unsetIsSlowStart() {
        CacheClientProxy.isSlowStartForTesting = false;
    }

    public void testTwoRegionsTwoWriters() {
        try {
            this.vm0.invoke(ConflationDUnitTest.class, "setIsSlowStart");
            ConflationDUnitTest.createClientCache1UniqueWriter(ConflationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT));
            this.vm2.invoke(ConflationDUnitTest.class, "createClientCache2UniqueWriter", new Object[]{ConflationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
            this.vm2.invoke(ConflationDUnitTest.class, "setBridgeObserverForBeforeInterestRecovery");
            this.vm2.invoke(ConflationDUnitTest.class, "setAllCountersZero");
            this.vm2.invoke(ConflationDUnitTest.class, "assertAllCountersZero");
            this.vm2.invoke(ConflationDUnitTest.class, "registerInterest");
            ConflationDUnitTest.create();
            ConflationDUnitTest.put();
            ConflationDUnitTest.createMarker();
            this.vm2.invoke(ConflationDUnitTest.class, "waitForMarker");
            this.vm2.invoke(ConflationDUnitTest.class, "assertValue");
            this.vm2.invoke(ConflationDUnitTest.class, "destroyMarker");
            ConflationDUnitTest.destroy();
            ConflationDUnitTest.createMarker();
            this.vm2.invoke(ConflationDUnitTest.class, "waitForMarker");
            this.vm2.invoke(ConflationDUnitTest.class, "assertCounterSizes");
        }
        catch (Exception e) {
            ConflationDUnitTest.fail("Test failed due to exception", e);
        }
    }

    public void testTwoRegionsOneWriter() {
        try {
            this.vm0.invoke(ConflationDUnitTest.class, "setIsSlowStart");
            ConflationDUnitTest.createClientCache1CommonWriter(ConflationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT));
            this.vm2.invoke(ConflationDUnitTest.class, "createClientCache2CommonWriter", new Object[]{ConflationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
            this.vm2.invoke(ConflationDUnitTest.class, "setBridgeObserverForBeforeInterestRecovery");
            this.vm2.invoke(ConflationDUnitTest.class, "setAllCountersZero");
            this.vm2.invoke(ConflationDUnitTest.class, "assertAllCountersZero");
            this.vm2.invoke(ConflationDUnitTest.class, "registerInterest");
            ConflationDUnitTest.create();
            ConflationDUnitTest.put();
            ConflationDUnitTest.createMarker();
            this.vm2.invoke(ConflationDUnitTest.class, "waitForMarker");
            this.vm2.invoke(ConflationDUnitTest.class, "assertValue");
            this.vm2.invoke(ConflationDUnitTest.class, "destroyMarker");
            ConflationDUnitTest.destroy();
            ConflationDUnitTest.createMarker();
            this.vm2.invoke(ConflationDUnitTest.class, "waitForMarker");
            this.vm2.invoke(ConflationDUnitTest.class, "assertCounterSizes");
        }
        catch (Exception e) {
            ConflationDUnitTest.fail("Test failed due to exception", e);
        }
    }

    public void testNotMoreMessagesSent() {
        try {
            this.vm0.invoke(ConflationDUnitTest.class, "setIsSlowStart");
            ConflationDUnitTest.createClientCache1CommonWriterTest3(ConflationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT));
            this.vm2.invoke(ConflationDUnitTest.class, "createClientCache2CommonWriterTest3", new Object[]{ConflationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT)});
            this.vm2.invoke(ConflationDUnitTest.class, "setBridgeObserverForBeforeInterestRecovery");
            this.vm2.invoke(ConflationDUnitTest.class, "setAllCountersZero");
            this.vm2.invoke(ConflationDUnitTest.class, "assertAllCountersZero");
            this.vm2.invoke(ConflationDUnitTest.class, "registerInterest");
            ConflationDUnitTest.create();
            ConflationDUnitTest.put200();
            ConflationDUnitTest.createMarker();
            this.vm2.invoke(ConflationDUnitTest.class, "waitForMarker");
            this.vm2.invoke(ConflationDUnitTest.class, "assertValue");
            this.vm2.invoke(ConflationDUnitTest.class, "destroyMarker");
            ConflationDUnitTest.destroy();
            ConflationDUnitTest.createMarker();
            this.vm2.invoke(ConflationDUnitTest.class, "waitForMarker");
            this.vm2.invoke(ConflationDUnitTest.class, "assertCounterSizesLessThan200");
            this.vm0.invoke(ConflationDUnitTest.class, "getStatsOnServer");
            this.vm0.invoke(ConflationDUnitTest.class, "assertConflationStatus");
        }
        catch (Exception e) {
            ConflationDUnitTest.fail("Test failed due to exception", e);
        }
    }

    private static Properties createProperties1() {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        return props;
    }

    private static Pool createPool(String host, String name, Integer port, boolean enableQueue) {
        return PoolManager.createFactory().addServer(host, port.intValue()).setSubscriptionEnabled(enableQueue).setSubscriptionRedundancy(-1).setReadTimeout(10000).setSocketBufferSize(32768).setMinConnections(3).setThreadLocalConnections(true).create("ConflationUnitTestPool" + name);
    }

    public static void createClientCache1CommonWriter(String host, Integer port) throws Exception {
        ConflationDUnitTest test = new ConflationDUnitTest("temp");
        cache = test.createCache(ConflationDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p1", port, true).getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        cache.createRegion(REGION_NAME2, attrs);
    }

    public static void createClientCache1CommonWriterTest3(String host, Integer port) throws Exception {
        ConflationDUnitTest test = new ConflationDUnitTest("temp");
        cache = test.createCache(ConflationDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p1", port, false).getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        cache.createRegion(REGION_NAME2, attrs);
    }

    public static void createClientCache2CommonWriter(String host, Integer port) throws Exception {
        ConflationDUnitTest test = new ConflationDUnitTest("temp");
        cache = test.createCache(ConflationDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p1", port, true).getName());
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Listener received event " + event);
                String val = (String)event.getNewValue();
                Class<ConflationDUnitTest> clazz = ConflationDUnitTest.class;
                synchronized (ConflationDUnitTest.class) {
                    if (val.equals(ConflationDUnitTest.MARKER)) {
                        ++count;
                    } else {
                        ++counterCreate;
                    }
                    if (2 == count) {
                        ConflationDUnitTest.class.notify();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterUpdate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Listener received event " + event);
                1 var2_2 = this;
                synchronized (var2_2) {
                    ++counterUpdate;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDestroy(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Listener received event " + event);
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (!event.getKey().equals(ConflationDUnitTest.MARKER)) {
                        ++counterDestroy;
                    }
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        cache.createRegion(REGION_NAME2, attrs);
    }

    public static void createClientCache2CommonWriterTest3(String host, Integer port) throws Exception {
        ConflationDUnitTest test = new ConflationDUnitTest("temp");
        cache = test.createCache(ConflationDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p1", port, true).getName());
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Listener received event " + event);
                String val = (String)event.getNewValue();
                Class<ConflationDUnitTest> clazz = ConflationDUnitTest.class;
                synchronized (ConflationDUnitTest.class) {
                    if (val.equals(ConflationDUnitTest.MARKER)) {
                        ++count;
                    } else {
                        ++counterCreate;
                    }
                    if (2 == count) {
                        ConflationDUnitTest.class.notify();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterUpdate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Listener received event " + event);
                2 var2_2 = this;
                synchronized (var2_2) {
                    ++counterUpdate;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDestroy(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Listener received event " + event);
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (!event.getKey().equals(ConflationDUnitTest.MARKER)) {
                        ++counterDestroy;
                    }
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        cache.createRegion(REGION_NAME2, attrs);
    }

    public static void createClientCache1UniqueWriter(String host, Integer port) throws Exception {
        ConflationDUnitTest test = new ConflationDUnitTest("temp");
        cache = test.createCache(ConflationDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p1", port, true).getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p2", port, true).getName());
        attrs = factory.create();
        cache.createRegion(REGION_NAME2, attrs);
    }

    public static void createClientCache2UniqueWriter(String host, Integer port) throws Exception {
        ConflationDUnitTest test = new ConflationDUnitTest("temp");
        cache = test.createCache(ConflationDUnitTest.createProperties1());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p1", port, true).getName());
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCreate(EntryEvent event) {
                String val = (String)event.getNewValue();
                DistributedTestCase.getLogWriter().info("Listener received event " + event);
                Class<ConflationDUnitTest> clazz = ConflationDUnitTest.class;
                synchronized (ConflationDUnitTest.class) {
                    if (val.equals(ConflationDUnitTest.MARKER)) {
                        ++count;
                    } else {
                        ++counterCreate;
                    }
                    if (2 == count) {
                        ConflationDUnitTest.class.notify();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterUpdate(EntryEvent event) {
                3 var2_2 = this;
                synchronized (var2_2) {
                    ++counterUpdate;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDestroy(EntryEvent event) {
                3 var2_2 = this;
                synchronized (var2_2) {
                    if (!event.getKey().equals(ConflationDUnitTest.MARKER)) {
                        ++counterDestroy;
                    }
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        factory.setPoolName(ConflationDUnitTest.createPool(host, "p2", port, true).getName());
        attrs = factory.create();
        cache.createRegion(REGION_NAME2, attrs);
    }

    public static void assertAllCountersZero() {
        ConflationDUnitTest.assertEquals((int)count, (int)0);
        ConflationDUnitTest.assertEquals((int)counterCreate, (int)0);
        ConflationDUnitTest.assertEquals((int)counterUpdate, (int)0);
        ConflationDUnitTest.assertEquals((int)counterDestroy, (int)0);
    }

    public static void setAllCountersZero() {
        count = 0;
        counterCreate = 0;
        counterUpdate = 0;
        counterDestroy = 0;
    }

    public static void setBridgeObserverForBeforeInterestRecovery() {
        PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void beforeInterestRecovery() {
                ConflationDUnitTest.setAllCountersZero();
            }
        });
    }

    public static void assertCounterSizes() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterCreate == 2;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterUpdate == 2;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterDestroy == 2;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    public static void assertCounterSizesLessThan200() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterCreate == 2;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterDestroy == 2;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Thread.yield();
                return counterUpdate <= 200;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForMarker() {
        cache.getRegion("/ConflationDUnitTest_region1");
        cache.getRegion("/ConflationDUnitTest_region2");
        long giveUpTime = System.currentTimeMillis() + 30000L;
        Class<ConflationDUnitTest> clazz = ConflationDUnitTest.class;
        synchronized (ConflationDUnitTest.class) {
            while (count != 2) {
                if (System.currentTimeMillis() > giveUpTime) {
                    ConflationDUnitTest.assertTrue((String)("Count (" + count + ") failed to reach 2"), (count == 2 ? 1 : 0) != 0);
                }
                try {
                    ConflationDUnitTest.class.wait(1000L);
                }
                catch (InterruptedException e) {
                    ConflationDUnitTest.fail((String)"interrupted");
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public static void assertValue() {
        try {
            Region r1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region r2 = cache.getRegion("/ConflationDUnitTest_region2");
            ConflationDUnitTest.assertTrue((boolean)r1.containsKey((Object)"key-1"));
            ConflationDUnitTest.assertTrue((boolean)r1.get((Object)"key-1").equals("33"));
            ConflationDUnitTest.assertTrue((boolean)r2.containsKey((Object)"key-1"));
            ConflationDUnitTest.assertTrue((boolean)r2.get((Object)"key-1").equals("33"));
        }
        catch (Exception e) {
            ConflationDUnitTest.fail((String)("Exception in trying to get due to " + e));
        }
    }

    public static void assertConflationStatus() {
        ConflationDUnitTest.assertNotNull((Object)statMap);
        Long confCount = (Long)statMap.get("eventsConflated");
        ConflationDUnitTest.assertTrue((String)("No Conflation found: eventsConflated value is " + confCount), (confCount > 0L ? 1 : 0) != 0);
        ConflationDUnitTest.assertTrue((String)("Error in Conflation found: eventsConflated value is " + confCount), (confCount <= 200L ? 1 : 0) != 0);
    }

    public static Integer createServerCache() throws Exception {
        ConflationDUnitTest test = new ConflationDUnitTest("temp");
        cache = test.createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableConflation(true);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        cache.createRegion(REGION_NAME2, attrs);
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.setSocketBufferSize(32768);
        server.start();
        return new Integer(server.getPort());
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void registerInterest() {
        try {
            Region region1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region region2 = cache.getRegion("/ConflationDUnitTest_region2");
            ConflationDUnitTest.assertTrue((region1 != null ? 1 : 0) != 0);
            ConflationDUnitTest.assertTrue((region2 != null ? 1 : 0) != 0);
            region1.registerInterest((Object)"ALL_KEYS");
            region2.registerInterest((Object)"ALL_KEYS");
        }
        catch (CacheWriterException e) {
            ConflationDUnitTest.fail((String)("test failed due to " + (Object)((Object)e)));
        }
    }

    public static void unregisterInterest() {
        try {
            Region region1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region region2 = cache.getRegion("/ConflationDUnitTest_region2");
            region1.unregisterInterest((Object)"ALL_KEYS");
            region2.unregisterInterest((Object)"ALL_KEYS");
        }
        catch (CacheWriterException e) {
            ConflationDUnitTest.fail((String)("test failed due to " + (Object)((Object)e)));
        }
    }

    public static void create() {
        try {
            Region r1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region r2 = cache.getRegion("/ConflationDUnitTest_region2");
            r1.create((Object)"key-1", (Object)"value");
            r2.create((Object)"key-1", (Object)"value");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ConflationDUnitTest.fail("failed while region.create()", ex);
        }
    }

    public static void put() {
        try {
            Region r1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region r2 = cache.getRegion("/ConflationDUnitTest_region2");
            r1.put((Object)"key-1", (Object)"11");
            r1.put((Object)"key-1", (Object)"22");
            r1.put((Object)"key-1", (Object)"33");
            r2.put((Object)"key-1", (Object)"11");
            r2.put((Object)"key-1", (Object)"22");
            r2.put((Object)"key-1", (Object)"33");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ConflationDUnitTest.fail("failed while region.put()", ex);
        }
    }

    public static void createMarker() {
        try {
            Region r1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region r2 = cache.getRegion("/ConflationDUnitTest_region2");
            r1.put((Object)MARKER, (Object)MARKER);
            r2.put((Object)MARKER, (Object)MARKER);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ConflationDUnitTest.fail("failed while region.create() marker", ex);
        }
    }

    public static void put200() {
        try {
            Region r1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region r2 = cache.getRegion("/ConflationDUnitTest_region2");
            for (int i = 1; i < 100; ++i) {
                r1.put((Object)"key-1", (Object)"11");
                r2.put((Object)"key-1", (Object)"11");
            }
            r1.put((Object)"key-1", (Object)"33");
            r2.put((Object)"key-1", (Object)"33");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ConflationDUnitTest.fail("failed while region.put()", ex);
        }
    }

    public static void getStatsOnServer() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Iterator itr = cache.getBridgeServers().iterator();
        BridgeServerImpl server = (BridgeServerImpl)itr.next();
        Iterator iter_prox = server.getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
        int ccpCount = 0;
        while (iter_prox.hasNext()) {
            ++ccpCount;
            CacheClientProxy proxy = (CacheClientProxy)iter_prox.next();
            if (!HaHelper.checkPrimary(proxy)) continue;
            HARegion region = (HARegion)proxy.getHARegion();
            ConflationDUnitTest.assertNotNull((Object)region);
            HARegionQueue haRegionQueue = HAHelper.getRegionQueue(region);
            statMap.put("eventsConflated", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated()));
            Log.getLogWriter().info("new Stats Map  : " + statMap.toString());
        }
        ConflationDUnitTest.assertTrue((String)"CCP Count is not 1 ", (ccpCount == 1 ? 1 : 0) != 0);
    }

    public static void get() {
        try {
            Region r = cache.getRegion("/ConflationDUnitTest_region1");
            r.get((Object)"key-1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ConflationDUnitTest.fail("failed while region.get()", ex);
        }
    }

    public static void destroyRegion() {
        try {
            Region region2;
            Region region1 = cache.getRegion("/region1");
            if (region1 != null) {
                region1.destroyRegion();
            }
            if ((region2 = cache.getRegion("/region1")) != null) {
                region2.destroyRegion();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ConflationDUnitTest.fail((String)("test failed due to exception in destroy region" + e));
        }
    }

    public static void destroy() {
        try {
            Region region1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region region2 = cache.getRegion("/ConflationDUnitTest_region2");
            region1.destroy((Object)"key-1");
            region2.destroy((Object)"key-1");
        }
        catch (Exception e) {
            e.printStackTrace();
            ConflationDUnitTest.fail((String)"test failed due to exception in destroy ");
        }
    }

    public static void destroyMarker() {
        try {
            Region region1 = cache.getRegion("/ConflationDUnitTest_region1");
            Region region2 = cache.getRegion("/ConflationDUnitTest_region2");
            region1.destroy((Object)MARKER);
            region2.destroy((Object)MARKER);
            count = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            ConflationDUnitTest.fail((String)"test failed due to exception in destroy ");
        }
    }

    @Override
    public void tearDown2() throws Exception {
        ConflationDUnitTest.closeCache();
        this.vm2.invoke(ConflationDUnitTest.class, "closeCache");
        this.vm0.invoke(ConflationDUnitTest.class, "closeCache");
    }

    static {
        statMap = new HashMap();
        count = 0;
        counterCreate = 0;
        counterUpdate = 0;
        counterDestroy = 0;
    }
}

