/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.TestDataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject1;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject10;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject11;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject12;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject13;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject2;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject3;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject4;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject5;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject6;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject7;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject8;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObject9;
import com.gemstone.gemfire.internal.cache.tier.sockets.DSObjectLocalOnly;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.TestCase;

public class DataSerializerPropogationDUnitTest
extends DistributedTestCase {
    private static final long serialVersionUID = 0L;
    private static Cache cache = null;
    private static VM client1 = null;
    private static VM client2 = null;
    private static VM server1 = null;
    private static VM server2 = null;
    private static int PORT1 = -1;
    private static int PORT2 = -1;
    private static int instanceCountWithAllPuts = 3;
    private static int instanceCountWithOnePut = 1;
    private static final String REGION_NAME = "ClientServerDataSerializersRegistrationDUnitTest";
    protected static EventID eventId;
    static boolean testEventIDResult;
    public static boolean successfullyLoadedTestDataSerializer;
    public static final ThreadLocal<Boolean> allowNonLocalTL;

    public DataSerializerPropogationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        client1 = host.getVM(0);
        client2 = host.getVM(1);
        server1 = host.getVM(2);
        server2 = host.getVM(3);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        DataSerializerPropogationDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        DataSerializerPropogationDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DataSerializerPropogationDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port1.intValue()).setMinConnections(1).setSubscriptionEnabled(true).setPingInterval(200L).create("ClientServerDataSerializersRegistrationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        Region r = cache.createRegion(REGION_NAME, factory.create());
        r.registerInterest((Object)"ALL_KEYS");
    }

    protected int getMaxThreads() {
        return 0;
    }

    private int initServerCache(VM server) {
        Object[] args = new Object[]{new Integer(this.getMaxThreads())};
        return (Integer)server.invoke(DataSerializerPropogationDUnitTest.class, "createServerCache", args);
    }

    public static Integer createServerCache(Integer maxThreads) throws Exception {
        new DataSerializerPropogationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            client1.invoke(DataSerializerPropogationDUnitTest.class, "closeCache");
            client2.invoke(DataSerializerPropogationDUnitTest.class, "closeCache");
            DataSerializerPropogationDUnitTest.closeCache();
            server1.invoke(DataSerializerPropogationDUnitTest.class, "closeCache");
            server2.invoke(DataSerializerPropogationDUnitTest.class, "closeCache");
            super.tearDown2();
            client1 = null;
            client2 = null;
            server1 = null;
        }
        finally {
            DataSerializerPropogationDUnitTest.unregisterAllDataSerializersFromAllVms();
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void verifyDataSerializers(int numOfDataSerializers) {
        DataSerializerPropogationDUnitTest.verifyDataSerializers(numOfDataSerializers, false);
    }

    public static void verifyDataSerializers(final int numOfDataSerializers, final boolean allowNonLocal) {
        DistributedTestCase.WaitCriterion2 wc = new DistributedTestCase.WaitCriterion2(){
            String excuse;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private DataSerializer[] getSerializers() {
                allowNonLocalTL.set(allowNonLocal);
                try {
                    DataSerializer[] dataSerializerArray = InternalDataSerializer.getSerializers();
                    return dataSerializerArray;
                }
                finally {
                    allowNonLocalTL.remove();
                }
            }

            @Override
            public boolean done() {
                return this.getSerializers().length == numOfDataSerializers;
            }

            @Override
            public String description() {
                return "expected " + numOfDataSerializers + " but got this " + InternalDataSerializer.getSerializers().length + " serializers=" + Arrays.toString(this.getSerializers());
            }

            @Override
            public boolean stopWaiting() {
                return this.getSerializers().length > numOfDataSerializers;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public static void registerDSObject1() throws Exception {
        try {
            InternalDataSerializer.register(DSObject1.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject1", e);
        }
    }

    public static void registerDSObject2() throws Exception {
        try {
            InternalDataSerializer.register(DSObject2.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject2", e);
        }
    }

    public static void registerDSObject3() throws Exception {
        try {
            InternalDataSerializer.register(DSObject3.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject2", e);
        }
    }

    public static void registerDSObject4() throws Exception {
        try {
            InternalDataSerializer.register(DSObject4.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject4", e);
        }
    }

    public static void registerDSObject5() throws Exception {
        try {
            InternalDataSerializer.register(DSObject5.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject5", e);
        }
    }

    public static void registerDSObject6() throws Exception {
        try {
            InternalDataSerializer.register(DSObject6.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject6", e);
        }
    }

    public static void registerDSObject7() throws Exception {
        try {
            InternalDataSerializer.register(DSObject7.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject7", e);
        }
    }

    public static void registerDSObject8() throws Exception {
        try {
            InternalDataSerializer.register(DSObject8.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject8", e);
        }
    }

    public static void registerDSObject9() throws Exception {
        try {
            InternalDataSerializer.register(DSObject9.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject9", e);
        }
    }

    public static void registerDSObject10() throws Exception {
        try {
            InternalDataSerializer.register(DSObject10.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject10", e);
        }
    }

    public static void registerDSObject11() throws Exception {
        try {
            InternalDataSerializer.register(DSObject11.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject11", e);
        }
    }

    public static void registerDSObject12() throws Exception {
        try {
            InternalDataSerializer.register(DSObject12.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject12", e);
        }
    }

    public static void registerDSObject13() throws Exception {
        try {
            InternalDataSerializer.register(DSObject13.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObject13", e);
        }
    }

    public static void registerDSObjectLocalOnly() throws Exception {
        try {
            InternalDataSerializer._register((DataSerializer)new DSObjectLocalOnly(79), (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in DSObjectLocalOnly", e);
        }
    }

    public static void registerTestDataSerializer() throws Exception {
        try {
            InternalDataSerializer.register(TestDataSerializer.class, (boolean)true);
        }
        catch (Exception e) {
            DataSerializerPropogationDUnitTest.fail("Test failed due to exception in TestDataSerializer", e);
        }
    }

    public static void stopServer() {
        try {
            DataSerializerPropogationDUnitTest.assertEquals((String)"Expected exactly one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            DataSerializerPropogationDUnitTest.assertNotNull((Object)bs);
            bs.stop();
        }
        catch (Exception ex) {
            DataSerializerPropogationDUnitTest.fail((String)("while setting stopServer  " + ex));
        }
    }

    public static void startServer() {
        try {
            Cache c = CacheFactory.getAnyInstance();
            DataSerializerPropogationDUnitTest.assertEquals((String)"Expected exactly one BridgeServer", (int)1, (int)c.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            DataSerializerPropogationDUnitTest.assertNotNull((Object)bs);
            bs.start();
        }
        catch (Exception ex) {
            DataSerializerPropogationDUnitTest.fail((String)("while startServer()  " + ex));
        }
    }

    public void testServerUpFirstClientLater() throws Exception {
        PORT1 = this.initServerCache(server1);
        DataSerializerPropogationDUnitTest.pause(3000);
        server1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject1");
        server1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject2");
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(2)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        DataSerializerPropogationDUnitTest.pause(3000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(2)});
        client1.invoke(new CacheSerializableRunnable("Put entries from client"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(DataSerializerPropogationDUnitTest.REGION_NAME);
                for (int i = 1; i <= 10; ++i) {
                    region.put((Object)i, (Object)i);
                }
            }
        });
        client1.invoke(new CacheSerializableRunnable("Get all entries from server"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(DataSerializerPropogationDUnitTest.REGION_NAME);
                TestCase.assertEquals((Object)1, (Object)region.get((Object)1));
            }
        });
        server1.invoke(new CacheSerializableRunnable("Put entry from client"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(DataSerializerPropogationDUnitTest.REGION_NAME);
                region.put((Object)1, (Object)20);
            }
        });
        DataSerializerPropogationDUnitTest.pause(3000);
        client1.invoke(new CacheSerializableRunnable("Get entry from client"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(DataSerializerPropogationDUnitTest.REGION_NAME);
                TestCase.assertEquals((Object)20, (Object)region.get((Object)1));
            }
        });
    }

    public void testDataSerializersWith2ClientsN2Servers() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2)});
        DataSerializerPropogationDUnitTest.pause(2000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject3");
        DataSerializerPropogationDUnitTest.pause(4000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
    }

    public void testLocalOnlyDS() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2)});
        DataSerializerPropogationDUnitTest.pause(2000);
        server1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObjectLocalOnly", new Object[0]);
        DataSerializerPropogationDUnitTest.pause(4000);
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(0)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1), Boolean.TRUE});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(0)});
    }

    public void testDataSerializersWithServerKill() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2)});
        DataSerializerPropogationDUnitTest.pause(2000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject4");
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{1});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{1});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{1});
        DistributedTestCase.ExpectedException expectedEx = DataSerializerPropogationDUnitTest.addExpectedException("Server unreachable", client1);
        server1.invoke(DataSerializerPropogationDUnitTest.class, "stopServer");
        server1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject5");
        server1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject6");
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(3)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(3)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithOnePut)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(3)});
        expectedEx.remove();
    }

    public void testDataSerializers() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2)});
        DataSerializerPropogationDUnitTest.pause(2000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject10");
        server1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject11");
        DataSerializerPropogationDUnitTest.pause(4000);
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(2)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(2)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(2)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(2)});
    }

    public void testDataSerializersWithServerKillAndReInvoked() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject7");
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithOnePut)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithOnePut)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithOnePut)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithOnePut)});
        DistributedTestCase.ExpectedException expectedEx = DataSerializerPropogationDUnitTest.addExpectedException("Server unreachable", client1);
        server1.invoke(DataSerializerPropogationDUnitTest.class, "stopServer");
        try {
            client1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            client1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject9");
        }
        catch (Exception exception) {
            // empty catch block
        }
        server1.invoke(DataSerializerPropogationDUnitTest.class, "startServer");
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithAllPuts)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithAllPuts)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithAllPuts)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(instanceCountWithAllPuts)});
        expectedEx.remove();
    }

    public void testDataSerializerCount() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        DataSerializerPropogationDUnitTest.createClientCache(DataSerializerPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2));
        DataSerializerPropogationDUnitTest.pause(2000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "registerDSObject12");
        DataSerializerPropogationDUnitTest.pause(4000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        DataSerializerPropogationDUnitTest.verifyDataSerializers(1);
    }

    public void testDataSerializersEventIdVerificationClientsAndServers() throws Exception {
        PORT1 = this.initServerCache(server1, 1);
        PORT2 = this.initServerCache(server2, 2);
        DataSerializerPropogationDUnitTest.createClientCache(DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1));
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2)});
        DataSerializerPropogationDUnitTest.setBridgeObserver1();
        client2.invoke(DataSerializerPropogationDUnitTest.class, "setBridgeObserver2");
        DataSerializerPropogationDUnitTest.registerDSObject13();
        DataSerializerPropogationDUnitTest.pause(10000);
        Boolean pass = (Boolean)client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyResult");
        DataSerializerPropogationDUnitTest.assertTrue((String)"EventId found Different", (boolean)pass);
        PoolImpl.IS_INSTANTIATOR_CALLBACK = false;
    }

    public void testLazyLoadingOfDataSerializersWith2ClientsN2Servers() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "createClientCache", new Object[]{DataSerializerPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT2)});
        DataSerializerPropogationDUnitTest.pause(2000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "registerTestDataSerializer");
        DataSerializerPropogationDUnitTest.pause(4000);
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyLoadedDataSerializers", new Object[]{new Integer(1)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerClassNamesMap", new Object[]{new Integer(0)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerIDMap", new Object[]{new Integer(0)});
        client1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerSupportedClassNamesMap", new Object[]{new Integer(0)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyLoadedDataSerializers", new Object[]{new Integer(1)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerClassNamesMap", new Object[]{new Integer(0)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerIDMap", new Object[]{new Integer(0)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerSupportedClassNamesMap", new Object[]{new Integer(0)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyLoadedDataSerializers", new Object[]{new Integer(1)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerClassNamesMap", new Object[]{new Integer(0)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerIDMap", new Object[]{new Integer(0)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerSupportedClassNamesMap", new Object[]{new Integer(0)});
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyTestDataSerializerLoaded");
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyTestDataSerializerLoaded");
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyTestDataSerializerNotLoaded");
        server1.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        server2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyLoadedDataSerializers", new Object[]{new Integer(0)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerClassNamesMap", new Object[]{new Integer(1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerIDMap", new Object[]{new Integer(1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerSupportedClassNamesMap", new Object[]{new Integer(3)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializers", new Object[]{new Integer(1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyTestDataSerializerLoaded");
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyLoadedDataSerializers", new Object[]{new Integer(1)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerClassNamesMap", new Object[]{new Integer(0)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerIDMap", new Object[]{new Integer(0)});
        client2.invoke(DataSerializerPropogationDUnitTest.class, "verifyDataSerializerSupportedClassNamesMap", new Object[]{new Integer(0)});
    }

    public static void verifyTestDataSerializerNotLoaded() {
        DataSerializerPropogationDUnitTest.assertFalse((String)"TestDataSerializer should not have been loaded in this vm.", (boolean)successfullyLoadedTestDataSerializer);
    }

    public static void verifyTestDataSerializerLoaded() {
        DataSerializerPropogationDUnitTest.assertTrue((String)"TestDataSerializer should have been loaded in this vm.", (boolean)successfullyLoadedTestDataSerializer);
    }

    public static void verifyLoadedDataSerializers(Integer expected) {
        int actual = InternalDataSerializer.getLoadedDataSerializers();
        DataSerializerPropogationDUnitTest.assertTrue((String)("Number of loaded data serializers, expected: " + expected + ", actual: " + actual), (actual == expected ? 1 : 0) != 0);
    }

    public static void verifyDataSerializerClassNamesMap(Integer expected) {
        int actual = InternalDataSerializer.getDsClassesToHoldersMap().size();
        DataSerializerPropogationDUnitTest.assertTrue((String)("Number of data serializer classnames, expected: " + expected + ", actual: " + actual), (actual == expected ? 1 : 0) != 0);
    }

    public static void verifyDataSerializerIDMap(Integer expected) {
        int actual = InternalDataSerializer.getIdsToHoldersMap().size();
        DataSerializerPropogationDUnitTest.assertTrue((String)("Number of ids, expected: " + expected + ", actual: " + actual), (actual == expected ? 1 : 0) != 0);
    }

    public static void verifyDataSerializerSupportedClassNamesMap(Integer expected) {
        int actual = InternalDataSerializer.getSupportedClassesToHoldersMap().size();
        DataSerializerPropogationDUnitTest.assertTrue((String)("Number of supported classnames, expected: " + expected + ", actual: " + actual), (actual == expected ? 1 : 0) != 0);
    }

    public static Boolean verifyResult() {
        boolean temp = testEventIDResult;
        testEventIDResult = false;
        return new Boolean(temp);
    }

    private int initServerCache(VM server, int serverNo) {
        Object[] args = new Object[]{new Integer(this.getMaxThreads())};
        if (serverNo == 1) {
            return (Integer)server.invoke(DataSerializerPropogationDUnitTest.class, "createServerCacheOne", args);
        }
        return (Integer)server.invoke(DataSerializerPropogationDUnitTest.class, "createServerCacheTwo", args);
    }

    public static Integer createServerCacheTwo(Integer maxThreads) throws Exception {
        new DataSerializerPropogationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(port);
    }

    public static Integer createServerCacheOne(Integer maxThreads) throws Exception {
        new DataSerializerPropogationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(port);
    }

    public static void setBridgeObserver1() {
        PoolImpl.IS_INSTANTIATOR_CALLBACK = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void beforeSendingToServer(EventID eventID) {
                eventId = eventID;
                client2.invoke(DataSerializerPropogationDUnitTest.class, "setEventId", new Object[]{eventId});
            }
        });
    }

    public static void setEventId(EventID eventID) {
        eventId = eventID;
    }

    public static void setBridgeObserver2() {
        PoolImpl.IS_INSTANTIATOR_CALLBACK = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void afterReceivingFromServer(EventID eventID) {
                testEventIDResult = eventID.equals((Object)eventId);
            }
        });
    }

    static {
        testEventIDResult = false;
        successfullyLoadedTestDataSerializer = false;
        allowNonLocalTL = new ThreadLocal();
    }
}

