/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.Properties;

public class DeltaToRegionRelationCQRegistrationDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    VM server = null;
    VM client = null;
    VM server2 = null;
    VM client2 = null;
    private static int PORT1;
    private static int PORT2;
    private static PoolImpl p;
    private static final String REGION_NAME1 = "DeltaToRegionRelationCQRegistration_region1";
    private static final String REGION_NAME2 = "DeltaToRegionRelationCQRegistration_region2";
    private static Integer primary;
    private static final String CQ1 = "SELECT * FROM /DeltaToRegionRelationCQRegistration_region1";
    private static final String CQ2 = "SELECT * FROM /DeltaToRegionRelationCQRegistration_region2";
    private static final String CQ3 = "SELECT ALL * FROM /DeltaToRegionRelationCQRegistration_region1";
    private static final String CQ4 = "SELECT ALL * FROM /DeltaToRegionRelationCQRegistration_region2";
    private static final String cqName1 = "cqNameFirst";
    private static final String cqName2 = "cqNameSecond";
    private static final String cqName3 = "cqNamethird";
    private static final String cqName4 = "cqNameFourth";

    public DeltaToRegionRelationCQRegistrationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        DeltaToRegionRelationCQRegistrationDUnitTest.disconnectAllFromDS();
        DeltaToRegionRelationCQRegistrationDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.server = host.getVM(0);
        this.client = host.getVM(1);
        this.server2 = host.getVM(2);
        this.client2 = host.getVM(3);
    }

    public void testDeltaToRegionForRegisterCQ() {
        this.intialSetUp();
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName1, CQ1, new Boolean(false)});
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName2, CQ2, new Boolean(false)});
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName3, CQ3, new Boolean(false)});
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName4, CQ4, new Boolean(true)});
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
        this.tearDownforSimpleCase();
    }

    public void testDeltaToRegionForRegisterCQIR() {
        this.intialSetUp();
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName1, CQ1, new Boolean(true)});
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName2, CQ2, new Boolean(true)});
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName3, CQ3, new Boolean(true)});
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName4, CQ4, new Boolean(false)});
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
        this.tearDownforSimpleCase();
    }

    public void testDeltaToRegionForRegisterCQIRThroughPool() {
        this.intialSetUpClientWithNoRegion();
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCqThroughPool", new Object[]{cqName1, CQ1, new Boolean(true)});
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCqThroughPool", new Object[]{cqName2, CQ2, new Boolean(true)});
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServerForCqRegistrationFromPool");
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCqThroughPool", new Object[]{cqName3, CQ3, new Boolean(true)});
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCqThroughPool", new Object[]{cqName4, CQ4, new Boolean(false)});
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServerForCqRegistrationFromPool");
        this.tearDownforSimpleCase();
    }

    public void testDeltaToRegionForRegisterCQFailover() {
        this.intialSetUpForFailOver();
        this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName1, CQ1, new Boolean(false)});
        this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName2, CQ2, new Boolean(false)});
        this.validationForFailOver();
        this.tearDownForFailOver();
    }

    public void testDeltaToRegionForRegisterCQIRFaliover() {
        this.intialSetUpForFailOver();
        this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName1, CQ1, new Boolean(true)});
        this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCq", new Object[]{cqName2, CQ2, new Boolean(true)});
        this.validationForFailOver();
        this.tearDownForFailOver();
    }

    public void testDeltaToRegionForRegisterCQIRFromPoolFaliover() {
        this.intialSetUpNoRegiononClientForFailOver();
        this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCqThroughPool", new Object[]{cqName1, CQ1, new Boolean(true)});
        this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "registerCqThroughPool", new Object[]{cqName2, CQ2, new Boolean(true)});
        this.validationForCQFiredFromPoolFailOver();
        this.tearDownForFailOver();
    }

    public static void registerCq(String name, String Cquery, Boolean cqWithIR) {
        QueryService cqService = null;
        try {
            cqService = cache.getQueryService();
        }
        catch (Exception cqe) {
            cqe.printStackTrace();
            DeltaToRegionRelationCQRegistrationDUnitTest.fail((String)"Failed to getCqService.");
        }
        CqAttributesFactory cqf = new CqAttributesFactory();
        CqAttributes cqa = cqf.create();
        try {
            CqQuery cq1 = cqService.newCq(name, Cquery, cqa);
            DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
            if (cqWithIR.booleanValue()) {
                cq1.executeWithInitialResults();
            } else {
                cq1.execute();
            }
        }
        catch (Exception ex) {
            DeltaToRegionRelationCQRegistrationDUnitTest.getLogWriter().info("CqService is :" + cqService);
            ex.printStackTrace();
            AssertionError err = new AssertionError((Object)"Failed to create CQ cqNameFirst . ");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        CqQuery cQuery = cqService.getCq(name);
        if (cQuery == null) {
            DeltaToRegionRelationCQRegistrationDUnitTest.fail((String)"Failed to get CqQuery for CQ : cqNameFirst");
        }
    }

    public static void registerCqThroughPool(String name, String Cquery, Boolean cqWithIR) {
        QueryService cqService = null;
        try {
            cqService = p.getQueryService();
        }
        catch (Exception cqe) {
            cqe.printStackTrace();
            DeltaToRegionRelationCQRegistrationDUnitTest.fail((String)"Failed to getCqService.");
        }
        CqAttributesFactory cqf = new CqAttributesFactory();
        CqAttributes cqa = cqf.create();
        try {
            CqQuery cq1 = cqService.newCq(name, Cquery, cqa);
            DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
            if (cqWithIR.booleanValue()) {
                cq1.executeWithInitialResults();
            } else {
                cq1.execute();
            }
        }
        catch (Exception ex) {
            DeltaToRegionRelationCQRegistrationDUnitTest.getLogWriter().info("CqService is :" + cqService);
            ex.printStackTrace();
            AssertionError err = new AssertionError((Object)"Failed to create CQ cqNameFirst . ");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        CqQuery cQuery = cqService.getCq(name);
        if (cQuery == null) {
            DeltaToRegionRelationCQRegistrationDUnitTest.fail((String)"Failed to get CqQuery for CQ : cqNameFirst");
        }
    }

    public static void validationOnServer() throws Exception {
        DeltaToRegionRelationCQRegistrationDUnitTest.checkNumberOfClientProxies(1);
        CacheClientProxy proxy = DeltaToRegionRelationCQRegistrationDUnitTest.getClientProxy();
        DeltaToRegionRelationCQRegistrationDUnitTest.assertNotNull((Object)proxy);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return DeltaToRegionRelationCQRegistrationDUnitTest.getClientProxy().getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationCQRegistration_region1");
            }

            @Override
            public String description() {
                return "Wait Expired";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 5000L, 100L, true);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"DeltaToRegionRelationCQRegistration_region1 not present in cache client proxy : Delta is enable", (boolean)proxy.getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationCQRegistration_region1"));
        DeltaToRegionRelationCQRegistrationDUnitTest.assertFalse((String)"DeltaToRegionRelationCQRegistration_region2 present in cache client proxy : Delta is disable", (boolean)proxy.getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationCQRegistration_region2"));
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"Multiple entries for a region", (proxy.getRegionsWithEmptyDataPolicy().size() == 1 ? 1 : 0) != 0);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"Wrong ordinal stored for empty data policy", ((Integer)proxy.getRegionsWithEmptyDataPolicy().get("/DeltaToRegionRelationCQRegistration_region1") == 0 ? 1 : 0) != 0);
    }

    public static void validationOnServerForCqRegistrationFromPool() throws Exception {
        DeltaToRegionRelationCQRegistrationDUnitTest.checkNumberOfClientProxies(1);
        CacheClientProxy proxy = DeltaToRegionRelationCQRegistrationDUnitTest.getClientProxy();
        DeltaToRegionRelationCQRegistrationDUnitTest.assertNotNull((Object)proxy);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return DeltaToRegionRelationCQRegistrationDUnitTest.getClientProxy().getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationCQRegistration_region1") && DeltaToRegionRelationCQRegistrationDUnitTest.getClientProxy().getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationCQRegistration_region2");
            }

            @Override
            public String description() {
                return "Wait Expired";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 5000L, 100L, true);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"Multiple entries for a region", (proxy.getRegionsWithEmptyDataPolicy().size() == 2 ? 1 : 0) != 0);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"Wrong ordinal stored for empty data policy", ((Integer)proxy.getRegionsWithEmptyDataPolicy().get("/DeltaToRegionRelationCQRegistration_region1") == 0 ? 1 : 0) != 0);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)"Wrong ordinal stored for empty data policy", ((Integer)proxy.getRegionsWithEmptyDataPolicy().get("/DeltaToRegionRelationCQRegistration_region2") == 0 ? 1 : 0) != 0);
    }

    public static Integer createServerCache() throws Exception {
        new DeltaToRegionRelationCQRegistrationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        cache.createRegion(REGION_NAME2, attrs);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache(String host, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DeltaToRegionRelationCQRegistrationDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port.intValue()).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaToRegionRelationCQRegistrationTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        factory.setCloningEnabled(false);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertFalse((boolean)cache.getRegion(REGION_NAME1).getAttributes().getCloningEnabled());
        factory.setDataPolicy(DataPolicy.NORMAL);
        attrs = factory.create();
        cache.createRegion(REGION_NAME2, attrs);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertFalse((boolean)cache.getRegion(REGION_NAME2).getAttributes().getCloningEnabled());
        cache.getRegion(REGION_NAME2).getAttributesMutator().setCloningEnabled(true);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((boolean)cache.getRegion(REGION_NAME2).getAttributes().getCloningEnabled());
    }

    public static void createClientCacheWithNoRegion(String host, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DeltaToRegionRelationCQRegistrationDUnitTest("temp").createCache(props);
        p = (PoolImpl)PoolManager.createFactory().addServer(host, port.intValue()).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaToRegionRelationCQRegistrationTestPool");
    }

    public static Integer createClientCache2(String host1, String host2, Integer port1, Integer port2) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DeltaToRegionRelationCQRegistrationDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host1, port1.intValue()).addServer(host2, port2.intValue()).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaToRegionRelationCQRegistrationTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        factory.setDataPolicy(DataPolicy.NORMAL);
        attrs = factory.create();
        cache.createRegion(REGION_NAME2, attrs);
        return new Integer(p.getPrimaryPort());
    }

    public static Integer createClientCache3(String host1, String host2, Integer port1, Integer port2) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DeltaToRegionRelationCQRegistrationDUnitTest("temp").createCache(props);
        p = (PoolImpl)PoolManager.createFactory().addServer(host1, port1.intValue()).addServer(host2, port2.intValue()).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaToRegionRelationCQRegistrationTestPool");
        return new Integer(p.getPrimaryPort());
    }

    @Override
    public void tearDown2() throws Exception {
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static CacheClientProxy getClientProxy() {
        CacheClientNotifier notifier = DeltaToRegionRelationCQRegistrationDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
        CacheClientProxy proxy = null;
        Iterator i = notifier.getClientProxies().iterator();
        if (i.hasNext()) {
            proxy = (CacheClientProxy)i.next();
        }
        return proxy;
    }

    private static BridgeServerImpl getBridgeServer() {
        BridgeServerImpl bridgeServer = (BridgeServerImpl)cache.getCacheServers().iterator().next();
        DeltaToRegionRelationCQRegistrationDUnitTest.assertNotNull((Object)bridgeServer);
        return bridgeServer;
    }

    private static int getNumberOfClientProxies() {
        return DeltaToRegionRelationCQRegistrationDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier().getClientProxies().size();
    }

    private static void checkNumberOfClientProxies(int expected) {
        int current = DeltaToRegionRelationCQRegistrationDUnitTest.getNumberOfClientProxies();
        int tries = 1;
        while (expected != current && tries++ < 60) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            current = DeltaToRegionRelationCQRegistrationDUnitTest.getNumberOfClientProxies();
        }
        DeltaToRegionRelationCQRegistrationDUnitTest.assertEquals((int)expected, (int)current);
    }

    public static void stopCacheServer() {
        DeltaToRegionRelationCQRegistrationDUnitTest.getBridgeServer().stop();
    }

    public void intialSetUp() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createServerCache");
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createClientCache", new Object[]{DeltaToRegionRelationCQRegistrationDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1)});
    }

    public void intialSetUpClientWithNoRegion() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createServerCache");
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createClientCacheWithNoRegion", new Object[]{DeltaToRegionRelationCQRegistrationDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1)});
    }

    public void tearDownforSimpleCase() {
        this.client.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "closeCache");
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "closeCache");
    }

    public void intialSetUpForFailOver() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createServerCache");
        primary = (Integer)this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createClientCache2", new Object[]{DeltaToRegionRelationCQRegistrationDUnitTest.getServerHostName(this.server.getHost()), DeltaToRegionRelationCQRegistrationDUnitTest.getServerHostName(this.server2.getHost()), new Integer(PORT1), new Integer(PORT2)});
    }

    public void intialSetUpNoRegiononClientForFailOver() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createServerCache");
        primary = (Integer)this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "createClientCache3", new Object[]{DeltaToRegionRelationCQRegistrationDUnitTest.getServerHostName(this.server.getHost()), DeltaToRegionRelationCQRegistrationDUnitTest.getServerHostName(this.server2.getHost()), new Integer(PORT1), new Integer(PORT2)});
    }

    public void validationForFailOver() {
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)" primary server is not detected ", (primary != -1 ? 1 : 0) != 0);
        if (primary == PORT1) {
            this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
            this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "stopCacheServer");
            this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
        } else {
            this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
            this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "stopCacheServer");
            this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServer");
        }
    }

    public void validationForCQFiredFromPoolFailOver() {
        DeltaToRegionRelationCQRegistrationDUnitTest.assertTrue((String)" primary server is not detected ", (primary != -1 ? 1 : 0) != 0);
        if (primary == PORT1) {
            this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServerForCqRegistrationFromPool");
            this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "stopCacheServer");
            this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServerForCqRegistrationFromPool");
        } else {
            this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServerForCqRegistrationFromPool");
            this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "stopCacheServer");
            this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "validationOnServerForCqRegistrationFromPool");
        }
    }

    public void tearDownForFailOver() {
        this.client2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "closeCache");
        this.server.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "closeCache");
        this.server2.invoke(DeltaToRegionRelationCQRegistrationDUnitTest.class, "closeCache");
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        DeltaToRegionRelationCQRegistrationDUnitTest.assertNotNull((Object)cache);
    }

    static {
        p = null;
        primary = null;
    }
}

