/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientUpdater;
import delta.DeltaTestObj;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class DeltaToRegionRelationDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    VM server = null;
    VM client = null;
    VM server2 = null;
    VM client2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME1 = "DeltaToRegionRelationDUnitTest_region1";
    private static final String REGION_NAME2 = "DeltaToRegionRelationDUnitTest_region2";
    private static Integer primary;

    public DeltaToRegionRelationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        DeltaToRegionRelationDUnitTest.disconnectAllFromDS();
        DeltaToRegionRelationDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.server = host.getVM(0);
        this.client = host.getVM(1);
        this.server2 = host.getVM(2);
        this.client2 = host.getVM(3);
    }

    public void testDeltaToRegionForRegisterInterestRegex() {
        this.intialSetUp();
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerRegex", new Object[]{REGION_NAME1, ".*"});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerRegex", new Object[]{REGION_NAME2, ".*"});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerRegex", new Object[]{REGION_NAME1, ".8"});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME1, new Integer(3), new Integer(4)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerRegex", new Object[]{REGION_NAME2, ".8"});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        this.tearDownforSimpleCase();
    }

    public void testDeltaToRegionForRegisterInterest() {
        this.intialSetUp();
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeyOnly", new Object[]{REGION_NAME1, new Integer(1)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeyOnly", new Object[]{REGION_NAME2, new Integer(1)});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeyOnly", new Object[]{REGION_NAME1, new Integer(2)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME1, new Integer(3), new Integer(4)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME2, new Integer(3), new Integer(4)});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        this.tearDownforSimpleCase();
    }

    public void testDeltaToRegionForRegisterInterestList() {
        this.intialSetUp();
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME1, new Integer(1), new Integer(2)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME2, new Integer(1), new Integer(2)});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME1, new Integer(3), new Integer(4)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeyOnly", new Object[]{REGION_NAME1, new Integer(5)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeyOnly", new Object[]{REGION_NAME2, new Integer(3)});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        this.tearDownforSimpleCase();
    }

    public void testDeltaToRegionForRegisterInterestFailover() {
        this.intialSetUpForFailOver();
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeyOnly", new Object[]{REGION_NAME1, new Integer(1)});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeyOnly", new Object[]{REGION_NAME2, new Integer(1)});
        this.validationForFailOver();
        this.tearDownForFailOver();
    }

    public void testDeltaToRegionForRegisterInterestListFaliover() {
        this.intialSetUpForFailOver();
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME1, new Integer(1), new Integer(2)});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "registerKeys", new Object[]{REGION_NAME2, new Integer(1), new Integer(2)});
        this.validationForFailOver();
        this.tearDownForFailOver();
    }

    public void testDeltaToRegionForRegisterInterestRegexFaliover() {
        this.intialSetUpForFailOver();
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "registerRegex", new Object[]{REGION_NAME1, ".9"});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "registerRegex", new Object[]{REGION_NAME2, ".9"});
        this.validationForFailOver();
        this.tearDownForFailOver();
    }

    public static void validationOnServer() throws Exception {
        DeltaToRegionRelationDUnitTest.checkNumberOfClientProxies(1);
        CacheClientProxy proxy = DeltaToRegionRelationDUnitTest.getClientProxy();
        DeltaToRegionRelationDUnitTest.assertNotNull((Object)proxy);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return DeltaToRegionRelationDUnitTest.getClientProxy().isAlive() && DeltaToRegionRelationDUnitTest.getClientProxy().getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationDUnitTest_region1");
            }

            @Override
            public String description() {
                return "Wait Expired";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 5000L, 100L, true);
        DeltaToRegionRelationDUnitTest.assertTrue((String)"registerInterest not happened", (boolean)proxy.hasRegisteredInterested());
        DeltaToRegionRelationDUnitTest.assertTrue((String)"DeltaToRegionRelationDUnitTest_region1 not present in cache client proxy : Delta is enable", (boolean)proxy.getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationDUnitTest_region1"));
        DeltaToRegionRelationDUnitTest.assertFalse((String)"DeltaToRegionRelationDUnitTest_region2 present in cache client proxy : Delta is disable", (boolean)proxy.getRegionsWithEmptyDataPolicy().containsKey("/DeltaToRegionRelationDUnitTest_region2"));
        DeltaToRegionRelationDUnitTest.assertTrue((String)"Multiple entries for a region", (proxy.getRegionsWithEmptyDataPolicy().size() == 1 ? 1 : 0) != 0);
        DeltaToRegionRelationDUnitTest.assertTrue((String)"Wrong ordinal stored for empty data policy", ((Integer)proxy.getRegionsWithEmptyDataPolicy().get("/DeltaToRegionRelationDUnitTest_region1") == 0 ? 1 : 0) != 0);
    }

    public static Integer createServerCache() throws Exception {
        new DeltaToRegionRelationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        cache.createRegion(REGION_NAME2, attrs);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache(String host, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DeltaToRegionRelationDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port.intValue()).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaToRegionRelationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        factory.setCloningEnabled(false);
        RegionAttributes attrs = factory.create();
        Region reg1 = cache.createRegion(REGION_NAME1, attrs);
        DeltaToRegionRelationDUnitTest.assertFalse((boolean)reg1.getAttributes().getCloningEnabled());
        factory.setDataPolicy(DataPolicy.NORMAL);
        attrs = factory.create();
        Region reg2 = cache.createRegion(REGION_NAME2, attrs);
        DeltaToRegionRelationDUnitTest.assertFalse((boolean)reg2.getAttributes().getCloningEnabled());
        reg2.getAttributesMutator().setCloningEnabled(true);
        DeltaToRegionRelationDUnitTest.assertTrue((boolean)reg2.getAttributes().getCloningEnabled());
    }

    public static Integer createClientCache2(String host1, String host2, Integer port1, Integer port2) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DeltaToRegionRelationDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host1, port1.intValue()).addServer(host2, port2.intValue()).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaToRegionRelationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME1, attrs);
        factory.setDataPolicy(DataPolicy.NORMAL);
        attrs = factory.create();
        cache.createRegion(REGION_NAME2, attrs);
        return new Integer(p.getPrimaryPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        DeltaToRegionRelationDUnitTest.assertNotNull((Object)cache);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        cache = null;
        DeltaToRegionRelationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static CacheClientProxy getClientProxy() {
        CacheClientNotifier notifier = DeltaToRegionRelationDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
        CacheClientProxy proxy = null;
        Iterator i = notifier.getClientProxies().iterator();
        if (i.hasNext()) {
            proxy = (CacheClientProxy)i.next();
        }
        return proxy;
    }

    private static BridgeServerImpl getBridgeServer() {
        BridgeServerImpl bridgeServer = (BridgeServerImpl)cache.getCacheServers().iterator().next();
        DeltaToRegionRelationDUnitTest.assertNotNull((Object)bridgeServer);
        return bridgeServer;
    }

    private static int getNumberOfClientProxies() {
        return DeltaToRegionRelationDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier().getClientProxies().size();
    }

    private static void checkNumberOfClientProxies(int expected) {
        int current = DeltaToRegionRelationDUnitTest.getNumberOfClientProxies();
        int tries = 1;
        while (expected != current && tries++ < 60) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            current = DeltaToRegionRelationDUnitTest.getNumberOfClientProxies();
        }
        DeltaToRegionRelationDUnitTest.assertEquals((int)expected, (int)current);
    }

    private static void registerKeyOnly(String regionName, Object key) {
        Region r = cache.getRegion("/" + regionName);
        DeltaToRegionRelationDUnitTest.assertNotNull((Object)r);
        r.registerInterest(key);
    }

    public static void registerKeys(String regionName, Integer obj1, Integer Obj2) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            Region r = cache.getRegion("/" + regionName);
            DeltaToRegionRelationDUnitTest.assertNotNull((Object)r);
            list.add(obj1);
            list.add(Obj2);
            r.registerInterest(list);
        }
        catch (Exception ex) {
            DeltaToRegionRelationDUnitTest.fail("failed while registering keys" + list + "", ex);
        }
    }

    public static void registerRegex(String regionName, String exp) {
        Region r = cache.getRegion("/" + regionName);
        DeltaToRegionRelationDUnitTest.assertNotNull((Object)r);
        r.registerInterestRegex(exp);
    }

    public static void stopCacheServer() {
        DeltaToRegionRelationDUnitTest.getBridgeServer().stop();
    }

    public void intialSetUp() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationDUnitTest.class, "createServerCache");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "createClientCache", new Object[]{DeltaToRegionRelationDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1)});
    }

    public void tearDownforSimpleCase() {
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "closeCache");
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "closeCache");
    }

    public void intialSetUpForFailOver() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(DeltaToRegionRelationDUnitTest.class, "createServerCache");
        primary = (Integer)this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "createClientCache2", new Object[]{DeltaToRegionRelationDUnitTest.getServerHostName(this.server.getHost()), DeltaToRegionRelationDUnitTest.getServerHostName(this.server2.getHost()), new Integer(PORT1), new Integer(PORT2)});
    }

    public void validationForFailOver() {
        DeltaToRegionRelationDUnitTest.assertTrue((String)" primary server is not detected ", (primary != -1 ? 1 : 0) != 0);
        if (primary == PORT1) {
            this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
            this.server.invoke(DeltaToRegionRelationDUnitTest.class, "stopCacheServer");
            this.server2.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        } else {
            this.server2.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
            this.server2.invoke(DeltaToRegionRelationDUnitTest.class, "stopCacheServer");
            this.server.invoke(DeltaToRegionRelationDUnitTest.class, "validationOnServer");
        }
    }

    public void tearDownForFailOver() {
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "closeCache");
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "closeCache");
        this.server2.invoke(DeltaToRegionRelationDUnitTest.class, "closeCache");
    }

    public static void createClientCache3(String host, Integer port, Boolean bool) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DeltaToRegionRelationDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port.intValue()).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaToRegionRelationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        factory.setCloningEnabled(false);
        RegionAttributes attrs = factory.create();
        Region r = cache.createRegion(REGION_NAME1, attrs);
        r.registerInterest((Object)"ALL_KEYS");
        DeltaToRegionRelationDUnitTest.assertFalse((boolean)cache.getRegion(REGION_NAME1).getAttributes().getCloningEnabled());
    }

    public static void putDelta(String regName) {
        Region reg = cache.getRegion("/" + regName);
        DeltaTestObj obj = new DeltaTestObj();
        for (int i = 0; i < 10; ++i) {
            obj.setIntVar(i);
            reg.put((Object)new Integer(1), (Object)obj);
        }
    }

    public static void createDelta(String regName) {
        Region reg = cache.getRegion("/" + regName);
        DeltaTestObj obj = new DeltaTestObj();
        for (int i = 0; i < 10; ++i) {
            obj.setIntVar(i);
            reg.create((Object)new Integer(i), (Object)obj);
        }
    }

    public static void setTestFlagForAskFullValue(Boolean bool) {
        CacheClientUpdater.isUsedByTest = bool;
        DeltaTestObj.resetFromDeltaCounter();
    }

    public static void verifyNoDeltaPropagation() {
        DeltaToRegionRelationDUnitTest.assertFalse((boolean)CacheClientUpdater.fullValueRequested);
        DeltaToRegionRelationDUnitTest.assertFalse((boolean)DeltaTestObj.fromDeltaFeatureUsed());
    }

    public static void noDeltaFailureOnServer() {
        CachePerfStats stats = ((LocalRegion)cache.getRegion(REGION_NAME1)).getCachePerfStats();
        int deltaFailures = stats.getDeltaFailedUpdates();
        DeltaToRegionRelationDUnitTest.assertTrue((String)"delta failures count is not zero", (deltaFailures == 0 ? 1 : 0) != 0);
        DeltaToRegionRelationDUnitTest.assertTrue((String)"fromDelta invoked", (DeltaTestObj.fromDeltaFeatureUsed() == false ? 1 : 0) != 0);
    }

    public static void waitForCreate(String r) {
        Region reg = cache.getRegion(REGION_NAME1);
        long elapsed = 0L;
        long start = System.currentTimeMillis();
        while (elapsed < 10000L && reg.size() < 10) {
            try {
                elapsed = System.currentTimeMillis() - start;
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void testForEmptyDataPolicy() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationDUnitTest.class, "createServerCache");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "createClientCache3", new Object[]{DeltaToRegionRelationDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), new Boolean(false)});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "createClientCache3", new Object[]{DeltaToRegionRelationDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), new Boolean(true)});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "setTestFlagForAskFullValue", new Object[]{new Boolean(true)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "putDelta", new Object[]{REGION_NAME1});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "waitForCreate", new Object[]{REGION_NAME1});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "verifyNoDeltaPropagation");
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "setTestFlagForAskFullValue", new Object[]{new Boolean(false)});
    }

    public void testForEmptyDataPolicyWithCreate() {
        PORT1 = (Integer)this.server.invoke(DeltaToRegionRelationDUnitTest.class, "createServerCache");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "createClientCache3", new Object[]{DeltaToRegionRelationDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), new Boolean(false)});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "createClientCache3", new Object[]{DeltaToRegionRelationDUnitTest.getServerHostName(this.server.getHost()), new Integer(PORT1), new Boolean(true)});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "resetFlags");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "resetFlags");
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "resetFlags");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "setTestFlagForAskFullValue", new Object[]{new Boolean(true)});
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "createDelta", new Object[]{REGION_NAME1});
        this.client2.invoke(DeltaToRegionRelationDUnitTest.class, "waitForCreate", new Object[]{REGION_NAME1});
        this.server.invoke(DeltaToRegionRelationDUnitTest.class, "noDeltaFailureOnServer");
        this.client.invoke(DeltaToRegionRelationDUnitTest.class, "setTestFlagForAskFullValue", new Object[]{new Boolean(false)});
    }

    public static void resetFlags() {
        DeltaTestObj.resetDeltaInvokationCounters();
    }

    static {
        primary = null;
    }
}

