/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.NoSubscriptionServersAvailableException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;

public class DurableClientBug39997DUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = -2712855295338732543L;

    public DurableClientBug39997DUnitTest(String name) {
        super(name);
    }

    public void testNoServerAvailableOnStartup() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String hostName = DurableClientBug39997DUnitTest.getServerHostName(host);
        final int port = AvailablePortHelper.getRandomAvailableTCPPort();
        vm0.invoke(new SerializableRunnable("create cache"){

            @Override
            public void run() {
                DurableClientBug39997DUnitTest.this.getSystem(DurableClientBug39997DUnitTest.this.getClientProperties());
                PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(hostName, port).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).create("DurableClientReconnectDUnitTestPool");
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setPoolName(p.getName());
                Cache cache = DurableClientBug39997DUnitTest.this.getCache();
                Region region1 = cache.createRegion("region", factory.create());
                cache.readyForEvents();
                try {
                    region1.registerInterest((Object)"ALL_KEYS");
                    TestCase.fail((String)"Should have received an exception trying to register interest");
                }
                catch (NoSubscriptionServersAvailableException noSubscriptionServersAvailableException) {
                    // empty catch block
                }
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DurableClientBug39997DUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                cache.createRegion("region", factory.create());
                CacheServer server = cache.addCacheServer();
                server.setPort(port);
                try {
                    server.start();
                }
                catch (IOException e) {
                    DistributedTestCase.fail("couldn't start server", e);
                }
            }
        });
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = DurableClientBug39997DUnitTest.this.getCache();
                final Region region = cache.getRegion("region");
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "Wait for register interest to succeed";
                    }

                    @Override
                    public boolean done() {
                        try {
                            region.registerInterest((Object)"ALL_KEYS");
                        }
                        catch (NoSubscriptionServersAvailableException e) {
                            return false;
                        }
                        return true;
                    }
                }, 30000L, 1000L, true);
            }
        });
    }

    public Properties getClientProperties() {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("durable-client-id", "my_id");
        return props;
    }
}

