/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class DurableRegistrationDUnitTest
extends DistributedTestCase {
    private VM server1VM;
    private VM server2VM;
    private VM durableClientVM;
    private String regionName;
    private int PORT1;
    private int PORT2;
    private static final String K1 = "KEY_STONE1";
    private static final String K2 = "KEY_STONE2";
    private static final String K3 = "KEY_STONE3";
    private static final String K4 = "KEY_STONE4";

    public DurableRegistrationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        this.server1VM = host.getVM(0);
        this.server2VM = host.getVM(1);
        this.durableClientVM = host.getVM(2);
        this.regionName = DurableRegistrationDUnitTest.class.getName() + "_region";
        CacheServerTestUtil.disableShufflingOfEndpoints();
    }

    public void testSimpleDurableClient() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.PORT1 = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.PORT2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 600;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableRegistrationDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, this.PORT2, true, 0), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 600), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K1, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K2, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K3, new Boolean(true)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K4, new Boolean(true)});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K1, "Value1"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K2, "Value2"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K3, "Value3"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K4, "Value4"});
        DurableRegistrationDUnitTest.pause(1000);
        DurableRegistrationDUnitTest.assertEquals((Object)"Value1", (Object)this.server2VM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value1", (Object)this.server1VM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value1", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value2", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K2}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value3", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K3}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value4", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K4}));
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "closeCache");
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K1, "PingPong1"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K2, "PingPong2"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K3, "PingPong3"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K4, "PingPong4"});
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableRegistrationDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, this.PORT2, true, 0), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        DurableRegistrationDUnitTest.pause(5000);
        DurableRegistrationDUnitTest.assertNull((Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertNull((Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K2}));
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K1, new Boolean(false)});
        DurableRegistrationDUnitTest.pause(5000);
        DurableRegistrationDUnitTest.assertNull((Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertNull((Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K2}));
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K1, "PingPong_updated_1"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K2, "PingPong_updated_2"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K3, "PingPong_updated_3"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K4, "PingPong_updated_4"});
        DurableRegistrationDUnitTest.pause(5000);
        DurableRegistrationDUnitTest.assertEquals((Object)"PingPong_updated_1", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertNull((Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K2}));
        DurableRegistrationDUnitTest.assertEquals((Object)"PingPong_updated_3", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K3}));
        DurableRegistrationDUnitTest.assertEquals((Object)"PingPong_updated_4", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K4}));
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testSimpleDurableClientWithRegistration() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.PORT1 = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.PORT2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 600;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableRegistrationDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, this.PORT2, true, 0), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 600)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K1, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K2, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K3, new Boolean(true)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K4, new Boolean(true)});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K1, "Value1"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K2, "Value2"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K3, "Value3"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K4, "Value4"});
        DurableRegistrationDUnitTest.pause(1000);
        DurableRegistrationDUnitTest.assertEquals((Object)"Value1", (Object)this.server2VM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value1", (Object)this.server1VM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value1", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value2", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K2}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value3", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K3}));
        DurableRegistrationDUnitTest.assertEquals((Object)"Value4", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K4}));
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "closeCache");
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K1, "PingPong1"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K2, "PingPong2"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K3, "PingPong3"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K4, "PingPong4"});
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableRegistrationDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, this.PORT2, true, 0), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K3, new Boolean(true)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K4, new Boolean(true)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K1, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K2, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "unregisterKey", new Object[]{K1});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "unregisterKey", new Object[]{K3});
        DurableRegistrationDUnitTest.pause(5000);
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K1, "PingPong_updated_1"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K2, "PingPong_updated_2"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K3, "PingPong_updated_3"});
        this.server2VM.invoke(DurableRegistrationDUnitTest.class, "putValue", new Object[]{K4, "PingPong_updated_4"});
        DurableRegistrationDUnitTest.pause(5000);
        try {
            DurableRegistrationDUnitTest.assertEquals((Object)"PingPong_updated_2", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K2}));
        }
        catch (Exception e) {
            DurableRegistrationDUnitTest.fail((String)("Prob in KEY_STONE2: " + this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K2})));
        }
        try {
            DurableRegistrationDUnitTest.assertEquals((Object)"PingPong_updated_4", (Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K4}));
        }
        catch (Exception e) {
            DurableRegistrationDUnitTest.fail((String)("Prob in KEY_STONE4: " + this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K4})));
        }
        try {
            DurableRegistrationDUnitTest.assertNull((Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1}));
        }
        catch (Exception e) {
            DurableRegistrationDUnitTest.fail((String)("Prob in KEY_STONE1: " + this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K1})));
        }
        try {
            DurableRegistrationDUnitTest.assertNull((Object)this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K3}));
        }
        catch (Exception e) {
            DurableRegistrationDUnitTest.fail((String)("Prob in KEY_STONE3: " + this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "getValue", new Object[]{K3})));
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testDurableClientWithRegistrationHA() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.PORT2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        this.PORT1 = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 600;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableRegistrationDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, this.PORT2, true, 1), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 600)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K1, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K2, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K3, new Boolean(true)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K4, new Boolean(true)});
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), this.PORT2});
        DurableRegistrationDUnitTest.pause(3000);
        this.server2VM.invoke(new CacheSerializableRunnable("Verify Interests."){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Verifying interests registered by DurableClient. ###");
                CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                CacheClientProxy p = null;
                for (int i = 0; i < 60; ++i) {
                    Iterator ps = ccn.getClientProxies().iterator();
                    if (ps.hasNext()) {
                        p = (CacheClientProxy)ps.next();
                        break;
                    }
                    DistributedTestCase.pause(1000);
                }
                if (p == null) {
                    TestCase.fail((String)"Proxy initialization taking long time. Increase the wait time.");
                }
                Iterator rs = p.getInterestRegisteredRegions().iterator();
                String rName = (String)rs.next();
                TestCase.assertNotNull((String)"Null region Name found.", rs);
                LocalRegion r = (LocalRegion)GemFireCacheImpl.getInstance().getRegion(rName);
                TestCase.assertNotNull((String)"Null region found.", (Object)r);
                FilterProfile pf = r.getFilterProfile();
                Set intrests = Collections.EMPTY_SET;
                Set interestKeys = pf.getKeysOfInterest((Object)p.getProxyID().getDurableId());
                TestCase.assertNotNull((String)"durable Interests not found for the proxy", (Object)interestKeys);
                TestCase.assertEquals((String)"The number of durable keys registered during HARegion GII doesn't match.", (int)interestKeys.size(), (int)2);
                interestKeys = pf.getKeysOfInterest((Object)p.getProxyID());
                TestCase.assertNotNull((String)"non-durable Interests not found for the proxy", (Object)interestKeys);
                TestCase.assertEquals((String)"The number of non-durable keys registered during HARegion GII doesn't match.", (int)interestKeys.size(), (int)2);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testDurableClientDisConnectWithRegistrationHA() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.PORT2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        this.PORT1 = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 600;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableRegistrationDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, this.PORT2, true, 1), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 600)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K1, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K2, new Boolean(false)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K3, new Boolean(true)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "registerKey", new Object[]{K4, new Boolean(true)});
        this.durableClientVM.invoke(DurableRegistrationDUnitTest.class, "closeCache");
        DurableRegistrationDUnitTest.pause(2000);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableRegistrationDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, this.PORT2, true, 1), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), this.PORT2});
        DurableRegistrationDUnitTest.pause(3000);
        this.server2VM.invoke(new CacheSerializableRunnable("Verify Interests."){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Verifying interests registered by DurableClient. ###");
                CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                CacheClientProxy p = null;
                for (int i = 0; i < 60; ++i) {
                    Iterator ps = ccn.getClientProxies().iterator();
                    if (ps.hasNext()) {
                        p = (CacheClientProxy)ps.next();
                        break;
                    }
                    DistributedTestCase.pause(1000);
                }
                if (p == null) {
                    TestCase.fail((String)"Proxy initialization taking long time. Increase the wait time.");
                }
                Iterator rs = p.getInterestRegisteredRegions().iterator();
                String rName = (String)rs.next();
                TestCase.assertNotNull((String)"Null region Name found.", rs);
                LocalRegion r = (LocalRegion)GemFireCacheImpl.getInstance().getRegion(rName);
                TestCase.assertNotNull((String)"Null region found.", (Object)r);
                FilterProfile pf = r.getFilterProfile();
                Set intrests = Collections.EMPTY_SET;
                Set interestKeys = pf.getKeysOfInterest((Object)p.getProxyID().getDurableId());
                TestCase.assertNotNull((String)"durable Interests not found for the proxy", (Object)interestKeys);
                TestCase.assertEquals((String)"The number of durable keys registered during HARegion GII doesn't match.", (int)interestKeys.size(), (int)2);
                interestKeys = pf.getKeysOfInterest((Object)p.getProxyID());
                TestCase.assertNull((String)"non-durable Interests found for the proxy", (Object)interestKeys);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    private static void unregisterAllKeys() {
        Region region = CacheServerTestUtil.getCache().getRegion(DurableRegistrationDUnitTest.class.getName() + "_region");
        DurableRegistrationDUnitTest.assertNotNull((Object)region);
        region.unregisterInterest((Object)K1);
        region.unregisterInterest((Object)K2);
        region.unregisterInterest((Object)K3);
        region.unregisterInterest((Object)K4);
    }

    private static void registerKeys() throws Exception {
        try {
            Region region = CacheServerTestUtil.getCache().getRegion(DurableRegistrationDUnitTest.class.getName() + "_region");
            DurableRegistrationDUnitTest.assertNotNull((Object)region);
            region.registerInterest((Object)K1, InterestResultPolicy.KEYS_VALUES, false);
            region.registerInterest((Object)K2, InterestResultPolicy.KEYS_VALUES, false);
            region.registerInterest((Object)K3, InterestResultPolicy.KEYS_VALUES, true);
            region.registerInterest((Object)K4, InterestResultPolicy.KEYS_VALUES, true);
            DurableRegistrationDUnitTest.assertNotNull((Object)region.getInterestList());
        }
        catch (Exception ex) {
            DurableRegistrationDUnitTest.fail("failed while registering interest in registerKey function", ex);
        }
    }

    private static String getValue(String key) {
        Region r = CacheServerTestUtil.getCache().getRegion(DurableRegistrationDUnitTest.class.getName() + "_region");
        DurableRegistrationDUnitTest.assertNotNull((Object)r);
        Region.Entry re = r.getEntry((Object)key);
        if (re == null) {
            return null;
        }
        return (String)re.getValue();
    }

    private static void registerKey(String key, boolean isDurable) throws Exception {
        try {
            Region region = CacheServerTestUtil.getCache().getRegion(DurableRegistrationDUnitTest.class.getName() + "_region");
            DurableRegistrationDUnitTest.assertNotNull((Object)region);
            region.registerInterest((Object)key, InterestResultPolicy.NONE, isDurable);
        }
        catch (Exception ex) {
            DurableRegistrationDUnitTest.fail("failed while registering interest in registerKey function", ex);
        }
    }

    private static void unregisterKey(String key) throws Exception {
        try {
            Region region = CacheServerTestUtil.getCache().getRegion(DurableRegistrationDUnitTest.class.getName() + "_region");
            DurableRegistrationDUnitTest.assertNotNull((Object)region);
            region.unregisterInterest((Object)key);
        }
        catch (Exception ex) {
            DurableRegistrationDUnitTest.fail("failed while registering interest in registerKey function", ex);
        }
    }

    private static void putValue(String key, String value) {
        try {
            Region r = CacheServerTestUtil.getCache().getRegion(DurableRegistrationDUnitTest.class.getName() + "_region");
            DurableRegistrationDUnitTest.assertNotNull((Object)r);
            if (r.getEntry((Object)key) != null) {
                r.put((Object)key, (Object)value);
            } else {
                r.create((Object)key, (Object)value);
            }
            DurableRegistrationDUnitTest.assertEquals((Object)value, (Object)r.getEntry((Object)key).getValue());
        }
        catch (Exception e) {
            DurableRegistrationDUnitTest.fail((String)"Put in Server has some fight");
        }
    }

    private Pool getClientPool(String host, int server1Port, int server2Port, boolean establishCallbackConnection, int redundancyLevel) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, server1Port).addServer(host, server2Port).setSubscriptionEnabled(establishCallbackConnection).setSubscriptionRedundancy(redundancyLevel);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    private Properties getClientDistributedSystemProperties(String durableClientId) {
        return this.getClientDistributedSystemProperties(durableClientId, 300);
    }

    private static void checkNumberOfClientProxies(final int expected) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return expected == DurableRegistrationDUnitTest.getNumberOfClientProxies();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 15000L, 200L, true);
    }

    protected static int getNumberOfClientProxies() {
        return DurableRegistrationDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier().getClientProxies().size();
    }

    private Properties getClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }

    private static CacheClientProxy getClientProxy() {
        CacheClientNotifier notifier = DurableRegistrationDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
        CacheClientProxy proxy = null;
        Iterator i = notifier.getClientProxies().iterator();
        if (i.hasNext()) {
            proxy = (CacheClientProxy)i.next();
        }
        return proxy;
    }

    private static BridgeServerImpl getBridgeServer() {
        BridgeServerImpl bridgeServer = (BridgeServerImpl)CacheServerTestUtil.getCache().getBridgeServers().iterator().next();
        DurableRegistrationDUnitTest.assertNotNull((Object)bridgeServer);
        return bridgeServer;
    }

    public static void closeCache() {
        Cache cache = CacheServerTestUtil.getCache();
        if (cache != null && !cache.isClosed()) {
            cache.close(true);
            cache.getDistributedSystem().disconnect();
        }
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }
}

