/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class EventIDVerificationDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    static VM vm0 = null;
    static VM vm1 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "EventIDVerificationDUnitTest_region";
    protected static EventID eventId;
    static boolean gotCallback;
    static boolean testEventIDResult;

    public EventIDVerificationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
        PORT1 = (Integer)vm0.invoke(EventIDVerificationDUnitTest.class, "createServerCache");
        PORT2 = (Integer)vm1.invoke(EventIDVerificationDUnitTest.class, "createServerCache");
        EventIDVerificationDUnitTest.createClientCache(EventIDVerificationDUnitTest.getServerHostName(host), new Integer(PORT1), new Integer(PORT2));
        CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter());
    }

    public void testEventIDOnServer() {
        EventIDVerificationDUnitTest.createEntry();
        Boolean pass = (Boolean)vm0.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
        EventIDVerificationDUnitTest.put();
        pass = (Boolean)vm0.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
        EventIDVerificationDUnitTest.destroy();
        pass = (Boolean)vm0.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
        EventIDVerificationDUnitTest.put();
        cache.getLogger().info("going to remove");
        EventIDVerificationDUnitTest.remove();
        cache.getLogger().info("after remove");
        pass = (Boolean)vm0.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
    }

    public void testEventIDPrapogationOnServerDuringRegionDestroy() {
        EventIDVerificationDUnitTest.destroyRegion();
        Boolean pass = (Boolean)vm0.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
        pass = (Boolean)vm1.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
    }

    public void testEventIDPrapogationOnServerDuringRegionClear() {
        EventIDVerificationDUnitTest.clearRegion();
        Boolean pass = (Boolean)vm0.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
        pass = (Boolean)vm1.invoke(EventIDVerificationDUnitTest.class, "verifyResult");
        EventIDVerificationDUnitTest.assertTrue((boolean)pass);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        EventIDVerificationDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        EventIDVerificationDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new EventIDVerificationDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.NONE);
        BridgeTestCase.configureConnectionPool(factory, host, new int[]{PORT1, PORT2}, true, -1, 2, null, -1, -1, false, -2);
        CacheWriterAdapter writer = new CacheWriterAdapter(){

            public void beforeCreate(EntryEvent event) {
                vm0.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((EntryEventImpl)event).getEventId()});
                vm1.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((EntryEventImpl)event).getEventId()});
                try {
                    super.beforeCreate(event);
                }
                catch (CacheWriterException e) {
                    e.printStackTrace();
                    TestCase.fail((String)("Test failed bcoz of exception =" + (Object)((Object)e)));
                }
            }

            public void beforeUpdate(EntryEvent event) {
                vm0.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((EntryEventImpl)event).getEventId()});
                vm1.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((EntryEventImpl)event).getEventId()});
                try {
                    super.beforeUpdate(event);
                }
                catch (CacheWriterException e) {
                    e.printStackTrace();
                    TestCase.fail((String)("Test failed bcoz of exception =" + (Object)((Object)e)));
                }
            }

            public void beforeDestroy(EntryEvent event) {
                vm0.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((EntryEventImpl)event).getEventId()});
                vm1.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((EntryEventImpl)event).getEventId()});
                try {
                    super.beforeDestroy(event);
                }
                catch (CacheWriterException e) {
                    e.printStackTrace();
                    TestCase.fail((String)("Test failed bcoz of exception =" + (Object)((Object)e)));
                }
            }

            public void beforeRegionDestroy(RegionEvent event) {
                vm0.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((RegionEventImpl)event).getEventId()});
                vm1.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((RegionEventImpl)event).getEventId()});
                try {
                    super.beforeRegionDestroy(event);
                }
                catch (CacheWriterException e) {
                    e.printStackTrace();
                    TestCase.fail((String)("Test failed bcoz of exception =" + (Object)((Object)e)));
                }
            }

            public void beforeRegionClear(RegionEvent event) {
                vm0.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((RegionEventImpl)event).getEventId()});
                vm1.invoke(EventIDVerificationDUnitTest.class, "setEventIDData", new Object[]{((RegionEventImpl)event).getEventId()});
                try {
                    super.beforeRegionClear(event);
                }
                catch (CacheWriterException e) {
                    e.printStackTrace();
                    TestCase.fail((String)("Test failed bcoz of exception =" + (Object)((Object)e)));
                }
            }
        };
        factory.setCacheWriter((CacheWriter)writer);
        RegionAttributes attrs = factory.create();
        Region r = cache.createRegion(REGION_NAME, attrs);
        r.registerInterest((Object)"ALL_KEYS");
    }

    public static void setEventIDData(Object evID) {
        eventId = (EventID)evID;
    }

    public static Integer createServerCache() throws Exception {
        new EventIDVerificationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCreate(EntryEvent event) {
                Class<EventIDVerificationDUnitTest> clazz = EventIDVerificationDUnitTest.class;
                synchronized (EventIDVerificationDUnitTest.class) {
                    gotCallback = true;
                    testEventIDResult = ((EntryEventImpl)event).getEventId().equals((Object)eventId);
                    EventIDVerificationDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterUpdate(EntryEvent event) {
                Class<EventIDVerificationDUnitTest> clazz = EventIDVerificationDUnitTest.class;
                synchronized (EventIDVerificationDUnitTest.class) {
                    gotCallback = true;
                    testEventIDResult = ((EntryEventImpl)event).getEventId().equals((Object)eventId);
                    EventIDVerificationDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterDestroy(EntryEvent event) {
                Class<EventIDVerificationDUnitTest> clazz = EventIDVerificationDUnitTest.class;
                synchronized (EventIDVerificationDUnitTest.class) {
                    gotCallback = true;
                    testEventIDResult = ((EntryEventImpl)event).getEventId().equals((Object)eventId);
                    EventIDVerificationDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRegionDestroy(RegionEvent event) {
                Class<EventIDVerificationDUnitTest> clazz = EventIDVerificationDUnitTest.class;
                synchronized (EventIDVerificationDUnitTest.class) {
                    gotCallback = true;
                    testEventIDResult = ((RegionEventImpl)event).getEventId().equals((Object)eventId);
                    EventIDVerificationDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRegionClear(RegionEvent event) {
                Class<EventIDVerificationDUnitTest> clazz = EventIDVerificationDUnitTest.class;
                synchronized (EventIDVerificationDUnitTest.class) {
                    gotCallback = true;
                    testEventIDResult = ((RegionEventImpl)event).getEventId().equals((Object)eventId);
                    EventIDVerificationDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public static void createEntry() {
        try {
            Region r = cache.getRegion("/EventIDVerificationDUnitTest_region");
            EventIDVerificationDUnitTest.assertNotNull((Object)r);
            if (!r.containsKey((Object)"key-1")) {
                r.create((Object)"key-1", (Object)"key-1");
            }
            EventIDVerificationDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)"key-1");
        }
        catch (Exception ex) {
            EventIDVerificationDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void put() {
        try {
            Region r = cache.getRegion("/EventIDVerificationDUnitTest_region");
            EventIDVerificationDUnitTest.assertNotNull((Object)r);
            r.put((Object)"key-1", (Object)"vm2-key-1");
            EventIDVerificationDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)"vm2-key-1");
        }
        catch (Exception ex) {
            EventIDVerificationDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void destroy() {
        try {
            Region r = cache.getRegion("/EventIDVerificationDUnitTest_region");
            EventIDVerificationDUnitTest.assertNotNull((Object)r);
            r.destroy((Object)"key-1");
        }
        catch (Exception ex) {
            EventIDVerificationDUnitTest.fail("test failed due to exception in destroy ", ex);
        }
    }

    public static void remove() {
        try {
            Region r = cache.getRegion("/EventIDVerificationDUnitTest_region");
            EventIDVerificationDUnitTest.assertNotNull((Object)r);
            r.remove((Object)"key-1");
        }
        catch (Exception ex) {
            EventIDVerificationDUnitTest.fail("test failed due to exception in remove ", ex);
        }
    }

    public static void destroyRegion() {
        try {
            Region r = cache.getRegion("/EventIDVerificationDUnitTest_region");
            EventIDVerificationDUnitTest.assertNotNull((Object)r);
            r.destroyRegion();
        }
        catch (Exception ex) {
            EventIDVerificationDUnitTest.fail("test failed due to exception in destroyRegion ", ex);
        }
    }

    public static void clearRegion() {
        try {
            Region r = cache.getRegion("/EventIDVerificationDUnitTest_region");
            EventIDVerificationDUnitTest.assertNotNull((Object)r);
            r.clear();
        }
        catch (Exception ex) {
            EventIDVerificationDUnitTest.fail("test failed due to exception in clearRegion ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean verifyResult() {
        Class<EventIDVerificationDUnitTest> clazz = EventIDVerificationDUnitTest.class;
        synchronized (EventIDVerificationDUnitTest.class) {
            if (!gotCallback) {
                try {
                    EventIDVerificationDUnitTest.class.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    gotCallback = false;
                    e.printStackTrace();
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return Boolean.FALSE;
                }
            }
            gotCallback = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            boolean temp = testEventIDResult;
            testEventIDResult = false;
            return new Boolean(temp);
        }
    }

    public static void verifyEventIDsDuringRegionDestroy(RegionEvent event) {
        EventIDVerificationDUnitTest.assertEquals((Object)eventId, (Object)((RegionEventImpl)event).getEventId());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        EventIDVerificationDUnitTest.closeCache();
        vm0.invoke(EventIDVerificationDUnitTest.class, "closeCache");
        vm1.invoke(EventIDVerificationDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        gotCallback = false;
        testEventIDResult = false;
    }
}

