/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class EventIDVerificationInP2PDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    static VM vm0 = null;
    private static final String REGION_NAME = "EventIDVerificationInP2PDUnitTest_region";
    protected static EventID eventId;
    static boolean receiver;
    static boolean gotCallback;
    static int DISTRIBUTED_ACK;
    static int GLOBAL;

    public EventIDVerificationInP2PDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        receiver = false;
    }

    public void testEventIDsDACK() throws Exception {
        EventIDVerificationInP2PDUnitTest.createServerCache(new Integer(DISTRIBUTED_ACK));
        vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "createServerCache", new Object[]{new Integer(DISTRIBUTED_ACK)});
        EventIDVerificationInP2PDUnitTest.verifyOperations();
    }

    public void testEventIDsGLOBAL() throws Exception {
        EventIDVerificationInP2PDUnitTest.createServerCache(new Integer(GLOBAL));
        vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "createServerCache", new Object[]{new Integer(GLOBAL)});
        EventIDVerificationInP2PDUnitTest.verifyOperations();
    }

    public void _testEventIDsNOACK() throws Exception {
        EventIDVerificationInP2PDUnitTest.createServerCache(new Integer(0));
        vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "createServerCache", new Object[]{new Integer(0)});
        EventIDVerificationInP2PDUnitTest.createEntry();
        Boolean pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertFalse((boolean)pass);
        EventIDVerificationInP2PDUnitTest.put();
        pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertFalse((boolean)pass);
        EventIDVerificationInP2PDUnitTest.destroy();
        pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertFalse((boolean)pass);
        EventIDVerificationInP2PDUnitTest.destroyRegion();
        pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertFalse((boolean)pass);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        EventIDVerificationInP2PDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        EventIDVerificationInP2PDUnitTest.assertNotNull((Object)cache);
    }

    public static void createServerCache(Integer type) throws Exception {
        new EventIDVerificationInP2PDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        if (type == DISTRIBUTED_ACK) {
            factory.setScope(Scope.DISTRIBUTED_ACK);
        }
        if (type == GLOBAL) {
            factory.setScope(Scope.GLOBAL);
        } else {
            factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        }
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void afterCreate(EntryEvent event) {
                eventId = ((InternalCacheEvent)event).getEventId();
                if (!receiver) return;
                Class<EventIDVerificationInP2PDUnitTest> clazz = EventIDVerificationInP2PDUnitTest.class;
                synchronized (EventIDVerificationInP2PDUnitTest.class) {
                    gotCallback = true;
                    EventIDVerificationInP2PDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void afterUpdate(EntryEvent event) {
                eventId = ((InternalCacheEvent)event).getEventId();
                if (!receiver) return;
                Class<EventIDVerificationInP2PDUnitTest> clazz = EventIDVerificationInP2PDUnitTest.class;
                synchronized (EventIDVerificationInP2PDUnitTest.class) {
                    gotCallback = true;
                    EventIDVerificationInP2PDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void afterDestroy(EntryEvent event) {
                eventId = ((InternalCacheEvent)event).getEventId();
                if (!receiver) return;
                Class<EventIDVerificationInP2PDUnitTest> clazz = EventIDVerificationInP2PDUnitTest.class;
                synchronized (EventIDVerificationInP2PDUnitTest.class) {
                    gotCallback = true;
                    EventIDVerificationInP2PDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void afterRegionDestroy(RegionEvent event) {
                eventId = ((InternalCacheEvent)event).getEventId();
                if (!receiver) return;
                Class<EventIDVerificationInP2PDUnitTest> clazz = EventIDVerificationInP2PDUnitTest.class;
                synchronized (EventIDVerificationInP2PDUnitTest.class) {
                    gotCallback = true;
                    EventIDVerificationInP2PDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void afterRegionInvalidate(RegionEvent event) {
                eventId = ((InternalCacheEvent)event).getEventId();
                if (!receiver) return;
                Class<EventIDVerificationInP2PDUnitTest> clazz = EventIDVerificationInP2PDUnitTest.class;
                synchronized (EventIDVerificationInP2PDUnitTest.class) {
                    gotCallback = true;
                    EventIDVerificationInP2PDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static void createEntry() {
        try {
            Region r = cache.getRegion("/EventIDVerificationInP2PDUnitTest_region");
            EventIDVerificationInP2PDUnitTest.assertNotNull((Object)r);
            if (!r.containsKey((Object)"key-1")) {
                r.create((Object)"key-1", (Object)"key-1");
            }
            EventIDVerificationInP2PDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)"key-1");
        }
        catch (Exception ex) {
            EventIDVerificationInP2PDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void put() {
        try {
            Region r = cache.getRegion("/EventIDVerificationInP2PDUnitTest_region");
            EventIDVerificationInP2PDUnitTest.assertNotNull((Object)r);
            r.put((Object)"key-1", (Object)"vm0-key-1");
            EventIDVerificationInP2PDUnitTest.assertEquals((Object)r.getEntry((Object)"key-1").getValue(), (Object)"vm0-key-1");
        }
        catch (Exception ex) {
            EventIDVerificationInP2PDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void destroy() {
        try {
            Region r = cache.getRegion("/EventIDVerificationInP2PDUnitTest_region");
            EventIDVerificationInP2PDUnitTest.assertNotNull((Object)r);
            r.destroy((Object)"key-1");
        }
        catch (Exception ex) {
            EventIDVerificationInP2PDUnitTest.fail("test failed due to exception in destroy ", ex);
        }
    }

    public static void destroyRegion() {
        try {
            Region r = cache.getRegion("/EventIDVerificationInP2PDUnitTest_region");
            EventIDVerificationInP2PDUnitTest.assertNotNull((Object)r);
            r.destroyRegion();
        }
        catch (Exception ex) {
            EventIDVerificationInP2PDUnitTest.fail("test failed due to exception in destroyRegion ", ex);
        }
    }

    public static void invalidateRegion() {
        try {
            Region r = cache.getRegion("/EventIDVerificationInP2PDUnitTest_region");
            EventIDVerificationInP2PDUnitTest.assertNotNull((Object)r);
            r.invalidateRegion();
        }
        catch (Exception ex) {
            EventIDVerificationInP2PDUnitTest.fail("test failed due to exception in invalidateRegion ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean verifyResult(EventID correctId) {
        Class<EventIDVerificationInP2PDUnitTest> clazz = EventIDVerificationInP2PDUnitTest.class;
        synchronized (EventIDVerificationInP2PDUnitTest.class) {
            if (!gotCallback) {
                try {
                    EventIDVerificationInP2PDUnitTest.class.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    gotCallback = false;
                    e.printStackTrace();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return Boolean.FALSE;
                }
            }
            gotCallback = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            boolean temp = correctId.equals((Object)eventId);
            return new Boolean(temp);
        }
    }

    public static void verifyOperations() {
        EventIDVerificationInP2PDUnitTest.createEntry();
        Boolean pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertTrue((boolean)pass);
        EventIDVerificationInP2PDUnitTest.put();
        pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertTrue((boolean)pass);
        EventIDVerificationInP2PDUnitTest.invalidateRegion();
        pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertTrue((boolean)pass);
        EventIDVerificationInP2PDUnitTest.destroy();
        pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertTrue((boolean)pass);
        EventIDVerificationInP2PDUnitTest.destroyRegion();
        pass = (Boolean)vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "verifyResult", new Object[]{eventId});
        EventIDVerificationInP2PDUnitTest.assertTrue((boolean)pass);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        EventIDVerificationInP2PDUnitTest.closeCache();
        vm0.invoke(EventIDVerificationInP2PDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        receiver = true;
        gotCallback = false;
        DISTRIBUTED_ACK = 1;
        GLOBAL = 2;
    }
}

