/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FaultyDelta
implements Delta,
DataSerializable {
    public static final byte INT_MASK = 1;
    public static final byte BIG_OBJECT_MASK = 2;
    public static final byte COMPLETE_MASK = 3;
    protected int intVal = 0;
    protected boolean hasDelta = false;
    protected byte[] bigObj = new byte[2];
    public static boolean isPatternMatched = false;
    protected byte deltaBits = 0;

    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        try {
            byte deltaBits = DataSerializer.readByte((DataInput)in);
            GemFireCacheImpl.getInstance().getLogger().fine("Applying delta on " + this.toString());
            if (deltaBits != 0) {
                if ((deltaBits & 1) == 1) {
                    this.bigObj = DataSerializer.readByteArray((DataInput)in);
                    GemFireCacheImpl.getInstance().getLogger().fine(" Applied delta on DeltaImpl's field 'bigObj' = {" + this.bigObj[0] + " " + this.bigObj[1] + "}");
                }
                if ((deltaBits & 2) == 2) {
                    this.intVal = DataSerializer.readPrimitiveInt((DataInput)in);
                    GemFireCacheImpl.getInstance().getLogger().fine(" Applied delta on DeltaImpl's field 'intVal' = " + this.intVal);
                }
                if ((deltaBits | 3) != 3) {
                    GemFireCacheImpl.getInstance().getLogger().fine(" <unknown field code>");
                    throw new IllegalArgumentException("DeltaImpl.fromDelta(): Unknown field code, " + deltaBits);
                }
            }
        }
        catch (IOException ioe) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.fromDelta(): " + ioe);
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.fromDelta(): " + iae);
            throw new InvalidDeltaException((Throwable)iae);
        }
    }

    public boolean hasDelta() {
        return this.hasDelta;
    }

    public void toDelta(DataOutput out) throws IOException {
        try {
            DataSerializer.writeByte((Byte)this.deltaBits, (DataOutput)out);
            GemFireCacheImpl.getInstance().getLogger().fine("Extracting delta from " + this.toString());
            if ((this.deltaBits & 1) == 1) {
                GemFireCacheImpl.getInstance().getLogger().fine(" Extracted delta from DeltaObj's field 'intVal' = " + this.intVal);
                DataSerializer.writePrimitiveInt((int)this.intVal, (DataOutput)out);
            }
            if ((this.deltaBits & 2) == 2) {
                GemFireCacheImpl.getInstance().getLogger().fine(" Extracted delta from DeltaObj's field 'bigObj' = {" + this.bigObj[0] + " " + this.bigObj[1] + "}");
                DataSerializer.writeByteArray((byte[])this.bigObj, (DataOutput)out);
            }
            if ((this.deltaBits | 3) != 3) {
                GemFireCacheImpl.getInstance().getLogger().fine(" <unknown field code>");
                throw new IllegalArgumentException("DeltaImpl.toDelta(): Unknown field code, " + this.deltaBits);
            }
            DataSerializer.writeByte((Byte)-1, (DataOutput)out);
            GemFireCacheImpl.getInstance().getLogger().fine(" Writing extra DeltaObj's field 'byte' = 255");
            GemFireCacheImpl.getInstance().getLogger().fine("-----------");
            this.resetDeltaStatus();
        }
        catch (IOException ioe) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.toDelta(): " + ioe);
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.toDelta(): " + iae);
            throw new InvalidDeltaException((Throwable)iae);
        }
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.intVal = DataSerializer.readPrimitiveInt((DataInput)in);
        this.bigObj = DataSerializer.readByteArray((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writePrimitiveInt((int)this.intVal, (DataOutput)out);
        DataSerializer.writeByteArray((byte[])this.bigObj, (DataOutput)out);
    }

    public byte[] getBigObj() {
        return this.bigObj;
    }

    public void setBigObj(byte[] bigObj) {
        this.hasDelta = true;
        this.deltaBits = (byte)(this.deltaBits | 2);
        this.bigObj = bigObj;
    }

    public void resetDeltaStatus() {
        this.deltaBits = 0;
        this.hasDelta = false;
    }

    public int getIntVal() {
        return this.intVal;
    }

    public void setIntVal(int intVal) {
        this.hasDelta = true;
        this.deltaBits = (byte)(this.deltaBits | 1);
        this.intVal = intVal;
    }

    public String toString() {
        return "DeltaObj[hasDelta=" + this.hasDelta + ",intVal=" + this.intVal + ",bigObj={" + this.bigObj[0] + "," + this.bigObj[1] + "}]";
    }
}

