/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;

public class ForceInvalidateEvictionDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = -11364213547039967L;

    public ForceInvalidateEvictionDUnitTest(String name) {
        super(name);
    }

    private void doPropagationTest(VM sourceVM, VM destinationVm, boolean validateCallbacks, boolean validateContent) {
        this.addListener(destinationVm);
        this.putEntries(sourceVM, 0, 20);
        this.checkValue(sourceVM, Integer.valueOf(0), null);
        if (validateContent) {
            this.checkValue(destinationVm, Integer.valueOf(0), "value");
        }
        this.invalidateEntry(sourceVM, Integer.valueOf(0));
        this.checkValue(sourceVM, Integer.valueOf(0), null);
        if (validateContent) {
            this.checkValue(destinationVm, Integer.valueOf(0), Token.INVALID);
        }
        if (validateCallbacks) {
            this.checkAndClearListener(destinationVm, Integer.valueOf(0), true);
        }
        this.removeListener(destinationVm);
    }

    public void testPRToAccessor() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPR(vm0);
        this.createPR(vm1);
        this.createAccessor(vm2, true);
        this.doPropagationTest(vm0, vm2, true, false);
        this.doPropagationTest(vm1, vm2, true, false);
    }

    public void testBridgeClientWithPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm3 = host.getVM(3);
        this.createPR(vm0);
        this.createPR(vm1);
        int port = this.addBridgeServer(vm1);
        this.createClient(vm3, port);
        this.doPropagationTest(vm0, vm3, true, true);
        this.doPropagationTest(vm1, vm3, true, true);
    }

    public void testBridgeClientWithAccessorServer() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createPR(vm0);
        this.createPR(vm1);
        this.createAccessor(vm2, false);
        int port = this.addBridgeServer(vm2);
        this.createClient(vm3, port);
        this.doPropagationTest(vm0, vm3, true, true);
    }

    public void testBridgeClientWithAccessorSource() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createPR(vm0);
        this.createPR(vm1);
        this.createAccessor(vm2, false);
        int port1 = this.addBridgeServer(vm0);
        this.createClient(vm3, port1);
        this.doPropagationTest(vm2, vm3, true, true);
        vm3.invoke(new SerializableRunnable("close cache"){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                cache.close();
            }
        });
        int port2 = this.addBridgeServer(vm1);
        this.createClient(vm3, port2);
        this.doPropagationTest(vm2, vm3, true, true);
    }

    private void createPR(VM vm) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setEnableOffHeapMemory(ForceInvalidateEvictionDUnitTest.this.isOffHeapEnabled());
                rf.setDataPolicy(DataPolicy.PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(5);
                rf.setPartitionAttributes(paf.create());
                rf.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1));
                rf.setConcurrencyChecksEnabled(false);
                rf.create(name);
            }
        });
    }

    private void createAccessor(VM vm, final boolean allContent) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setEnableOffHeapMemory(ForceInvalidateEvictionDUnitTest.this.isOffHeapEnabled());
                rf.setDataPolicy(DataPolicy.PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(5);
                paf.setLocalMaxMemory(0);
                rf.setPartitionAttributes(paf.create());
                rf.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1));
                rf.setConcurrencyChecksEnabled(false);
                if (allContent) {
                    rf.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                }
                rf.create(name);
            }
        });
    }

    private void addListener(VM vm) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                Region region = cache.getRegion(name);
                AttributesMutator am = region.getAttributesMutator();
                am.initCacheListeners(new CacheListener[]{new MyListener()});
            }
        });
    }

    private void removeListener(VM vm) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                Region region = cache.getRegion(name);
                AttributesMutator am = region.getAttributesMutator();
                am.initCacheListeners(null);
            }
        });
    }

    private void checkAndClearListener(VM vm, final Serializable key, final boolean invalidated) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                Region region = cache.getRegion(name);
                final MyListener listener = (MyListener)region.getAttributes().getCacheListeners()[0];
                if (invalidated) {
                    DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                        @Override
                        public String description() {
                            return "Didn't receive invalidate after 30 seconds";
                        }

                        @Override
                        public boolean done() {
                            return listener.remove(key);
                        }
                    }, 30000L, 100L, true);
                } else {
                    TestCase.assertFalse((boolean)listener.remove(key));
                }
            }
        });
    }

    private void checkValue(VM vm, final Serializable key, final Object expected) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                final LocalRegion region = (LocalRegion)cache.getRegion(name);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        Object value = null;
                        try {
                            value = region.getValueInVM((Object)key);
                            if (value instanceof CachedDeserializable) {
                                value = ((CachedDeserializable)value).getDeserializedForReading();
                            }
                        }
                        catch (EntryNotFoundException entryNotFoundException) {
                            // empty catch block
                        }
                        return expected == null ? value == null : expected.equals(value);
                    }

                    @Override
                    public String description() {
                        return "Value did not become " + expected + " after 30s: " + region.getValueInVM((Object)key);
                    }
                }, 30000L, 100L, true);
            }
        });
    }

    private void invalidateEntry(VM vm, final Serializable key) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                Region region = cache.getRegion(name);
                region.invalidate((Object)key);
            }
        });
    }

    private void putEntries(VM vm, final int start, final int end) {
        final String name = this.getUniqueName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                Region region = cache.getRegion(name);
                for (int i = start; i < end; ++i) {
                    region.put((Object)i, (Object)"value");
                }
            }
        });
    }

    private void createClient(VM vm, final int port) {
        final String name = this.getUniqueName();
        final Host host = Host.getHost(0);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(host), port);
                pf.setSubscriptionEnabled(true);
                pf.create(name);
                RegionFactory rf = new RegionFactory();
                rf.setEnableOffHeapMemory(ForceInvalidateEvictionDUnitTest.this.isOffHeapEnabled());
                rf.setScope(Scope.LOCAL);
                rf.setPoolName(name);
                Region region = rf.create(name);
                region.registerInterest((Object)"ALL_KEYS");
            }
        });
    }

    private int addBridgeServer(VM vm) {
        final int port = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm);
        vm.invoke(new SerializableRunnable("add bridge server"){

            @Override
            public void run() {
                Cache cache = ForceInvalidateEvictionDUnitTest.this.getCache();
                CacheServer server = cache.addCacheServer();
                server.setNotifyBySubscription(true);
                server.setPort(port);
                try {
                    server.start();
                }
                catch (IOException e) {
                    DistributedTestCase.fail("IO Exception", e);
                }
            }
        });
        return port;
    }

    public boolean isOffHeapEnabled() {
        return false;
    }

    private static class MyListener<K, V>
    extends CacheListenerAdapter<K, V> {
        private static final Object VALUE = new Object();
        Map invalidates = new ConcurrentHashMap();

        private MyListener() {
        }

        public void afterInvalidate(EntryEvent<K, V> event) {
            Object oldValue = event.getOldValue();
            this.invalidates.put(event.getKey(), VALUE);
        }

        public boolean remove(K key) {
            return this.invalidates.remove(key) != null;
        }
    }
}

