/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.internal.cache.tier.sockets.HAInterestBaseTest;
import dunit.DistributedTestCase;
import dunit.VM;

public class HAInterestPart2DUnitTest
extends HAInterestBaseTest {
    public HAInterestPart2DUnitTest(String name) {
        super(name);
    }

    public void testPrimaryFailureInUNregisterInterest() throws Exception {
        HAInterestPart2DUnitTest.createClientPoolCache(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart2DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart2DUnitTest.registerK1AndK2();
        VM oldPrimary = HAInterestPart2DUnitTest.getPrimaryVM();
        HAInterestPart2DUnitTest.stopPrimaryAndUnregisterRegisterK1();
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(1, 2);
        VM newPrimary = HAInterestPart2DUnitTest.getPrimaryVM(oldPrimary);
        newPrimary.invoke(HAInterestBaseTest.class, "verifyDispatcherIsAlive");
        newPrimary.invoke(HAInterestBaseTest.class, "verifyInterestUNRegistration");
        HAInterestPart2DUnitTest.getBackupVM().invoke(HAInterestBaseTest.class, "verifyInterestUNRegistration");
    }

    public void testSecondaryFailureInUNRegisterInterest() throws Exception {
        HAInterestPart2DUnitTest.createClientPoolCache(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart2DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart2DUnitTest.registerK1AndK2();
        VM stoppedBackup = HAInterestPart2DUnitTest.stopSecondaryAndUNregisterK1();
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(1, 2);
        HAInterestPart2DUnitTest.getPrimaryVM().invoke(HAInterestBaseTest.class, "verifyDispatcherIsAlive");
        HAInterestPart2DUnitTest.getPrimaryVM().invoke(HAInterestBaseTest.class, "verifyInterestUNRegistration");
        HAInterestPart2DUnitTest.getBackupVM(stoppedBackup).invoke(HAInterestBaseTest.class, "verifyInterestUNRegistration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDSMDetectsServerLiveJustBeforeInterestRegistration() throws Exception {
        HAInterestPart2DUnitTest.createClientPoolCache(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart2DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        VM backup = HAInterestPart2DUnitTest.getBackupVM();
        backup.invoke(HAInterestBaseTest.class, "stopServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(1, 2);
        HAInterestPart2DUnitTest.setBridgeObserverForBeforeRegistration(backup);
        try {
            HAInterestPart2DUnitTest.registerK1AndK2();
            HAInterestPart2DUnitTest.waitForBeforeRegistrationCallback();
        }
        finally {
            HAInterestPart2DUnitTest.unSetBridgeObserverForRegistrationCallback();
        }
        server1.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server2.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server3.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDSMDetectsServerLiveJustAfterInterestRegistration() throws Exception {
        HAInterestPart2DUnitTest.createClientPoolCache(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart2DUnitTest.createEntriesK1andK2();
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        VM backup = HAInterestPart2DUnitTest.getBackupVM();
        backup.invoke(HAInterestBaseTest.class, "stopServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(1, 2);
        HAInterestPart2DUnitTest.setBridgeObserverForAfterRegistration(backup);
        try {
            HAInterestPart2DUnitTest.registerK1AndK2();
            HAInterestPart2DUnitTest.waitForAfterRegistrationCallback();
        }
        finally {
            HAInterestPart2DUnitTest.unSetBridgeObserverForRegistrationCallback();
        }
        server1.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server2.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
        server3.invoke(HAInterestBaseTest.class, "verifyInterestRegistration");
    }

    public void testRefreshEntriesFromPrimaryWhenDSMDetectsServerLive() throws Exception {
        PORT1 = (Integer)server1.invoke(HAInterestBaseTest.class, "createServerCache");
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart2DUnitTest.createClientPoolCacheConnectionToSingleServer(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart2DUnitTest.registerK1AndK2();
        HAInterestPart2DUnitTest.verifyRefreshedEntriesFromServer();
        DistributedTestCase.ExpectedException expectedEx = HAInterestPart2DUnitTest.addExpectedException(ServerConnectivityException.class.getName());
        server1.invoke(HAInterestBaseTest.class, "stopServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(1, 0);
        server1.invoke(HAInterestBaseTest.class, "putK1andK2");
        server1.invoke(HAInterestBaseTest.class, "startServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(0, 1);
        final Region r1 = cache.getRegion("/HAInterestBaseTest_region");
        HAInterestPart2DUnitTest.assertNotNull((Object)r1);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Region.Entry e2;
                Region.Entry e1;
                try {
                    e1 = r1.getEntry((Object)"k1");
                    if (e1 == null) {
                        this.excuse = "Entry for k1 is null";
                        return false;
                    }
                }
                catch (EntryDestroyedException e) {
                    this.excuse = "Entry destroyed";
                    return false;
                }
                if (!"server-k1".equals(e1.getValue())) {
                    this.excuse = "e1 value is not server_k1";
                    return false;
                }
                try {
                    e2 = r1.getEntry((Object)"k2");
                    if (e2 == null) {
                        this.excuse = "Entry for k2 is null";
                        return false;
                    }
                }
                catch (EntryDestroyedException e) {
                    this.excuse = "Entry destroyed";
                    return false;
                }
                if (!"server-k2".equals(e2.getValue())) {
                    this.excuse = "e2 value is not server_k2";
                    return false;
                }
                return true;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
        expectedEx.remove();
    }

    public void testGIIFromSecondaryWhenDSMDetectsServerLive() throws Exception {
        server1.invoke(HAInterestBaseTest.class, "closeCache");
        server2.invoke(HAInterestBaseTest.class, "closeCache");
        server3.invoke(HAInterestBaseTest.class, "closeCache");
        PORT1 = (Integer)server1.invoke(HAInterestBaseTest.class, "createServerCacheWithLocalRegion");
        PORT2 = (Integer)server2.invoke(HAInterestBaseTest.class, "createServerCacheWithLocalRegion");
        PORT3 = (Integer)server3.invoke(HAInterestBaseTest.class, "createServerCacheWithLocalRegion");
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        server3.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart2DUnitTest.createClientPoolCache(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        VM backup1 = HAInterestPart2DUnitTest.getBackupVM();
        VM backup2 = HAInterestPart2DUnitTest.getBackupVM(backup1);
        backup1.invoke(HAInterestBaseTest.class, "stopServer");
        backup2.invoke(HAInterestBaseTest.class, "stopServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(2, 1);
        HAInterestPart2DUnitTest.registerK1AndK2();
        HAInterestPart2DUnitTest.verifyRefreshedEntriesFromServer();
        backup1.invoke(HAInterestBaseTest.class, "putK1andK2");
        backup1.invoke(HAInterestBaseTest.class, "startServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(1, 2);
        HAInterestPart2DUnitTest.verifyRefreshedEntriesFromServer();
    }

    public void testBug35945() throws Exception {
        PORT1 = (Integer)server1.invoke(HAInterestBaseTest.class, "createServerCache");
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart2DUnitTest.createClientPoolCacheConnectionToSingleServer(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart2DUnitTest.registerK1AndK2();
        HAInterestPart2DUnitTest.verifyRefreshedEntriesFromServer();
        server1.invoke(HAInterestBaseTest.class, "stopServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(1, 0);
        server1.invoke(HAInterestBaseTest.class, "putK1andK2");
        HAInterestPart2DUnitTest.setBridgeObserverForBeforeInterestRecovery();
        server1.invoke(HAInterestBaseTest.class, "startServer");
        HAInterestPart2DUnitTest.verifyDeadAndLiveServers(0, 1);
        HAInterestPart2DUnitTest.waitForBeforeInterestRecoveryCallBack();
        final Region r1 = cache.getRegion("/HAInterestBaseTest_region");
        HAInterestPart2DUnitTest.assertNotNull((Object)r1);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Region.Entry e1 = r1.getEntry((Object)"k1");
                Region.Entry e2 = r1.getEntry((Object)"k2");
                if (e1 == null || !"server_k1_updated".equals(e1.getValue())) {
                    return false;
                }
                return e2 != null && "server-k2".equals(e2.getValue());
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterestRecoveryFailure() throws Exception {
        PORT1 = (Integer)server1.invoke(HAInterestBaseTest.class, "createServerCache");
        server1.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        PORT2 = (Integer)server2.invoke(HAInterestBaseTest.class, "createServerCache");
        server2.invoke(HAInterestBaseTest.class, "createEntriesK1andK2");
        HAInterestPart2DUnitTest.createClientPoolCacheWithSmallRetryInterval(this.getName(), HAInterestPart2DUnitTest.getServerHostName(server1.getHost()));
        HAInterestPart2DUnitTest.registerK1AndK2();
        HAInterestPart2DUnitTest.verifyRefreshedEntriesFromServer();
        VM backup = HAInterestPart2DUnitTest.getBackupVM();
        VM primary = HAInterestPart2DUnitTest.getPrimaryVM();
        cache.getLogger().info("<ExpectedException action=add>Server unreachable</ExpectedException>");
        try {
            backup.invoke(HAInterestBaseTest.class, "stopServer");
            primary.invoke(HAInterestBaseTest.class, "stopServer");
            HAInterestPart2DUnitTest.verifyDeadAndLiveServers(2, 0);
        }
        finally {
            cache.getLogger().info("<ExpectedException action=remove>Server unreachable</ExpectedException>");
        }
        primary.invoke(HAInterestBaseTest.class, "putK1andK2");
        HAInterestPart2DUnitTest.setBridgeObserverForBeforeInterestRecoveryFailure();
        primary.invoke(HAInterestBaseTest.class, "startServer");
        HAInterestPart2DUnitTest.waitForBeforeInterestRecoveryCallBack();
        if (exceptionOccured) {
            HAInterestPart2DUnitTest.fail((String)"The DSM could not ensure that server 1 is started & serevr 2 is stopped");
        }
        final Region r1 = cache.getRegion("/HAInterestBaseTest_region");
        HAInterestPart2DUnitTest.assertNotNull((Object)r1);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                Region.Entry e1 = r1.getEntry((Object)"k1");
                Region.Entry e2 = r1.getEntry((Object)"k2");
                if (e1 == null) {
                    this.excuse = "Entry for k1 still null";
                    return false;
                }
                if (e2 == null) {
                    this.excuse = "Entry for k2 still null";
                    return false;
                }
                if (!"server-k1".equals(e1.getValue())) {
                    this.excuse = "Value for k1 wrong";
                    return false;
                }
                if (!"server-k2".equals(e2.getValue())) {
                    this.excuse = "Value for k2 wrong";
                    return false;
                }
                return true;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }
}

