/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.TestCase;
import objects.ConfigurableObject;

public class InstantiatorPropogationDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM client1 = null;
    private static VM client2 = null;
    private static VM server1 = null;
    private static VM server2 = null;
    private static int PORT1 = -1;
    private static int PORT2 = -1;
    private static int instanceCountWithAllPuts = 3;
    private static int instanceCountWithOnePut = 1;
    private static final String REGION_NAME = "ClientServerInstantiatorRegistrationDUnitTest";
    protected static EventID eventId;
    static boolean testEventIDResult;
    public static boolean testObject20Loaded;

    public InstantiatorPropogationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        client1 = host.getVM(0);
        client2 = host.getVM(1);
        server1 = host.getVM(2);
        server2 = host.getVM(3);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        InstantiatorPropogationDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        InstantiatorPropogationDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new InstantiatorPropogationDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port1.intValue()).setMinConnections(1).setSubscriptionEnabled(true).setPingInterval(200L).create("ClientServerInstantiatorRegistrationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        Region r = cache.createRegion(REGION_NAME, factory.create());
        r.registerInterest((Object)"ALL_KEYS");
    }

    protected int getMaxThreads() {
        return 0;
    }

    private int initServerCache(VM server) {
        Object[] args = new Object[]{new Integer(this.getMaxThreads())};
        return (Integer)server.invoke(InstantiatorPropogationDUnitTest.class, "createServerCache", args);
    }

    public static Integer createServerCache(Integer maxThreads) throws Exception {
        new InstantiatorPropogationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.start();
        return new Integer(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
            InstantiatorPropogationDUnitTest.closeCache();
            client1.invoke(InstantiatorPropogationDUnitTest.class, "closeCache");
            client2.invoke(InstantiatorPropogationDUnitTest.class, "closeCache");
            server1.invoke(InstantiatorPropogationDUnitTest.class, "closeCache");
            server1.invoke(InstantiatorPropogationDUnitTest.class, "closeCache");
        }
        finally {
            InstantiatorPropogationDUnitTest.cleanupAllVms();
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void verifyInstantiators(final int numOfInstantiators) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return InternalInstantiator.getInstantiators().length == numOfInstantiators;
            }

            @Override
            public String description() {
                return "expected " + numOfInstantiators + " but got this " + InternalInstantiator.getInstantiators().length + " instantiators=" + Arrays.toString(InternalInstantiator.getInstantiators());
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public static void registerTestObject1() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject1");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject1", e);
        }
    }

    public static void registerTestObject2() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject2");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject2", e);
        }
    }

    public static void registerTestObject3() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject3");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject3", e);
        }
    }

    public static void registerTestObject4() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject4");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject4", e);
        }
    }

    public static void registerTestObject5() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject5");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject5", e);
        }
    }

    public static void registerTestObject6() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject6");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject6", e);
        }
    }

    public static void registerTestObject7() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject7");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject7", e);
        }
    }

    public static void registerTestObject8() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject8");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject8", e);
        }
    }

    public static void registerTestObject9() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject9");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject9", e);
        }
    }

    public static void registerTestObject10() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject10");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject10", e);
        }
    }

    public static void registerTestObject11() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject11");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject11", e);
        }
    }

    public static void registerTestObject12() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject12");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject11", e);
        }
    }

    public static void registerTestObject13() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject13");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject13", e);
        }
    }

    public static void registerTestObject14() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject14");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject14", e);
        }
    }

    public static void registerTestObject15() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject15");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject15", e);
        }
    }

    public static void registerTestObject16() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject16");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject16", e);
        }
    }

    public static void registerTestObject17() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject17");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject17", e);
        }
    }

    public static void registerTestObject18() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject18");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject18", e);
        }
    }

    public static void registerTestObject19() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject19");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject19", e);
        }
    }

    public static void registerTestObject20() throws Exception {
        try {
            Class<?> cls = Class.forName("com.gemstone.gemfire.internal.cache.tier.sockets.TestObject20");
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(0);
        }
        catch (Exception e) {
            InstantiatorPropogationDUnitTest.fail("Test failed due to exception in TestObject20", e);
        }
    }

    public static void stopServer() {
        try {
            InstantiatorPropogationDUnitTest.assertEquals((String)"Expected exactly one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            InstantiatorPropogationDUnitTest.assertNotNull((Object)bs);
            bs.stop();
        }
        catch (Exception ex) {
            InstantiatorPropogationDUnitTest.fail((String)("while setting stopServer  " + ex));
        }
    }

    public static void startServer() {
        try {
            Cache c = CacheFactory.getAnyInstance();
            InstantiatorPropogationDUnitTest.assertEquals((String)"Expected exactly one BridgeServer", (int)1, (int)c.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            InstantiatorPropogationDUnitTest.assertNotNull((Object)bs);
            bs.start();
        }
        catch (Exception ex) {
            InstantiatorPropogationDUnitTest.fail((String)("while startServer()  " + ex));
        }
    }

    public void testServerUpFirstClientLater() throws Exception {
        PORT1 = this.initServerCache(server1);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        InstantiatorPropogationDUnitTest.pause(3000);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        server1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject1");
        server1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject2");
        server1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(2)});
        client1.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        InstantiatorPropogationDUnitTest.pause(3000);
        client1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(2)});
        client1.invoke(new CacheSerializableRunnable("Put entries from client"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(InstantiatorPropogationDUnitTest.REGION_NAME);
                for (int i = 1; i <= 10; ++i) {
                    region.put((Object)i, (Object)i);
                }
            }
        });
        client1.invoke(new CacheSerializableRunnable("Get all entries from server"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(InstantiatorPropogationDUnitTest.REGION_NAME);
                TestCase.assertEquals((Object)1, (Object)region.get((Object)1));
            }
        });
        server1.invoke(new CacheSerializableRunnable("Put entry from client"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(InstantiatorPropogationDUnitTest.REGION_NAME);
                region.put((Object)1, (Object)20);
            }
        });
        InstantiatorPropogationDUnitTest.pause(3000);
        client1.invoke(new CacheSerializableRunnable("Get entry from client"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion(InstantiatorPropogationDUnitTest.REGION_NAME);
                TestCase.assertEquals((Object)20, (Object)region.get((Object)1));
            }
        });
        InstantiatorPropogationDUnitTest.cleanupAllVms();
    }

    public void testInstantiatorsWith2ClientsN2Servers() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        InstantiatorPropogationDUnitTest.pause(2000);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        client1.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT2)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        InstantiatorPropogationDUnitTest.pause(2000);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        client1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject3");
        InstantiatorPropogationDUnitTest.pause(4000);
        client1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        server1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        server2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
    }

    public void _testInstantiatorsWithServerKill() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT2)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        InstantiatorPropogationDUnitTest.pause(2000);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        client1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject4");
        InstantiatorPropogationDUnitTest.pause(4000);
        server1.invoke(InstantiatorPropogationDUnitTest.class, "stopServer");
        server1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject5");
        server1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject6");
        server2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithAllPuts)});
        server1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithAllPuts)});
        client1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithOnePut)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithAllPuts)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
    }

    public void _testInstantiators() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT2)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        InstantiatorPropogationDUnitTest.pause(2000);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        client1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject10");
        InstantiatorPropogationDUnitTest.pause(4000);
        server1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject11");
        InstantiatorPropogationDUnitTest.pause(4000);
        server2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(2)});
        server1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(2)});
        client1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(2)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(2)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
    }

    public void _testInstantiatorsWithServerKillAndReInvoked() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT2)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        client1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject7");
        client1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithOnePut)});
        server1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithOnePut)});
        server2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithOnePut)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithOnePut)});
        server1.invoke(InstantiatorPropogationDUnitTest.class, "stopServer");
        try {
            client1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            client1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject9");
        }
        catch (Exception exception) {
            // empty catch block
        }
        server1.invoke(InstantiatorPropogationDUnitTest.class, "startServer");
        client1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithAllPuts)});
        server1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithAllPuts)});
        server2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(instanceCountWithAllPuts)});
        InstantiatorPropogationDUnitTest.cleanupAllVms();
    }

    public void _testInstantiatorCount() throws Exception {
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        client1.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        InstantiatorPropogationDUnitTest.createClientCache(InstantiatorPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2));
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        InstantiatorPropogationDUnitTest.pause(2000);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
        client1.invoke(InstantiatorPropogationDUnitTest.class, "registerTestObject12");
        InstantiatorPropogationDUnitTest.pause(4000);
        client1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        server1.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        server2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        client2.invoke(InstantiatorPropogationDUnitTest.class, "verifyInstantiators", new Object[]{new Integer(1)});
        InstantiatorPropogationDUnitTest.verifyInstantiators(1);
        InstantiatorPropogationDUnitTest.cleanupAllVms();
    }

    public static void createClientCache_EventId(String host, Integer port1) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new InstantiatorPropogationDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(true).create("RegisterInstantiatorEventIdDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        cache.createRegion(REGION_NAME, factory.create());
    }

    public void _testInstantiatorsEventIdVerificationClientsAndServers() throws Exception {
        PORT1 = this.initServerCache(server1, 1);
        PORT2 = this.initServerCache(server2, 2);
        InstantiatorPropogationDUnitTest.createClientCache_EventId(InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1));
        client2.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache_EventId", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT2)});
        InstantiatorPropogationDUnitTest.setBridgeObserver1();
        client2.invoke(InstantiatorPropogationDUnitTest.class, "setBridgeObserver2");
        InstantiatorPropogationDUnitTest.registerTestObject19();
        InstantiatorPropogationDUnitTest.pause(10000);
        Boolean pass = (Boolean)client2.invoke(InstantiatorPropogationDUnitTest.class, "verifyResult");
        InstantiatorPropogationDUnitTest.assertTrue((String)"EventId found Different", (boolean)pass);
        PoolImpl.IS_INSTANTIATOR_CALLBACK = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyRegistrationOfInstantiators() throws Exception {
        try {
            PORT1 = this.initServerCache(server1);
            PORT2 = this.initServerCache(server2);
            InstantiatorPropogationDUnitTest.pause(3000);
            InstantiatorPropogationDUnitTest.cleanupAllVms();
            InstantiatorPropogationDUnitTest.createClientCache(InstantiatorPropogationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1));
            client2.invoke(InstantiatorPropogationDUnitTest.class, "createClientCache", new Object[]{InstantiatorPropogationDUnitTest.getServerHostName(server2.getHost()), new Integer(PORT2)});
            InstantiatorPropogationDUnitTest.pause(3000);
            InstantiatorPropogationDUnitTest.cleanupAllVms();
            InstantiatorPropogationDUnitTest.assertTestObject20NotLoaded();
            server1.invoke(InstantiatorPropogationDUnitTest.class, "assertTestObject20NotLoaded");
            server2.invoke(InstantiatorPropogationDUnitTest.class, "assertTestObject20NotLoaded");
            client2.invoke(InstantiatorPropogationDUnitTest.class, "assertTestObject20NotLoaded");
            InstantiatorPropogationDUnitTest.registerTestObject20();
            InstantiatorPropogationDUnitTest.pause(5000);
            InstantiatorPropogationDUnitTest.assertTestObject20Loaded();
            server1.invoke(InstantiatorPropogationDUnitTest.class, "assertTestObject20Loaded");
            client2.invoke(InstantiatorPropogationDUnitTest.class, "assertTestObject20NotLoaded");
        }
        finally {
            InstantiatorPropogationDUnitTest.cleanupAllVms();
            InstantiatorPropogationDUnitTest.disconnectAllFromDS();
        }
    }

    public static void assertTestObject20Loaded() {
        InstantiatorPropogationDUnitTest.assertTrue((String)"TestObject20 is expected to be loaded into VM.", (boolean)testObject20Loaded);
    }

    public static void assertTestObject20NotLoaded() {
        InstantiatorPropogationDUnitTest.assertFalse((String)"TestObject20 is not expected to be loaded into VM.", (boolean)testObject20Loaded);
    }

    public static Boolean verifyResult() {
        boolean temp = testEventIDResult;
        testEventIDResult = false;
        return new Boolean(temp);
    }

    private int initServerCache(VM server, int serverNo) {
        Object[] args = new Object[]{new Integer(this.getMaxThreads())};
        if (serverNo == 1) {
            return (Integer)server.invoke(InstantiatorPropogationDUnitTest.class, "createServerCacheOne", args);
        }
        return (Integer)server.invoke(InstantiatorPropogationDUnitTest.class, "createServerCacheTwo", args);
    }

    public static Integer createServerCacheTwo(Integer maxThreads) throws Exception {
        new InstantiatorPropogationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(port);
    }

    public static Integer createServerCacheOne(Integer maxThreads) throws Exception {
        new InstantiatorPropogationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(port);
    }

    public static void setBridgeObserver1() {
        PoolImpl.IS_INSTANTIATOR_CALLBACK = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void beforeSendingToServer(EventID eventID) {
                eventId = eventID;
                System.out.println("client2= " + client2 + " eventid= " + eventID);
                client2.invoke(InstantiatorPropogationDUnitTest.class, "setEventId", new Object[]{eventId});
            }
        });
    }

    public static void setEventId(EventID eventID) {
        eventId = eventID;
    }

    public static void setBridgeObserver2() {
        PoolImpl.IS_INSTANTIATOR_CALLBACK = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void afterReceivingFromServer(EventID eventID) {
                testEventIDResult = eventID.equals((Object)eventId);
            }
        });
    }

    static {
        testEventIDResult = false;
        testObject20Loaded = false;
    }
}

