/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.ClientSession;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestRegistrationEvent;
import com.gemstone.gemfire.cache.InterestRegistrationListener;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.NoSubscriptionServersAvailableException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class InterestListDUnitTest
extends DistributedTestCase {
    static Cache cache = null;
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    static int PORT1;
    static final Integer key1;
    static final Integer key2;
    static final String key1_originalValue = "key-1-orig-value";
    static final String key2_originalValue = "key-2-orig-value";
    static final String REGION_NAME = "InterestListDUnitTest_region";
    static CacheServer server;
    static InterestListener interestListener;

    public InterestListDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        InterestListDUnitTest.disconnectAllFromDS();
        InterestListDUnitTest.pause(10000);
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        PORT1 = (Integer)this.vm0.invoke(InterestListDUnitTest.class, "createServerCache");
    }

    public void testInterestListRegistration() {
        this.vm1.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1)});
        this.vm2.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1)});
        this.vm1.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm1.invoke(InterestListDUnitTest.class, "registerKey", new Object[]{key1});
        this.vm2.invoke(InterestListDUnitTest.class, "registerKey", new Object[]{key2});
        this.vm1.invoke(InterestListDUnitTest.class, "put", new Object[]{"vm1"});
        InterestListDUnitTest.pause(10000);
        this.vm2.invoke(InterestListDUnitTest.class, "validateEntriesK1andK2", new Object[]{"vm2"});
        this.vm2.invoke(InterestListDUnitTest.class, "put", new Object[]{"vm2"});
        InterestListDUnitTest.pause(10000);
        this.vm1.invoke(InterestListDUnitTest.class, "validateEntriesK1andK2", new Object[]{"vm1"});
        this.vm1.invoke(InterestListDUnitTest.class, "unregisterKey", new Object[]{key1});
        this.vm2.invoke(InterestListDUnitTest.class, "unregisterKey", new Object[]{key2});
        this.vm1.invoke(InterestListDUnitTest.class, "putAgain", new Object[]{"vm1"});
        InterestListDUnitTest.pause(10000);
        this.vm2.invoke(InterestListDUnitTest.class, "validateEntriesAgain", new Object[]{"vm2"});
        this.vm2.invoke(InterestListDUnitTest.class, "putAgain", new Object[]{"vm2"});
        InterestListDUnitTest.pause(10000);
        this.vm1.invoke(InterestListDUnitTest.class, "validateEntriesAgain", new Object[]{"vm1"});
    }

    public void testValueRefresh() {
        this.vm1.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1)});
        this.vm2.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1)});
        this.vm1.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(InterestListDUnitTest.class, "putSingleEntry", new Object[]{key2, "vm2"});
        InterestListDUnitTest.pause(2000);
        this.vm1.invoke(InterestListDUnitTest.class, "validateSingleEntry", new Object[]{key2, key2_originalValue});
        this.vm1.invoke(InterestListDUnitTest.class, "registerKey", new Object[]{key2});
        this.vm1.invoke(InterestListDUnitTest.class, "validateSingleEntry", new Object[]{key2, "vm2"});
        this.vm1.invoke(InterestListDUnitTest.class, "validateSingleEntry", new Object[]{key1, key1_originalValue});
        this.vm1.invoke(InterestListDUnitTest.class, "putSingleEntry", new Object[]{key1, "vm1"});
        InterestListDUnitTest.pause(2000);
        this.vm2.invoke(InterestListDUnitTest.class, "validateSingleEntry", new Object[]{key1, key1_originalValue});
        this.vm2.invoke(InterestListDUnitTest.class, "registerKey", new Object[]{key1});
        this.vm2.invoke(InterestListDUnitTest.class, "validateSingleEntry", new Object[]{key1, "vm1"});
        this.vm2.invoke(InterestListDUnitTest.class, "unregisterKey", new Object[]{key1});
        this.vm1.invoke(InterestListDUnitTest.class, "putSingleEntry", new Object[]{key1, key1_originalValue});
        InterestListDUnitTest.pause(2000);
        this.vm2.invoke(InterestListDUnitTest.class, "validateSingleEntry", new Object[]{key1, "vm1"});
    }

    public void testInterestListRegistration_ALL_KEYS() {
        this.vm1.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1)});
        this.vm2.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1)});
        this.vm1.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(InterestListDUnitTest.class, "registerALL_KEYS");
        this.vm1.invoke(InterestListDUnitTest.class, "put_ALL_KEYS");
        InterestListDUnitTest.pause(10000);
        this.vm2.invoke(InterestListDUnitTest.class, "validate_ALL_KEYS");
    }

    public void testInitializationOfRegionFromInterestList() {
        this.vm0.invoke(InterestListDUnitTest.class, "multiple_put");
        InterestListDUnitTest.pause(1000);
        this.vm1.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1)});
        this.vm2.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1)});
        this.vm1.invoke(InterestListDUnitTest.class, "registerKeys");
        this.vm2.invoke(InterestListDUnitTest.class, "registerKeysAgain");
        InterestListDUnitTest.pause(10000);
        this.vm1.invoke(InterestListDUnitTest.class, "validateRegionEntriesFromInterestListInVm1");
        this.vm2.invoke(InterestListDUnitTest.class, "validateRegionEntriesFromInterestListInVm2");
    }

    public void testInterestListRegistrationOnServer() {
        DistributedMember c1 = (DistributedMember)this.vm1.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), PORT1});
        DistributedMember c2 = (DistributedMember)this.vm2.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), PORT1});
        this.vm1.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm0.invoke(InterestListDUnitTest.class, "registerKeyForClient", new Object[]{c1, key1});
        this.vm0.invoke(InterestListDUnitTest.class, "registerKeyForClient", new Object[]{c2, key2});
        this.vm0.invoke(InterestListDUnitTest.class, "flushQueues");
        this.vm1.invoke(InterestListDUnitTest.class, "put", new Object[]{"vm1"});
        this.vm0.invoke(InterestListDUnitTest.class, "flushQueues");
        this.vm2.invoke(InterestListDUnitTest.class, "validateEntriesK1andK2", new Object[]{"vm2"});
        this.vm2.invoke(InterestListDUnitTest.class, "put", new Object[]{"vm2"});
        this.vm0.invoke(InterestListDUnitTest.class, "flushQueues");
        this.vm1.invoke(InterestListDUnitTest.class, "validateEntriesK1andK2", new Object[]{"vm1"});
        this.vm0.invoke(InterestListDUnitTest.class, "unregisterKeyForClient", new Object[]{c1, key1});
        this.vm0.invoke(InterestListDUnitTest.class, "unregisterKeyForClient", new Object[]{c2, key2});
        this.vm1.invoke(InterestListDUnitTest.class, "putAgain", new Object[]{"vm1"});
        this.vm0.invoke(InterestListDUnitTest.class, "flushQueues");
        this.vm2.invoke(InterestListDUnitTest.class, "validateEntriesAgain", new Object[]{"vm2"});
        this.vm2.invoke(InterestListDUnitTest.class, "putAgain", new Object[]{"vm2"});
        this.vm0.invoke(InterestListDUnitTest.class, "flushQueues");
        this.vm1.invoke(InterestListDUnitTest.class, "validateEntriesAgain", new Object[]{"vm1"});
    }

    public void testInterestRegistrationListeners() {
        int port2 = 0;
        try {
            InterestListDUnitTest.createCache();
            server = InterestListDUnitTest.addCacheServer();
            port2 = server.getPort();
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("Cache creation threw an exception", ex);
        }
        InterestListDUnitTest.addRegisterInterestListener();
        this.vm0.invoke(InterestListDUnitTest.class, "addRegisterInterestListener");
        DistributedMember c1 = (DistributedMember)this.vm1.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), PORT1, port2});
        DistributedMember c2 = (DistributedMember)this.vm2.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), PORT1, port2});
        this.vm1.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(InterestListDUnitTest.class, "createEntriesK1andK2");
        InterestListDUnitTest.getLogWriter().info("test phase 1");
        this.vm1.invoke(InterestListDUnitTest.class, "registerKey", new Object[]{key1});
        this.vm2.invoke(InterestListDUnitTest.class, "registerKey", new Object[]{key2});
        Integer zero = new Integer(0);
        Integer two = new Integer(2);
        interestListener.verifyCountsAndClear(2, 0);
        this.vm0.invoke(InterestListDUnitTest.class, "verifyCountsAndClear", new Object[]{two, zero});
        InterestListDUnitTest.getLogWriter().info("test phase 2");
        this.vm1.invoke(InterestListDUnitTest.class, "unregisterKey", new Object[]{key1});
        this.vm2.invoke(InterestListDUnitTest.class, "unregisterKey", new Object[]{key2});
        interestListener.verifyCountsAndClear(0, 2);
        this.vm0.invoke(InterestListDUnitTest.class, "verifyCountsAndClear", new Object[]{zero, two});
        InterestListDUnitTest.getLogWriter().info("test phase 3");
        InterestListDUnitTest.registerKeyForClient(c1, key1);
        this.vm0.invoke(InterestListDUnitTest.class, "registerKeyForClient", new Object[]{c1, key1});
        InterestListDUnitTest.registerKeyForClient(c2, key2);
        this.vm0.invoke(InterestListDUnitTest.class, "registerKeyForClient", new Object[]{c2, key2});
        interestListener.verifyCountsAndClear(2, 0);
        this.vm0.invoke(InterestListDUnitTest.class, "verifyCountsAndClear", new Object[]{two, zero});
        InterestListDUnitTest.getLogWriter().info("test phase 4");
        InterestListDUnitTest.unregisterKeyForClient(c1, key1);
        this.vm0.invoke(InterestListDUnitTest.class, "unregisterKeyForClient", new Object[]{c1, key1});
        InterestListDUnitTest.unregisterKeyForClient(c2, key2);
        this.vm0.invoke(InterestListDUnitTest.class, "unregisterKeyForClient", new Object[]{c2, key2});
        interestListener.verifyCountsAndClear(0, 2);
        this.vm0.invoke(InterestListDUnitTest.class, "verifyCountsAndClear", new Object[]{zero, two});
    }

    public void testNoAvailableServer() {
        this.vm1.invoke(InterestListDUnitTest.class, "createClientCache", new Object[]{InterestListDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1)});
        this.vm1.invoke(InterestListDUnitTest.class, "registerKey", new Object[]{key1});
        this.vm0.invoke(InterestListDUnitTest.class, "closeCache");
        this.vm1.invoke(InterestListDUnitTest.class, "unregisterKeyEx", new Object[]{key1});
        this.vm1.invoke(InterestListDUnitTest.class, "registerKeyEx", new Object[]{key2});
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        InterestListDUnitTest.assertNotNull((Object)cache);
    }

    public static DistributedMember createClientCache(String host, int port) throws Exception {
        return InterestListDUnitTest.createClientCache(host, port, 0);
    }

    public static DistributedMember createClientCache(String host, int port, int port2) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        props.setProperty("delta-propagation", "false");
        new InterestListDUnitTest("temp").createCache(props);
        PoolFactory pfactory = PoolManager.createFactory().addServer(host, port).setThreadLocalConnections(true).setMinConnections(3).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(10000).setSocketBufferSize(32768);
        if (port2 > 0) {
            pfactory.addServer(host, port2);
        }
        Pool p = pfactory.create("InterestListDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        return cache.getDistributedSystem().getDistributedMember();
    }

    private static void createCache() throws Exception {
        Properties props = new Properties();
        props.setProperty("delta-propagation", "false");
        new InterestListDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableSubscriptionConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    private static CacheServer addCacheServer() throws Exception {
        CacheServer s = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        s.setPort(port);
        s.start();
        return s;
    }

    public static Integer createServerCache() throws Exception {
        InterestListDUnitTest.createCache();
        server = InterestListDUnitTest.addCacheServer();
        return new Integer(server.getPort());
    }

    public static void flushQueues() throws Exception {
        BridgeServerImpl impl = (BridgeServerImpl)server;
        Iterator i$ = impl.getAllClientSessions().iterator();
        while (i$.hasNext()) {
            CacheClientProxy proxy;
            final CacheClientProxy fproxy = proxy = (CacheClientProxy)i$.next();
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return fproxy.getHARegionQueue().size() == 0;
                }

                @Override
                public String description() {
                    return "waiting for queues to drain for " + fproxy.getProxyID();
                }
            };
            DistributedTestCase.waitForCriterion(ev, 50000L, 200L, true);
        }
    }

    public static void addRegisterInterestListener() {
        interestListener = new InterestListener();
        List servers = cache.getCacheServers();
        for (CacheServer s : servers) {
            s.registerInterestRegistrationListener((InterestRegistrationListener)interestListener);
        }
    }

    public static void verifyCountsAndClear(int count1, int count2) {
        interestListener.verifyCountsAndClear(count1, count2);
    }

    public static void createEntriesK1andK2() {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            if (!r.containsKey((Object)key1)) {
                r.create((Object)key1, (Object)key1_originalValue);
            }
            if (!r.containsKey((Object)key2)) {
                r.create((Object)key2, (Object)key2_originalValue);
            }
            InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key1).getValue(), (Object)key1_originalValue);
            InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key2).getValue(), (Object)key2_originalValue);
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    private static void registerKeyOnly(Object key) {
        Region r = cache.getRegion("/InterestListDUnitTest_region");
        InterestListDUnitTest.assertNotNull((Object)r);
        r.registerInterest(key);
    }

    public static void registerKey(Object key) {
        try {
            InterestListDUnitTest.registerKeyOnly(key);
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while registering key(" + key + ")", ex);
        }
    }

    public static void registerKeyForClient(DistributedMember clientId, Object key) {
        try {
            ClientSession cs = server.getClientSession(clientId);
            if (cs.isPrimary()) {
                cs.registerInterest("/InterestListDUnitTest_region", key, InterestResultPolicy.KEYS_VALUES, false);
            }
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while registering key(" + key + ")", ex);
        }
    }

    public static void registerKeyEx(Object key) {
        try {
            InterestListDUnitTest.registerKeyOnly(key);
            InterestListDUnitTest.fail((String)"Expected an exception during register interest with no available servers.");
        }
        catch (NoSubscriptionServersAvailableException ex) {
            InterestListDUnitTest.getLogWriter().info("Got expected exception in registerKey: ");
        }
    }

    public static void registerALL_KEYS() {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"ALL_KEYS");
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while registering ALL_KEYS", ex);
        }
    }

    public static void put_ALL_KEYS() {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            r.put((Object)key1, (Object)"vm1-key-1");
            r.put((Object)key2, (Object)"vm1-key-2");
            InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key1).getValue(), (Object)"vm1-key-1");
            InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key2).getValue(), (Object)"vm1-key-2");
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while put_ALL_KEY()", ex);
        }
    }

    public static void validate_ALL_KEYS() {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key1).getValue(), (Object)"vm1-key-1");
            InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key2).getValue(), (Object)"vm1-key-2");
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while validate_ALL_KEY", ex);
        }
    }

    public static void registerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            list.add("k1");
            list.add("k2");
            r.registerInterest(list);
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while registering keys" + list + "", ex);
        }
    }

    public static void registerKeysAgain() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            list.add("k3");
            list.add("k4");
            list.add("k5");
            r.registerInterest(list);
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while registering keys" + list + "", ex);
        }
    }

    private static void unregisterKeyOnly(Object key) {
        Region r = cache.getRegion("/InterestListDUnitTest_region");
        InterestListDUnitTest.assertNotNull((Object)r);
        r.unregisterInterest(key);
    }

    public static void unregisterKey(Object key) {
        try {
            InterestListDUnitTest.unregisterKeyOnly(key);
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while un-registering key(" + key + ")", ex);
        }
    }

    public static void unregisterKeyForClient(DistributedMember clientId, Object key) {
        try {
            ClientSession cs = server.getClientSession(clientId);
            if (cs.isPrimary()) {
                cs.unregisterInterest("/InterestListDUnitTest_region", key, false);
            }
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while un-registering key(" + key + ") for client " + clientId, ex);
        }
    }

    public static void unregisterKeyEx(Object key) {
        InterestListDUnitTest.unregisterKeyOnly(key);
    }

    public static void validateRegionEntriesFromInterestListInVm1() {
        Region r = cache.getRegion("/InterestListDUnitTest_region");
        InterestListDUnitTest.assertNotNull((Object)r);
        Region.Entry k1 = r.getEntry((Object)"k1");
        Region.Entry k2 = r.getEntry((Object)"k2");
        InterestListDUnitTest.assertNotNull((Object)k1);
        InterestListDUnitTest.assertNotNull((Object)k2);
        InterestListDUnitTest.assertEquals((Object)k1.getValue(), (Object)"server1");
        InterestListDUnitTest.assertEquals((Object)k2.getValue(), (Object)"server2");
    }

    public static void validateRegionEntriesFromInterestListInVm2() {
        Region r = cache.getRegion("/InterestListDUnitTest_region");
        InterestListDUnitTest.assertNotNull((Object)r);
        InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)"k3").getValue(), (Object)"server3");
        InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)"k4").getValue(), (Object)"server4");
        InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)"k5").getValue(), (Object)"server5");
    }

    public static void putSingleEntry(Object key, String value) {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            r.put(key, (Object)value);
            InterestListDUnitTest.assertEquals((Object)r.getEntry(key).getValue(), (Object)value);
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void put(String vm) {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            if (vm.equals("vm1")) {
                r.put((Object)key1, (Object)"vm1-key-1");
                r.put((Object)key2, (Object)"vm1-key-2");
                InterestListDUnitTest.assertEquals((Object)"vm1-key-1", (Object)r.getEntry((Object)key1).getValue());
                InterestListDUnitTest.assertEquals((Object)"vm1-key-2", (Object)r.getEntry((Object)key2).getValue());
            } else {
                r.put((Object)key1, (Object)"vm2-key-1");
                r.put((Object)key2, (Object)"vm2-key-2");
                InterestListDUnitTest.assertEquals((Object)"vm2-key-1", (Object)r.getEntry((Object)key1).getValue());
                InterestListDUnitTest.assertEquals((Object)"vm2-key-2", (Object)r.getEntry((Object)key2).getValue());
            }
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void multiple_put() {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            r.put((Object)"k1", (Object)"server1");
            r.put((Object)"k2", (Object)"server2");
            r.put((Object)"k3", (Object)"server3");
            r.put((Object)"k4", (Object)"server4");
            r.put((Object)"k5", (Object)"server5");
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void putAgain(String vm) {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            if (vm.equals("vm1")) {
                r.put((Object)key1, (Object)"vm1-key-1-again");
                r.put((Object)key2, (Object)"vm1-key-2-again");
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key1).getValue(), (Object)"vm1-key-1-again");
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key2).getValue(), (Object)"vm1-key-2-again");
            } else {
                r.put((Object)key1, (Object)"vm2-key-1-again");
                r.put((Object)key2, (Object)"vm2-key-2-again");
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key1).getValue(), (Object)"vm2-key-1-again");
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key2).getValue(), (Object)"vm2-key-2-again");
            }
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while r.putAgain()", ex);
        }
    }

    public static void validateEntriesK1andK2(final String vm) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    Region r = cache.getRegion("/InterestListDUnitTest_region");
                    TestCase.assertNotNull((Object)r);
                    if (vm.equals("vm1")) {
                        TestCase.assertEquals((Object)"vm2-key-1", (Object)r.getEntry((Object)key1).getValue());
                        TestCase.assertEquals((Object)"vm1-key-2", (Object)r.getEntry((Object)key2).getValue());
                    } else {
                        TestCase.assertEquals((Object)InterestListDUnitTest.key1_originalValue, (Object)r.getEntry((Object)key1).getValue());
                        TestCase.assertEquals((Object)"vm1-key-2", (Object)r.getEntry((Object)key2).getValue());
                    }
                    return true;
                }
                catch (AssertionFailedError ex) {
                    return false;
                }
            }

            @Override
            public String description() {
                return "waiting for client to apply events from server";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 50000L, 200L, true);
    }

    public static void validateSingleEntry(Object key, String value) {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertEquals((Object)value, (Object)r.getEntry(key).getValue());
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while validateSingleEntry()", ex);
        }
    }

    public static void validateEntriesAgain(String vm) {
        try {
            Region r = cache.getRegion("/InterestListDUnitTest_region");
            InterestListDUnitTest.assertNotNull((Object)r);
            if (vm.equals("vm1")) {
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key1).getValue(), (Object)"vm1-key-1-again");
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key2).getValue(), (Object)"vm1-key-2-again");
            } else {
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key1).getValue(), (Object)"vm2-key-1");
                InterestListDUnitTest.assertEquals((Object)r.getEntry((Object)key2).getValue(), (Object)"vm2-key-2");
            }
        }
        catch (Exception ex) {
            InterestListDUnitTest.fail("failed while r.put()", ex);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.vm1.invoke(InterestListDUnitTest.class, "closeCache");
        this.vm2.invoke(InterestListDUnitTest.class, "closeCache");
        this.vm0.invoke(InterestListDUnitTest.class, "closeCache");
        cache = null;
        InterestListDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        key1 = new Integer(1);
        key2 = new Integer(2);
    }

    static class InterestListener
    implements InterestRegistrationListener {
        private int registrationCount;
        private int unregistrationCount;

        public void afterRegisterInterest(InterestRegistrationEvent event) {
            DistributedTestCase.getLogWriter().info("InterestListener.afterRegisterInterest invoked with this event: " + event);
            ++this.registrationCount;
        }

        public void afterUnregisterInterest(InterestRegistrationEvent event) {
            DistributedTestCase.getLogWriter().info("InterestListener.afterUnregisterInterest invoked with this event: " + event);
            ++this.unregistrationCount;
        }

        public void verifyCountsAndClear(int expectedRegistrations, int expectedUnregistrations) {
            TestCase.assertEquals((int)expectedRegistrations, (int)this.registrationCount);
            TestCase.assertEquals((int)expectedUnregistrations, (int)this.unregistrationCount);
            this.registrationCount = 0;
            this.unregistrationCount = 0;
        }

        public void close() {
        }
    }
}

