/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.QueueConnectionImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.shared.HostLocationBase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class InterestListEndpointDUnitTest
extends DistributedTestCase {
    static VM server1 = null;
    static VM server2 = null;
    static VM client1 = null;
    protected static Cache cache = null;
    private static int PORT1;
    private static int PORT2;
    private static Connection conn1;
    private static PoolImpl pool;
    private static final String REGION_NAME = "InterestListEndpointDUnitTest_region";
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String client_k1 = "client-k1";
    private static final String client_k2 = "client-k2";
    private static final String server_k1 = "server-k1";
    private static final String server_k2 = "server-k2";
    static InterestListEndpointDUnitTest impl;

    public InterestListEndpointDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        InterestListEndpointDUnitTest.disconnectAllFromDS();
        InterestListEndpointDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        InterestListEndpointDUnitTest.createImpl();
        for (int i = 0; i < 4; ++i) {
            host.getVM(i).invoke(this.getClass(), "createImpl", null);
        }
        PORT1 = this.initServerCache(server1);
        PORT2 = this.initServerCache(server2);
        InterestListEndpointDUnitTest.pause(5000);
        client1.invoke(impl.getClass(), "createClientCache", new Object[]{InterestListEndpointDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1), new Integer(PORT2)});
    }

    public static void createImpl() {
        impl = new InterestListEndpointDUnitTest("temp");
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        InterestListEndpointDUnitTest.assertNotNull((Object)cache);
    }

    public void testDirectPutOnServer() {
        client1.invoke(impl.getClass(), "createEntriesK1andK2");
        server1.invoke(impl.getClass(), "createEntriesK1andK2");
        server2.invoke(impl.getClass(), "createEntriesK1andK2");
        client1.invoke(impl.getClass(), "registerKey1");
        server1.invoke(impl.getClass(), "put");
        client1.invoke(impl.getClass(), "verifyPut");
    }

    public void testInterestListEndpoint() {
        client1.invoke(impl.getClass(), "createEntriesK1andK2");
        server2.invoke(impl.getClass(), "createEntriesK1andK2");
        server1.invoke(impl.getClass(), "createEntriesK1andK2");
        client1.invoke(impl.getClass(), "registerKey1");
        server1.invoke(impl.getClass(), "verifyIfNotInterestListEndpointAndThenPut");
        server2.invoke(impl.getClass(), "verifyIfNotInterestListEndpointAndThenPut");
        client1.invoke(impl.getClass(), "verifyPut");
    }

    public void testInterestListEndpointAfterFailover() throws Exception {
        long maxWaitTime = 20000L;
        client1.invoke(impl.getClass(), "createEntriesK1andK2");
        server2.invoke(impl.getClass(), "createEntriesK1andK2");
        server1.invoke(impl.getClass(), "createEntriesK1andK2");
        client1.invoke(impl.getClass(), "registerKey1");
        boolean firstIsPrimary = InterestListEndpointDUnitTest.isVm0Primary();
        VM primary = firstIsPrimary ? server1 : server2;
        primary.invoke(impl.getClass(), "stopILEndpointServer");
        InterestListEndpointDUnitTest.pause(5000);
        client1.invoke(new CacheSerializableRunnable("Ensure that the failover from ILEP occurs"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion("/InterestListEndpointDUnitTest_region");
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                pool.acquireConnection();
                try {
                    r.put((Object)"ping", (Object)"pong1");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                try {
                    r.put((Object)"ping", (Object)"pong2");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() != 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
            }
        });
        primary.invoke(impl.getClass(), "put");
        client1.invoke(impl.getClass(), "verifyPut");
    }

    public static boolean isVm0Primary() throws Exception {
        int port = (Integer)client1.invoke(impl.getClass(), "getPrimaryPort");
        return port == PORT1;
    }

    public static int getPrimaryPort() throws Exception {
        Region r1 = cache.getRegion("/InterestListEndpointDUnitTest_region");
        String poolName = r1.getAttributes().getPoolName();
        InterestListEndpointDUnitTest.assertNotNull((Object)poolName);
        pool = (PoolImpl)PoolManager.find((String)poolName);
        InterestListEndpointDUnitTest.assertNotNull((Object)pool);
        InterestListEndpointDUnitTest.assertTrue((pool.getPrimaryName() != null ? 1 : 0) != 0);
        return pool.getPrimaryPort();
    }

    public void testUpdaterThreadIsAliveForFailedEndPoint() {
        client1.invoke(impl.getClass(), "acquirePoolConnection");
        client1.invoke(impl.getClass(), "processException");
        client1.invoke(impl.getClass(), "verifyUpdaterThreadIsAlive");
    }

    public static void acquirePoolConnection() {
        try {
            Region r1 = cache.getRegion("/InterestListEndpointDUnitTest_region");
            InterestListEndpointDUnitTest.assertNotNull((Object)r1);
            String poolName = r1.getAttributes().getPoolName();
            InterestListEndpointDUnitTest.assertNotNull((Object)poolName);
            pool = (PoolImpl)PoolManager.find((String)poolName);
            InterestListEndpointDUnitTest.assertNotNull((Object)pool);
            conn1 = pool.getPrimaryConnection();
            InterestListEndpointDUnitTest.assertNotNull((Object)conn1);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while setting acquireConnections  ", ex);
        }
    }

    public static void processException() {
        try {
            pool.processException((Throwable)new IOException(), conn1);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while setting processException  ", ex);
        }
    }

    public static void verifyUpdaterThreadIsAlive() throws InterruptedException {
        QueueConnectionImpl conn2 = (QueueConnectionImpl)pool.getPrimaryConnection();
        Assert.assertNotSame((Object)conn1, (Object)conn2);
        Assert.assertFalse((boolean)conn1.getServer().equals((HostLocationBase)conn2.getServer()));
        InterestListEndpointDUnitTest.assertNull((Object)((QueueConnectionImpl)conn1).getUpdater());
        InterestListEndpointDUnitTest.assertTrue((boolean)conn2.getUpdater().isAlive());
    }

    public static void stopILEndpointServer() {
        try {
            Iterator iter;
            CacheClientProxy proxy;
            Cache c = CacheFactory.getAnyInstance();
            InterestListEndpointDUnitTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)c.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            InterestListEndpointDUnitTest.assertNotNull((Object)bs);
            InterestListEndpointDUnitTest.assertNotNull((Object)bs.getAcceptor());
            InterestListEndpointDUnitTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            Iterator iter_prox = bs.getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
            if (iter_prox.hasNext() && (proxy = (CacheClientProxy)iter_prox.next()).isPrimary() && (iter = cache.getBridgeServers().iterator()).hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                cache.getLogger().fine("stopping server " + server);
                server.stop();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while setting stopServer  ", ex);
        }
    }

    public static void createEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/InterestListEndpointDUnitTest_region");
            InterestListEndpointDUnitTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)k1)) {
                r1.create((Object)k1, (Object)client_k1);
            }
            if (!r1.containsKey((Object)k2)) {
                r1.create((Object)k2, (Object)client_k2);
            }
            if (r1.getAttributes().getPartitionAttributes() == null) {
                InterestListEndpointDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)client_k1);
                InterestListEndpointDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)client_k2);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("failed while createEntries()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new InterestListEndpointDUnitTest("temp").createCache(props);
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setMinConnections(6).setSocketBufferSize(32768).setReadTimeout(2000).create("InterestListEndpointDUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    protected int getMaxThreads() {
        return 0;
    }

    private int initServerCache(VM server) {
        Object[] args = new Object[]{new Integer(this.getMaxThreads())};
        return (Integer)server.invoke(InterestListEndpointDUnitTest.class, "createServerCache", args);
    }

    public static Integer createServerCache(Integer maxThreads) throws Exception {
        new InterestListEndpointDUnitTest("temp").createCache(new Properties());
        RegionAttributes attrs = impl.createServerCacheAttributes();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setMaxThreads(maxThreads.intValue());
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    protected RegionAttributes createServerCacheAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        return factory.create();
    }

    public static void put() {
        try {
            Region r = cache.getRegion("/InterestListEndpointDUnitTest_region");
            InterestListEndpointDUnitTest.assertNotNull((Object)r);
            r.put((Object)k1, (Object)server_k1);
            r.put((Object)k2, (Object)server_k2);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed while region.put()", ex);
        }
    }

    public static void verifyIfNotInterestListEndpointAndThenPut() {
        try {
            CacheClientProxy proxy;
            Cache c = CacheFactory.getAnyInstance();
            InterestListEndpointDUnitTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)c.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            InterestListEndpointDUnitTest.assertNotNull((Object)bs);
            InterestListEndpointDUnitTest.assertNotNull((Object)bs.getAcceptor());
            InterestListEndpointDUnitTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            Iterator iter = bs.getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
            if (iter.hasNext() && !(proxy = (CacheClientProxy)iter.next()).isPrimary()) {
                Region r = cache.getRegion("/InterestListEndpointDUnitTest_region");
                r.put((Object)k1, (Object)server_k1);
                r.put((Object)k2, (Object)server_k2);
            }
        }
        catch (Exception ex) {
            InterestListEndpointDUnitTest.fail("failed while verifyIfNotInterestListEndpointAndThenPut()", ex);
        }
    }

    public static void registerKey1() {
        try {
            Region r = cache.getRegion("/InterestListEndpointDUnitTest_region");
            InterestListEndpointDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)k1, InterestResultPolicy.KEYS);
        }
        catch (Exception ex) {
            InterestListEndpointDUnitTest.fail("failed while region.registerInterest()", ex);
        }
    }

    public static void verifyPut() {
        try {
            final Region r = cache.getRegion("/InterestListEndpointDUnitTest_region");
            InterestListEndpointDUnitTest.assertNotNull((Object)r);
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Region.Entry e1 = r.getEntry((Object)InterestListEndpointDUnitTest.k1);
                    if (e1 == null) {
                        return false;
                    }
                    Region.Entry e2 = r.getEntry((Object)InterestListEndpointDUnitTest.k2);
                    if (e2 == null) {
                        return false;
                    }
                    Object v1 = e1.getValue();
                    if (!InterestListEndpointDUnitTest.server_k1.equals(v1)) {
                        return false;
                    }
                    Object v2 = e2.getValue();
                    return InterestListEndpointDUnitTest.client_k2.equals(v2);
                }

                @Override
                public String description() {
                    Region.Entry e1 = r.getEntry((Object)InterestListEndpointDUnitTest.k1);
                    if (e1 == null) {
                        return "Entry for k1 is null";
                    }
                    Region.Entry e2 = r.getEntry((Object)InterestListEndpointDUnitTest.k2);
                    if (e2 == null) {
                        return "Entry for k2 is null";
                    }
                    Object v1 = e1.getValue();
                    if (!InterestListEndpointDUnitTest.server_k1.equals(v1)) {
                        return "v1 supposed to be server-k1 but is " + v1;
                    }
                    Object v2 = e2.getValue();
                    if (!InterestListEndpointDUnitTest.client_k2.equals(v2)) {
                        return "v2 supposed to be client-k2 but is " + v2;
                    }
                    return "Test missed a success";
                }
            };
            DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
            InterestListEndpointDUnitTest.assertEquals((Object)server_k1, (Object)r.getEntry((Object)k1).getValue());
            InterestListEndpointDUnitTest.assertEquals((Object)client_k2, (Object)r.getEntry((Object)k2).getValue());
        }
        catch (Exception ex) {
            throw new RuntimeException("failed while region.verifyPut()", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        client1.invoke(impl.getClass(), "closeCache");
        server2.invoke(impl.getClass(), "closeCache");
        server1.invoke(impl.getClass(), "closeCache");
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
        cache = null;
        InterestListEndpointDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }
}

