/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.RedundancyLevelTestBase;
import dunit.DistributedTestCase;
import dunit.Host;

public class RedundancyLevelPart3DUnitTest
extends RedundancyLevelTestBase {
    public RedundancyLevelPart3DUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        DistributedTestCase.disconnectAllFromDS();
    }

    public void testRegisterInterestAndMakePrimaryWithFullRedundancy() {
        try {
            CacheServerTestUtil.disableShufflingOfEndpoints();
            RedundancyLevelPart3DUnitTest.createClientCache(RedundancyLevelPart3DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 3);
            RedundancyLevelPart3DUnitTest.createEntriesK1andK2();
            RedundancyLevelPart3DUnitTest.registerK1AndK2();
            RedundancyLevelPart3DUnitTest.assertEquals((int)3, (int)pool.getRedundantNames().size());
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsNotAlive");
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsNotAlive");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsNotAlive");
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = true;
            PoolImpl.BEFORE_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = true;
            PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = true;
            registerInterestCalled = false;
            makePrimaryCalled = false;
            BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

                public void beforeInterestRegistration() {
                    RedundancyLevelTestBase.registerInterestCalled = true;
                }

                public void beforeInterestRecovery() {
                    RedundancyLevelTestBase.registerInterestCalled = true;
                }

                public void beforePrimaryIdentificationFromBackup() {
                    RedundancyLevelTestBase.makePrimaryCalled = true;
                }
            });
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsNotAlive");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsNotAlive");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(3, 2);
            if (registerInterestCalled) {
                RedundancyLevelPart3DUnitTest.fail((String)"register interest should not have been called since we failed to a redundant server !");
            }
            if (!makePrimaryCalled) {
                RedundancyLevelPart3DUnitTest.fail((String)"make primary should have been called since primary did fail and a new primary was to be chosen ");
            }
            RedundancyLevelPart3DUnitTest.assertEquals((int)2, (int)pool.getRedundantNames().size());
            makePrimaryCalled = false;
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsNotAlive");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(2, 1);
            if (registerInterestCalled) {
                RedundancyLevelPart3DUnitTest.fail((String)"register interest should not have been called since we failed to a redundant server !");
            }
            if (!makePrimaryCalled) {
                RedundancyLevelPart3DUnitTest.fail((String)"make primary should have been called since primary did fail and a new primary was to be chosen ");
            }
            RedundancyLevelPart3DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            makePrimaryCalled = false;
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(1, 0);
            if (registerInterestCalled) {
                RedundancyLevelPart3DUnitTest.fail((String)"register interest should not have been called since we failed to a redundant server !");
            }
            if (!makePrimaryCalled) {
                RedundancyLevelPart3DUnitTest.fail((String)"make primary should have been called since primary did fail and a new primary was to be chosen ");
            }
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
            this.server3.invoke(RedundancyLevelTestBase.class, "stopServer");
            this.server0.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(1, 0);
            if (!registerInterestCalled) {
                RedundancyLevelPart3DUnitTest.fail((String)"register interest should have been called since a recovered server came up!");
            }
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
            PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = false;
            PoolImpl.BEFORE_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
            PoolImpl.BEFORE_RECOVER_INTERST_CALLBACK_FLAG = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RedundancyLevelPart3DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedMoreThanEPs ", ex);
        }
    }

    public void testRegisterInterestAndMakePrimaryWithZeroRedundancy() {
        try {
            CacheServerTestUtil.disableShufflingOfEndpoints();
            RedundancyLevelPart3DUnitTest.createClientCache(RedundancyLevelPart3DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 0);
            RedundancyLevelPart3DUnitTest.createEntriesK1andK2();
            RedundancyLevelPart3DUnitTest.registerK1AndK2();
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(3, 0);
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(2, 0);
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(1, 0);
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
            this.server3.invoke(RedundancyLevelTestBase.class, "stopServer");
            this.server0.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(1, 0);
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RedundancyLevelPart3DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedMoreThanEPs ", ex);
        }
    }

    public void testRegisterInterestAndMakePrimaryWithRedundancyOne() {
        try {
            CacheServerTestUtil.disableShufflingOfEndpoints();
            RedundancyLevelPart3DUnitTest.createClientCache(RedundancyLevelPart3DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1);
            RedundancyLevelPart3DUnitTest.createEntriesK1andK2();
            RedundancyLevelPart3DUnitTest.registerK1AndK2();
            RedundancyLevelPart3DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyCCP");
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart3DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(1, 0);
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
            this.server3.invoke(RedundancyLevelTestBase.class, "stopServer");
            this.server0.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart3DUnitTest.doPuts();
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyDispatcherIsAlive");
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            RedundancyLevelPart3DUnitTest.verifyLiveAndRedundantServers(1, 0);
            RedundancyLevelPart3DUnitTest.assertEquals((int)0, (int)pool.getRedundantNames().size());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RedundancyLevelPart3DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedMoreThanEPs ", ex);
        }
    }
}

