/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.Properties;

public class RegionCloseDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM client1 = null;
    private static int PORT1;
    private static final String REGION_NAME = "RegionCloseDUnitTest_region";
    protected static String clientMembershipId;
    private static Cache cache;

    public RegionCloseDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.client1 = host.getVM(1);
        PORT1 = (Integer)this.server1.invoke(RegionCloseDUnitTest.class, "createServerCache");
        this.client1.invoke(RegionCloseDUnitTest.class, "createClientCache", new Object[]{RegionCloseDUnitTest.getServerHostName(host), new Integer(PORT1)});
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        RegionCloseDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        RegionCloseDUnitTest.assertNotNull((Object)cache);
    }

    public void testCloseRegionOnClient() {
        this.server1.invoke(RegionCloseDUnitTest.class, "VerifyClientProxyOnServerBeforeClose");
        this.client1.invoke(RegionCloseDUnitTest.class, "closeRegion");
        this.server1.invoke(RegionCloseDUnitTest.class, "VerifyClientProxyOnServerAfterClose");
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        PORT1 = port1;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new RegionCloseDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setThreadLocalConnections(true).setSocketBufferSize(1000).setMinConnections(2).create("RegionCloseDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache() throws Exception {
        new RegionCloseDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        RegionCloseDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void VerifyClientProxyOnServerBeforeClose() {
        Cache c = CacheFactory.getAnyInstance();
        RegionCloseDUnitTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)c.getBridgeServers().size());
        final BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return bs.getAcceptor().getCacheClientNotifier().getClientProxies().size() == 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 15000L, 200L, true);
        RegionCloseDUnitTest.assertEquals((int)1, (int)bs.getAcceptor().getCacheClientNotifier().getClientProxies().size());
        Iterator iter = bs.getAcceptor().getCacheClientNotifier().getClientProxies().iterator();
        if (iter.hasNext()) {
            CacheClientProxy proxy = (CacheClientProxy)iter.next();
            clientMembershipId = proxy.getProxyID().toString();
            RegionCloseDUnitTest.assertNotNull((Object)proxy.getHARegion());
        }
    }

    public static void closeRegion() {
        try {
            Region r = cache.getRegion("/RegionCloseDUnitTest_region");
            RegionCloseDUnitTest.assertNotNull((Object)r);
            String poolName = r.getAttributes().getPoolName();
            RegionCloseDUnitTest.assertNotNull((Object)poolName);
            Pool pool = PoolManager.find((String)poolName);
            RegionCloseDUnitTest.assertNotNull((Object)pool);
            r.close();
            pool.destroy();
        }
        catch (Exception ex) {
            RegionCloseDUnitTest.fail("failed while region close", ex);
        }
    }

    public static void VerifyClientProxyOnServerAfterClose() {
        final Cache c = CacheFactory.getAnyInstance();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return c.getBridgeServers().size() == 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 40000L, 200L, true);
        final BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return c.getRegion("/" + clientMembershipId) == null;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 40000L, 200L, true);
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return bs.getAcceptor().getCacheClientNotifier().getClientProxies().size() != 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 40000L, 200L, true);
        RegionCloseDUnitTest.assertEquals((int)0, (int)bs.getAcceptor().getCacheClientNotifier().getClientProxies().size());
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(RegionCloseDUnitTest.class, "closeCache");
        this.server1.invoke(RegionCloseDUnitTest.class, "closeCache");
    }

    static {
        cache = null;
    }
}

