/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class RegisterInterestBeforeRegionCreationDUnitTest
extends DistributedTestCase {
    static VM server1 = null;
    static VM server2 = null;
    static VM client1 = null;
    static VM client2 = null;
    public static int PORT1;
    public static int PORT2;
    private static final String REGION_NAME = "RegisterInterestBeforeRegionCreationDUnitTest_Region";
    protected static Cache cache;

    public RegisterInterestBeforeRegionCreationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "closeCache");
        client2.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "closeCache");
        server1.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "closeCache");
        server2.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "closeCache");
    }

    public void YOGESH_testRegisterInterestHappeningBeforeRegionCreation() throws Exception {
        this.createClientServerConfigurationForClearTest();
        server1.invoke(this.putFromServer());
        client1.invoke(this.verifyIfAllPutsGot());
        server2.invoke(this.createRegionOnServer());
        server2.invoke(this.verifyIfAllPutsGot());
        client2.invoke(this.verifyIfAllPutsGot());
    }

    public void testDummyAsThereIsNoOtherTestInThisClass() {
    }

    private CacheSerializableRunnable putFromServer() {
        CacheSerializableRunnable putFromServer = new CacheSerializableRunnable("putFromServer"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/RegisterInterestBeforeRegionCreationDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)("key" + i), (Object)("value" + i));
                }
            }
        };
        return putFromServer;
    }

    private CacheSerializableRunnable verifyIfAllPutsGot() {
        CacheSerializableRunnable putFromServer = new CacheSerializableRunnable("createRegionOnServer"){

            @Override
            public void run2() throws CacheException {
                final Region region = cache.getRegion("/RegisterInterestBeforeRegionCreationDUnitTest_Region");
                TestCase.assertNotNull((Object)region);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return region.size() == 1000;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
            }
        };
        return putFromServer;
    }

    private CacheSerializableRunnable createRegionOnServer() {
        CacheSerializableRunnable putFromServer = new CacheSerializableRunnable("createRegionOnServer"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setMirrorType(MirrorType.KEYS_VALUES);
                RegionAttributes attrs = factory.createRegionAttributes();
                cache.createVMRegion(RegisterInterestBeforeRegionCreationDUnitTest.REGION_NAME, attrs);
            }
        };
        return putFromServer;
    }

    private void createClientServerConfigurationForClearTest() throws Exception {
        PORT1 = (Integer)server1.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "createServer", new Object[]{new Boolean(true)});
        PORT2 = (Integer)server2.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "createServer", new Object[]{new Boolean(false)});
        client1.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "createClient", new Object[]{RegisterInterestBeforeRegionCreationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT1)});
        client2.invoke(RegisterInterestBeforeRegionCreationDUnitTest.class, "createClient", new Object[]{RegisterInterestBeforeRegionCreationDUnitTest.getServerHostName(server1.getHost()), new Integer(PORT2)});
    }

    public static Integer createServer(Boolean createRegion) throws Exception {
        new RegisterInterestBeforeRegionCreationDUnitTest("temp").createCache(new Properties());
        boolean isCreateRegion = createRegion;
        if (isCreateRegion) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setMirrorType(MirrorType.KEYS_VALUES);
            RegionAttributes attrs = factory.createRegionAttributes();
            cache.createVMRegion(REGION_NAME, attrs);
        }
        BridgeServerImpl server = (BridgeServerImpl)cache.addBridgeServer();
        RegisterInterestBeforeRegionCreationDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        RegisterInterestBeforeRegionCreationDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        RegisterInterestBeforeRegionCreationDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClient(String host, Integer port1) throws Exception {
        PORT1 = port1;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new RegisterInterestBeforeRegionCreationDUnitTest("temp").createCache(props);
        Pool p = PoolManager.createFactory().addServer(host, PORT1).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(2).create("RegisterInterestBeforeRegionCreationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.createRegionAttributes();
        cache.createVMRegion(REGION_NAME, attrs);
        Region region = cache.getRegion("/RegisterInterestBeforeRegionCreationDUnitTest_Region");
        RegisterInterestBeforeRegionCreationDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        cache = null;
    }
}

