/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.TestCase;

public class UpdatePropagationDUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "UpdatePropagationDUnitTest_region";
    protected static Cache cache;
    static UpdatePropagationDUnitTest impl;
    private static final String WAIT_PROPERTY = "UpdatePropagationDUnitTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 60000;

    public UpdatePropagationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        UpdatePropagationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        UpdatePropagationDUnitTest.createImpl();
        for (int i = 0; i < 4; ++i) {
            host.getVM(i).invoke(this.getClass(), "createImpl", null);
        }
        PORT1 = (Integer)this.server1.invoke(this.getClass(), "createServerCache");
        PORT2 = (Integer)this.server2.invoke(this.getClass(), "createServerCache");
        this.client1.invoke(this.getClass(), "createClientCache", new Object[]{UpdatePropagationDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1), new Integer(PORT2)});
        this.client2.invoke(this.getClass(), "createClientCache", new Object[]{UpdatePropagationDUnitTest.getServerHostName(this.server1.getHost()), new Integer(PORT1), new Integer(PORT2)});
    }

    public static void createImpl() {
        impl = new UpdatePropagationDUnitTest("temp");
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        UpdatePropagationDUnitTest.assertNotNull((Object)cache);
    }

    public void testVerifyUpdatesNotReceivedBySender() {
        final int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        this.client1.invoke(impl.getClass(), "createEntriesK1andK2");
        this.client2.invoke(impl.getClass(), "createEntriesK1andK2");
        this.client1.invoke(impl.getClass(), "registerKeysK1andK2");
        this.client2.invoke(impl.getClass(), "registerKeysK1andK2");
        this.server1.invoke(UpdatePropagationDUnitTest.class, "killServer", new Object[]{new Integer(PORT1)});
        this.client1.invoke(new CacheSerializableRunnable("Wait for server on port1 to be dead"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(UpdatePropagationDUnitTest.REGION_NAME);
                try {
                    r.put((Object)"ping", (Object)"pong1");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() != 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.client2.invoke(new CacheSerializableRunnable("Wait for server on port1 to be dead"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(UpdatePropagationDUnitTest.REGION_NAME);
                try {
                    r.put((Object)"ping", (Object)"pong3");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() != 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.server1.invoke(UpdatePropagationDUnitTest.class, "startServer", new Object[]{new Integer(PORT1)});
        this.client1.invoke(new CacheSerializableRunnable("Wait for server on port1 to be dead"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(UpdatePropagationDUnitTest.REGION_NAME);
                try {
                    r.put((Object)"ping", (Object)"pong2");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() == 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.client1.invoke(impl.getClass(), "acquireConnectionsAndPutonK1andK2", new Object[]{UpdatePropagationDUnitTest.getServerHostName(this.client1.getHost())});
        this.server1.invoke(impl.getClass(), "verifyUpdates");
        this.server2.invoke(impl.getClass(), "verifyUpdates");
        this.client1.invoke(impl.getClass(), "verifyNoUpdates");
    }

    public void testVerifyUpdatesReceivedByOtherClients() {
        final int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        this.client1.invoke(impl.getClass(), "createEntriesK1andK2");
        this.client2.invoke(impl.getClass(), "createEntriesK1andK2");
        this.client1.invoke(impl.getClass(), "registerKeysK1andK2");
        this.client2.invoke(impl.getClass(), "registerKeysK1andK2");
        this.server1.invoke(UpdatePropagationDUnitTest.class, "killServer", new Object[]{new Integer(PORT1)});
        this.client1.invoke(new CacheSerializableRunnable("Wait for server on port1 to be dead"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(UpdatePropagationDUnitTest.REGION_NAME);
                try {
                    r.put((Object)"ping", (Object)"pong3");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() != 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.client2.invoke(new CacheSerializableRunnable("Wait for server on port1 to be dead"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(UpdatePropagationDUnitTest.REGION_NAME);
                try {
                    r.put((Object)"ping", (Object)"pong3");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() != 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.server1.invoke(UpdatePropagationDUnitTest.class, "startServer", new Object[]{new Integer(PORT1)});
        this.client1.invoke(new CacheSerializableRunnable("Wait for servers to be alive"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(UpdatePropagationDUnitTest.REGION_NAME);
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() == 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.client2.invoke(new CacheSerializableRunnable("Wait for servers to be alive"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(UpdatePropagationDUnitTest.REGION_NAME);
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() == 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.client1.invoke(impl.getClass(), "acquireConnectionsAndPutonK1andK2", new Object[]{UpdatePropagationDUnitTest.getServerHostName(this.client1.getHost())});
        UpdatePropagationDUnitTest.pause(5000);
        this.server1.invoke(impl.getClass(), "verifyUpdates");
        this.server2.invoke(impl.getClass(), "verifyUpdates");
        this.client2.invoke(impl.getClass(), "verifyUpdates");
    }

    public static void acquireConnectionsAndPutonK1andK2(String host) {
        try {
            Region r1 = cache.getRegion("/UpdatePropagationDUnitTest_region");
            UpdatePropagationDUnitTest.assertNotNull((Object)r1);
            String poolName = r1.getAttributes().getPoolName();
            UpdatePropagationDUnitTest.assertNotNull((Object)poolName);
            PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
            UpdatePropagationDUnitTest.assertNotNull((Object)pool);
            Connection conn = pool.acquireConnection(new ServerLocation(host, PORT1));
            UpdatePropagationDUnitTest.assertNotNull((Object)conn);
            UpdatePropagationDUnitTest.assertEquals((int)PORT1, (int)conn.getServer().getPort());
            ServerRegionProxy srp = new ServerRegionProxy("/UpdatePropagationDUnitTest_region", pool);
            srp.putOnForTestsOnly(conn, (Object)"key1", (Object)"server-value1", new EventID(new byte[]{1}, 159632L, 1L), null);
            srp.putOnForTestsOnly(conn, (Object)"key2", (Object)"server-value2", new EventID(new byte[]{1}, 159632L, 2L), null);
        }
        catch (Exception ex) {
            UpdatePropagationDUnitTest.fail((String)("while setting acquireConnections  " + ex));
        }
    }

    public static void killServer(Integer port) {
        try {
            BridgeServer server;
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext() && (server = (BridgeServer)iter.next()).getPort() == port.intValue()) {
                server.stop();
            }
        }
        catch (Exception ex) {
            UpdatePropagationDUnitTest.fail((String)("while killing Server  " + ex));
        }
    }

    public static void startServer(Integer port) {
        try {
            BridgeServer server1 = cache.addBridgeServer();
            server1.setPort(port.intValue());
            server1.setNotifyBySubscription(true);
            server1.start();
        }
        catch (Exception ex) {
            UpdatePropagationDUnitTest.fail((String)("while killServer  " + ex));
        }
    }

    public static void createEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/UpdatePropagationDUnitTest_region");
            UpdatePropagationDUnitTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)"key1")) {
                r1.put((Object)"key1", (Object)"key-1");
            }
            if (!r1.containsKey((Object)"key2")) {
                r1.put((Object)"key2", (Object)"key-2");
            }
            UpdatePropagationDUnitTest.assertEquals((Object)r1.get((Object)"key1"), (Object)"key-1");
            if (r1.getAttributes().getPartitionAttributes() == null) {
                UpdatePropagationDUnitTest.assertEquals((Object)r1.getEntry((Object)"key1").getValue(), (Object)"key-1");
                UpdatePropagationDUnitTest.assertEquals((Object)r1.getEntry((Object)"key2").getValue(), (Object)"key-2");
            } else {
                UpdatePropagationDUnitTest.assertEquals((Object)r1.get((Object)"key1"), (Object)"key-1");
                UpdatePropagationDUnitTest.assertEquals((Object)r1.get((Object)"key2"), (Object)"key-2");
            }
        }
        catch (Exception ex) {
            UpdatePropagationDUnitTest.fail("failed while createEntriesK1andK2()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Pool p;
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new UpdatePropagationDUnitTest("temp").createCache(props);
        try {
            System.setProperty("gemfire.PoolImpl.DISABLE_RANDOM", "true");
            p = PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setMinConnections(4).setSocketBufferSize(1000).setReadTimeout(2000).create("UpdatePropagationDUnitTestPool");
        }
        finally {
            System.setProperty("gemfire.PoolImpl.DISABLE_RANDOM", "false");
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache() throws Exception {
        new UpdatePropagationDUnitTest("temp").createCache(new Properties());
        RegionAttributes attrs = impl.createCacheServerAttributes();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        UpdatePropagationDUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    protected RegionAttributes createCacheServerAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        return factory.create();
    }

    public static void registerKeysK1andK2() {
        try {
            Region r = cache.getRegion("/UpdatePropagationDUnitTest_region");
            UpdatePropagationDUnitTest.assertNotNull((Object)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add("key1");
            list.add("key2");
            r.registerInterest(list);
        }
        catch (Exception ex) {
            UpdatePropagationDUnitTest.fail("failed while registering interest", ex);
        }
    }

    public static void verifyNoUpdates() {
        try {
            Region r = cache.getRegion("/UpdatePropagationDUnitTest_region");
            UpdatePropagationDUnitTest.assertNotNull((Object)r);
            UpdatePropagationDUnitTest.assertEquals((Object)"key-1", (Object)r.getEntry((Object)"key1").getValue());
            UpdatePropagationDUnitTest.assertEquals((Object)"key-2", (Object)r.getEntry((Object)"key2").getValue());
        }
        catch (Exception ex) {
            UpdatePropagationDUnitTest.fail("failed while verifyNoUpdates()", ex);
        }
    }

    public static void verifyUpdates() {
        try {
            Region r = cache.getRegion("/UpdatePropagationDUnitTest_region");
            UpdatePropagationDUnitTest.assertNotNull((Object)r);
            if (r.getAttributes().getPartitionAttributes() == null) {
                UpdatePropagationDUnitTest.assertEquals((Object)"server-value2", (Object)r.getEntry((Object)"key2").getValue());
                UpdatePropagationDUnitTest.assertEquals((Object)"server-value1", (Object)r.getEntry((Object)"key1").getValue());
            } else {
                UpdatePropagationDUnitTest.assertEquals((Object)"server-value2", (Object)r.get((Object)"key2"));
                UpdatePropagationDUnitTest.assertEquals((Object)"server-value1", (Object)r.get((Object)"key1"));
            }
        }
        catch (Exception ex) {
            UpdatePropagationDUnitTest.fail("failed while region", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.client1.invoke(this.getClass(), "closeCache");
        this.client2.invoke(this.getClass(), "closeCache");
        this.server1.invoke(this.getClass(), "closeCache");
        this.server2.invoke(this.getClass(), "closeCache");
    }

    static {
        cache = null;
    }
}

