/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueStats;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallback;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GatewayImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.CustomAsyncEventListener;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverStats;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderFactoryImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.MyAsyncEventListener;
import com.gemstone.gemfire.internal.cache.wan.MyAsyncEventListener2;
import com.gemstone.gemfire.internal.cache.wan.MyGatewaySenderEventListener;
import com.gemstone.gemfire.internal.cache.wan.MyGatewaySenderEventListener2;
import com.gemstone.gemfire.internal.cache.wan.QueueListener;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.concurrent.AI;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import com.gemstone.gemfire.pdx.SimpleClass;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.CacheHelper;
import hydra.Log;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import rebalance.RebalanceUtil;
import util.TestException;
import util.TestHelper;

public class WANTestBase
extends DistributedTestCase {
    protected static Cache cache;
    protected static Region region;
    protected static PartitionedRegion customerRegion;
    protected static PartitionedRegion orderRegion;
    protected static PartitionedRegion shipmentRegion;
    protected static final String customerRegionName = "CUSTOMER";
    protected static final String orderRegionName = "ORDER";
    protected static final String shipmentRegionName = "SHIPMENT";
    protected static VM vm0;
    protected static VM vm1;
    protected static VM vm2;
    protected static VM vm3;
    protected static VM vm4;
    protected static VM vm5;
    protected static VM vm6;
    protected static VM vm7;
    protected static QueueListener listener1;
    protected static QueueListener listener2;
    protected static List<QueueListener> gatewayListeners;
    protected static AsyncEventListener eventListener1;
    protected static AsyncEventListener eventListener2;
    private static final long MAX_WAIT = 10000L;
    protected static GatewayEventFilter eventFilter;
    protected static boolean destroyFlag;

    public WANTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
        vm2 = host.getVM(2);
        vm3 = host.getVM(3);
        vm4 = host.getVM(4);
        vm5 = host.getVM(5);
        vm6 = host.getVM(6);
        vm7 = host.getVM(7);
    }

    public static void createLocator(int dsId, int port, Set<String> localLocatorsList, Set<String> remoteLocatorsList) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        StringBuffer localLocatorBuffer = new StringBuffer(localLocatorsList.toString());
        localLocatorBuffer.deleteCharAt(0);
        localLocatorBuffer.deleteCharAt(localLocatorBuffer.lastIndexOf("]"));
        String localLocator = localLocatorBuffer.toString();
        localLocator = localLocator.replace(" ", "");
        props.setProperty("locators", localLocator);
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        StringBuffer remoteLocatorBuffer = new StringBuffer(remoteLocatorsList.toString());
        remoteLocatorBuffer.deleteCharAt(0);
        remoteLocatorBuffer.deleteCharAt(remoteLocatorBuffer.lastIndexOf("]"));
        String remoteLocator = remoteLocatorBuffer.toString();
        remoteLocator = remoteLocator.replace(" ", "");
        props.setProperty("remote-locators", remoteLocator);
        test.getSystem(props);
    }

    public static Integer createFirstLocatorWithDSId(int dsId) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        test.getSystem(props);
        return port;
    }

    public static Integer createFirstPeerLocator(int dsId) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=false,peer=true,hostname-for-clients=localhost");
        test.getSystem(props);
        return port;
    }

    public static Integer createSecondLocator(int dsId, int locatorPort) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + locatorPort + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        test.getSystem(props);
        return port;
    }

    public static Integer createSecondPeerLocator(int dsId, int locatorPort) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + locatorPort + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=false,peer=true,hostname-for-clients=localhost");
        test.getSystem(props);
        return port;
    }

    public static Integer createFirstRemoteLocator(int dsId, int remoteLocPort) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        test.getSystem(props);
        return port;
    }

    public static void bringBackLocatorOnOldPort(int dsId, int remoteLocPort, int oldPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + oldPort + "]");
        props.setProperty("start-locator", "localhost[" + oldPort + "],server=true,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        test.getSystem(props);
    }

    public static Integer createFirstRemotePeerLocator(int dsId, int remoteLocPort) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=false,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        test.getSystem(props);
        return port;
    }

    public static Integer createSecondRemoteLocator(int dsId, int localPort, int remoteLocPort) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + localPort + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        test.getSystem(props);
        return port;
    }

    public static Integer createSecondRemotePeerLocator(int dsId, int localPort, int remoteLocPort) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + localPort + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=false,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        test.getSystem(props);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReplicatedRegion(String regionName, String senderIds, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(InterruptedException.class.getName());
        DistributedTestCase.ExpectedException exp2 = WANTestBase.addExpectedException(GatewaySenderException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            if (senderIds != null) {
                StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    String senderId = tokenizer.nextToken();
                    fact.addGatewaySenderId(senderId);
                }
            }
            fact.setDataPolicy(DataPolicy.REPLICATE);
            fact.setScope(Scope.DISTRIBUTED_ACK);
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            Region r = cache.createRegionFactory(fact.create()).create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
            exp1.remove();
            exp2.remove();
        }
    }

    public static void createNormalRegion(String regionName, String senderIds) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        fact.setDataPolicy(DataPolicy.NORMAL);
        fact.setScope(Scope.DISTRIBUTED_ACK);
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    public static void createPersistentReplicatedRegion(String regionName, String senderIds, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        fact.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    public static void createReplicatedRegion_WithGatewayEnabled(String regionName, String senderIds, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        fact.setEnableGateway(true);
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        fact.setDataPolicy(DataPolicy.REPLICATE);
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReplicatedRegionWithAsyncEventQueue(String regionName, String asyncQueueIds, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            if (asyncQueueIds != null) {
                StringTokenizer tokenizer = new StringTokenizer(asyncQueueIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    String asyncQueueId = tokenizer.nextToken();
                    fact.addAsyncEventQueueId(asyncQueueId);
                }
            }
            fact.setDataPolicy(DataPolicy.REPLICATE);
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            RegionFactory regionFactory = cache.createRegionFactory(fact.create());
            Region r = regionFactory.create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp1.remove();
        }
    }

    public static void createPersistentReplicatedRegionWithAsyncEventQueue(String regionName, String asyncQueueIds, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        if (asyncQueueIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(asyncQueueIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String asyncQueueId = tokenizer.nextToken();
                fact.addAsyncEventQueueId(asyncQueueId);
            }
        }
        fact.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        RegionFactory regionFactory = cache.createRegionFactory(fact.create());
        Region r = regionFactory.create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReplicatedRegionWithSenderAndAsyncEventQueue(String regionName, String senderIds, String asyncChannelId, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            if (senderIds != null) {
                StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    String senderId = tokenizer.nextToken();
                    fact.addGatewaySenderId(senderId);
                }
            }
            fact.setDataPolicy(DataPolicy.REPLICATE);
            fact.setScope(Scope.DISTRIBUTED_ACK);
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            RegionFactory regionFactory = cache.createRegionFactory(fact.create());
            regionFactory.addAsyncEventQueueId(asyncChannelId);
            Region r = regionFactory.create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
        }
    }

    public static void createReplicatedRegion(String regionName, String senderIds, Scope scope, DataPolicy policy, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        fact.setDataPolicy(policy);
        fact.setScope(scope);
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    public static void createAsyncEventQueue(String asyncChannelId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, String diskStoreName, boolean isDiskSynchronous) {
        if (diskStoreName != null) {
            File directory = new File(asyncChannelId + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
            directory.mkdir();
            File[] dirs1 = new File[]{directory};
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            dsf.setDiskDirs(dirs1);
            DiskStore diskStore = dsf.create(diskStoreName);
        }
        MyAsyncEventListener asyncEventListener = new MyAsyncEventListener();
        AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
        factory.setBatchSize(batchSize.intValue());
        factory.setPersistent(isPersistent);
        factory.setDiskStoreName(diskStoreName);
        factory.setDiskSynchronous(isDiskSynchronous);
        factory.setBatchConflationEnabled(isConflation);
        factory.setMaximumQueueMemory(maxMemory.intValue());
        factory.setParallel(isParallel);
        factory.create(asyncChannelId, (AsyncEventListener)asyncEventListener);
    }

    public static void createAsyncEventQueueWithListener2(String asyncChannelId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isPersistent, String diskStoreName) {
        if (diskStoreName != null) {
            File directory = new File(asyncChannelId + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
            directory.mkdir();
            File[] dirs1 = new File[]{directory};
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            dsf.setDiskDirs(dirs1);
            DiskStore diskStore = dsf.create(diskStoreName);
        }
        MyAsyncEventListener2 asyncEventListener = new MyAsyncEventListener2();
        AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
        factory.setBatchSize(batchSize.intValue());
        factory.setPersistent(isPersistent);
        factory.setDiskStoreName(diskStoreName);
        factory.setMaximumQueueMemory(maxMemory.intValue());
        factory.setParallel(isParallel);
        AsyncEventQueue asyncChannel = factory.create(asyncChannelId, asyncEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAsyncEventQueueWithCustomListener(String asyncChannelId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, String diskStoreName, boolean isDiskSynchronous) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            if (diskStoreName != null) {
                File directory = new File(asyncChannelId + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
                directory.mkdir();
                File[] dirs1 = new File[]{directory};
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                dsf.setDiskDirs(dirs1);
                DiskStore diskStore = dsf.create(diskStoreName);
            }
            CustomAsyncEventListener asyncEventListener = new CustomAsyncEventListener();
            AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
            factory.setBatchSize(batchSize.intValue());
            factory.setPersistent(isPersistent);
            factory.setDiskStoreName(diskStoreName);
            factory.setMaximumQueueMemory(maxMemory.intValue());
            factory.setParallel(isParallel);
            AsyncEventQueue asyncEventQueue = factory.create(asyncChannelId, asyncEventListener);
        }
        finally {
            exp.remove();
        }
    }

    public static void createConcurrentAsyncEventQueue(String asyncChannelId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, String diskStoreName, boolean isDiskSynchronous, int dispatcherThreads, Gateway.OrderPolicy policy) {
        if (diskStoreName != null) {
            File directory = new File(asyncChannelId + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
            directory.mkdir();
            File[] dirs1 = new File[]{directory};
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            dsf.setDiskDirs(dirs1);
            DiskStore diskStore = dsf.create(diskStoreName);
        }
        MyAsyncEventListener asyncEventListener = new MyAsyncEventListener();
        AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
        factory.setBatchSize(batchSize.intValue());
        factory.setPersistent(isPersistent);
        factory.setDiskStoreName(diskStoreName);
        factory.setDiskSynchronous(isDiskSynchronous);
        factory.setBatchConflationEnabled(isConflation);
        factory.setMaximumQueueMemory(maxMemory.intValue());
        factory.setParallel(isParallel);
        factory.setDispatcherThreads(dispatcherThreads);
        factory.setOrderPolicy(policy);
        AsyncEventQueue asyncChannel = factory.create(asyncChannelId, (AsyncEventListener)asyncEventListener);
    }

    public static String createAsyncEventQueueWithDiskStore(String asyncChannelId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isPersistent, String diskStoreName) {
        MyAsyncEventListener asyncEventListener = new MyAsyncEventListener();
        File persistentDirectory = null;
        persistentDirectory = diskStoreName == null ? new File(asyncChannelId + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum()) : new File(diskStoreName);
        WANTestBase.getLogWriter().info("The ds is : " + persistentDirectory.getName());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
        factory.setBatchSize(batchSize.intValue());
        factory.setParallel(isParallel);
        if (isPersistent) {
            factory.setPersistent(isPersistent);
            factory.setDiskStoreName(dsf.setDiskDirs(dirs1).create(asyncChannelId).getName());
        }
        factory.setMaximumQueueMemory(maxMemory.intValue());
        factory.create(asyncChannelId, (AsyncEventListener)asyncEventListener);
        return persistentDirectory.getName();
    }

    public static void pauseAsyncEventQueue(String asyncChannelId) {
        AsyncEventQueue theChannel = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncChannelId.equals(asyncChannel.getId())) continue;
            theChannel = asyncChannel;
        }
        ((AsyncEventQueueImpl)theChannel).getSender().pause();
    }

    public static void pauseAsyncEventQueueAndWaitForDispatcherToPause(String asyncChannelId) {
        AsyncEventQueue theChannel = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncChannelId.equals(asyncChannel.getId())) continue;
            theChannel = asyncChannel;
            break;
        }
        ((AsyncEventQueueImpl)theChannel).getSender().pause();
        ((AsyncEventQueueImpl)theChannel).getSender().getEventProcessor().waitForDispatcherToPause();
    }

    public static void resumeAsyncEventQueue(String asyncQueueId) {
        AsyncEventQueue theQueue = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncQueueId.equals(asyncChannel.getId())) continue;
            theQueue = asyncChannel;
        }
        ((AsyncEventQueueImpl)theQueue).getSender().resume();
    }

    public static void checkAsyncEventQueueSize(String asyncQueueId, int numQueueEntries) {
        Set queues;
        AsyncEventQueue theAsyncEventQueue = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncQueueId.equals(asyncChannel.getId())) continue;
            theAsyncEventQueue = asyncChannel;
        }
        AbstractGatewaySender sender = ((AsyncEventQueueImpl)theAsyncEventQueue).getSender();
        if (sender instanceof ParallelGatewaySenderImpl) {
            queues = ((ParallelGatewaySenderImpl)sender).getQueues();
            WANTestBase.assertEquals((int)numQueueEntries, (int)queues.toArray(new RegionQueue[queues.size()])[0].getRegion().size());
        } else {
            queues = ((SerialGatewaySenderImpl)sender).getQueues();
            int size = 0;
            for (RegionQueue q : queues) {
                size += q.size();
            }
            WANTestBase.assertEquals((int)numQueueEntries, (int)size);
        }
    }

    public static void waitForAsyncEventQueueSize(String asyncQueueId, final int numQueueEntries) throws Exception {
        AsyncEventQueue theAsyncEventQueue = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncQueueId.equals(asyncChannel.getId())) continue;
            theAsyncEventQueue = asyncChannel;
        }
        AbstractGatewaySender sender = ((AsyncEventQueueImpl)theAsyncEventQueue).getSender();
        if (!(sender instanceof ParallelGatewaySenderImpl)) {
            throw new Exception("This method should be used for only ParallelGatewaySender,SerialGatewaySender should use checkAsyncEventQueueSize() method instead");
        }
        final Set queues = ((ParallelGatewaySenderImpl)sender).getQueues();
        WANTestBase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "Waiting for EventQueue size to be " + numQueueEntries;
            }

            @Override
            public boolean done() {
                boolean done = numQueueEntries == queues.toArray(new RegionQueue[queues.size()])[0].getRegion().size();
                return done;
            }
        }, 10000L, 500L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPartitionedRegion(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(PartitionOfflineException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            if (senderIds != null) {
                StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    String senderId = tokenizer.nextToken();
                    fact.addGatewaySenderId(senderId);
                }
            }
            PartitionAttributesFactory pfact = new PartitionAttributesFactory();
            pfact.setTotalNumBuckets(totalNumBuckets.intValue());
            pfact.setRedundantCopies(redundantCopies.intValue());
            pfact.setRecoveryDelay(0L);
            fact.setPartitionAttributes(pfact.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            Region r = cache.createRegionFactory(fact.create()).create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createColocatedPartitionedRegion(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets, String colocatedWith, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(PartitionOfflineException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            if (senderIds != null) {
                StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    String senderId = tokenizer.nextToken();
                    fact.addGatewaySenderId(senderId);
                }
            }
            PartitionAttributesFactory pfact = new PartitionAttributesFactory();
            pfact.setTotalNumBuckets(totalNumBuckets.intValue());
            pfact.setRedundantCopies(redundantCopies.intValue());
            pfact.setRecoveryDelay(0L);
            pfact.setColocatedWith(colocatedWith);
            fact.setPartitionAttributes(pfact.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            Region r = cache.createRegionFactory(fact.create()).create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPartitionedRegionWithAsyncEventQueue(String regionName, String asyncEventQueueId, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(PartitionOfflineException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            PartitionAttributesFactory pfact = new PartitionAttributesFactory();
            pfact.setTotalNumBuckets(16);
            fact.setPartitionAttributes(pfact.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            Region r = cache.createRegionFactory(fact.create()).addAsyncEventQueueId(asyncEventQueueId).create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createColocatedPartitionedRegionWithAsyncEventQueue(String regionName, String asyncEventQueueId, Integer totalNumBuckets, String colocatedWith, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(PartitionOfflineException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            PartitionAttributesFactory pfact = new PartitionAttributesFactory();
            pfact.setTotalNumBuckets(totalNumBuckets.intValue());
            pfact.setColocatedWith(colocatedWith);
            fact.setPartitionAttributes(pfact.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            Region r = cache.createRegionFactory(fact.create()).addAsyncEventQueueId(asyncEventQueueId).create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    public static void createPersistentPartitionedRegionWithAsyncEventQueue(String regionName, String asyncEventQueueId, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        fact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        pfact.setTotalNumBuckets(16);
        fact.setPartitionAttributes(pfact.create());
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        if (asyncEventQueueId != null) {
            StringTokenizer tokenizer = new StringTokenizer(asyncEventQueueId, ",");
            while (tokenizer.hasMoreTokens()) {
                String asyncId = tokenizer.nextToken();
                fact.addAsyncEventQueueId(asyncId);
            }
        }
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPRWithRedundantCopyWithAsyncEventQueue(String regionName, String asyncEventQueueId, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            PartitionAttributesFactory pfact = new PartitionAttributesFactory();
            pfact.setTotalNumBuckets(16);
            pfact.setRedundantCopies(1);
            fact.setPartitionAttributes(pfact.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            Region r = cache.createRegionFactory(fact.create()).addAsyncEventQueueId(asyncEventQueueId).create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
        }
    }

    public static void createPartitionedRegionAccessorWithAsyncEventQueue(String regionName, String asyncEventQueueId) {
        AttributesFactory fact = new AttributesFactory();
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        pfact.setTotalNumBuckets(16);
        pfact.setLocalMaxMemory(0);
        fact.setPartitionAttributes(pfact.create());
        Region r = cache.createRegionFactory(fact.create()).addAsyncEventQueueId(asyncEventQueueId).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    public static void createPartitionedRegion_WithGatewayEnabled(String regionName, Integer redundantCopies, Integer totalNumBuckets, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        fact.setEnableGateway(true);
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        pfact.setTotalNumBuckets(totalNumBuckets.intValue());
        pfact.setRedundantCopies(redundantCopies.intValue());
        fact.setPartitionAttributes(pfact.create());
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    public static void createPartitionedRegionAsAccessor(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        pfact.setTotalNumBuckets(totalNumBuckets.intValue());
        pfact.setRedundantCopies(redundantCopies.intValue());
        pfact.setLocalMaxMemory(0);
        fact.setPartitionAttributes(pfact.create());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    public static void createPartitionedRegionWithSerialParallelSenderIds(String regionName, String serialSenderIds, String parallelSenderIds, String colocatedWith, Boolean offHeap) {
        String senderId;
        StringTokenizer tokenizer;
        AttributesFactory fact = new AttributesFactory();
        if (serialSenderIds != null) {
            tokenizer = new StringTokenizer(serialSenderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        if (parallelSenderIds != null) {
            tokenizer = new StringTokenizer(parallelSenderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        pfact.setColocatedWith(colocatedWith);
        fact.setPartitionAttributes(pfact.create());
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPersistentPartitionedRegion(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(PartitionOfflineException.class.getName());
        try {
            AttributesFactory fact = new AttributesFactory();
            if (senderIds != null) {
                StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    String senderId = tokenizer.nextToken();
                    fact.addGatewaySenderId(senderId);
                }
            }
            PartitionAttributesFactory pfact = new PartitionAttributesFactory();
            pfact.setTotalNumBuckets(totalNumBuckets.intValue());
            pfact.setRedundantCopies(redundantCopies.intValue());
            fact.setPartitionAttributes(pfact.create());
            fact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            Region r = cache.createRegionFactory(fact.create()).create(regionName);
            WANTestBase.assertNotNull((Object)r);
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCustomerOrderShipmentPartitionedRegion(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets, Boolean offHeap) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            String senderId;
            StringTokenizer tokenizer;
            AttributesFactory fact = new AttributesFactory();
            if (senderIds != null) {
                StringTokenizer tokenizer2 = new StringTokenizer(senderIds, ",");
                while (tokenizer2.hasMoreTokens()) {
                    String senderId2 = tokenizer2.nextToken();
                    fact.addGatewaySenderId(senderId2);
                }
            }
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(redundantCopies.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
            fact.setPartitionAttributes(paf.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            customerRegion = (PartitionedRegion)cache.createRegionFactory(fact.create()).create(customerRegionName);
            WANTestBase.assertNotNull((Object)customerRegion);
            WANTestBase.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
            paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(redundantCopies.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setColocatedWith(customerRegionName).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
            fact = new AttributesFactory();
            if (senderIds != null) {
                tokenizer = new StringTokenizer(senderIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    senderId = tokenizer.nextToken();
                    fact.addGatewaySenderId(senderId);
                }
            }
            fact.setPartitionAttributes(paf.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            orderRegion = (PartitionedRegion)cache.createRegionFactory(fact.create()).create(orderRegionName);
            WANTestBase.assertNotNull((Object)orderRegion);
            WANTestBase.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
            paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(redundantCopies.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setColocatedWith(orderRegionName).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
            fact = new AttributesFactory();
            if (senderIds != null) {
                tokenizer = new StringTokenizer(senderIds, ",");
                while (tokenizer.hasMoreTokens()) {
                    senderId = tokenizer.nextToken();
                    fact.addGatewaySenderId(senderId);
                }
            }
            fact.setPartitionAttributes(paf.create());
            fact.setEnableOffHeapMemory(offHeap.booleanValue());
            shipmentRegion = (PartitionedRegion)cache.createRegionFactory(fact.create()).create(shipmentRegionName);
            WANTestBase.assertNotNull((Object)shipmentRegion);
            WANTestBase.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        }
        finally {
            exp.remove();
        }
        WANTestBase.assertNotNull((Object)shipmentRegion);
    }

    public static void createColocatedPartitionedRegions(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        pfact.setTotalNumBuckets(totalNumBuckets.intValue());
        pfact.setRedundantCopies(redundantCopies.intValue());
        fact.setPartitionAttributes(pfact.create());
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
        pfact.setColocatedWith(r.getName());
        fact.setPartitionAttributes(pfact.create());
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r1 = cache.createRegionFactory(fact.create()).create(regionName + "_child1");
        WANTestBase.assertNotNull((Object)r1);
        Region r2 = cache.createRegionFactory(fact.create()).create(regionName + "_child2");
        WANTestBase.assertNotNull((Object)r2);
    }

    public static void createColocatedPartitionedRegions2(String regionName, String senderIds, Integer redundantCopies, Integer totalNumBuckets, Boolean offHeap) {
        AttributesFactory fact = new AttributesFactory();
        if (senderIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(senderIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String senderId = tokenizer.nextToken();
                fact.addGatewaySenderId(senderId);
            }
        }
        PartitionAttributesFactory pfact = new PartitionAttributesFactory();
        pfact.setTotalNumBuckets(totalNumBuckets.intValue());
        pfact.setRedundantCopies(redundantCopies.intValue());
        fact.setPartitionAttributes(pfact.create());
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r = cache.createRegionFactory(fact.create()).create(regionName);
        WANTestBase.assertNotNull((Object)r);
        fact = new AttributesFactory();
        pfact.setColocatedWith(r.getName());
        fact.setPartitionAttributes(pfact.create());
        fact.setEnableOffHeapMemory(offHeap.booleanValue());
        Region r1 = cache.createRegionFactory(fact.create()).create(regionName + "_child1");
        WANTestBase.assertNotNull((Object)r1);
        Region r2 = cache.createRegionFactory(fact.create()).create(regionName + "_child2");
        WANTestBase.assertNotNull((Object)r2);
    }

    public static void createCache(Integer locPort) {
        WANTestBase.createCache(false, locPort);
    }

    public static void createManagementCache(Integer locPort) {
        WANTestBase.createCache(true, locPort);
    }

    protected static void createCache(boolean management, Integer locPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        if (management) {
            props.setProperty("jmx-manager", "true");
            props.setProperty("jmx-manager-start", "false");
            props.setProperty("jmx-manager-port", "0");
            props.setProperty("jmx-manager-http-port", "0");
        }
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
    }

    public static void createSecuredCache(Properties authProps, Object javaProps, Integer locPort) {
        new WANTestBase(testName);
        authProps.setProperty("mcast-port", "0");
        authProps.setProperty("locators", "localhost[" + locPort + "]");
        authProps.setProperty("security-log-level", "finest");
        WANTestBase.getLogWriter().info("Set the server properties to: " + authProps);
        WANTestBase.getLogWriter().info("Set the java properties to: " + javaProps);
        SecurityTestUtil tmpInstance = new SecurityTestUtil("temp");
        DistributedSystem ds = tmpInstance.createSystem(authProps, (Properties)javaProps);
        WANTestBase.assertNotNull((Object)ds);
        WANTestBase.assertTrue((boolean)ds.isConnected());
        cache = CacheFactory.create((DistributedSystem)ds);
        WANTestBase.assertNotNull((Object)cache);
    }

    public static void createCache_PDX(Integer locPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setPdxPersistent(true);
        cacheConfig.setPdxDiskStore("PDX_TEST");
        cache = GemFireCacheImpl.create((DistributedSystem)ds, (boolean)false, (CacheConfig)cacheConfig);
        File persistentDirectory = new File("PDX_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        dsf.setDiskDirs(dirs1).create("PDX_TEST");
    }

    public static void createCache(Integer locPort1, Integer locPort2) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort1 + "],localhost[" + locPort2 + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
    }

    public static void createCacheWithoutLocator(Integer mCastPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "" + mCastPort);
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
    }

    public static Integer createCacheServer() {
        CacheServer server1 = cache.addCacheServer();
        WANTestBase.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        try {
            server1.start();
        }
        catch (IOException e) {
            WANTestBase.fail("Failed to start the Server", e);
        }
        WANTestBase.assertTrue((boolean)server1.isRunning());
        return new Integer(server1.getPort());
    }

    public static Map getCacheServers() {
        List cacheServers = cache.getCacheServers();
        HashMap<String, Integer> cacheServersMap = new HashMap<String, Integer>();
        Iterator itr = cacheServers.iterator();
        int bridgeServerCounter = 0;
        int receiverServerCounter = 0;
        while (itr.hasNext()) {
            BridgeServerImpl cacheServer = (BridgeServerImpl)itr.next();
            if (cacheServer.getAcceptor().isGatewayReceiver()) {
                ++receiverServerCounter;
                continue;
            }
            ++bridgeServerCounter;
        }
        cacheServersMap.put("BridgeServer", bridgeServerCounter);
        cacheServersMap.put("ReceiverServer", receiverServerCounter);
        return cacheServersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSender(String senderId) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(InterruptedException.class.getName());
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            sender.start();
        }
        finally {
            exp.remove();
            exp1.remove();
            exln.remove();
        }
    }

    public static void startAsyncEventQueue(String senderId) {
        Set queues = cache.getAsyncEventQueues();
        AsyncEventQueue q = null;
        for (AsyncEventQueue s : queues) {
            if (!s.getId().equals(senderId)) continue;
            q = s;
            break;
        }
        q.start();
    }

    public static Map getSenderToReceiverConnectionInfo(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        HashMap<String, Object> connectionInfo = null;
        if (sender instanceof SerialGatewaySenderImpl && ((AbstractGatewaySender)sender).isPrimary()) {
            connectionInfo = new HashMap<String, Object>();
            GatewaySenderEventDispatcher dispatcher = ((SerialGatewaySenderImpl)sender).getEventProcessor().getDispatcher();
            if (dispatcher instanceof GatewaySenderEventRemoteDispatcher) {
                ServerLocation serverLocation = ((GatewaySenderEventRemoteDispatcher)dispatcher).getConnection().getServer();
                connectionInfo.put("serverHost", serverLocation.getHostName());
                connectionInfo.put("serverPort", serverLocation.getPort());
            }
        }
        return connectionInfo;
    }

    public static void startGatewayHub(String gatewayHubId) {
        GatewayHub hub = cache.getGatewayHub(gatewayHubId);
        try {
            hub.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)"Failed to start GatewayHub");
        }
    }

    public static List<Integer> getSenderStats(String senderId, final int expectedQueueSize) {
        Set senders = cache.getGatewaySenders();
        AbstractGatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = (AbstractGatewaySender)s;
            break;
        }
        GatewaySenderStats statistics = sender.getStatistics();
        if (expectedQueueSize != -1) {
            final RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return regionQueue.size() == expectedQueueSize;
                }

                @Override
                public String description() {
                    return "Expected queue entries: " + expectedQueueSize + " but actual entries: " + regionQueue.size();
                }
            };
            DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
        }
        ArrayList<Integer> stats = new ArrayList<Integer>();
        stats.add(statistics.getEventQueueSize());
        stats.add(statistics.getEventsReceived());
        stats.add(statistics.getEventsQueued());
        stats.add(statistics.getEventsDistributed());
        stats.add(statistics.getBatchesDistributed());
        stats.add(statistics.getBatchesRedistributed());
        stats.add(statistics.getEventsFiltered());
        stats.add(statistics.getEventsNotQueuedConflated());
        return stats;
    }

    public static void checkQueueStats(String senderId, int queueSize, int eventsReceived, int eventsQueued, int eventsDistributed) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        GatewaySenderStats statistics = ((AbstractGatewaySender)sender).getStatistics();
        WANTestBase.assertEquals((int)queueSize, (int)statistics.getEventQueueSize());
        WANTestBase.assertEquals((int)eventsReceived, (int)statistics.getEventsReceived());
        WANTestBase.assertEquals((int)eventsQueued, (int)statistics.getEventsQueued());
        assert (statistics.getEventsDistributed() >= eventsDistributed);
    }

    public static void checkAsyncEventQueueStats(String queueId, int queueSize, int eventsReceived, int eventsQueued, int eventsDistributed) {
        Set asyncQueues = cache.getAsyncEventQueues();
        AsyncEventQueue queue = null;
        for (AsyncEventQueue q : asyncQueues) {
            if (!q.getId().equals(queueId)) continue;
            queue = q;
            break;
        }
        AsyncEventQueueStats statistics = ((AsyncEventQueueImpl)queue).getStatistics();
        WANTestBase.assertEquals((int)queueSize, (int)statistics.getEventQueueSize());
        WANTestBase.assertEquals((int)eventsReceived, (int)statistics.getEventsReceived());
        WANTestBase.assertEquals((int)eventsQueued, (int)statistics.getEventsQueued());
        assert (statistics.getEventsDistributed() >= eventsDistributed);
    }

    public static void checkGatewayReceiverStats(int processBatches, int eventsReceived, int creates) {
        Set gatewayReceivers = cache.getGatewayReceivers();
        GatewayReceiverImpl receiver = (GatewayReceiverImpl)gatewayReceivers.iterator().next();
        CacheServerStats stats = ((BridgeServerImpl)receiver.getServer()).getAcceptor().getStats();
        WANTestBase.assertTrue((boolean)(stats instanceof GatewayReceiverStats));
        GatewayReceiverStats gatewayReceiverStats = (GatewayReceiverStats)stats;
        WANTestBase.assertTrue((gatewayReceiverStats.getProcessBatchRequests() >= processBatches ? 1 : 0) != 0);
        WANTestBase.assertEquals((int)eventsReceived, (int)gatewayReceiverStats.getEventsReceived());
        WANTestBase.assertEquals((int)creates, (int)gatewayReceiverStats.getCreateRequest());
    }

    public static void checkMinimumGatewayReceiverStats(int processBatches, int eventsReceived) {
        Set gatewayReceivers = cache.getGatewayReceivers();
        GatewayReceiverImpl receiver = (GatewayReceiverImpl)gatewayReceivers.iterator().next();
        CacheServerStats stats = ((BridgeServerImpl)receiver.getServer()).getAcceptor().getStats();
        WANTestBase.assertTrue((boolean)(stats instanceof GatewayReceiverStats));
        GatewayReceiverStats gatewayReceiverStats = (GatewayReceiverStats)stats;
        WANTestBase.assertTrue((gatewayReceiverStats.getProcessBatchRequests() >= processBatches ? 1 : 0) != 0);
        WANTestBase.assertTrue((gatewayReceiverStats.getEventsReceived() >= eventsReceived ? 1 : 0) != 0);
    }

    public static void checkExcepitonStats(int exceptionsOccured) {
        Set gatewayReceivers = cache.getGatewayReceivers();
        GatewayReceiverImpl receiver = (GatewayReceiverImpl)gatewayReceivers.iterator().next();
        CacheServerStats stats = ((BridgeServerImpl)receiver.getServer()).getAcceptor().getStats();
        WANTestBase.assertTrue((boolean)(stats instanceof GatewayReceiverStats));
        GatewayReceiverStats gatewayReceiverStats = (GatewayReceiverStats)stats;
        if (exceptionsOccured == 0) {
            WANTestBase.assertEquals((int)exceptionsOccured, (int)gatewayReceiverStats.getExceptionsOccured());
        } else {
            WANTestBase.assertTrue((gatewayReceiverStats.getExceptionsOccured() >= exceptionsOccured ? 1 : 0) != 0);
        }
    }

    public static void checkGatewayReceiverStatsHA(int processBatches, int eventsReceived, int creates) {
        Set gatewayReceivers = cache.getGatewayReceivers();
        GatewayReceiverImpl receiver = (GatewayReceiverImpl)gatewayReceivers.iterator().next();
        CacheServerStats stats = ((BridgeServerImpl)receiver.getServer()).getAcceptor().getStats();
        WANTestBase.assertTrue((boolean)(stats instanceof GatewayReceiverStats));
        GatewayReceiverStats gatewayReceiverStats = (GatewayReceiverStats)stats;
        WANTestBase.assertTrue((gatewayReceiverStats.getProcessBatchRequests() >= processBatches ? 1 : 0) != 0);
        WANTestBase.assertTrue((gatewayReceiverStats.getEventsReceived() >= eventsReceived ? 1 : 0) != 0);
        WANTestBase.assertTrue((gatewayReceiverStats.getCreateRequest() >= creates ? 1 : 0) != 0);
    }

    public static void checkEventFilteredStats(String senderId, int eventsFiltered) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        GatewaySenderStats statistics = ((AbstractGatewaySender)sender).getStatistics();
        WANTestBase.assertEquals((int)eventsFiltered, (int)statistics.getEventsFiltered());
    }

    public static void checkConflatedStats(String senderId, int eventsConflated) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        GatewaySenderStats statistics = ((AbstractGatewaySender)sender).getStatistics();
        WANTestBase.assertEquals((int)eventsConflated, (int)statistics.getEventsNotQueuedConflated());
    }

    public static void checkAsyncEventQueueConflatedStats(String asyncEventQueueId, int eventsConflated) {
        Set queues = cache.getAsyncEventQueues();
        AsyncEventQueue queue = null;
        for (AsyncEventQueue q : queues) {
            if (!q.getId().equals(asyncEventQueueId)) continue;
            queue = q;
            break;
        }
        AsyncEventQueueStats statistics = ((AsyncEventQueueImpl)queue).getStatistics();
        WANTestBase.assertEquals((int)eventsConflated, (int)statistics.getEventsNotQueuedConflated());
    }

    public static void checkStats_Failover(String senderId, int eventsReceived) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        GatewaySenderStats statistics = ((SerialGatewaySenderImpl)sender).getStatistics();
        WANTestBase.assertEquals((int)eventsReceived, (int)statistics.getEventsReceived());
        WANTestBase.assertEquals((int)eventsReceived, (int)(statistics.getEventsQueued() + statistics.getUnprocessedTokensAddedByPrimary() + statistics.getUnprocessedEventsRemovedByPrimary()));
    }

    public static void checkAsyncEventQueueStats_Failover(String asyncEventQueueId, int eventsReceived) {
        Set asyncEventQueues = cache.getAsyncEventQueues();
        AsyncEventQueue queue = null;
        for (AsyncEventQueue q : asyncEventQueues) {
            if (!q.getId().equals(asyncEventQueueId)) continue;
            queue = q;
            break;
        }
        AsyncEventQueueStats statistics = ((AsyncEventQueueImpl)queue).getStatistics();
        WANTestBase.assertEquals((int)eventsReceived, (int)statistics.getEventsReceived());
        WANTestBase.assertEquals((int)eventsReceived, (int)(statistics.getEventsQueued() + statistics.getUnprocessedTokensAddedByPrimary() + statistics.getUnprocessedEventsRemovedByPrimary()));
    }

    public static void checkBatchStats(String senderId, int batches) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        GatewaySenderStats statistics = ((AbstractGatewaySender)sender).getStatistics();
        assert (statistics.getBatchesDistributed() >= batches);
        WANTestBase.assertEquals((int)0, (int)statistics.getBatchesRedistributed());
    }

    public static void checkAsyncEventQueueBatchStats(String asyncQueueId, int batches) {
        Set queues = cache.getAsyncEventQueues();
        AsyncEventQueue queue = null;
        for (AsyncEventQueue q : queues) {
            if (!q.getId().equals(asyncQueueId)) continue;
            queue = q;
            break;
        }
        AsyncEventQueueStats statistics = ((AsyncEventQueueImpl)queue).getStatistics();
        assert (statistics.getBatchesDistributed() >= batches);
        WANTestBase.assertEquals((int)0, (int)statistics.getBatchesRedistributed());
    }

    public static void checkBatchStats(String senderId, boolean batchesDistributed, boolean bathcesRedistributed) {
        GatewaySenderStats statistics;
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        WANTestBase.assertEquals((boolean)batchesDistributed, ((statistics = ((AbstractGatewaySender)sender).getStatistics()).getBatchesDistributed() > 0 ? 1 : 0) != 0);
        WANTestBase.assertEquals((boolean)bathcesRedistributed, (statistics.getBatchesRedistributed() > 0 ? 1 : 0) != 0);
    }

    public static void checkUnProcessedStats(String senderId, int events) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        GatewaySenderStats statistics = ((SerialGatewaySenderImpl)sender).getStatistics();
        WANTestBase.assertEquals((int)events, (int)(statistics.getUnprocessedEventsAddedBySecondary() + statistics.getUnprocessedTokensRemovedBySecondary()));
        WANTestBase.assertEquals((int)events, (int)(statistics.getUnprocessedEventsRemovedByPrimary() + statistics.getUnprocessedTokensAddedByPrimary()));
    }

    public static void checkAsyncEventQueueUnprocessedStats(String asyncQueueId, int events) {
        Set asyncQueues = cache.getAsyncEventQueues();
        AsyncEventQueue queue = null;
        for (AsyncEventQueue q : asyncQueues) {
            if (!q.getId().equals(asyncQueueId)) continue;
            queue = q;
            break;
        }
        AsyncEventQueueStats statistics = ((AsyncEventQueueImpl)queue).getStatistics();
        WANTestBase.assertEquals((int)events, (int)(statistics.getUnprocessedEventsAddedBySecondary() + statistics.getUnprocessedTokensRemovedBySecondary()));
        WANTestBase.assertEquals((int)events, (int)(statistics.getUnprocessedEventsRemovedByPrimary() + statistics.getUnprocessedTokensAddedByPrimary()));
    }

    public static void setRemoveFromQueueOnException(String senderId, boolean removeFromQueue) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        WANTestBase.assertNotNull(sender);
        ((AbstractGatewaySender)sender).setRemoveFromQueueOnException(removeFromQueue);
    }

    public static void unsetRemoveFromQueueOnException(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        WANTestBase.assertNotNull(sender);
        ((AbstractGatewaySender)sender).setRemoveFromQueueOnException(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForSenderRunningState(String senderId) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        try {
            Set senders = cache.getGatewaySenders();
            final GatewaySender sender = WANTestBase.getGatewaySenderById(senders, senderId);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return sender != null && sender.isRunning();
                }

                @Override
                public String description() {
                    return "Expected sender isRunning state to be true but is false";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 300000L, 500L, true);
        }
        finally {
            exln.remove();
        }
    }

    public static void waitForSenderToBecomePrimary(String senderId) {
        Set senders = ((GemFireCacheImpl)cache).getAllGatewaySenders();
        final GatewaySender sender = WANTestBase.getGatewaySenderById(senders, senderId);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return sender != null && ((AbstractGatewaySender)sender).isPrimary();
            }

            @Override
            public String description() {
                return "Expected sender primary state to be true but is false";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 1000L, true);
    }

    private static GatewaySender getGatewaySenderById(Set<GatewaySender> senders, String senderId) {
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            return s;
        }
        return null;
    }

    public static HashMap checkQueue() {
        HashMap<String, List> listenerAttrs = new HashMap<String, List>();
        listenerAttrs.put("Create", WANTestBase.listener1.createList);
        listenerAttrs.put("Update", WANTestBase.listener1.updateList);
        listenerAttrs.put("Destroy", WANTestBase.listener1.destroyList);
        return listenerAttrs;
    }

    public static void checkQueueOnSecondary(final Map primaryUpdatesMap) {
        final HashMap<String, List> secondaryUpdatesMap = new HashMap<String, List>();
        secondaryUpdatesMap.put("Create", WANTestBase.listener1.createList);
        secondaryUpdatesMap.put("Update", WANTestBase.listener1.updateList);
        secondaryUpdatesMap.put("Destroy", WANTestBase.listener1.destroyList);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                secondaryUpdatesMap.put("Create", WANTestBase.listener1.createList);
                secondaryUpdatesMap.put("Update", WANTestBase.listener1.updateList);
                secondaryUpdatesMap.put("Destroy", WANTestBase.listener1.destroyList);
                return secondaryUpdatesMap.equals(primaryUpdatesMap);
            }

            @Override
            public String description() {
                return "Expected seconadry map to be " + primaryUpdatesMap + " but it is " + secondaryUpdatesMap;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 300000L, 500L, true);
    }

    public static HashMap checkQueue2() {
        HashMap<String, List> listenerAttrs = new HashMap<String, List>();
        listenerAttrs.put("Create", WANTestBase.listener2.createList);
        listenerAttrs.put("Update", WANTestBase.listener2.updateList);
        listenerAttrs.put("Destroy", WANTestBase.listener2.destroyList);
        return listenerAttrs;
    }

    public static HashMap checkPR(String regionName) {
        PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
        QueueListener listener = (QueueListener)region.getCacheListener();
        HashMap<String, List> listenerAttrs = new HashMap<String, List>();
        listenerAttrs.put("Create", listener.createList);
        listenerAttrs.put("Update", listener.updateList);
        listenerAttrs.put("Destroy", listener.destroyList);
        return listenerAttrs;
    }

    public static HashMap checkBR(String regionName, int numBuckets) {
        PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
        HashMap<String, List> listenerAttrs = new HashMap<String, List>();
        for (int i = 0; i < numBuckets; ++i) {
            BucketRegion br = region.getBucketRegion((Object)i);
            QueueListener listener = (QueueListener)br.getCacheListener();
            listenerAttrs.put("Create" + i, listener.createList);
            listenerAttrs.put("Update" + i, listener.updateList);
            listenerAttrs.put("Destroy" + i, listener.destroyList);
        }
        return listenerAttrs;
    }

    public static HashMap checkQueue_PR(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        RegionQueue parallelQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
        PartitionedRegion region = (PartitionedRegion)parallelQueue.getRegion();
        QueueListener listener = (QueueListener)region.getCacheListener();
        HashMap<String, List> listenerAttrs = new HashMap<String, List>();
        listenerAttrs.put("Create", listener.createList);
        listenerAttrs.put("Update", listener.updateList);
        listenerAttrs.put("Destroy", listener.destroyList);
        return listenerAttrs;
    }

    public static HashMap checkQueue_BR(String senderId, int numBuckets) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        RegionQueue parallelQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
        PartitionedRegion region = (PartitionedRegion)parallelQueue.getRegion();
        HashMap<String, List> listenerAttrs = new HashMap<String, List>();
        for (int i = 0; i < numBuckets; ++i) {
            QueueListener listener;
            BucketRegion br = region.getBucketRegion((Object)i);
            if (br == null || (listener = (QueueListener)br.getCacheListener()) == null) continue;
            listenerAttrs.put("Create" + i, listener.createList);
            listenerAttrs.put("Update" + i, listener.updateList);
            listenerAttrs.put("Destroy" + i, listener.destroyList);
        }
        return listenerAttrs;
    }

    public static HashMap checkGateways(String gatewayHubId) {
        GatewayHub hub = cache.getGatewayHub(gatewayHubId);
        List gateways = hub.getGateways();
        HashMap<String, List> listenerAttrs = new HashMap<String, List>();
        int i = 0;
        for (Gateway gateway : gateways) {
            QueueListener listener = gatewayListeners.get(i);
            if (listener != null) {
                listenerAttrs.put("Create" + i, listener.createList);
                listenerAttrs.put("Update" + i, listener.updateList);
                listenerAttrs.put("Destroy" + i, listener.destroyList);
            }
            ++i;
        }
        return listenerAttrs;
    }

    public static void addListenerOnBucketRegion(String regionName, int numBuckets) {
        WANTestBase test = new WANTestBase(testName);
        test.addCacheListenerOnBucketRegion(regionName, numBuckets);
    }

    private void addCacheListenerOnBucketRegion(String regionName, int numBuckets) {
        PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
        for (int i = 0; i < numBuckets; ++i) {
            BucketRegion br = region.getBucketRegion((Object)i);
            AttributesMutator mutator = br.getAttributesMutator();
            listener1 = new QueueListener();
            mutator.addCacheListener((CacheListener)listener1);
        }
    }

    public static void addListenerOnQueueBucketRegion(String senderId, int numBuckets) {
        WANTestBase test = new WANTestBase(testName);
        test.addCacheListenerOnQueueBucketRegion(senderId, numBuckets);
    }

    private void addCacheListenerOnQueueBucketRegion(String senderId, int numBuckets) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        RegionQueue parallelQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
        PartitionedRegion region = (PartitionedRegion)parallelQueue.getRegion();
        for (int i = 0; i < numBuckets; ++i) {
            BucketRegion br = region.getBucketRegion((Object)i);
            if (br == null) continue;
            AttributesMutator mutator = br.getAttributesMutator();
            QueueListener listener = new QueueListener();
            mutator.addCacheListener((CacheListener)listener);
        }
    }

    public static void addListenerOnGateway(String gatewayHubId) {
        WANTestBase test = new WANTestBase(testName);
        test.addCacheListenerOnGateway(gatewayHubId);
    }

    private void addCacheListenerOnGateway(String gatewayHubId) {
        GatewayHub hub = cache.getGatewayHub(gatewayHubId);
        List gateways = hub.getGateways();
        gatewayListeners = new ArrayList<QueueListener>();
        for (Gateway gateway : gateways) {
            QueueListener listener = new QueueListener();
            ((GatewayImpl)gateway).getRegionQueueTestOnly().addCacheListener((CacheListener)listener);
            gatewayListeners.add(listener);
        }
    }

    public static void addQueueListener(String senderId, boolean isParallel) {
        WANTestBase test = new WANTestBase(testName);
        test.addCacheQueueListener(senderId, isParallel);
    }

    public static void addSecondQueueListener(String senderId, boolean isParallel) {
        WANTestBase test = new WANTestBase(testName);
        test.addSecondCacheQueueListener(senderId, isParallel);
    }

    public static void addListenerOnRegion(String regionName) {
        WANTestBase test = new WANTestBase(testName);
        test.addCacheListenerOnRegion(regionName);
    }

    private void addCacheListenerOnRegion(String regionName) {
        Region region = cache.getRegion(regionName);
        AttributesMutator mutator = region.getAttributesMutator();
        listener1 = new QueueListener();
        mutator.addCacheListener((CacheListener)listener1);
    }

    private void addCacheQueueListener(String senderId, boolean isParallel) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        listener1 = new QueueListener();
        if (!isParallel) {
            Set queues = ((SerialGatewaySenderImpl)sender).getQueues();
            for (RegionQueue q : queues) {
                q.addCacheListener((CacheListener)listener1);
            }
        } else {
            RegionQueue parallelQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            parallelQueue.addCacheListener((CacheListener)listener1);
        }
    }

    private void addSecondCacheQueueListener(String senderId, boolean isParallel) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        listener2 = new QueueListener();
        if (!isParallel) {
            Set queues = ((SerialGatewaySenderImpl)sender).getQueues();
            for (RegionQueue q : queues) {
                q.addCacheListener((CacheListener)listener2);
            }
        } else {
            RegionQueue parallelQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            parallelQueue.addCacheListener((CacheListener)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseSender(String senderId) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            sender.pause();
        }
        finally {
            exp.remove();
            exln.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseSenderAndWaitForDispatcherToPause(String senderId) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            sender.pause();
            ((AbstractGatewaySender)sender).getEventProcessor().waitForDispatcherToPause();
        }
        finally {
            exp.remove();
            exln.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeSender(String senderId) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            sender.resume();
        }
        finally {
            exp.remove();
            exln.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSender(String senderId) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            sender.stop();
        }
        finally {
            exp.remove();
            exln.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSender(String dsName, int remoteDsId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, boolean isManulaStart) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        try {
            File persistentDirectory = new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
            persistentDirectory.mkdir();
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            File[] dirs1 = new File[]{persistentDirectory};
            if (isParallel) {
                GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
                gateway.setParallel(true);
                gateway.setMaximumQueueMemory(maxMemory.intValue());
                gateway.setBatchSize(batchSize.intValue());
                gateway.setManualStart(isManulaStart);
                ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
                if (filter != null) {
                    eventFilter = filter;
                    gateway.addGatewayEventFilter(filter);
                }
                if (isPersistent) {
                    gateway.setPersistenceEnabled(true);
                    gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
                } else {
                    DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                    gateway.setDiskStoreName(store.getName());
                }
                gateway.setBatchConflationEnabled(isConflation);
                gateway.create(dsName, remoteDsId);
            } else {
                GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
                gateway.setMaximumQueueMemory(maxMemory.intValue());
                gateway.setBatchSize(batchSize.intValue());
                gateway.setManualStart(isManulaStart);
                ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
                if (filter != null) {
                    eventFilter = filter;
                    gateway.addGatewayEventFilter(filter);
                }
                gateway.setBatchConflationEnabled(isConflation);
                if (isPersistent) {
                    gateway.setPersistenceEnabled(true);
                    gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
                } else {
                    DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                    gateway.setDiskStoreName(store.getName());
                }
                gateway.create(dsName, remoteDsId);
            }
        }
        finally {
            exln.remove();
        }
    }

    public static void createSenderWithoutDiskStore(String dsName, int remoteDsId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, boolean isManulaStart) {
        GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
        gateway.setParallel(true);
        gateway.setMaximumQueueMemory(maxMemory.intValue());
        gateway.setBatchSize(batchSize.intValue());
        gateway.setManualStart(isManulaStart);
        gateway.setBatchConflationEnabled(isConflation);
        gateway.create(dsName, remoteDsId);
    }

    public static void createConcurrentSender(String dsName, int remoteDsId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, boolean isManulaStart, int concurrencyLevel, Gateway.OrderPolicy policy) {
        File persistentDirectory = new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        if (isParallel) {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setParallel(true);
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.setBatchConflationEnabled(isConflation);
            gateway.setDispatcherThreads(concurrencyLevel);
            gateway.setOrderPolicy(policy);
            gateway.create(dsName, remoteDsId);
        } else {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            gateway.setBatchConflationEnabled(isConflation);
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.setDispatcherThreads(concurrencyLevel);
            gateway.setOrderPolicy(policy);
            gateway.create(dsName, remoteDsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSenderForValidations(String dsName, int remoteDsId, boolean isParallel, Integer alertThreshold, boolean isConflation, boolean isPersistent, List<GatewayEventFilter> eventfilters, List<GatewayTransportFilter> tranportFilters, boolean isManulaStart, boolean isDiskSync) {
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(RegionDestroyedException.class.getName());
        try {
            File persistentDirectory = new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
            persistentDirectory.mkdir();
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            File[] dirs1 = new File[]{persistentDirectory};
            if (isParallel) {
                GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
                gateway.setParallel(true);
                gateway.setAlertThreshold(alertThreshold.intValue());
                ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
                if (eventfilters != null) {
                    for (GatewayEventFilter gatewayEventFilter : eventfilters) {
                        gateway.addGatewayEventFilter(gatewayEventFilter);
                    }
                }
                if (tranportFilters != null) {
                    for (GatewayTransportFilter gatewayTransportFilter : tranportFilters) {
                        gateway.addGatewayTransportFilter(gatewayTransportFilter);
                    }
                }
                if (isPersistent) {
                    gateway.setPersistenceEnabled(true);
                    gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName + "_Parallel").getName());
                } else {
                    DiskStore store = dsf.setDiskDirs(dirs1).create(dsName + "_Parallel");
                    gateway.setDiskStoreName(store.getName());
                }
                gateway.setDiskSynchronous(isDiskSync);
                gateway.setBatchConflationEnabled(isConflation);
                gateway.setManualStart(isManulaStart);
                gateway.create(dsName, remoteDsId);
            } else {
                GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
                gateway.setAlertThreshold(alertThreshold.intValue());
                gateway.setManualStart(isManulaStart);
                ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
                if (eventfilters != null) {
                    for (GatewayEventFilter gatewayEventFilter : eventfilters) {
                        gateway.addGatewayEventFilter(gatewayEventFilter);
                    }
                }
                if (tranportFilters != null) {
                    for (GatewayTransportFilter gatewayTransportFilter : tranportFilters) {
                        gateway.addGatewayTransportFilter(gatewayTransportFilter);
                    }
                }
                gateway.setBatchConflationEnabled(isConflation);
                if (isPersistent) {
                    gateway.setPersistenceEnabled(true);
                    gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName + "_Serial").getName());
                } else {
                    DiskStore store = dsf.setDiskDirs(dirs1).create(dsName + "_Serial");
                    gateway.setDiskStoreName(store.getName());
                }
                gateway.setDiskSynchronous(isDiskSync);
                gateway.create(dsName, remoteDsId);
            }
        }
        finally {
            exp1.remove();
        }
    }

    public static String createSenderWithDiskStore(String dsName, int remoteDsId, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, String dsStore, boolean isManualStart) {
        File persistentDirectory = null;
        persistentDirectory = dsStore == null ? new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum()) : new File(dsStore);
        WANTestBase.getLogWriter().info("The ds is : " + persistentDirectory.getName());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        if (isParallel) {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setParallel(true);
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManualStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                String dsname = dsf.setDiskDirs(dirs1).create(dsName).getName();
                gateway.setDiskStoreName(dsname);
                WANTestBase.getLogWriter().info("The DiskStoreName is : " + dsname);
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
                WANTestBase.getLogWriter().info("The ds is : " + store.getName());
            }
            gateway.setBatchConflationEnabled(isConflation);
            gateway.create(dsName, remoteDsId);
        } else {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManualStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            gateway.setBatchConflationEnabled(isConflation);
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.create(dsName, remoteDsId);
        }
        return persistentDirectory.getName();
    }

    public static void createSenderWithListener(String dsName, int remoteDsName, boolean isParallel, Integer maxMemory, Integer batchSize, boolean isConflation, boolean isPersistent, GatewayEventFilter filter, boolean attachTwoListeners, boolean isManulaStart) {
        File persistentDirectory = new File(dsName + "_disk_" + System.currentTimeMillis() + "_" + VM.getCurrentVMNum());
        persistentDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{persistentDirectory};
        if (isParallel) {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setParallel(true);
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            gateway.setBatchConflationEnabled(isConflation);
            gateway.create(dsName, remoteDsName);
        } else {
            GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
            gateway.setMaximumQueueMemory(maxMemory.intValue());
            gateway.setBatchSize(batchSize.intValue());
            gateway.setManualStart(isManulaStart);
            ((GatewaySenderFactoryImpl)gateway).setLocatorDiscoveryCallback((LocatorDiscoveryCallback)new MyLocatorCallback());
            if (filter != null) {
                gateway.addGatewayEventFilter(filter);
            }
            gateway.setBatchConflationEnabled(isConflation);
            if (isPersistent) {
                gateway.setPersistenceEnabled(true);
                gateway.setDiskStoreName(dsf.setDiskDirs(dirs1).create(dsName).getName());
            } else {
                DiskStore store = dsf.setDiskDirs(dirs1).create(dsName);
                gateway.setDiskStoreName(store.getName());
            }
            eventListener1 = new MyGatewaySenderEventListener();
            ((GatewaySenderFactoryImpl)gateway).addAsyncEventListener(eventListener1);
            if (attachTwoListeners) {
                eventListener2 = new MyGatewaySenderEventListener2();
                ((GatewaySenderFactoryImpl)gateway).addAsyncEventListener(eventListener2);
            }
            ((GatewaySenderFactoryImpl)gateway).create(dsName);
        }
    }

    public static void createGatewayHub(String localDsName, String remoteDsName, Integer port) {
        WANTestBase test = new WANTestBase(testName);
        int localport = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        GatewayHub hub = cache.addGatewayHub(localDsName, localport);
        Gateway gateway1 = hub.addGateway(remoteDsName);
        gateway1.addEndpoint("myEndpoint", "localhost", port.intValue());
        try {
            hub.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayHub on port " + port));
        }
    }

    public static void createGatewayHub(String id, Map<String, Integer> gateways) {
        new WANTestBase(testName);
        int localport = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        GatewayHub hub = cache.addGatewayHub(id, localport);
        Set<String> remoteDsNames = gateways.keySet();
        for (String remoteDsName : remoteDsNames) {
            Integer port = gateways.get(remoteDsName);
            Gateway gateway1 = hub.addGateway(remoteDsName);
            gateway1.addEndpoint("myEndpoint", "localhost", port.intValue());
        }
    }

    public static void pauseGateway(String localDsName) {
        new WANTestBase(testName);
        AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        GatewayHub hub = cache.getGatewayHub(localDsName);
        List gateways = hub.getGateways();
        for (Gateway gateway : gateways) {
            gateway.pause();
        }
    }

    public static void pauseWaitCriteria(final long millisec) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return "Expected to wait for " + millisec + " millisec.";
            }
        };
        DistributedTestCase.waitForCriterion(wc, millisec, 500L, false);
    }

    public static int createReceiver(int locPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + port));
        }
        return port;
    }

    public static int createReceiverAfterCache(int locPort) {
        WANTestBase test = new WANTestBase(testName);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + port));
        }
        return port;
    }

    public static void createReceiverAndServer(int locPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int receiverPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(receiverPort);
        fact.setEndPort(receiverPort);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + receiverPort));
        }
        CacheServer server = cache.addCacheServer();
        int serverPort = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(serverPort);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            WANTestBase.fail("Failed to start server ", e);
        }
    }

    public static int createReceiverInSecuredCache(int locPort) {
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail("Failed to start GatewayRecevier on port " + port, e);
        }
        return port;
    }

    public static int createServer(int locPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            WANTestBase.fail("Failed to start server ", e);
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWithLocator(int port0, String host, String regionName) {
        Pool p;
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        WANTestBase.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addLocator(host, port0).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(regionName);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setPoolName(p.getName());
        factory.setDataPolicy(DataPolicy.NORMAL);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(regionName, attrs);
        region.registerInterest((Object)"ALL_KEYS");
        WANTestBase.assertNotNull((Object)region);
        WANTestBase.getLogWriter().info("Distributed Region " + regionName + " created Successfully :" + region.toString());
    }

    public static int createReceiver_PDX(int locPort) {
        WANTestBase test = new WANTestBase(testName);
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + locPort + "]");
        InternalDistributedSystem ds = test.getSystem(props);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setPdxPersistent(true);
        cache = GemFireCacheImpl.create((DistributedSystem)ds, (boolean)false, (CacheConfig)cacheConfig);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + port));
        }
        return port;
    }

    public static void createReceiver2(int locPort) {
        WANTestBase test = new WANTestBase(testName);
        GatewayReceiverFactory fact = cache.createGatewayReceiverFactory();
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        fact.setStartPort(port);
        fact.setEndPort(port);
        GatewayReceiver receiver = fact.create();
        try {
            receiver.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayRecevier on port " + port));
        }
    }

    public static int createEndPoint(String dsName) {
        WANTestBase test = new WANTestBase(testName);
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        GatewayHub hub = cache.addGatewayHub(dsName, port);
        try {
            hub.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            WANTestBase.fail((String)("Test " + test.getName() + " failed to start GatewayHub on port " + port));
        }
        return port;
    }

    public static void doRebalance() {
        ResourceManager resMan = CacheHelper.getCache().getResourceManager();
        boolean heapEviction = resMan.getEvictionHeapPercentage() > 0.0f;
        RebalanceFactory factory = resMan.createRebalanceFactory();
        try {
            RebalanceResults simulateResults = null;
            if (!heapEviction) {
                Log.getLogWriter().info("Calling rebalance simulate");
                RebalanceOperation simulateOp = factory.simulate();
                simulateResults = simulateOp.getResults();
                Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(simulateResults, "Simulate"));
            }
            Log.getLogWriter().info("Starting rebalancing");
            RebalanceOperation rebalanceOp = factory.start();
            RebalanceResults rebalanceResults = rebalanceOp.getResults();
            Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
            if (!heapEviction) {
                RebalanceUtil.isBalanceImproved(rebalanceResults);
                RebalanceUtil.checkSimulateAgainstRebalance(simulateResults, rebalanceResults);
            }
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPuts(String regionName, int numPuts) {
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(InterruptedException.class.getName());
        DistributedTestCase.ExpectedException exp2 = WANTestBase.addExpectedException(GatewaySenderException.class.getName());
        try {
            Region r = cache.getRegion("/" + regionName);
            WANTestBase.assertNotNull((Object)r);
            for (long i = 0L; i < (long)numPuts; ++i) {
                r.put((Object)i, (Object)i);
                WANTestBase.getLogWriter().info("KBKBKB : i : " + i);
            }
        }
        finally {
            exp1.remove();
            exp2.remove();
        }
    }

    public static void doPutsAfter300(String regionName, int numPuts) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (long i = 300L; i < (long)numPuts; ++i) {
            r.put((Object)i, (Object)i);
        }
    }

    public static void doPutsFrom(String regionName, int from, int numPuts) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (long i = (long)from; i < (long)numPuts; ++i) {
            WANTestBase.getLogWriter().info("KBKBKB : putting key : " + i);
            r.put((Object)i, (Object)i);
        }
    }

    public static void doDestroys(String regionName, int keyNum) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (long i = 0L; i < (long)keyNum; ++i) {
            r.destroy((Object)i);
        }
    }

    public static void doPutAll(String regionName, int numPuts, int size) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (long i = 0L; i < (long)numPuts; ++i) {
            HashMap<Long, Long> putAllMap = new HashMap<Long, Long>();
            for (long j = 0L; j < (long)size; ++j) {
                putAllMap.put((long)size * i + j, i);
            }
            r.putAll(putAllMap);
            putAllMap.clear();
        }
    }

    public static void doPutsWithKeyAsString(String regionName, int numPuts) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (long i = 0L; i < (long)numPuts; ++i) {
            r.put((Object)("Object_" + i), (Object)i);
        }
    }

    public static void putGivenKeyValue(String regionName, Map keyValues) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (Object key : keyValues.keySet()) {
            r.put(key, keyValues.get(key));
        }
    }

    public static void destroyRegion(String regionName) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        r.destroyRegion();
    }

    public static void destroyRegionAfterMinRegionSize(String regionName, final int min) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return destroyFlag;
            }

            @Override
            public String description() {
                return "Looking for min size of region to be " + min;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 30000L, 5L, false);
        r.destroyRegion();
        destroyFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localDestroyRegion(String regionName) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(PRLocallyDestroyedException.class.getName());
        try {
            Region r = cache.getRegion("/" + regionName);
            WANTestBase.assertNotNull((Object)r);
            r.localDestroyRegion();
        }
        finally {
            exp.remove();
        }
    }

    public static Map putCustomerPartitionedRegion(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)customerRegion);
        HashMap<CustId, Customer> custKeyValues = new HashMap<CustId, Customer>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                customerRegion.put((Object)custid, (Object)customer);
                custKeyValues.put(custid, customer);
                WANTestBase.assertTrue((boolean)customerRegion.containsKey((Object)custid));
                WANTestBase.assertEquals((Object)customer, (Object)customerRegion.get((Object)custid));
                continue;
            }
            catch (Exception e) {
                WANTestBase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
            }
        }
        return custKeyValues;
    }

    public static Map updateCustomerPartitionedRegion(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)customerRegion);
        HashMap<CustId, Customer> custKeyValues = new HashMap<CustId, Customer>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i + "_update");
            try {
                customerRegion.put((Object)custid, (Object)customer);
                WANTestBase.assertTrue((boolean)customerRegion.containsKey((Object)custid));
                WANTestBase.assertEquals((Object)customer, (Object)customerRegion.get((Object)custid));
                custKeyValues.put(custid, customer);
                continue;
            }
            catch (Exception e) {
                WANTestBase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
            }
        }
        return custKeyValues;
    }

    public static Map putOrderPartitionedRegion(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)orderRegion);
        HashMap<OrderId, Order> orderKeyValues = new HashMap<OrderId, Order>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 1; ++j) {
                int oid = i * 1 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                try {
                    orderRegion.put((Object)orderId, (Object)order);
                    orderKeyValues.put(orderId, order);
                    WANTestBase.assertTrue((boolean)orderRegion.containsKey((Object)orderId));
                    WANTestBase.assertEquals((Object)order, (Object)orderRegion.get((Object)orderId));
                    continue;
                }
                catch (Exception e) {
                    WANTestBase.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
        return orderKeyValues;
    }

    public static Map putOrderPartitionedRegionUsingCustId(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)orderRegion);
        HashMap<CustId, Order> orderKeyValues = new HashMap<CustId, Order>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            Order order = new Order("OREDR" + i);
            try {
                orderRegion.put((Object)custid, (Object)order);
                orderKeyValues.put(custid, order);
                WANTestBase.assertTrue((boolean)orderRegion.containsKey((Object)custid));
                WANTestBase.assertEquals((Object)order, (Object)orderRegion.get((Object)custid));
                continue;
            }
            catch (Exception e) {
                WANTestBase.fail("putOrderPartitionedRegionUsingCustId : failed while doing put operation in OrderPartitionedRegion ", e);
            }
        }
        return orderKeyValues;
    }

    public static Map updateOrderPartitionedRegion(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)orderRegion);
        HashMap<OrderId, Order> orderKeyValues = new HashMap<OrderId, Order>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 1; ++j) {
                int oid = i * 1 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid + "_update");
                try {
                    orderRegion.put((Object)orderId, (Object)order);
                    orderKeyValues.put(orderId, order);
                    WANTestBase.assertTrue((boolean)orderRegion.containsKey((Object)orderId));
                    WANTestBase.assertEquals((Object)order, (Object)orderRegion.get((Object)orderId));
                    continue;
                }
                catch (Exception e) {
                    WANTestBase.fail("updateOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
        return orderKeyValues;
    }

    public static Map updateOrderPartitionedRegionUsingCustId(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)orderRegion);
        HashMap<CustId, Order> orderKeyValues = new HashMap<CustId, Order>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            Order order = new Order("OREDR" + i + "_update");
            try {
                orderRegion.put((Object)custid, (Object)order);
                WANTestBase.assertTrue((boolean)orderRegion.containsKey((Object)custid));
                WANTestBase.assertEquals((Object)order, (Object)orderRegion.get((Object)custid));
                orderKeyValues.put(custid, order);
                continue;
            }
            catch (Exception e) {
                WANTestBase.fail("updateOrderPartitionedRegionUsingCustId : failed while doing put operation in OrderPartitionedRegion ", e);
            }
        }
        return orderKeyValues;
    }

    public static Map putShipmentPartitionedRegion(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)shipmentRegion);
        HashMap<ShipmentId, Shipment> shipmentKeyValue = new HashMap<ShipmentId, Shipment>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 1; ++j) {
                int oid = i * 1 + j;
                OrderId orderId = new OrderId(oid, custid);
                for (int k = 1; k <= 1; ++k) {
                    int sid = oid * 1 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    try {
                        shipmentRegion.put((Object)shipmentId, (Object)shipment);
                        WANTestBase.assertTrue((boolean)shipmentRegion.containsKey((Object)shipmentId));
                        WANTestBase.assertEquals((Object)shipment, (Object)shipmentRegion.get((Object)shipmentId));
                        shipmentKeyValue.put(shipmentId, shipment);
                        continue;
                    }
                    catch (Exception e) {
                        WANTestBase.fail("putShipmentPartitionedRegion : failed while doing put operation in ShipmentPartitionedRegion ", e);
                    }
                }
            }
        }
        return shipmentKeyValue;
    }

    public static void putcolocatedPartitionedRegion(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)customerRegion);
        WANTestBase.assertNotNull((Object)orderRegion);
        WANTestBase.assertNotNull((Object)shipmentRegion);
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("Customer" + custid, "Address" + custid);
            customerRegion.put((Object)custid, (Object)customer);
            for (int j = 1; j <= 1; ++j) {
                int oid = i * 1 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("Order" + orderId);
                orderRegion.put((Object)orderId, (Object)order);
                for (int k = 1; k <= 1; ++k) {
                    int sid = oid * 1 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    shipmentRegion.put((Object)shipmentId, (Object)shipment);
                }
            }
        }
    }

    public static Map putShipmentPartitionedRegionUsingCustId(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)shipmentRegion);
        HashMap<CustId, Shipment> shipmentKeyValue = new HashMap<CustId, Shipment>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            Shipment shipment = new Shipment("Shipment" + i);
            try {
                shipmentRegion.put((Object)custid, (Object)shipment);
                WANTestBase.assertTrue((boolean)shipmentRegion.containsKey((Object)custid));
                WANTestBase.assertEquals((Object)shipment, (Object)shipmentRegion.get((Object)custid));
                shipmentKeyValue.put(custid, shipment);
                continue;
            }
            catch (Exception e) {
                WANTestBase.fail("putShipmentPartitionedRegionUsingCustId : failed while doing put operation in ShipmentPartitionedRegion ", e);
            }
        }
        return shipmentKeyValue;
    }

    public static void doPutsPDXSerializable(String regionName, int numPuts) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (int i = 0; i < numPuts; ++i) {
            r.put((Object)("Key_" + i), (Object)new SimpleClass(i, (byte)i));
        }
    }

    public static void doTxPuts(String regionName, int numPuts) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        CacheTransactionManager mgr = cache.getCacheTransactionManager();
        mgr.begin();
        r.put((Object)0, (Object)0);
        r.put((Object)100, (Object)100);
        r.put((Object)200, (Object)200);
        mgr.commit();
    }

    public static Map updateShipmentPartitionedRegion(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)shipmentRegion);
        HashMap<ShipmentId, Shipment> shipmentKeyValue = new HashMap<ShipmentId, Shipment>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 1; ++j) {
                int oid = i * 1 + j;
                OrderId orderId = new OrderId(oid, custid);
                for (int k = 1; k <= 1; ++k) {
                    int sid = oid * 1 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid + "_update");
                    try {
                        shipmentRegion.put((Object)shipmentId, (Object)shipment);
                        WANTestBase.assertTrue((boolean)shipmentRegion.containsKey((Object)shipmentId));
                        WANTestBase.assertEquals((Object)shipment, (Object)shipmentRegion.get((Object)shipmentId));
                        shipmentKeyValue.put(shipmentId, shipment);
                        continue;
                    }
                    catch (Exception e) {
                        WANTestBase.fail("updateShipmentPartitionedRegion : failed while doing put operation in ShipmentPartitionedRegion ", e);
                    }
                }
            }
        }
        return shipmentKeyValue;
    }

    public static Map updateShipmentPartitionedRegionUsingCustId(int numPuts) {
        WANTestBase.assertNotNull((Object)cache);
        WANTestBase.assertNotNull((Object)shipmentRegion);
        HashMap<CustId, Shipment> shipmentKeyValue = new HashMap<CustId, Shipment>();
        for (int i = 1; i <= numPuts; ++i) {
            CustId custid = new CustId(i);
            Shipment shipment = new Shipment("Shipment" + i + "_update");
            try {
                shipmentRegion.put((Object)custid, (Object)shipment);
                WANTestBase.assertTrue((boolean)shipmentRegion.containsKey((Object)custid));
                WANTestBase.assertEquals((Object)shipment, (Object)shipmentRegion.get((Object)custid));
                shipmentKeyValue.put(custid, shipment);
                continue;
            }
            catch (Exception e) {
                WANTestBase.fail("updateShipmentPartitionedRegionUsingCustId : failed while doing put operation in ShipmentPartitionedRegion ", e);
            }
        }
        return shipmentKeyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doNextPuts(String regionName, int start, int numPuts) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(CacheClosedException.class.getName());
        try {
            Region r = cache.getRegion("/" + regionName);
            WANTestBase.assertNotNull((Object)r);
            for (long i = (long)start; i < (long)numPuts; ++i) {
                r.put((Object)i, (Object)i);
            }
        }
        finally {
            exp.remove();
        }
    }

    public static void checkQueueSize(String senderId, int numQueueEntries) {
        GatewaySender sender = null;
        for (GatewaySender s : cache.getGatewaySenders()) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if (sender instanceof ParallelGatewaySenderImpl) {
            int totalSize = 0;
            Set queues = ((ParallelGatewaySenderImpl)sender).getQueues();
            for (RegionQueue q : queues) {
                ConcurrentParallelGatewaySenderQueue prQ = (ConcurrentParallelGatewaySenderQueue)q;
                totalSize += prQ.size();
            }
            WANTestBase.assertEquals((int)numQueueEntries, (int)totalSize);
        } else {
            Set queues = ((SerialGatewaySenderImpl)sender).getQueues();
            int size = 0;
            for (RegionQueue q : queues) {
                size += q.size();
            }
            WANTestBase.assertEquals((int)numQueueEntries, (int)size);
        }
    }

    public static void checkPRQLocalSize(String senderId, int numQueueEntries) {
        GatewaySender sender = null;
        for (GatewaySender s : cache.getGatewaySenders()) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if (sender instanceof ParallelGatewaySenderImpl) {
            int totalSize = 0;
            Set queues = ((ParallelGatewaySenderImpl)sender).getQueues();
            for (RegionQueue q : queues) {
                ConcurrentParallelGatewaySenderQueue prQ = (ConcurrentParallelGatewaySenderQueue)q;
                totalSize += prQ.localSize();
            }
            WANTestBase.assertEquals((int)numQueueEntries, (int)totalSize);
        }
    }

    public static void doUpdates(String regionName, int numUpdates) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (int i = 0; i < numUpdates; ++i) {
            String s = "K" + i;
            r.put((Object)i, (Object)s);
        }
    }

    public static void doUpdateOnSameKey(String regionName, int key, int numUpdates) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (int i = 0; i < numUpdates; ++i) {
            String s = "V_" + i;
            r.put((Object)key, (Object)s);
        }
    }

    public static void doRandomUpdates(String regionName, int numUpdates) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        HashSet<Integer> generatedKeys = new HashSet<Integer>();
        while (generatedKeys.size() != numUpdates) {
            generatedKeys.add(new Random().nextInt(r.size()));
        }
        for (Integer i : generatedKeys) {
            String s = "K" + i;
            r.put((Object)i, (Object)s);
        }
    }

    public static void doMultiThreadedPuts(String regionName, int numPuts) {
        AtomicInteger ai = new AtomicInteger(-1);
        ExecutorService execService = Executors.newFixedThreadPool(5, new ThreadFactory(){
            AI threadNum = CFactory.createAI();

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r, "Client Put Thread-" + this.threadNum.incrementAndGet());
                result.setDaemon(true);
                return result;
            }
        });
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        ArrayList<PutTask> tasks = new ArrayList<PutTask>();
        for (long i = 0L; i < 5L; ++i) {
            tasks.add(new PutTask(r, ai, numPuts));
        }
        try {
            List l = execService.invokeAll(tasks);
            for (Future f : l) {
                f.get();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        execService.shutdown();
    }

    public static void verifyAsyncEventListenerForPossibleDuplicates(String asyncEventQueueId, Set<Integer> bucketIds, int batchSize) {
        AsyncEventListener theListener = null;
        Set asyncEventQueues = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncQueue : asyncEventQueues) {
            if (!asyncEventQueueId.equals(asyncQueue.getId())) continue;
            theListener = asyncQueue.getAsyncEventListener();
        }
        Map<Integer, List<GatewaySenderEventImpl>> bucketToEventsMap = ((MyAsyncEventListener2)theListener).getBucketToEventsMap();
        WANTestBase.assertNotNull(bucketToEventsMap);
        WANTestBase.assertTrue((bucketIds.size() > 1 ? 1 : 0) != 0);
        for (int bucketId : bucketIds) {
            List<GatewaySenderEventImpl> eventsForBucket = bucketToEventsMap.get(bucketId);
            WANTestBase.getLogWriter().info("Events for bucket: " + bucketId + " is " + eventsForBucket);
            WANTestBase.assertNotNull(eventsForBucket);
            for (int i = 0; i < batchSize; ++i) {
                GatewaySenderEventImpl senderEvent = eventsForBucket.get(i);
                WANTestBase.assertTrue((boolean)senderEvent.getPossibleDuplicate());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateRegionSize(String regionName, final int regionSize) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(CacheClosedException.class.getName());
        try {
            final Region r = cache.getRegion("/" + regionName);
            WANTestBase.assertNotNull((Object)r);
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r.keySet().size() == regionSize;
                }

                @Override
                public String description() {
                    return "Expected region entries: " + regionSize + " but actual entries: " + r.keySet().size() + " present region keyset " + r.keySet();
                }
            };
            DistributedTestCase.waitForCriterion(wc, 240000L, 500L, true);
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    public static void validateAsyncEventQueueAttributes(String asyncChannelId, int maxQueueMemory, int batchSize, int batchTimeInterval, boolean isPersistent, String diskStoreName, boolean isDiskSynchronous, boolean batchConflationEnabled) {
        AsyncEventQueue theChannel = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncChannelId.equals(asyncChannel.getId())) continue;
            theChannel = asyncChannel;
        }
        AbstractGatewaySender theSender = ((AsyncEventQueueImpl)theChannel).getSender();
        WANTestBase.assertEquals((String)"maxQueueMemory", (int)maxQueueMemory, (int)theSender.getMaximumQueueMemory());
        WANTestBase.assertEquals((String)"batchSize", (int)batchSize, (int)theSender.getBatchSize());
        WANTestBase.assertEquals((String)"batchTimeInterval", (int)batchTimeInterval, (int)theSender.getBatchTimeInterval());
        WANTestBase.assertEquals((String)"isPersistent", (boolean)isPersistent, (boolean)theSender.isPersistenceEnabled());
        WANTestBase.assertEquals((String)"diskStoreName", (String)diskStoreName, (String)theSender.getDiskStoreName());
        WANTestBase.assertEquals((String)"isDiskSynchronous", (boolean)isDiskSynchronous, (boolean)theSender.isDiskSynchronous());
        WANTestBase.assertEquals((String)"batchConflation", (boolean)batchConflationEnabled, (boolean)theSender.isBatchConflationEnabled());
    }

    public static void validateConcurrentAsyncEventQueueAttributes(String asyncChannelId, int maxQueueMemory, int batchSize, int batchTimeInterval, boolean isPersistent, String diskStoreName, boolean isDiskSynchronous, boolean batchConflationEnabled, int dispatcherThreads, Gateway.OrderPolicy policy) {
        AsyncEventQueue theChannel = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncChannelId.equals(asyncChannel.getId())) continue;
            theChannel = asyncChannel;
        }
        AbstractGatewaySender theSender = ((AsyncEventQueueImpl)theChannel).getSender();
        WANTestBase.assertEquals((String)"maxQueueMemory", (int)maxQueueMemory, (int)theSender.getMaximumQueueMemory());
        WANTestBase.assertEquals((String)"batchSize", (int)batchSize, (int)theSender.getBatchSize());
        WANTestBase.assertEquals((String)"batchTimeInterval", (int)batchTimeInterval, (int)theSender.getBatchTimeInterval());
        WANTestBase.assertEquals((String)"isPersistent", (boolean)isPersistent, (boolean)theSender.isPersistenceEnabled());
        WANTestBase.assertEquals((String)"diskStoreName", (String)diskStoreName, (String)theSender.getDiskStoreName());
        WANTestBase.assertEquals((String)"isDiskSynchronous", (boolean)isDiskSynchronous, (boolean)theSender.isDiskSynchronous());
        WANTestBase.assertEquals((String)"batchConflation", (boolean)batchConflationEnabled, (boolean)theSender.isBatchConflationEnabled());
        WANTestBase.assertEquals((String)"dispatcherThreads", (int)dispatcherThreads, (int)theSender.getDispatcherThreads());
        WANTestBase.assertEquals((String)"orderPolicy", (Object)policy, (Object)theSender.getOrderPolicy());
    }

    public static void validateAsyncEventListener(String asyncQueueId, final int expectedSize) {
        AsyncEventListener theListener = null;
        Set asyncEventQueues = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncQueue : asyncEventQueues) {
            if (!asyncQueueId.equals(asyncQueue.getId())) continue;
            theListener = asyncQueue.getAsyncEventListener();
        }
        final Map eventsMap = ((MyAsyncEventListener)theListener).getEventsMap();
        WANTestBase.assertNotNull((Object)eventsMap);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return eventsMap.size() == expectedSize;
            }

            @Override
            public String description() {
                return "Expected map entries: " + expectedSize + " but actual entries: " + eventsMap.size();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 500L, true);
    }

    public static void validateCustomAsyncEventListener(String asyncQueueId, final int expectedSize) {
        AsyncEventListener theListener = null;
        Set asyncEventQueues = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncQueue : asyncEventQueues) {
            if (!asyncQueueId.equals(asyncQueue.getId())) continue;
            theListener = asyncQueue.getAsyncEventListener();
        }
        final Map eventsMap = ((CustomAsyncEventListener)theListener).getEventsMap();
        WANTestBase.assertNotNull(eventsMap);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return eventsMap.size() == expectedSize;
            }

            @Override
            public String description() {
                return "Expected map entries: " + expectedSize + " but actual entries: " + eventsMap.size();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 500L, true);
        for (AsyncEvent event : eventsMap.values()) {
            WANTestBase.assertTrue((String)("possibleDuplicate should be true for event: " + event), (boolean)event.getPossibleDuplicate());
        }
    }

    public static void waitForAsyncQueueToGetEmpty(String asyncQueueId) {
        AsyncEventQueue theAsyncEventQueue = null;
        Set asyncEventChannels = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncChannel : asyncEventChannels) {
            if (!asyncQueueId.equals(asyncChannel.getId())) continue;
            theAsyncEventQueue = asyncChannel;
        }
        AbstractGatewaySender sender = ((AsyncEventQueueImpl)theAsyncEventQueue).getSender();
        if (sender instanceof ParallelGatewaySenderImpl) {
            final Set queues = ((ParallelGatewaySenderImpl)sender).getQueues();
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    int size = 0;
                    for (RegionQueue q : queues) {
                        size += q.size();
                    }
                    return size == 0;
                }

                @Override
                public String description() {
                    int size = 0;
                    for (RegionQueue q : queues) {
                        size += q.size();
                    }
                    return "Expected queue size to be : 0 but actual entries: " + size;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 500L, true);
        } else {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion((GatewaySender)sender){
                final /* synthetic */ GatewaySender val$sender;
                {
                    this.val$sender = gatewaySender;
                }

                @Override
                public boolean done() {
                    Set queues = ((SerialGatewaySenderImpl)this.val$sender).getQueues();
                    int size = 0;
                    for (RegionQueue q : queues) {
                        size += q.size();
                    }
                    return size == 0;
                }

                @Override
                public String description() {
                    Set queues = ((SerialGatewaySenderImpl)this.val$sender).getQueues();
                    int size = 0;
                    for (RegionQueue q : queues) {
                        size += q.size();
                    }
                    return "Expected queue size to be : 0 but actual entries: " + size;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 500L, true);
        }
    }

    public static int getAsyncEventListenerMapSize(String asyncEventQueueId) {
        AsyncEventListener theListener = null;
        Set asyncEventQueues = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncQueue : asyncEventQueues) {
            if (!asyncEventQueueId.equals(asyncQueue.getId())) continue;
            theListener = asyncQueue.getAsyncEventListener();
        }
        Map eventsMap = ((MyAsyncEventListener)theListener).getEventsMap();
        WANTestBase.assertNotNull((Object)eventsMap);
        WANTestBase.getLogWriter().info("The events map size is " + eventsMap.size());
        return eventsMap.size();
    }

    public static int getAsyncEventQueueSize(String asyncEventQueueId) {
        AsyncEventQueue theQueue = null;
        Set asyncEventQueues = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncQueue : asyncEventQueues) {
            if (!asyncEventQueueId.equals(asyncQueue.getId())) continue;
            theQueue = asyncQueue;
        }
        WANTestBase.assertNotNull(theQueue);
        return theQueue.size();
    }

    public static void validateRegionSize_PDX(String regionName, final int regionSize) {
        final Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return r.keySet().size() == regionSize;
            }

            @Override
            public String description() {
                return "Expected region entries: " + regionSize + " but actual entries: " + r.keySet().size() + " present region keyset " + r.keySet();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 200000L, 500L, true);
        for (int i = 0; i < regionSize; ++i) {
            WANTestBase.getLogWriter().info("For Key : Key_" + i + " : Values : " + r.get((Object)("Key_" + i)));
            WANTestBase.assertEquals((Object)new SimpleClass(i, (byte)i), (Object)r.get((Object)("Key_" + i)));
        }
    }

    public static void validateRegionSizeRemainsSame(String regionName, final int regionSizeLimit) {
        final Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            final int MIN_VERIFICATION_RUNS = 20;
            int sameRegionSizeCounter = 0;
            long previousSize = -1L;

            @Override
            public boolean done() {
                if ((long)r.keySet().size() == this.previousSize) {
                    ++this.sameRegionSizeCounter;
                    return this.sameRegionSizeCounter >= 20 && r.keySet().size() <= regionSizeLimit;
                }
                this.previousSize = r.keySet().size();
                this.sameRegionSizeCounter = 0;
                return false;
            }

            @Override
            public String description() {
                return "Expected region size to remain same below a specified limit but actual region size does not remain same or exceeded the specified limit " + this.sameRegionSizeCounter + " :regionSize " + this.previousSize;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 200000L, 500L, true);
    }

    public static String getRegionFullPath(String regionName) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        return r.getFullPath();
    }

    public static Integer getRegionSize(String regionName) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        return r.keySet().size();
    }

    public static void validateRegionContents(String regionName, final Map keyValues) {
        final Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                for (Object key : keyValues.keySet()) {
                    if (r.get(key).equals(keyValues.get(key))) continue;
                    DistributedTestCase.getLogWriter().info("The values are for key   " + key + " " + r.get(key) + " in the map " + keyValues.get(key));
                    return false;
                }
                return true;
            }

            @Override
            public String description() {
                return "Expected region entries doesn't match";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
    }

    public static void CheckContent(String regionName, int regionSize) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (long i = 0L; i < (long)regionSize; ++i) {
            WANTestBase.assertEquals((Object)i, (Object)r.get((Object)i));
        }
    }

    public static void validateRegionContentsForPR(String regionName, final int regionSize) {
        final Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return r.keySet().size() == regionSize;
            }

            @Override
            public String description() {
                return "Expected region entries: " + regionSize + " but actual entries: " + r.keySet().size();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
    }

    public static void verifyPrimaryStatus(final Boolean isPrimary) {
        Set senders = cache.getGatewaySenders();
        WANTestBase.assertEquals((int)senders.size(), (int)1);
        final SerialGatewaySenderImpl sender = (SerialGatewaySenderImpl)senders.iterator().next();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return sender.isPrimary() == isPrimary.booleanValue();
            }

            @Override
            public String description() {
                return "Expected sender to be : " + isPrimary + " but actually it is : " + sender.isPrimary();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
    }

    public static Boolean getPrimaryStatus() {
        Set senders = cache.getGatewaySenders();
        WANTestBase.assertEquals((int)senders.size(), (int)1);
        final SerialGatewaySenderImpl sender = (SerialGatewaySenderImpl)senders.iterator().next();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return sender.isPrimary();
            }

            @Override
            public String description() {
                return "Checking Primary Status";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 500L, false);
        return sender.isPrimary();
    }

    public static Set<Integer> getAllPrimaryBucketsOnTheNode(String regionName) {
        PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
        return region.getDataStore().getAllLocalPrimaryBucketIds();
    }

    public static void doHeavyPuts(String regionName, int numPuts) {
        Region r = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)r);
        for (long i = 0L; i < (long)numPuts; ++i) {
            r.put((Object)i, (Object)new byte[0x100000]);
        }
    }

    public static void addListenerAndKillPrimary() {
        Set senders = ((GemFireCacheImpl)cache).getAllGatewaySenders();
        WANTestBase.assertEquals((int)senders.size(), (int)1);
        SerialGatewaySenderImpl sender = (SerialGatewaySenderImpl)senders.iterator().next();
        Region queue = cache.getRegion("/" + sender.getId() + "_SERIAL_GATEWAY_SENDER_QUEUE");
        WANTestBase.assertNotNull((Object)queue);
        CacheListenerAdapter cl = new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                if ((Long)event.getKey() > 900L) {
                    cache.getLogger().fine(" Gateway sender is killed by a test");
                    cache.close();
                    cache.getDistributedSystem().disconnect();
                }
            }
        };
        queue.getAttributesMutator().addCacheListener((CacheListener)cl);
    }

    public static void addCacheListenerAndDestroyRegion(String regionName) {
        final Region region = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)region);
        CacheListenerAdapter cl = new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                if ((Long)event.getKey() == 99L) {
                    region.destroyRegion();
                }
            }
        };
        region.getAttributesMutator().addCacheListener((CacheListener)cl);
    }

    public static void addCacheListenerAndCloseCache(String regionName) {
        Region region = cache.getRegion("/" + regionName);
        WANTestBase.assertNotNull((Object)region);
        CacheListenerAdapter cl = new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                if ((Long)event.getKey() == 900L) {
                    cache.getLogger().fine(" Gateway sender is killed by a test");
                    cache.close();
                    cache.getDistributedSystem().disconnect();
                }
            }
        };
        region.getAttributesMutator().addCacheListener((CacheListener)cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean killSender(String senderId) {
        DistributedTestCase.ExpectedException exln = WANTestBase.addExpectedException("Could not connect");
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(CacheClosedException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            Boolean bl;
            Set senders = cache.getGatewaySenders();
            SerialGatewaySenderImpl sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = (SerialGatewaySenderImpl)s;
                break;
            }
            if (sender.isPrimary()) {
                WANTestBase.getLogWriter().info("Gateway sender is killed by a test");
                cache.getDistributedSystem().disconnect();
                bl = Boolean.TRUE;
                return bl;
            }
            bl = Boolean.FALSE;
            return bl;
        }
        finally {
            exp.remove();
            exp1.remove();
            exln.remove();
        }
    }

    public static Boolean killAsyncEventQueue(String asyncQueueId) {
        Set queues = cache.getAsyncEventQueues();
        AsyncEventQueueImpl queue = null;
        for (AsyncEventQueue q : queues) {
            if (!q.getId().equals(asyncQueueId)) continue;
            queue = (AsyncEventQueueImpl)q;
            break;
        }
        if (queue.isPrimary()) {
            WANTestBase.getLogWriter().info("AsyncEventQueue is killed by a test");
            cache.getDistributedSystem().disconnect();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void killSender() {
        WANTestBase.getLogWriter().info("Gateway sender is going to be killed by a test");
        cache.close();
        cache.getDistributedSystem().disconnect();
        WANTestBase.getLogWriter().info("Gateway sender is killed by a test");
    }

    static void waitForSitesToUpdate() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return "Waiting for all sites to get updated";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 500L, false);
    }

    public static void checkAllSiteMetaData(Map<Integer, List<Integer>> dsVsPorts) {
        WANTestBase.waitForSitesToUpdate();
        WANTestBase.assertNotNull((Object)system);
        List locatorsConfigured = Locator.getLocators();
        Locator locator = (Locator)locatorsConfigured.get(0);
        ConcurrentMap allSiteMetaData = ((InternalLocator)locator).getAllLocatorsInfo();
        System.out.println("allSiteMetaData : " + allSiteMetaData);
        System.out.println("dsVsPorts : " + dsVsPorts);
        System.out.println("Server allSiteMetaData : " + locator.getAllServerLocatorsInfo());
        for (Map.Entry<Integer, List<Integer>> entry : dsVsPorts.entrySet()) {
            Set locators = (Set)allSiteMetaData.get(entry.getKey());
            WANTestBase.assertNotNull((Object)locators);
            List<Integer> value = entry.getValue();
            for (Integer port : entry.getValue()) {
                boolean portAvailable = false;
                for (DistributionLocatorId locId : locators) {
                    if (locId.getPort() != port.intValue()) continue;
                    portAvailable = true;
                }
                WANTestBase.assertTrue((boolean)portAvailable);
            }
        }
    }

    public static Long checkAllSiteMetaDataFor3Sites(final Map<Integer, Set<String>> dsVsPort) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return DistributedTestCase.system != null;
            }

            @Override
            public String description() {
                return "Making sure system is initialized";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 50000L, 1000L, true);
        WANTestBase.assertNotNull((Object)system);
        List locatorsConfigured = Locator.getLocators();
        Locator locator = (Locator)locatorsConfigured.get(0);
        final ConcurrentMap allSiteMetaData = ((InternalLocator)locator).getAllLocatorsInfo();
        System.out.println("allSiteMetaData : " + allSiteMetaData);
        wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                if (dsVsPort.size() == allSiteMetaData.size()) {
                    for (Map.Entry entry : dsVsPort.entrySet()) {
                        Set locators = (Set)allSiteMetaData.get(entry.getKey());
                        for (String locator : (Set)entry.getValue()) {
                            DistributionLocatorId locatorId = new DistributionLocatorId(locator);
                            if (locators.contains(locatorId)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public String description() {
                return "Expected site Metadata: " + dsVsPort + " but actual meta data: " + allSiteMetaData;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 300000L, 500L, true);
        return System.currentTimeMillis();
    }

    public static void checkLocatorsinSender(String senderId, InetSocketAddress locatorToWaitFor) throws InterruptedException {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        MyLocatorCallback callback = (MyLocatorCallback)((AbstractGatewaySender)sender).getLocatorDiscoveryCallback();
        boolean discovered = callback.waitForDiscovery(locatorToWaitFor, 10000L);
        Assert.assertTrue((String)("Waited 10000 for " + locatorToWaitFor + " to be discovered on client. List is now: " + callback.getDiscovered()), (boolean)discovered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateQueueContents(String senderId, final int regionSize) {
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(InterruptedException.class.getName());
        DistributedTestCase.ExpectedException exp2 = WANTestBase.addExpectedException(GatewaySenderException.class.getName());
        try {
            DistributedTestCase.WaitCriterion wc;
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            if (sender instanceof SerialGatewaySenderImpl) {
                final Set queues = ((SerialGatewaySenderImpl)sender).getQueues();
                wc = new DistributedTestCase.WaitCriterion(){
                    int size = 0;

                    @Override
                    public boolean done() {
                        this.size = 0;
                        for (RegionQueue q : queues) {
                            this.size += q.size();
                        }
                        return this.size == regionSize;
                    }

                    @Override
                    public String description() {
                        return "Expected queue entries: " + regionSize + " but actual entries: " + this.size;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
            } else if (sender instanceof ParallelGatewaySenderImpl) {
                final RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return regionQueue.size() == regionSize;
                    }

                    @Override
                    public String description() {
                        return "Expected queue entries: " + regionSize + " but actual entries: " + regionQueue.size();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
            }
        }
        finally {
            exp1.remove();
            exp2.remove();
        }
    }

    public static void validateQueueClosedForConcurrentSerialGatewaySender(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        Set regionQueue = sender instanceof SerialGatewaySenderImpl ? ((SerialGatewaySenderImpl)sender).getQueuesForConcurrentSerialGatewaySender() : null;
        WANTestBase.assertEquals(null, (Object)regionQueue);
    }

    public static void validateQueueContentsForConcurrentSerialGatewaySender(String senderId, final int regionSize) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        final Set regionQueue = sender instanceof SerialGatewaySenderImpl ? ((SerialGatewaySenderImpl)sender).getQueuesForConcurrentSerialGatewaySender() : null;
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            int size = 0;

            @Override
            public boolean done() {
                this.size = 0;
                for (RegionQueue q : regionQueue) {
                    this.size += q.size();
                }
                return this.size == regionSize;
            }

            @Override
            public String description() {
                return "Expected queue entries: " + regionSize + " but actual entries: " + this.size;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 500L, true);
    }

    public static Integer getQueueContentSize(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if (sender instanceof SerialGatewaySenderImpl) {
            Set queues = ((SerialGatewaySenderImpl)sender).getQueues();
            int size = 0;
            for (RegionQueue q : queues) {
                size += q.size();
            }
            return size;
        }
        if (sender instanceof ParallelGatewaySenderImpl) {
            RegionQueue regionQueue = null;
            regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            return regionQueue.getRegion().size();
        }
        return 0;
    }

    public static void validateParallelSenderQueueBucketSize(String senderId, int bucketSize) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
        Set buckets = ((PartitionedRegion)regionQueue.getRegion()).getDataStore().getAllLocalPrimaryBucketRegions();
        for (BucketRegion bucket : buckets) {
            WANTestBase.assertEquals((String)("Expected bucket entries for bucket " + bucket.getId() + " is different than actual."), (int)bucketSize, (int)bucket.keySet().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateParallelSenderQueueAllBucketsDrained(String senderId) {
        DistributedTestCase.ExpectedException exp = WANTestBase.addExpectedException(RegionDestroyedException.class.getName());
        DistributedTestCase.ExpectedException exp1 = WANTestBase.addExpectedException(ForceReattemptException.class.getName());
        try {
            Set senders = cache.getGatewaySenders();
            GatewaySender sender = null;
            for (GatewaySender s : senders) {
                if (!s.getId().equals(senderId)) continue;
                sender = s;
                break;
            }
            RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            Set buckets = ((PartitionedRegion)regionQueue.getRegion()).getDataStore().getAllLocalPrimaryBucketRegions();
            for (final BucketRegion bucket : buckets) {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        if (bucket.keySet().size() == 0) {
                            DistributedTestCase.getLogWriter().info("Bucket " + bucket.getId() + " is empty");
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public String description() {
                        return "Expected bucket entries for bucket: " + bucket.getId() + " is: 0 but actual entries: " + bucket.keySet().size() + " This bucket isPrimary: " + bucket.getBucketAdvisor().isPrimary() + " KEYSET: " + bucket.keySet();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 180000L, 50L, true);
            }
        }
        finally {
            exp.remove();
            exp1.remove();
        }
    }

    public static int verifyAndGetEventsDispatchedByConcurrentDispatchers(String senderId) {
        ConcurrentParallelGatewaySenderEventProcessor cProc;
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if ((cProc = (ConcurrentParallelGatewaySenderEventProcessor)((ParallelGatewaySenderImpl)sender).getEventProcessor()) == null) {
            return 0;
        }
        int totalDispatched = 0;
        for (ParallelGatewaySenderEventProcessor lProc : cProc.getProcessors()) {
            WANTestBase.assertTrue((lProc.getNumEventsDispatched() > 0L ? 1 : 0) != 0);
            totalDispatched = (int)((long)totalDispatched + lProc.getNumEventsDispatched());
        }
        return totalDispatched;
    }

    public static Long getNumberOfEntriesOverflownToDisk(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        long numEntries = 0L;
        if (sender instanceof ParallelGatewaySenderImpl) {
            RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            numEntries = ((ConcurrentParallelGatewaySenderQueue)regionQueue).getNumEntriesOverflowOnDiskTestOnly();
        }
        return numEntries;
    }

    public static Long getNumberOfEntriesInVM(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        long numEntries = 0L;
        if (sender instanceof ParallelGatewaySenderImpl) {
            RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            numEntries = ((ConcurrentParallelGatewaySenderQueue)regionQueue).getNumEntriesInVMTestOnly();
        }
        return numEntries;
    }

    public static void verifyQueueSize(String senderId, int size) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if (sender instanceof SerialGatewaySenderImpl) {
            Set queues = ((SerialGatewaySenderImpl)sender).getQueues();
            int queueSize = 0;
            for (RegionQueue q : queues) {
                queueSize += q.size();
            }
            WANTestBase.assertEquals((String)("verifyQueueSize failed for sender " + senderId), (int)size, (int)queueSize);
        } else if (sender instanceof ParallelGatewaySenderImpl) {
            RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            WANTestBase.assertEquals((String)("verifyQueueSize failed for sender " + senderId), (int)size, (int)regionQueue.size());
        }
    }

    public static void verifyRegionQueueNotEmpty(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if (sender instanceof SerialGatewaySenderImpl) {
            Set queues = ((SerialGatewaySenderImpl)sender).getQueues();
            int queueSize = 0;
            for (RegionQueue q : queues) {
                queueSize += q.size();
            }
            WANTestBase.assertTrue((queueSize > 0 ? 1 : 0) != 0);
        } else if (sender instanceof ParallelGatewaySenderImpl) {
            RegionQueue regionQueue = ((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            WANTestBase.assertTrue((regionQueue.size() > 0 ? 1 : 0) != 0);
        }
    }

    public static void verifyRegionQueueNotEmptyForConcurrentSender(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if (sender instanceof SerialGatewaySenderImpl) {
            Set queues = ((SerialGatewaySenderImpl)sender).getQueuesForConcurrentSerialGatewaySender();
            for (RegionQueue q : queues) {
                WANTestBase.assertTrue((q.size() > 0 ? 1 : 0) != 0);
            }
        }
    }

    public static void verifySenderPausedState(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        WANTestBase.assertTrue((boolean)sender.isPaused());
    }

    public static void verifySenderResumedState(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        WANTestBase.assertFalse((boolean)sender.isPaused());
        WANTestBase.assertTrue((boolean)sender.isRunning());
    }

    public static void verifySenderStoppedState(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        WANTestBase.assertFalse((boolean)sender.isRunning());
    }

    public static void verifySenderRunningState(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        WANTestBase.assertTrue((boolean)sender.isRunning());
    }

    public static void removeSenderFromTheRegion(String senderId, String regionName) {
        Region region = cache.getRegion(regionName);
        WANTestBase.assertNotNull((Object)region);
        region.getAttributesMutator().removeGatewaySenderId(senderId);
    }

    public static void destroySender(String senderId) {
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        ((AbstractGatewaySender)sender).destroy();
    }

    public static void verifySenderDestroyed(String senderId, boolean isParallel) {
        Set senders = cache.getGatewaySenders();
        AbstractGatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = (AbstractGatewaySender)s;
            break;
        }
        WANTestBase.assertNull(sender);
        String queueRegionNameSuffix = null;
        queueRegionNameSuffix = isParallel ? "_PARALLEL_QUEUE_" : "_SERIAL_GATEWAY_SENDER_QUEUE";
        Set allRegions = ((GemFireCacheImpl)cache).getAllRegions();
        for (LocalRegion region : allRegions) {
            if (region.getName().indexOf(senderId + queueRegionNameSuffix) == -1) continue;
            WANTestBase.fail((String)"Region underlying the sender is not destroyed.");
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        WANTestBase.closeCache();
        vm0.invoke(WANTestBase.class, "closeCache");
        vm1.invoke(WANTestBase.class, "closeCache");
        vm2.invoke(WANTestBase.class, "closeCache");
        vm3.invoke(WANTestBase.class, "closeCache");
        vm4.invoke(WANTestBase.class, "closeCache");
        vm5.invoke(WANTestBase.class, "closeCache");
        vm6.invoke(WANTestBase.class, "closeCache");
        vm7.invoke(WANTestBase.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
            cache = null;
        } else {
            WANTestBase test = new WANTestBase(testName);
            if (test.isConnectedToDS()) {
                test.getSystem().disconnect();
            }
        }
    }

    public static void shutdownLocator() {
        WANTestBase test = new WANTestBase(testName);
        test.getSystem().disconnect();
    }

    public static void printEventListenerMap() {
        ((MyGatewaySenderEventListener)eventListener1).printMap();
    }

    @Override
    public InternalDistributedSystem getSystem(Properties props) {
        props.setProperty("off-heap-memory-size", "300m");
        return super.getSystem(props);
    }

    public boolean isOffHeap() {
        return false;
    }

    static {
        destroyFlag = false;
    }

    public static class PDXGatewayEventFilter
    implements GatewayEventFilter,
    Serializable {
        String Id = "PDXGatewayEventFilter";
        public int beforeEnqueueInvoked;
        public int beforeTransmitInvoked;
        public int afterAckInvoked;

        public PDXGatewayEventFilter() {
        }

        public PDXGatewayEventFilter(String id) {
            this.Id = id;
        }

        public boolean beforeEnqueue(GatewayQueueEvent event) {
            System.out.println("Invoked enqueue for " + event);
            ++this.beforeEnqueueInvoked;
            return true;
        }

        public boolean beforeTransmit(GatewayQueueEvent event) {
            System.out.println("Invoked transmit for " + event);
            ++this.beforeTransmitInvoked;
            return true;
        }

        public void close() {
        }

        public String toString() {
            return this.Id;
        }

        public void afterAcknowledgement(GatewayQueueEvent event) {
            System.out.println("Invoked afterAck for " + event);
            ++this.afterAckInvoked;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyGatewayEventFilter)) {
                return false;
            }
            MyGatewayEventFilter filter = (MyGatewayEventFilter)obj;
            return this.Id.equals(filter.Id);
        }
    }

    public static class MyGatewayEventFilter
    implements GatewayEventFilter,
    Serializable {
        String Id = "MyGatewayEventFilter";
        boolean beforeEnqueueInvoked;
        boolean beforeTransmitInvoked;
        boolean afterAckInvoked;

        public MyGatewayEventFilter() {
        }

        public MyGatewayEventFilter(String id) {
            this.Id = id;
        }

        public boolean beforeEnqueue(GatewayQueueEvent event) {
            this.beforeEnqueueInvoked = true;
            return (Long)event.getKey() < 500L || (Long)event.getKey() >= 600L;
        }

        public boolean beforeTransmit(GatewayQueueEvent event) {
            this.beforeTransmitInvoked = true;
            return (Long)event.getKey() < 600L || (Long)event.getKey() >= 700L;
        }

        public void close() {
        }

        public String toString() {
            return this.Id;
        }

        public void afterAcknowledgement(GatewayQueueEvent event) {
            this.afterAckInvoked = true;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyGatewayEventFilter)) {
                return false;
            }
            MyGatewayEventFilter filter = (MyGatewayEventFilter)obj;
            return this.Id.equals(filter.Id);
        }
    }

    protected static class PutTask
    implements Callable {
        private final Region region;
        private final AtomicInteger key_value;
        private final int numPuts;

        public PutTask(Region region, AtomicInteger key_value, int numPuts) {
            this.region = region;
            this.key_value = key_value;
            this.numPuts = numPuts;
        }

        public Object call() throws Exception {
            int key;
            while ((key = this.key_value.incrementAndGet()) < this.numPuts) {
                this.region.put((Object)key, (Object)key);
            }
            return null;
        }
    }

    public static class MyLocatorCallback
    extends LocatorDiscoveryCallbackAdapter {
        private final Set discoveredLocators = new HashSet();
        private final Set removedLocators = new HashSet();

        public synchronized void locatorsDiscovered(List locators) {
            this.discoveredLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void locatorsRemoved(List locators) {
            this.removedLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public boolean waitForDiscovery(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.discoveredLocators, locator, time);
        }

        public boolean waitForRemove(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.removedLocators, locator, time);
        }

        private synchronized boolean waitFor(Set set, InetSocketAddress locator, long time) throws InterruptedException {
            long remaining = time;
            long endTime = System.currentTimeMillis() + time;
            while (!set.contains(locator) && remaining >= 0L) {
                ((Object)((Object)this)).wait(remaining);
                remaining = endTime - System.currentTimeMillis();
            }
            return set.contains(locator);
        }

        public synchronized Set getDiscovered() {
            return new HashSet(this.discoveredLocators);
        }

        public synchronized Set getRemoved() {
            return new HashSet(this.removedLocators);
        }
    }
}

